﻿Alter PROCEDURE rpt_CustCaseTot_Parttime(
	@p_sY varchar(4),          -- 年度
    @p_Mon varchar(2),         -- 月份
   @p_CustName nvarchar(100)  -- 客戶名稱
)
AS
BEGIN
	-- 外包人員案件統計表
	Declare @p_Year varchar(4),@p_MonF varchar(2),@p_MonT varchar(2),@p_StartDate datetime,@p_EndDate datetime
    set @p_Year = @p_sY;
    
    IF @p_Mon='0' Set @p_Mon=''
    IF @p_Mon=''  SET @p_MonF='01'
	ELSE SET @p_MonF=@p_Mon;  
    IF @p_Mon='' SET @p_MonT='12' ELSE SET @p_MonT=@p_Mon;  
	
	set @p_MonF =RIGHT(REPLICATE('0',2) + CAST(@p_MonF as varchar),2);
	set @p_MonT =RIGHT(REPLICATE('0',2) + CAST(@p_MonT as varchar),2);

	set @p_StartDate=cast((@p_Year+'-'+ @p_MonF+'-01') as datetime) ;
	set @p_EndDate=DATEADD(month,1,cast((@p_Year+'-'+ @p_MonF+'-01') as datetime))  ;  
    print('1:'+convert(varchar(20),getdate(),126)) 
	-- 1.取得: 外包人員
	select a1.*, CN_name as Emp_name, b.user_id  into #tmpPT_EmployeeList from (
	select pn_userid as PT_EmpID,-- CN_name as Emp_name, a.user_id,
	SUM(ISNULL(CN_QN,0)) as CN_QN, SUM(ISNULL(PCT_AP,0)) as PCT_AP, SUM(ISNULL(CN_AP,0)) as CN_AP, SUM(ISNULL(JP_AP,0)) as JP_AP, SUM(ISNULL(US_AP,0)) as US_AP,
	SUM(ISNULL(EP_AP,0)) as EP_AP, SUM(ISNULL(RU_AP,0)) as RU_AP, SUM(ISNULL(KR_AP,0)) as KR_AP, SUM(ISNULL(IN_AP,0)) as IN_AP 
   from esn_pdatenum  c 
    --inner join evw_employee  a on a.user_name=c.pn_userid-- AND c.pn_Mon between @p_MonF AND @p_MonT AND c.Is_Enabled='1'
	WHERE c.Is_Enabled='1' AND pn_Year=@p_Year AND pn_Mon between @p_MonF AND @p_MonT
    --where a.Emp_DSNUM=80 
	GROUP BY pn_userid
	) a1 left join  evw_employee b on a1.PT_EmpID=b.user_name
	;  
	--select * from evw_employee a
	--select * from esn_pdatenum a
	--where  a.cn_name like '%德力%'
	-- or a.cn_name like '%外包人員%' or a.cn_name like '%金城%'
	--  or a.cn_name like '%汇泽%'
	--  or a.cn_name like '%嘉德%'
 --   return 
    insert #tmpPT_EmployeeList 
	select 'tot' as PT_EmpID,
	SUM(CN_QN) as CN_QN, SUM(PCT_AP) as PCT_AP, SUM(CN_AP) as CN_AP, 
	SUM(JP_AP) as JP_AP, SUM(US_AP) as US_AP, SUM(EP_AP) as EP_AP, SUM(RU_AP) as RU_AP, SUM(KR_AP) as KR_AP, SUM(IN_AP) as IN_AP,
	 '總計' as Emp_Name,'' as user_id
    FROM #tmpPT_EmployeeList  ;  
    -- 2.取得: 所有 patentcase 
    print('2:'+convert(varchar(20),getdate(),126)) 
    SELECT  a.case_id,a.PatentType,a.PatentType_Name,a.case_volume,a.case_name,a.case_name_en,a.charge_dept_id,a.charge_deptName,
	a.charge_deptFullName,a.charge_date,a.case_status_id,a.case_status_zh_tw,a.charge_user_id,a.charge_userID,a.charge_UserCName           
	, a.customer_name as Client_CompanyName,a.country_id as PatentOffice,a.case_volume as flowkey,
	b.pic_userID as CaseAssignedTo,b.pic_UserCName as CaseAssignedTo_Name  ,(select value from [ufn_split](a.case_volume,'-') a where a.ID=2) as CaseNo_r
	into #tmpPatCase_All 
	FROM evw_p_case_info a
	left join evw_p_case_pic_list b on a.case_id=b.obj_id
    INNER JOIN #tmpPT_EmployeeList e ON b.pic_userID = e.PT_EmpID      -- 承辦人=CaseAssignedTo
    WHERE a.charge_date between @p_StartDate AND @p_EndDate             -- 立案日=CaseStartDate
	  AND a.customer_name like '%'+@p_CustName+'%'         -- 客戶名稱
    ;  
    print('3:'+convert(varchar(20),getdate(),126)) 
		select* into #tmpTodos_All_1 from esn_Todos a
		WHERE ((a.StartDate2 between @p_StartDate AND @p_EndDate) OR        -- 起始日
		   (a.FinishedDate between @p_StartDate AND @p_EndDate) OR      -- 完成日
		   (a.AttorneyDueDate between @p_StartDate AND @p_EndDate))     -- 事務所到期日 

	-- 3.取得: 所有 ToDos 
	SELECT a.*,b.customer_name as Client_CompanyName, case when ics.case_status_code='NF_P'  THEN 'Y' END as PctNationalPhase,
	b.country_id as Office,(select value from [ufn_split](a.caseNO,'-') a where a.ID=2) as CaseNo_r,Cast(a.sn as varchar(20)) as Flowkey 
	into #tmpTodos_All 
	FROM #tmpTodos_All_1 a
    INNER JOIN #tmpPT_EmployeeList e ON a.AssignedTo_userid = e.user_id        -- 承辦人= AssignedTo
	left JOIN evw_p_case_info b ON a.case_id=b.case_id
	left join i_case_status ics on ics.case_status_id=b.case_status_id
	WHERE b.customer_name like '%'+@p_CustName+'%'      -- 客戶名稱
	;  
	--CREATE INDEX tmpTodosAll_index ON #tmpTodos_All (StartDate2);
	--CREATE INDEX tmpTodosAll_index2 ON #tmpTodos_All (FinishedDate);
	--CREATE INDEX tmpTodosAll_index3 ON #tmpTodos_All (AttorneyDueDate); 
     
    print('4:'+convert(varchar(20),getdate(),126)) 
	-- 4.取得: 委案量, 委案量是同新進的條件(抓 PatentCase)
	SELECT CASE WHEN a.Client_CompanyName like '%华星%' AND LEFT(a.CaseNo_r,1)='M' AND a.PatentType='PN01' THEN 'CN 查新' END as ItemIN1,  -- 1.CN 查新(新進) --> 1.客戶名稱為華星, 2.案件編號有-M, 3.案件類別: PN01, 4.立案日落在該月份
		   CASE WHEN a.PatentOffice='CN' AND a.PatentType IN ('PN01', 'PN02', 'PN03')  THEN 'CN 新申請' END as ItemIN2,                  -- 2.CN 新申請(新進)  -->1.國家為CN, 2.案件類別: PN01, PN02, PN03, 3.立案日落在該月份
		   CASE WHEN a.PatentOffice='PCT' AND a.PatentType IN ('PN01','PN07') THEN 'PCT 新申請' END as ItemIN3,                          -- 3.PCT 新申請(新進) -->1.國家為PCT, 2.案件類別: PN01, PN07, 3.立案日落在該月份
		   CASE WHEN a.PatentOffice NOT IN ('CN','PCT') AND a.PatentType IN ('PN01') --AND a.PctNationalPhase='Y'
		   THEN a.PatentOffice +' 新申請' END as ItemIN4, -- 4.XX 新申請(新進) --> 1.國家為XX, 2.案件類別: PN01 , 3.是 PCT國家階段, 4.立案日落在該月份
		   a.*
		   into #tmpPatCase_1
	FROM #tmpPatCase_All a
	WHERE a.charge_date between @p_StartDate AND @p_EndDate   -- 立案日 
	  AND a.PatentType IN ('PN01', 'PN02', 'PN03','PN07')      -- 案件類別
	;-- ALTER TABLE tmpPatCase_1 ADD INDEX(`CaseNo`);
	select * into #tmpDA_1 from (
	select CAST(ItemIN1 as CHAR(20)) as ItemIN, a.* from #tmpPatCase_1 a where ItemIN1<>''
	union select ItemIN2 as ItemIN, a.* from #tmpPatCase_1 a where ItemIN2<>''
	union select ItemIN3 as ItemIN, a.* from #tmpPatCase_1 a where ItemIN3<>''
	union select ItemIN4 as ItemIN, a.* from #tmpPatCase_1 a where ItemIN4<>''
	) a;
	--ALTER TABLE tmpDA_1 ADD INDEX(`CaseNo`);
    

	-- 5.取得: 委案量, 委案量是同新進的條件 (抓 ToDos) 
	SELECT CASE WHEN a.Office='CN' AND (Charindex('答復審查意見',a.TaskDescription)>0 OR Charindex('答复审查意见',a.TaskDescription)>0) AND a.Status='RS05.1' THEN 'CN OA' END as ItemIN1,         -- CN OA(新進) -->1.國家為CN , 2.抓管制事項：答复审查意见, 3.起始日落在該月份, 4.案件狀態：答辯中-撰稿(RS05.1)
		   CASE WHEN a.Office='TW' AND (Charindex('申復',a.TaskDescription)>0 OR Charindex('申复',a.TaskDescription)>0 OR Charindex('提出再審',a.TaskDescription)>0) AND a.Status='RS05' THEN 'TW OA' END as ItemIN2,    -- TW OA(新進) -->1.國家為TW, 2.抓管制事項：申復/提出再審 3.起始日落在該月份, 4.案件狀態：答辯中(RS05)
		   CASE WHEN a.Office='US' AND (Charindex('response',LOWER(a.TaskDescription))>0 OR Charindex('election',LOWER(a.TaskDescription))>0 OR Charindex('advisory action',LOWER(a.TaskDescription))>0) AND a.Status='RS05' THEN 'US OA' END as ItemIN3, -- US OA(新進) -->1.國家為US, 2.抓管制事項：Respnose/Election/Advisory Action  3.起始日落在該月份, 4.案件狀態：答辯中(RS05)
		   CASE WHEN a.Office='KR' AND (Charindex('response',LOWER(a.TaskDescription))>0 OR Charindex('re-examination',LOWER(a.TaskDescription))>0 OR Charindex('appeal',LOWER(a.TaskDescription))>0) AND a.Status='RS05' THEN 'KR OA' END as ItemIN4,    -- KR OA(新進) -->1.國家為KR, 2.抓管制事項：Response/Request for Re-examination/Appeal 3.起始日落在該月份, 4.案件狀態：答辯中(RS05)
		   CASE WHEN a.Office='JP' AND (Charindex('response',LOWER(a.TaskDescription))>0 OR Charindex('appeal',LOWER(a.TaskDescription))>0) AND a.Status='RS05' THEN 'JP OA' END as ItemIN5,      -- JP OA(新進) -->1.國家為JP, 2.抓管制事項：Response/Appeal  3.起始日落在該月份, 4.案件狀態：答辯中(RS05)
		   CASE WHEN a.Office NOT IN ('CN', 'TW', 'US','KR', 'JP') AND Charindex('response',LOWER(a.TaskDescription))>0 AND a.Status='RS05' THEN a.Office+' OA' END as ItemIN6,     -- XX OA(新進) -->1.國家為XX, 2.抓管制事項：Response  3.起始日落在該月份, 4.案件狀態：答辯中(RS05)
		   CASE WHEN a.TaskDescription='RCE' THEN 'RCE' END as ItemIN7,                                                                 -- RCE(新進) -->1.不分國家, 2.抓管制事項：RCE, 3.起始日落在該月份
		   CASE WHEN a.TaskDescription='IDS' THEN 'IDS' END as ItemIN8,                                                                 -- IDS(新進) -->1.不分國家, 2.抓管制事項：IDS, 3.起始日落在該月份
		   CASE WHEN (Charindex('繳費領證',a.TaskDescription)>0 OR Charindex('缴纳领证',a.TaskDescription)>0) THEN '繳費領證' END as ItemIN9, -- 繳費領證(新進) -->1.不分國家, 2.抓管制事項：繳費領證, 3.起始日落在該月份
		  Right(Convert(varchar(7) ,a.StartDate2,126),2) as colMon_ST, a.*, getdate() as sysDate 
		  into #tmpTodos_1
	FROM #tmpTodos_All a
	WHERE a.StartDate2 between @p_StartDate AND @p_EndDate 
	;     
	select * into #tmpDA_12 from(
	select CAST(ItemIN1 as CHAR(20)) as ItemIN, a.* from #tmpTodos_1 a where ItemIN1<>''
	union select ItemIN2 as ItemIN, a.* from #tmpTodos_1 a where ItemIN2<>''
	union select ItemIN3 as ItemIN, a.* from #tmpTodos_1 a where ItemIN3<>''
	union select ItemIN4 as ItemIN, a.* from #tmpTodos_1 a where ItemIN4<>''
	union select ItemIN5 as ItemIN, a.* from #tmpTodos_1 a where ItemIN5<>''
	union select ItemIN6 as ItemIN, a.* from #tmpTodos_1 a where ItemIN6<>''
	union select ItemIN7 as ItemIN, a.* from #tmpTodos_1 a where ItemIN7<>''
	union select ItemIN8 as ItemIN, a.* from #tmpTodos_1 a where ItemIN8<>''
	union select ItemIN8 as ItemIN, a.* from #tmpTodos_1 a where ItemIN9<>''
	) a; 
	--ALTER TABLE tmpDA_12 ADD INDEX(`CaseNo`);   
    

	-- 6.取得: OA 的「「完成」資料  
	SELECT CASE WHEN (a.Client_CompanyName like '%華星%' OR a.Client_CompanyName like '%华星%') AND LEFT(a.CaseNo_r,1)='M' AND a.Status='RS11' 
					 AND (Charindex('提出報告',a.TaskDescription)>0 OR Charindex('提出报告',a.TaskDescription)>0) 
					 AND ISNULL(a.FinishedDate,'')<>'' AND ISNULL(a.AttorneyDueDate,'')<>'' AND LEFT(a.AttorneyDueDate,7)=LEFT(a.FinishedDate,7) THEN 'CN 查新' END as ItemFH1,  -- CN 查新(完成) -->1.客戶名稱為華星, 2.案件編號有-M, 3.案件狀態：結案(RS11), 4.管制事項：提出報告, 5.完成日落在該月份
		   CASE WHEN a.Office='CN' AND a.PatentType IN ('PN01', 'PN02', 'PN03') AND a.TaskDescription='完成初稿' AND a.Matter='CNP01' THEN 'CN 新申請' END as ItemFH2,  -- CN 新申請(完成) -->1.國家為CN, 2.案件類別: PN01, PN02, PN03, 3.管制事項：完成初稿, 4.完成日落在該月份, 5. 案件程序:中國發明申請(CNP01)
		   CASE WHEN a.Office='PCT' AND a.PatentType IN ('PN01','PN07') AND a.TaskDescription='完成初稿' AND a.Matter='WOP01' THEN 'PCT 新申請' END as ItemFH3,         -- PCT 新申請(完成)-->1.國家為PCT, 2.案件類別: PN01, PN07, 3.管制事項：完成初稿, 4.完成日落在該月份, 5. 案件程序:PCT國際申請(WOP01)
		   CASE WHEN a.Office='US' AND a.PatentType='PN01' AND a.PctNationalPhase='Y' AND a.TaskDescription='完成初稿' AND a.Matter='USP01' THEN 'US 新申請' END as ItemFH4, -- US 新申請(完成)-->1.國家為US, 2.案件類別: PN01, PN07, 3.管制事項：完成初稿, 4.完成日落在該月份, 5. 案件程序:美國Utility申請(USP01)
		   CASE WHEN a.Office='TW' AND a.PatentType='PN01' AND a.PctNationalPhase='Y' AND a.TaskDescription='完成初稿' AND a.Matter='TWP01' THEN 'TW 新申請' END as ItemFH5, -- TW 新申請(完成)-->1.國家為TW, 2.案件類別: PN01, PN07, 3.管制事項：完成初稿, 4.完成日落在該月份, 5. 案件程序:台灣發明申請(TWP01)
		   CASE WHEN a.Office NOT IN ('CN', 'PCT', 'US', 'TW') AND (LEFT(a.CaseNo_r,1)<>'M' and NOT a.Client_CompanyName like '%华星%')
					 AND a.PatentType='PN01' AND a.PctNationalPhase='Y' AND a.TaskDescription='完成初稿' AND a.Matter='P01' THEN a.Office+' 新申請' END as ItemFH6,   -- XX 新申請(完成) -->1.國家為XX, 2.案件類別: PN01 , 3.是 PCT國家階段, 4.管制事項：完成初稿, 5.完成日落在該月份, 6. 案件程序:專利申請(P01)
				
		   CASE WHEN Office='CN' AND Charindex('完成初稿',a.TaskDescription)>0 AND a.Matter='CNP02'  THEN 'CN OA' END as ItemFH7, -- CN OA(完成) -->1.國家為CN, 2.抓管制事項：完成初稿(都含), 3.完成日落在該月份, 4.案件程序: 中國發明審查(CNP02)
		   CASE WHEN Office='TW' AND a.TaskDescription='完成初稿' AND a.Matter='TWP02'  THEN 'TW OA' END as ItemFH8,           -- TW OA(完成) -->1.國家為TW, 2.抓管制事項：完成初稿(只有這4個字), 4.完成日落在該月份, 4.案件程序: 台灣發明審查(TWP02)
		   CASE WHEN Office='US' AND a.TaskDescription='完成初稿' AND a.Matter='USP02'  THEN 'US OA' END as ItemFH9,           -- US OA(完成) -->1.國家為US, 2.抓管制事項：完成初稿(只有這4個字), 4.完成日落在該月份, 4.案件程序: 美國Utility審查(USP02)

		   CASE WHEN  Office NOT IN ('CN', 'TW','US') AND a.TaskDescription='完成初稿' AND a.Matter='P02' THEN a.Office+' OA' END as ItemFH10,  -- XX OA(完成) -->1.國家為XX,  2.抓管制事項：完成初稿(只有這4個字), 4.完成日落在該月份, 4.案件程序: 專利審查(P02)
		   CASE WHEN Charindex('rce', LOWER(a.TaskDescription))>0 THEN 'RCE' END as ItemFH11,     -- RCE(完成) -->1.不分國家, 2.抓管制事項：RCE -->完成日落在該月份
		   CASE WHEN Charindex('ids', LOWER(a.TaskDescription))>0 THEN 'IDS' END as ItemFH12,     -- IDS(完成) -->1.不分國家, 2.抓管制事項：IDS -->完成日落在該月份
		   CASE WHEN Charindex('繳費領證', a.TaskDescription)>0 THEN '繳費領證' END as ItemFH13,  -- 繳費領證(完成) -->1.不分國家, 2.管制事項有「繳費領證」該項, 3.抓管制事項：完成初稿 -->完成日落在該月份
		   Right(Convert(varchar(7) ,a.FinishedDate,126),2) as colMon_FH, a.*
		   into #tmpTodos_2
	FROM #tmpTodos_All a
	WHERE a.FinishedDate between @p_StartDate AND @p_EndDate AND a.PatentType IN ('PN01', 'PN02', 'PN03','PN07')
	  AND (Charindex('完成初稿',a.TaskDescription)>0 OR Charindex('提出報告',a.TaskDescription)>0 OR Charindex('提出报告',a.TaskDescription)>0 OR 
           Charindex('rce', LOWER(a.TaskDescription))>0 OR Charindex('ids', LOWER(a.TaskDescription))>0 OR Charindex('繳費領證', a.TaskDescription)>0)
	;  
	select * into #tmpDA_2 from (
	select CAST(ItemFH1 as CHAR(20)) as ItemFH, a.* from #tmpTodos_2 a where ItemFH1<>''
	union select ItemFH2 as ItemFH, a.* from #tmpTodos_2 a where ItemFH2<>''
	union select ItemFH3 as ItemFH, a.* from #tmpTodos_2 a where ItemFH3<>''
	union select ItemFH4 as ItemFH, a.* from #tmpTodos_2 a where ItemFH4<>''
	union select ItemFH5 as ItemFH, a.* from #tmpTodos_2 a where ItemFH5<>''
	union select ItemFH6 as ItemFH, a.* from #tmpTodos_2 a where ItemFH6<>''
	union select ItemFH7 as ItemFH, a.* from #tmpTodos_2 a where ItemFH7<>''
	union select ItemFH8 as ItemFH, a.* from #tmpTodos_2 a where ItemFH8<>''
	union select ItemFH9 as ItemFH, a.* from #tmpTodos_2 a where ItemFH9<>''
	union select ItemFH10 as ItemFH, a.* from #tmpTodos_2 a where ItemFH10<>''
	union select ItemFH11 as ItemFH, a.* from #tmpTodos_2 a where ItemFH11<>''
	union select ItemFH12 as ItemFH, a.* from #tmpTodos_2 a where ItemFH12<>''
	union select ItemFH13 as ItemFH, a.* from #tmpTodos_2 a where ItemFH13<>''
	) a;
    --ALTER TABLE tmpDA_2 ADD INDEX(`CaseNo`);



	-- 7.取得:「未完成」資料 
	SELECT CASE WHEN (a.Client_CompanyName like '%華星%' OR a.Client_CompanyName like '%华星%') AND LEFT(a.CaseNo_r,1)='M'  
				 AND (Charindex('提出報告',a.TaskDescription)>0 OR Charindex('提出报告',a.TaskDescription)>0) THEN 'CN 查新' END as Item_NotFH1,    -- CN 查新(未完成) -->1.客戶名稱為華星, 2.案件編號有-M, 3.管制事項：提出报告, 4.完成日為空白, 5.事務到期日落在該月份
		   CASE WHEN a.Office='CN' AND a.PatentType IN ('PN01', 'PN02', 'PN03') AND a.TaskDescription='完成初稿' AND a.Status='RS01' THEN 'CN 新申請' END as Item_NotFH2, -- CN 新申請(未完成) -->1.國家為CN, 2.案件類別: PN01, PN02, PN03, 3.管制事項：完成初稿(只有這4個字), 4.案件狀態：撰稿(RS01), 5.完成日為空白, 6.事務到期日落在該月份
		   CASE WHEN a.Office='PCT' AND a.PatentType IN ('PN01','PN07') AND a.TaskDescription='完成初稿' AND a.Status='RS01' THEN 'PCT 新申請' END as Item_NotFH3,        -- PCT 新申請(未完成)-->1.國家為PCT, 2.案件類別: PN01, PN07, 3.管制事項：完成初稿(只有這4個字), 4.案件狀態：撰稿(RS01), 5.完成日為空白, 6.事務到期日落在該月份
		   CASE WHEN a.Office='US' AND a.PatentType='PN01' AND a.PctNationalPhase='Y' AND a.TaskDescription='完成初稿' AND a.Status='RS01' THEN a.Office+' 新申請' END as Item_NotFH4,    -- XX 新申請(未完成) -->1.國家為XX, 2.案件類別: PN01 , 3.是 PCT國家階段, 4.管制事項：完成初稿(只有這4個字), 5.案件狀態：撰稿(RS01), 5.完成日為空白, 6.事務到期日落在該月份
				
		   CASE WHEN Charindex('完成初稿',a.TaskDescription)>0 AND a.Status='RS05.1'  THEN 'CN OA' END as Item_NotFH5,      -- CN OA(未完成) -->1.國家為CN, 2.管制事項：完成初稿(都含), 3.案件狀態：答辯中-撰稿(RS05.1), 4.完成日為空白, 5.事務到期日落在該月份
		   CASE WHEN a.TaskDescription='完成初稿' AND a.Status='RS05' AND a.Office NOT IN('CN','PCT') THEN a.Office+' OA' END as Item_NotFH6, -- XX OA(未完成) -->1.國家為XX, 2.管制事項：完成初稿(只有這4個字), 3.案件狀態：答辯中(RS05), 4.完成日為空白, 5.事務到期日落在該月份

		   CASE WHEN Charindex('rce', LOWER(a.TaskDescription))>0 THEN 'RCE' END as Item_NotFH7,       -- RCE(未完成) -->1.不分國家, 2.管制事項：「RCE」該項, 3.完成日為空白, 4.事務到期日落在該月份
		   CASE WHEN Charindex('ids', LOWER(a.TaskDescription))>0 THEN 'IDS' END as Item_NotFH8,       -- IDS(未完成) -->1.不分國家, 2.管制事項：「IDS」該項, 3.完成日為空白, 4.事務到期日落在該月份
		   CASE WHEN Charindex('繳費領證', a.TaskDescription)>0  THEN '繳費領證' END as Item_NotFH9,   -- 繳費領證(未完成) -->1.不分國家, 2.管制事項：「繳費領證」該項, 3.完成日為空白, 4.事務到期日落在該月份
		   CASE WHEN a.AttorneyDueDate='' THEN '' ELSE Right(Convert(varchar(7),a.AttorneyDueDate,126) ,2) END as colMon_AD, a.*
		   into #tmpTodos_3
	FROM #tmpTodos_All a
	WHERE ((a.AttorneyDueDate between @p_StartDate AND @p_EndDate ) AND (a.finishedDate='' or a.finishedDate is null))
	  AND a.PatentType IN ('PN01', 'PN02', 'PN03','PN07')
	  AND (Charindex('完成初稿',a.TaskDescription)>0 OR Charindex('提出報告',a.TaskDescription)>0 OR Charindex('提出报告',a.TaskDescription)>0 OR 
           Charindex('rce', LOWER(a.TaskDescription))>0 OR Charindex('ids', LOWER(a.TaskDescription))>0 OR Charindex('繳費領證', a.TaskDescription)>0)
	; 
	select * into #tmpDA_3 from (
	select CAST(Item_NotFH1 as CHAR(20)) as Item_NotFH, a.* from #tmpTodos_3 a where Item_NotFH1<>''
	union select Item_NotFH2 as Item_NotFH, a.* from #tmpTodos_3 a where Item_NotFH2<>''
	union select Item_NotFH3 as Item_NotFH, a.* from #tmpTodos_3 a where Item_NotFH3<>''
	union select Item_NotFH4 as Item_NotFH, a.* from #tmpTodos_3 a where Item_NotFH4<>''
	union select Item_NotFH5 as Item_NotFH, a.* from #tmpTodos_3 a where Item_NotFH5<>''
	union select Item_NotFH6 as Item_NotFH, a.* from #tmpTodos_3 a where Item_NotFH6<>''
	union select Item_NotFH7 as Item_NotFH, a.* from #tmpTodos_3 a where Item_NotFH7<>''
	union select Item_NotFH8 as Item_NotFH, a.* from #tmpTodos_3 a where Item_NotFH8<>''
	union select Item_NotFH8 as Item_NotFH, a.* from #tmpTodos_3 a where Item_NotFH9<>''
	) a;
	--ALTER TABLE tmpDA_3 ADD INDEX(`CaseNo`);
    -- 總計 
	SELECT * into #tmpDA_tot from (
	SELECT 1 as daType, CaseAssignedTo as PT_EmpID, CaseAssignedTo_Name as Emp_Name, ItemIN as Item, FlowKey FROM #tmpDA_1 
	UNION ALL
	SELECT 1 as daType, AssignedTo as PT_EmpID,AssignedTo +'-'+ AssignedTo_Name as Emp_Name, ItemIN as Item, FlowKey FROM #tmpDA_12 
	UNION ALL
	SELECT 2 as daType, AssignedTo as PT_EmpID, AssignedTo +'-'+ AssignedTo_Name as Emp_Name, ItemFH as Item, FlowKey FROM #tmpDA_2 
	UNION ALL
	SELECT 3 as daType, AssignedTo as PT_EmpID, AssignedTo +'-'+ AssignedTo_Name as Emp_Name, Item_NotFH as Item, FlowKey FROM #tmpDA_3
	) a
	;    
    -- 顯示結果

		with concatFlowkey1 as
	(
			--SELECT 1 as daType, CaseAssignedTo as PT_EmpID, CaseAssignedTo_Name as Emp_Name, ItemIN as Item, FlowKey FROM #tmpDA_1   -- 委案量
			--UNION ALL
			--SELECT 1 as daType, AssignedTo as PT_EmpID, AssignedTo_Name as Emp_Name, ItemIN as Item, FlowKey FROM #tmpDA_12          -- 委案量
			--UNION ALL
			--SELECT 2 as daType, AssignedTo as PT_EmpID, AssignedTo_Name as Emp_Name, ItemFH as Item, FlowKey FROM #tmpDA_2           -- 完成量
			--UNION ALL
			--SELECT 3 as daType, AssignedTo as PT_EmpID, AssignedTo_Name as Emp_Name, Item_NotFH as Item, FlowKey FROM #tmpDA_3       -- 未完成量
		select * FROM #tmpDA_tot 
	)   
	--select * from concatFlowkey1; 
	
    SELECT  a.Emp_name as attr_ItemName, CASE WHEN @p_MonF<>@p_MonT THEN '- 整年度　' ELSE '- '+@p_MonF+'月　' END as attr_Mon2, a.PT_EmpID as attr_PTEmpID, a.Emp_name as 外包人員, 
		   'CorDF' as class_ap1, a.CN_QN as 配委量_CNQN ,  attr_CNQN1_todos2,  num1_CNQN as 委案量_CNQN ,  attr_CNQN2_todos2,  num2_CNQN as 完成量_CNQN ,  attr_CNQN3_todos2,  num3_CNQN as 未完成量_CNQN , 
           'CorDF' as class_ap1, a.PCT_AP as 配委量_PCTAP, attr_PCTAP1_todos2, num1_PCTAP as 委案量_PCTAP, attr_PCTAP2_todos2, num2_PCTAP as 完成量_PCTAP, attr_PCTAP3_todos2, num3_PCTAP as 未完成量_PCTAP, 
		   'CorDF' as class_ap1, a.CN_AP as 配委量_CNAP ,  attr_CNAP1_todos2,  num1_CNAP as 委案量_CNAP ,  attr_CNAP2_todos2,  num2_CNAP as 完成量_CNAP ,  attr_CNAP3_todos2,  num3_CNAP as 未完成量_CNAP , 
		   'CorDF' as class_ap1, a.JP_AP as 配委量_JPAP ,  attr_JPAP1_todos2,  num1_JPAP as 委案量_JPAP ,  attr_JPAP2_todos2,  num2_JPAP as 完成量_JPAP ,  attr_JPAP3_todos2,  num3_JPAP as 未完成量_JPAP , 
           'CorDF' as class_ap1, a.US_AP as 配委量_USAP ,  attr_USAP1_todos2,  num1_USAP as 委案量_USAP ,  attr_USAP2_todos2,  num2_USAP as 完成量_USAP ,  attr_USAP3_todos2,  num3_USAP as 未完成量_USAP , 
		   'CorDF' as class_ap1, a.EP_AP as 配委量_EPAP ,  attr_EPAP1_todos2,  num1_EPAP as 委案量_EPAP ,  attr_EPAP2_todos2,  num2_EPAP as 完成量_EPAP ,  attr_EPAP3_todos2,  num3_EPAP as 未完成量_EPAP , 
		   'CorDF' as class_ap1, a.RU_AP as 配委量_RUAP ,  attr_RUAP1_todos2,  num1_RUAP as 委案量_RUAP ,  attr_RUAP2_todos2,  num2_RUAP as 完成量_RUAP ,  attr_RUAP3_todos2,  num3_RUAP as 未完成量_RUAP , 
		   'CorDF' as class_ap1, a.KR_AP as 配委量_KRAP ,  attr_KRAP1_todos2,  num1_KRAP as 委案量_KRAP ,  attr_KRAP2_todos2,  num2_KRAP as 完成量_KRAP ,  attr_KRAP3_todos2,  num3_KRAP as 未完成量_KRAP , 
		   'CorDF' as class_ap1, a.IN_AP as 配委量_INAP ,  attr_INAP1_todos2,  num1_INAP as 委案量_INAP ,  attr_INAP2_todos2,  num2_INAP as 完成量_INAP ,  attr_INAP3_todos2,  num3_INAP as 未完成量_INAP 
    FROM #tmpPT_EmployeeList a
    LEFT JOIN (
		SELECT PT_EmpID, Emp_Name, 
		SUM(CASE WHEN daType=1 AND Item='CN 查新' THEN 1 ELSE 0 END) as num1_CNQN, SUM(CASE WHEN daType=1 AND Item='PCT 新申請' THEN 1 ELSE 0 END) as num1_PCTAP, 
		SUM(CASE WHEN daType=1 AND Item='CN 新申請' THEN 1 ELSE 0 END) as num1_CNAP,SUM(CASE WHEN daType=1 AND Item='JP 新申請' THEN 1 ELSE 0 END) as num1_JPAP, 
		SUM(CASE WHEN daType=1 AND Item='US 新申請' THEN 1 ELSE 0 END) as num1_USAP,SUM(CASE WHEN daType=1 AND Item='EP 新申請' THEN 1 ELSE 0 END) as num1_EPAP, 
		SUM(CASE WHEN daType=1 AND Item='RU 新申請' THEN 1 ELSE 0 END) as num1_RUAP,SUM(CASE WHEN daType=1 AND Item='KR 新申請' THEN 1 ELSE 0 END) as num1_KRAP, 
		SUM(CASE WHEN daType=1 AND Item='IN 新申請' THEN 1 ELSE 0 END) as num1_INAP,SUM(CASE WHEN daType=2 AND Item='CN 查新' THEN 1 ELSE 0 END) as num2_CNQN, 
		SUM(CASE WHEN daType=2 AND Item='PCT 新申請' THEN 1 ELSE 0 END) as num2_PCTAP,SUM(CASE WHEN daType=2 AND Item='CN 新申請' THEN 1 ELSE 0 END) as num2_CNAP, 
		SUM(CASE WHEN daType=2 AND Item='JP 新申請' THEN 1 ELSE 0 END) as num2_JPAP,SUM(CASE WHEN daType=2 AND Item='US 新申請' THEN 1 ELSE 0 END) as num2_USAP, 
		SUM(CASE WHEN daType=2 AND Item='EP 新申請' THEN 1 ELSE 0 END) as num2_EPAP,SUM(CASE WHEN daType=2 AND Item='RU 新申請' THEN 1 ELSE 0 END) as num2_RUAP, 
		SUM(CASE WHEN daType=2 AND Item='KR 新申請' THEN 1 ELSE 0 END) as num2_KRAP,SUM(CASE WHEN daType=2 AND Item='IN 新申請' THEN 1 ELSE 0 END) as num2_INAP,
        SUM(CASE WHEN daType=3 AND Item='CN 查新' THEN 1 ELSE 0 END) as num3_CNQN, SUM(CASE WHEN daType=3 AND Item='PCT 新申請' THEN 1 ELSE 0 END) as num3_PCTAP, 
		SUM(CASE WHEN daType=3 AND Item='CN 新申請' THEN 1 ELSE 0 END) as num3_CNAP,SUM(CASE WHEN daType=3 AND Item='JP 新申請' THEN 1 ELSE 0 END) as num3_JPAP, 
		SUM(CASE WHEN daType=3 AND Item='US 新申請' THEN 1 ELSE 0 END) as num3_USAP,SUM(CASE WHEN daType=3 AND Item='EP 新申請' THEN 1 ELSE 0 END) as num3_EPAP,
		SUM(CASE WHEN daType=3 AND Item='RU 新申請' THEN 1 ELSE 0 END) as num3_RUAP, SUM(CASE WHEN daType=3 AND Item='KR 新申請' THEN 1 ELSE 0 END) as num3_KRAP,
		SUM(CASE WHEN daType=3 AND Item='IN 新申請' THEN 1 ELSE 0 END) as num3_INAP,
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='CN 查新' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_CNQN1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='PCT 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'') as attr_PCTAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='CN 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_CNAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='JP 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_JPAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='US 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_USAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='EP 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_EPAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='RU 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')as attr_RUAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='KR 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'') as attr_KRAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='IN 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'') as attr_INAP1_todos2, 

		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='CN 查新' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_CNQN2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='PCT 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'') as attr_PCTAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='CN 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_CNAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='JP 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_JPAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='US 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_USAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='EP 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_EPAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='RU 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')as attr_RUAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='KR 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'') as attr_KRAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='IN 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'') as attr_INAP2_todos2, 

		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='CN 查新' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_CNQN3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='PCT 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'') as attr_PCTAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='CN 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_CNAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='JP 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_JPAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='US 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_USAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='EP 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')  as attr_EPAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='RU 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'')as attr_RUAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='KR 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'') as attr_KRAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='IN 新申請' and p.PT_EmpID=c.PT_EmpID and p.Emp_Name=c.Emp_Name   FOR XML PATH('') ), 1, 1, N'') as attr_INAP3_todos2
        FROM concatFlowkey1 c 
		GROUP BY PT_EmpID, Emp_Name
        union all
		 select PT_EmpID,Emp_Name,sum(num1_CNQN) as num1_CNQN,sum(num1_PCTAP) as num1_PCTAP,sum(num1_CNAP) as num1_CNAP,sum(num1_JPAP) as num1_JPAP,sum(num1_USAP) as num1_USAP,sum(num1_EPAP) as num1_EPAP,
		sum(num1_RUAP) as num1_RUAP,sum(num1_KRAP) as num1_KRAP,sum(num1_INAP) as num1_INAP,sum(num2_CNQN) as num2_CNQN,sum(num2_PCTAP) as num2_PCTAP,sum(num2_CNAP) as num2_CNAP,sum(num2_JPAP) as num2_CNAP
		,sum(num2_USAP) as num2_USAP,sum(num2_EPAP) as num2_EPAP,
		sum(num2_RUAP) as num2_RUAP,sum(num2_KRAP) as num2_KRAP,sum(num2_INAP) as num2_INAP,sum(num3_CNQN) as num3_CNQN,sum(num3_PCTAP) as num3_PCTAP,sum(num3_CNAP) as num3_CNAP
		,sum(num3_JPAP) as num3_JPAP,sum(num3_USAP) as num3_USAP,sum(num3_EPAP) as num3_EPAP,
		sum(num3_RUAP),sum(num3_KRAP),sum(num3_INAP),attr_CNQN1_todos2,attr_PCTAP1_todos2,attr_CNAP1_todos2,attr_JPAP1_todos2,
		attr_USAP1_todos2,attr_EPAP1_todos2,attr_RUAP1_todos2,attr_KRAP1_todos2,attr_INAP1_todos2,attr_CNQN2_todos2,
		attr_PCTAP2_todos2,attr_CNAP2_todos2,attr_JPAP2_todos2,attr_USAP2_todos2,attr_EPAP2_todos2,attr_RUAP2_todos2,
		attr_KRAP2_todos2,attr_INAP2_todos2,attr_CNQN3_todos2,attr_PCTAP3_todos2,attr_CNAP3_todos2,attr_JPAP3_todos2,
		attr_USAP3_todos2,attr_EPAP3_todos2,attr_RUAP3_todos2,attr_KRAP3_todos2,attr_INAP3_todos2 
		from  (
        SELECT 'tot' as PT_EmpID, '總計' as Emp_Name,
		SUM(CASE WHEN daType=1 AND Item='CN 查新' THEN 1 ELSE 0 END) as num1_CNQN, SUM(CASE WHEN daType=1 AND Item='PCT 新申請' THEN 1 ELSE 0 END) as num1_PCTAP, 
		SUM(CASE WHEN daType=1 AND Item='CN 新申請' THEN 1 ELSE 0 END) as num1_CNAP, SUM(CASE WHEN daType=1 AND Item='JP 新申請' THEN 1 ELSE 0 END) as num1_JPAP, 
		SUM(CASE WHEN daType=1 AND Item='US 新申請' THEN 1 ELSE 0 END) as num1_USAP,SUM(CASE WHEN daType=1 AND Item='EP 新申請' THEN 1 ELSE 0 END) as num1_EPAP, 
		SUM(CASE WHEN daType=1 AND Item='RU 新申請' THEN 1 ELSE 0 END) as num1_RUAP, SUM(CASE WHEN daType=1 AND Item='KR 新申請' THEN 1 ELSE 0 END) as num1_KRAP, 
		SUM(CASE WHEN daType=1 AND Item='IN 新申請' THEN 1 ELSE 0 END) as num1_INAP,SUM(CASE WHEN daType=2 AND Item='CN 查新' THEN 1 ELSE 0 END) as num2_CNQN, 
			   SUM(CASE WHEN daType=2 AND Item='PCT 新申請' THEN 1 ELSE 0 END) as num2_PCTAP, SUM(CASE WHEN daType=2 AND Item='CN 新申請' THEN 1 ELSE 0 END) as num2_CNAP, 
			   SUM(CASE WHEN daType=2 AND Item='JP 新申請' THEN 1 ELSE 0 END) as num2_JPAP, SUM(CASE WHEN daType=2 AND Item='US 新申請' THEN 1 ELSE 0 END) as num2_USAP, 
			   SUM(CASE WHEN daType=2 AND Item='EP 新申請' THEN 1 ELSE 0 END) as num2_EPAP, SUM(CASE WHEN daType=2 AND Item='RU 新申請' THEN 1 ELSE 0 END) as num2_RUAP, 
			   SUM(CASE WHEN daType=2 AND Item='KR 新申請' THEN 1 ELSE 0 END) as num2_KRAP, SUM(CASE WHEN daType=2 AND Item='IN 新申請' THEN 1 ELSE 0 END) as num2_INAP,
               SUM(CASE WHEN daType=3 AND Item='CN 查新' THEN 1 ELSE 0 END) as num3_CNQN, SUM(CASE WHEN daType=3 AND Item='PCT 新申請' THEN 1 ELSE 0 END) as num3_PCTAP, 
			   SUM(CASE WHEN daType=3 AND Item='CN 新申請' THEN 1 ELSE 0 END) as num3_CNAP, SUM(CASE WHEN daType=3 AND Item='JP 新申請' THEN 1 ELSE 0 END) as num3_JPAP, 
			   SUM(CASE WHEN daType=3 AND Item='US 新申請' THEN 1 ELSE 0 END) as num3_USAP, 
			   SUM(CASE WHEN daType=3 AND Item='EP 新申請' THEN 1 ELSE 0 END) as num3_EPAP, SUM(CASE WHEN daType=3 AND Item='RU 新申請' THEN 1 ELSE 0 END) as num3_RUAP, 
			   SUM(CASE WHEN daType=3 AND Item='KR 新申請' THEN 1 ELSE 0 END) as num3_KRAP, SUM(CASE WHEN daType=3 AND Item='IN 新申請' THEN 1 ELSE 0 END) as num3_INAP,
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='CN 查新'    FOR XML PATH('') ), 1, 1, N'')  as attr_CNQN1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='PCT 新申請'    FOR XML PATH('') ), 1, 1, N'') as attr_PCTAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='CN 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_CNAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='JP 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_JPAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='US 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_USAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='EP 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_EPAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='RU 新申請'    FOR XML PATH('') ), 1, 1, N'')as attr_RUAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='KR 新申請'    FOR XML PATH('') ), 1, 1, N'') as attr_KRAP1_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=1 AND Item='IN 新申請'    FOR XML PATH('') ), 1, 1, N'') as attr_INAP1_todos2, 

		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='CN 查新'    FOR XML PATH('') ), 1, 1, N'')  as attr_CNQN2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='PCT 新申請'    FOR XML PATH('') ), 1, 1, N'') as attr_PCTAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='CN 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_CNAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='JP 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_JPAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='US 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_USAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='EP 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_EPAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='RU 新申請'    FOR XML PATH('') ), 1, 1, N'')as attr_RUAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='KR 新申請'    FOR XML PATH('') ), 1, 1, N'') as attr_KRAP2_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=2 AND Item='IN 新申請'    FOR XML PATH('') ), 1, 1, N'') as attr_INAP2_todos2, 

		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='CN 查新'    FOR XML PATH('') ), 1, 1, N'')  as attr_CNQN3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='PCT 新申請'    FOR XML PATH('') ), 1, 1, N'') as attr_PCTAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='CN 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_CNAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='JP 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_JPAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='US 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_USAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='EP 新申請'    FOR XML PATH('') ), 1, 1, N'')  as attr_EPAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='RU 新申請'    FOR XML PATH('') ), 1, 1, N'')as attr_RUAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='KR 新申請'    FOR XML PATH('') ), 1, 1, N'') as attr_KRAP3_todos2, 
		STUFF ((select ','+ p.Flowkey from concatFlowkey1 p where daType=3 AND Item='IN 新申請'    FOR XML PATH('') ), 1, 1, N'') as attr_INAP3_todos2
        FROM concatFlowkey1 c
		GROUP BY PT_EmpID, Emp_Name
		) a 	
		GROUP BY a.PT_EmpID, a.Emp_Name,attr_CNQN1_todos2,attr_PCTAP1_todos2,attr_CNAP1_todos2,attr_JPAP1_todos2,
				attr_USAP1_todos2,attr_EPAP1_todos2,attr_RUAP1_todos2,attr_KRAP1_todos2,attr_INAP1_todos2,attr_CNQN2_todos2,
				attr_PCTAP2_todos2,attr_CNAP2_todos2,attr_JPAP2_todos2,attr_USAP2_todos2,attr_EPAP2_todos2,attr_RUAP2_todos2,
				attr_KRAP2_todos2,attr_INAP2_todos2,attr_CNQN3_todos2,attr_PCTAP3_todos2,attr_CNAP3_todos2,attr_JPAP3_todos2,
				attr_USAP3_todos2,attr_EPAP3_todos2,attr_RUAP3_todos2,attr_KRAP3_todos2,attr_INAP3_todos2
   
	) b ON a.PT_EmpID=b.PT_EmpID 
    ORDER BY a.Emp_name,a.PT_EmpID ;  
    
    	IF OBJECT_ID('tempdb..#tmpPatCase_All', 'U') IS NOT NULL DROP TABLE #tmpPatCase_All
	IF OBJECT_ID('tempdb..#tmpPT_EmployeeList', 'U') IS NOT NULL DROP TABLE #tmpPT_EmployeeList
	IF OBJECT_ID('tempdb..#tmpDA_tot', 'U') IS NOT NULL DROP TABLE #tmpDA_tot
	IF OBJECT_ID('tempdb..#tmpDA_3', 'U') IS NOT NULL DROP TABLE #tmpDA_3
	IF OBJECT_ID('tempdb..#tmpTodos_3', 'U') IS NOT NULL DROP TABLE #tmpTodos_3
	IF OBJECT_ID('tempdb..#tmpDA_2', 'U') IS NOT NULL DROP TABLE #tmpDA_2
	IF OBJECT_ID('tempdb..#tmpDA_12', 'U') IS NOT NULL DROP TABLE #tmpDA_12
	IF OBJECT_ID('tempdb..#tmpTodos_2', 'U') IS NOT NULL DROP TABLE #tmpTodos_2
	IF OBJECT_ID('tempdb..#tmpTodos_1', 'U') IS NOT NULL DROP TABLE #tmpTodos_1
	IF OBJECT_ID('tempdb..#tmpDA_1', 'U') IS NOT NULL DROP TABLE #tmpDA_1
	IF OBJECT_ID('tempdb..#tmpTodos_All', 'U') IS NOT NULL DROP TABLE #tmpTodos_All
	IF OBJECT_ID('tempdb..#tmpPatCase_1', 'U') IS NOT NULL DROP TABLE #tmpPatCase_1
	 
END

GO   
DECLARE @RC int 

-- TODO: 在此處設定參數值。

EXECUTE @RC = [dbo].rpt_CustCaseTot_Parttime 
	@p_sY='2019',
    @p_Mon='' ,
    @p_CustName='华星'
GO   
 