USE [IPEasy_test]
GO

/****** Object:  UserDefinedFunction [dbo].[f_GetNewMultiplyingPoints_sol]    Script Date: 2021/10/20 下午 04:55:20 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO














-- =============================================
-- Author:		<Penny>
-- Create date: <2021-04-01>
-- Description:	<計算點數加乘 >
-- =============================================
Create FUNCTION [dbo].[f_GetNewMultiplyingPoints_sol]
(
 @i_user_id varchar(255),
 @i_is_engineer int,
 @i_is_sales int,
 @i_acting_points float,
 @i_non_acting_points float
)
RETURNS @TABLE TABLE (user_id varchar(255),acting_points int, non_acting_points int)
as
begin
	
	declare @i_points float,
			--@v_is_engineer int,
			--@v_is_sales int,
			--工程師
			@v_first_range float,
			@v_second_range float,
			@v_first_range_points float,
			@v_second_range_points float,
			--業務
			@weighting1 float = 1.15,
			@weighting2 float = 1.3, 
			@bracket1 int = 6000, 
			@bracket2 int= 8000,
			--加乘點數
			@o_multiplying_points float,
			@o_acting_points float,
			@o_non_acting_points float;

	set @i_points = isnull(@i_acting_points,0) + isnull(@i_non_acting_points,0)


	if @i_points = 0
	begin
		insert @TABLE
		(user_id,acting_points,non_acting_points)
		values (@i_user_id,@o_acting_points,@o_non_acting_points);
	end

	else
	begin

		--select 
		--@v_is_engineer = is_engineer,
		--@v_is_sales = is_sales 
		--from evw_ehr_employee_zh_tw 
		--where wade_user_id = @i_user_id;

		if @i_is_sales = 1
		begin
			set @o_multiplying_points= round(case when @i_points <= @bracket1 then @i_points
												  when @i_points <= @bracket2 then @bracket1 + @weighting1 * (@i_points - @bracket1)
												  else @bracket1 + (@bracket2 - @bracket1) * @weighting1 + (@i_points - @bracket2) * @weighting2
											  end, 0);
		end

		else
		begin

			set @v_first_range = 6500;

			set @v_second_range = 8500;

			set @v_first_range_points = case when @i_points > 0 and @v_first_range > 0 and @i_points > @v_second_range then @v_second_range - @v_first_range
											 when @i_points > 0 and @v_first_range > 0 and @i_points > @v_first_range and @i_points <= @v_second_range then @i_points - @v_first_range
											 else 0 end;

			set @v_second_range_points = case when @i_points > 0 and @v_first_range > 0 and @i_points > @v_second_range then @i_points - @v_second_range
											  else 0 end

			set @o_multiplying_points = case when @i_points <= 6500 then @i_points
											 when @i_points > @v_first_range then @v_first_range + @v_first_range_points * 1.15 + @v_second_range_points * 1.3 
											 when @i_points is null then null
											 else @i_points end;
		end

		set @o_multiplying_points = round(@o_multiplying_points,0)

		set @o_acting_points = case when @o_multiplying_points is null then null
									when isnull(@i_acting_points,0) = 0 then null
									else @o_multiplying_points * (@i_acting_points / @i_points) 
									end
		set @o_acting_points = round(isnull(@o_acting_points,0),0)

		set @o_non_acting_points = case when @o_multiplying_points is null then null
										when isnull(@i_non_acting_points,0) = 0 then null
										else @o_multiplying_points - @o_acting_points
										end

		insert @TABLE
		(user_id,acting_points,non_acting_points)
		values (@i_user_id,@o_acting_points,@o_non_acting_points);
	end

	return
	end
GO

