USE [IPEasy_test]
GO

/****** Object:  StoredProcedure [dbo].[esp_PD_CalPointsFlow]    Script Date: 2021/11/8 下午 02:03:29 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- ==========================================================================================
-- Author: nina
-- Create date: 2021-06-22
-- Description:	批量提成試算, 提成提交  
	/* 條件 :1.有承辦人 且有 TargetID
	2.有完成日期
	3.完成狀態=已完成
	4.排除部門=外包
	5.排除指派狀態in (AS01,AS04,AS05)
	6.排除子事項 = 確認委託且承辦人所別 not in (台北,台中,高雄)	 -->意思,確認委託只要抓台北台中高雄,其他都不抓
	7.在指定時間區間		  
	8.排除,確認委託 , 承辦人(Steven, hugo)
	*/
-- ==========================================================================================
CREATE PROCEDURE [dbo].[esp_PD_CalPointsFlow]
--declare 
	@p_DateF		 varchar(10),    	-- 日期起
	@p_DateT		 varchar(10), 	    -- 日期迄
	@p_Filter	     varchar(20), 		-- 其他條件組合
	@p_MtiCaseNo	 varchar(4000),     -- 案件編號
	@p_FlowUserID	 varchar(100), 		-- Flow user_id
	@p_UserID		 varchar(50) 		-- 登入員工user_id
AS
BEGIN
	--SELECT  @p_DateF='2021-09-01', @p_DateT='2021-09-30', @p_MtiCaseNo=''
	--SELECT @p_FlowUserID='49E9C2FF-2E97-40B9-BF9D-23DB089DA9FD,e41ea051-4ae4-436e-bbcc-6a1ccccd7219' /*setella,華星組*/, @p_UserID='49E9C2FF-2E97-40B9-BF9D-23DB089DA9FD'
	--SELECT @p_FlowUserID='732049ab-5ae7-47a7-8d1a-10dcc0b5d82b'/*nina*/, @p_UserID='732049ab-5ae7-47a7-8d1a-10dcc0b5d82b'
	--SELECT @p_FlowUserID='FEF90161-17FA-42FA-9C04-AC9B80E99D39'/*孟婷婷*/, @p_UserID='FEF90161-17FA-42FA-9C04-AC9B80E99D39'
	--SELECT @p_Filter='1,0,1,0,0,0,0,'  --已完成, 可提交 (程序只能查這2個條件, asp 寫固定)
	--SELECT @p_Filter='1,1,0,0,0,0,1,'  --已完成, 未完成, 可試數 (只抓有缺公式之資料, asp 寫固定)
	--SELECT @p_Filter='0,1,0,0,0,0,1,'  -- 未完成, 可試數 (IT 自由查)
	--SELECT  @p_DateF='', @p_DateT='', @p_Filter='', @p_MtiCaseNo='954999,962994,950221,950224,950227,'  --依todos.sn資料抓取

	IF OBJECT_ID('tempdb..#tmpFilter') IS NOT NULL DROP TABLE #tmpFilter
	SELECT * into #tmpFilter from dbo.ufn_split(@p_Filter,',') where value<>''

	declare @IsCheck_FinishDate varchar(1)=(select value from #tmpFilter where id=1)	--判斷條件:已完成
	declare @IsCheck_NoFinishDate varchar(1)=(select value from #tmpFilter where id=2)	--判斷條件:未完成
	declare @IsCheck_CanFlow varchar(1)=(select value from #tmpFilter where id=3)		--判斷條件:可提交
	declare @IsCheck_NoSubTodos03 varchar(1)=(select value from #tmpFilter where id=4)	--判斷條件:排除内部看稿
	declare @IsCheck_NoSubTodos01 varchar(1)=(select value from #tmpFilter where id=5)	--判斷條件:排除確認委託
	declare @IsCheck_NoClose varchar(1)=(select value from #tmpFilter where id=6)		--判斷條件:排除結案
	declare @IsCheck_CanReCal varchar(1)=(select value from #tmpFilter where id=7)		--判斷條件:可試算

	if @p_FlowUserID=@p_UserID and exists(select * from evw_Employee where user_id=@p_FlowUserID and Emp_DeptName='信息管理部') SET @p_FlowUserID='ALL'
	--print @p_FlowUserID

	IF OBJECT_ID('tempdb..#tmpTSN') IS NOT NULL DROP TABLE #tmpTSN
	CREATE TABLE #tmpTSN (SN int, case_id varchar(50), flow_user_id varchar(50), case_volume varchar(50), TaskClass_id varchar(20), points decimal(10,2), AssignStatus varchar(20), IsCheck_FinishDate varchar(1), IsCheck_NoFinishDate varchar(1), IsCheck_CanFlow varchar(1), IsCheck_CanReCal varchar(1), IsQry_NoneParam varchar(1))


	--抓初步條件的SN , 條件1.要有承辦人
	if @IsCheck_FinishDate='1' AND @IsCheck_NoFinishDate='1' AND @IsCheck_CanReCal='1' and @p_DateF='2021-01-01' --and @p_DateT=''
	begin
		-- 只抓有缺公式之資料 (傳入條件日期固定 2021-01-01 ~ '' , Filter='1,1,0,0,0,0,1,' 勾選已完成, 未完成, 可試算
		
		INSERT #tmpTSN SELECT distinct a.SN, a.case_id, p.flow_user_id, a.caseno as case_volume, a.TaskClass_id, a.points, a.AssignStatus, IsCheck_FinishDate=@IsCheck_FinishDate, IsCheck_NoFinishDate=@IsCheck_NoFinishDate, IsCheck_CanFlow=@IsCheck_CanFlow, IsCheck_CanReCal=@IsCheck_CanReCal, IsQry_NoneParam='1'/*只抓有缺公式之資料flag*/
		FROM esn_Todos  a
		inner join esn_OthData b on b.FldName='Points_tobe' and Oth_ID=Cast(a.SN as varchar(10)) and FldMemo like '%error.2.%'
		inner join p_case_info p on p.case_id=a.case_id
		WHERE a.active=1 AND ISNULL(a.AssignedTo_userid,'')<>''	   --有承辦人才能算點數
		   and a.AssignStatus not in ('AS01','AS02','AS05','AS06')	--派點狀態:AS00=待計算, AS01=運營辦指派, AS02=指派完成, AS03=系統指派, AS04=公式準備中, AS05=主管轉運營辦, AS06=已人工填寫, AS08=COO指派
		   and a.ToDosStatus not in ('TDS03')
		   and (   (isnull(a.FinishedDate_c10,'')<>'' AND isnull(convert(varchar(10),a.FinishedDate,120),'')>='2021-09-01') 
		        or (isnull(a.FinishedDate_c10,'')='' AND isnull(convert(varchar(10),a.Create_time,120),'')>=@p_DateF) ) 
		  and ((@p_FlowUserID='ALL' and 1=1) or 
		       (@p_FlowUserID<>'ALL' and exists(select 1 from dbo.ufn_split(@p_FlowUserID,',') where value=p.flow_user_id and value<>'') ) 	--案件流程人员	
			  )
	end
	else if @p_Filter='' and @p_DateF='' and @p_DateT='' and @p_MtiCaseNo<>''  --依Todos.SN 查詢, 不卡程序權限
	begin

		INSERT #tmpTSN 
		SELECT distinct a.SN, a.case_id, p.flow_user_id, a.caseno as case_volume, a.TaskClass_id, a.points, a.AssignStatus, IsCheck_FinishDate='0', IsCheck_NoFinishDate='0', IsCheck_CanFlow='0', IsCheck_CanReCal='0', IsQry_NoneParam='2'/*只抓傳入Todos.SN之資料flag*/
		FROM esn_Todos  a
		inner join p_case_info p on p.case_id=a.case_id
		WHERE a.active=1 AND ISNULL(a.AssignedTo_userid,'')<>''	   --有承辦人才能算點數
		   and a.AssignStatus not in ('AS01','AS02','AS05','AS06')	--派點狀態:AS00=待計算, AS01=運營辦指派, AS02=指派完成, AS03=系統指派, AS04=公式準備中, AS05=主管轉運營辦, AS06=已人工填寫, AS08=COO指派
		   --and a.ToDosStatus not in ('TDS03')
		   and a.SN in (select value from dbo.ufn_split(@p_MtiCaseNo,',') where value<>'')

	end
	else
	begin
		--條件2.有完成日期 , 3.完成狀態=已完成 , 5.排除指派狀態in (AS01,AS04,AS05), 7.在指定時間區間
		if @p_MtiCaseNo<>''
		begin
			INSERT #tmpTSN SELECT a.SN, a.case_id, b.flow_user_id, b.case_volume, a.TaskClass_id, a.points, a.AssignStatus, IsCheck_FinishDate=@IsCheck_FinishDate, IsCheck_NoFinishDate=@IsCheck_NoFinishDate, IsCheck_CanFlow=@IsCheck_CanFlow, IsCheck_CanReCal=@IsCheck_CanReCal, IsQry_NoneParam='0'
			FROM esn_Todos a 
			inner join p_case_info b on b.case_id=a.case_id
			where a.active=1 AND ISNULL(a.AssignedTo_userid,'')<>''
			  and exists(select 1 from dbo.ufn_split(@p_MtiCaseNo,',') where value=b.case_volume and value<>'')	 
			  and ((@p_FlowUserID='ALL' and 1=1) or 
				   (@p_FlowUserID<>'ALL' and exists(select 1 from dbo.ufn_split(@p_FlowUserID,',') where value=b.flow_user_id and value<>'') ) 	--案件流程人员	
				  )
			  and ((@IsCheck_FinishDate='0' AND 1=1)   OR (@IsCheck_FinishDate='1'   AND ToDosStatus='TDS02'/*已完成*/ AND ISNULL(a.FinishedDate,'')<>'' AND isnull(convert(varchar(10),a.FinishedDate,120),'') between @p_DateF and  @p_DateT) )    --已完成
			  and ((@IsCheck_NoFinishDate='0' AND 1=1) OR (@IsCheck_NoFinishDate='1' AND ISNULL(a.FinishedDate,'')='' and isnull(convert(varchar(10),a.StartDate2,120),'') between @p_DateF and  @p_DateT)) --未完成
			  and ((@IsCheck_NoSubTodos03='0' AND 1=1) OR (@IsCheck_NoSubTodos03='1' AND TaskClass_id<>'SubTodos_03'))	--排除内部看稿
			  and ((@IsCheck_NoSubTodos01='0' AND 1=1) OR (@IsCheck_NoSubTodos01='1' AND TaskClass_id<>'SubTodos_01'))  --排除確認委託
			  and ((@IsCheck_NoClose='0' AND 1=1)  OR (@IsCheck_NoClose='1' AND ToDosStatus<>'TDS03'))	 --排除結案
			  and ((@IsCheck_CanFlow='0' AND 1=1)  OR (@IsCheck_CanFlow='1' AND AssignStatus NOT in ('AS01','AS04','AS05')) )	--勾選可提交
			  and ((@IsCheck_CanReCal='0' AND 1=1) OR (@IsCheck_CanReCal='1' AND AssignStatus NOT in ('AS01','AS05')) )	        --勾選可試算
		end 
		else
		begin
			--if @IsCheck_FinishDate='1'
			INSERT #tmpTSN SELECT a.SN, a.case_id, b.flow_user_id, b.case_volume, a.TaskClass_id, a.points, a.AssignStatus, IsCheck_FinishDate=@IsCheck_FinishDate, IsCheck_NoFinishDate=@IsCheck_NoFinishDate, IsCheck_CanFlow=@IsCheck_CanFlow, IsCheck_CanReCal=@IsCheck_CanReCal, IsQry_NoneParam='0'
			FROM esn_Todos a 
			inner join p_case_info b on b.case_id=a.case_id
			where a.active=1 AND ISNULL(a.AssignedTo_userid,'')<>''
				and ((@IsCheck_FinishDate='0' AND 1=1)   OR (@IsCheck_FinishDate='1'   AND ToDosStatus='TDS02'/*已完成*/ AND ISNULL(a.FinishedDate,'')<>'' AND isnull(convert(varchar(10),a.FinishedDate,120),'') between @p_DateF and  @p_DateT) )    --已完成
				and ((@IsCheck_NoFinishDate='0' AND 1=1) OR (@IsCheck_NoFinishDate='1' AND ISNULL(a.FinishedDate,'')='' and isnull(convert(varchar(10),a.StartDate2,120),'') between @p_DateF and  @p_DateT)) --未完成
				and ((@IsCheck_NoSubTodos03='0' AND 1=1) OR (@IsCheck_NoSubTodos03='1' AND TaskClass_id<>'SubTodos_03'))	--排除内部看稿
				and ((@IsCheck_NoSubTodos01='0' AND 1=1) OR (@IsCheck_NoSubTodos01='1' AND TaskClass_id<>'SubTodos_01'))  --排除確認委託
				and ((@IsCheck_NoClose='0' AND 1=1)  OR (@IsCheck_NoClose='1' AND ToDosStatus<>'TDS03'))	 --排除結案
				and ((@IsCheck_CanFlow='0' AND 1=1)  OR (@IsCheck_CanFlow='1' AND AssignStatus NOT in ('AS01','AS04','AS05')) )	--勾選可提交
				and ((@IsCheck_CanReCal='0' AND 1=1) OR (@IsCheck_CanReCal='1' AND AssignStatus NOT in ('AS01','AS05')) )	        --勾選可試算

			if @p_FlowUserID<>'ALL'
			begin
				delete a from #tmpTSN a where not exists(select 1 from dbo.ufn_split(@p_FlowUserID,',') where value=flow_user_id and value<>'')  	--案件流程人员
			end
		end
	end
						 
	--刪除程序已確認或已結算
	delete #tmpTSN where dbo.efn_IsCheckClose('IsCheckClose',sn) ='1'

	--select * from #tmpTSN
	IF OBJECT_ID('tempdb..#tmpEMP') IS NOT NULL DROP TABLE #tmpEMP
	select * INTO #tmpEMP from evw_Employee	where  targetID <>0
		

	--第2次篩選, 要的資料及欄位 條件: 1.承辦人要有targetid, 4.排除部門=外包, 6.排除子事項 = 確認委託且承辦人所別 not in (台北,台中,高雄)
	IF OBJECT_ID('tempdb..#tmpDA') IS NOT NULL DROP TABLE #tmpDA
	select a.SN, p.case_volume, p.case_name, p.customer_name, p.country_id, a.case_id, p.case_type_id, p.apply_type_id, p.apply_type_zh_tw, 
			c.ctrl_proc_zh_tw, b.TaskClass_id, b.TaskDescription, b.AssignedTo_userid, AssignedTo_Name=ISNULL(s.cn_name,''),  AssignedTo_maineamil=ISNULL(s.main_email,''), AssignedTo_DSContury=ISNULL(s.Emp_DSContury,''), AssignedTo_DS=ISNULL(s.Emp_DS,''),
			director_email=isnull(s.director_email,''), director_name=isnull(s.director_name,''),  /*主管Email, 主管名稱*/
			director_badge=isnull(s.director_badge,''),
			director_userid=cast('' as varchar(50)),--isnull((SELECT TOP 1 user_id from evw_Employee where emp_no=s.director_badge and is_enabled=1),''),  /*主管user_id*/
			director_DSContury=cast('' as varchar(50)),--isnull((SELECT TOP 1 Emp_DSContury from evw_Employee where emp_no=s.director_badge and is_enabled=1),''), /*主管的國別*/
			b.FinishedDate_c10, Points=isnull(b.Points,0), b.ToDosStatus, b.ToDosStatus_Name, b.AssignStatus, b.AssignStatus_name
			,points_tobe=CASE WHEN ap.points_tobe is null then '' ELSE Cast(ap.points_tobe as varchar(20)) end 

			--派點狀態為如下時, 不顯示提成說明 (AS00=待計算, AS01=運營辦指派, AS02=指派完成, AS03=系統指派, AS04=公式準備中, AS05=主管轉運營辦, AS06=已人工填寫, AS08=COO指派)
			,points_tobe_desc=CASE WHEN b.AssignStatus in ('AS01','AS02','AS05','AS06','AS08') then '' ELSE ISNULL((select TOP 1 FldMemo  From esn_OthData where FldName='Points_tobe'  AND Oth_ID=Cast(a.SN as varchar(10)) Order by update_time DESC),'') END

			--可試算
			,IsCanReCal=dbo.efn_IsCanTobeFlow('IsCanReCal', 0, b.AssignedTo_userid, s.Emp_DS, s.targetID, b.FinishedDate, b.ToDosStatus, b.AssignStatus,b.Points, b.TaskClass_id, p.Apply_type_id, c.ctrl_proc_id)
			--可提交
			,IsCanFlow=dbo.efn_IsCanTobeFlow('IsCanFlow', b.sn, b.AssignedTo_userid, s.Emp_DS, s.targetID, b.FinishedDate, b.ToDosStatus, b.AssignStatus,b.Points, b.TaskClass_id, p.Apply_type_id, c.ctrl_proc_id)

			--涉外案
			,Case_country_id=ISNULL(p.country_id,''), Customer_country_id=ISNULL(p.Customer_country_id,''), isCheck_Country=dbo.efn_isCheck('checkCountry_id',0,p.case_id,'') 

			,p.flow_user_id, p.flow_UserCName, a.IsCheck_FinishDate, a.IsCheck_NoFinishDate, a.IsCheck_CanFlow, a.IsCheck_CanReCal, a.IsQry_NoneParam, c.proc_note
	INTO #tmpDA
	from #tmpTSN a
	inner join esn_Todos b on b.sn=a.sn
	inner join evw_p_case_info p on p.case_id=a.case_id
	inner join evw_p_proc_info c on c.proc_id=b.proc_id and c.case_id=a.case_id
	left join #tmpEMP s on s.user_id=b.AssignedTo_userid 
	left  join esn_Todos_auto_points ap on a.sn=ap.sn 
	where ((a.IsQry_NoneParam='1' and 1=1 /*只抓有缺件*/ ) OR (a.IsQry_NoneParam='2' and 1=1 /*依Todos.SN*/ ) OR 
   	       (a.IsQry_NoneParam='0' AND s.Emp_DS<>'外包所' 
	        and isnull(s.targetID,0)<>0 /*檢查承辦人有沒TargetID*/
		    and ((a.IsCheck_CanFlow='0' AND 1=1)  OR (a.IsCheck_CanFlow='1' and not (b.TaskClass_id='SubTodos_01' /*確認委託*/ and ISNULL(s.Emp_DS,'') not in ('台北所','台中所','高雄所')) ) ) --排除子事項 = 確認委託且承辦人所別 not in (台北,台中,高雄), (在勾可提交下, 要排除)
		    and ((a.IsCheck_CanFlow='0' AND 1=1)  OR (a.IsCheck_CanFlow='1' and not (b.TaskClass_id='SubTodos_01' /*確認委託*/ and b.AssignedTo_userid in ('0E416C5E-0885-4563-8838-C7781F39E116','FD67D192-041B-4725-A3E1-CB5E62A5CC61')) ) ) --8.排除,確認委託 , 承辦人(Steven, hugo)
	      ) )


	--這樣寫會比較快
	update a set director_userid=isnull((SELECT TOP 1 user_id from #tmpEMP where emp_no=a.director_badge and is_enabled=1),''),  /*主管user_id*/
				 director_DSContury=isnull((SELECT TOP 1 Emp_DSContury from #tmpEMP where emp_no=a.director_badge and is_enabled=1),'') /*主管的國別*/
	from #tmpDA a
	where director_badge<>''


	--顯示結果
	select * from #tmpDA 
	WHERE ((IsQry_NoneParam='1' AND points_tobe_desc like '%error.2.%' /*只抓有缺件*/) OR 
	       (IsQry_NoneParam='0' AND 1=1) OR
		   (IsQry_NoneParam='2' AND 1=1)
		  )
	order by case_volume, SN

END    

GO

