﻿
alter PROCEDURE [dbo].[rpt_CustCaseTot_YM] ( 
	@p_YM_F varchar(7),        -- 區期年月起值
	@p_YM_T varchar(7),        -- 區期年月迄值
    @p_RptType varchar(10),    -- 報表類別 RptType = byItem 項目 , byDept 所別, byDS 部別 
    @p_CustName nvarchar(100) 
   )
AS
BEGIN
	-- 案件統計表by項目, 案件統計表by所別, 案件統計表by部別
    -- call rpt_CustCaseTot_YM('201901','201906','byDS','华星');  
	Declare @p_EmpItem varchar(1),@Emp_ItemNo varchar(50),@p_StartDate datetime,@p_EndDate datetime,@p_StartDatet datetime;
	Declare @p_EndDateYM varchar(7),@i tinyint=1,@p_YMT_sql varchar(max)=''; 

	set @p_StartDate =Convert(datetime,@p_YM_F+'-01',126) ;
	set @p_EndDate =DATEADD(day,-1,DATEADD(month, 1,cast(@p_YM_T+'-01' as datetime))) ;   
	set @p_EndDateYM=Convert(varchar(7),@p_EndDate,126);
	
    print('1:'+convert(varchar(20),getdate(),126)) 
	select 99 as id ,Convert(varchar(7),@p_EndDate,126)  as value into #p_YMT	
	Set @p_StartDatet=@p_StartDate
	WHILE datediff(month,@p_StartDatet,@p_EndDate) >=0 
	BEGIN 
		Set @p_YMT_sql=@p_YMT_sql+'('+cast(@i as varchar(2))+',Convert(varchar(7),DATEADD(month,'+cast((@i-1) as varchar(2))+','''+(@p_YM_F+'-01')+''') ,126)),'
		--insert into #p_YMT (id,Value)
		--values(@i,Convert(varchar(7),DATEADD(month,@i-1,@p_StartDate) ,126))
		Set @i=@i+1
		Set @p_StartDatet=DATEADD(month,1,@p_StartDatet)
	END 
	set @p_YMT_sql=left(@p_YMT_sql,len(@p_YMT_sql)-1);
	--print 'insert into #p_YMT (id,Value) values ' + @p_YMT_sql 
	exec ('insert into #p_YMT (id,Value) values' +  @p_YMT_sql) 

	--/*
-- 取得「客戶名稱」的 recordset 
	SELECT ID as ItemNo,replace(replace(value, char(13),''), char(10),'') as ItemDesc into #tb_Split2 FROM [ufn_split](@p_CustName, ';') ;  

	 -- 取得RPT項目List 
	SELECT * into #tmpItem FROM (
	SELECT 1 as ItemNo, 'CN 查新' as ItemName union 
    SELECT 2, 'CN 新申請' union SELECT 3, 'PCT 新申請' union 
	SELECT 4, 'US 新申請' union SELECT 5, 'KR 新申請' union SELECT 6, 'JP 新申請' union SELECT 7, 'EA 新申請' union SELECT 8, 'EU 新申請' union 
	SELECT 9, 'IN 新申請' union SELECT 10, 'TW 新申請' union SELECT 11, 'DE 新申請' union SELECT 12, 'GB 新申請' union SELECT 13, 'RU 新申請' union 
	SELECT 41, 'CN OA' union SELECT 42, 'TW OA' union SELECT 43, 'US OA' union SELECT 45, 'KR OA' union SELECT 46, 'JP OA' union 
	SELECT 47, 'EA OA' union SELECT 48, 'DE OA' union SELECT 49, 'EU OA' union SELECT 50, 'GB OA' union SELECT 51, 'RU OA' union 
	SELECT 52, 'RCE' union SELECT 53, 'IDS' union SELECT 54, '繳費領證' 
	union SELECT 61 as ItemNo, 'CN OA-核駁' as ItemName union SELECT 62, 'TW OA-核駁' union SELECT 63, 'US OA-核駁' union SELECT 65, 'KR OA-核駁' 
	union SELECT 66, 'JP OA-核駁' union SELECT 67, 'EA OA-核駁' union SELECT 68, 'DE OA-核駁' union SELECT 69, 'EU OA-核駁' union SELECT 70, 'GB OA-核駁' union SELECT 71, 'RU OA-核駁'
	union SELECT 72 as ItemNo, 'CN-核駁' as ItemName union SELECT 73, 'TW-核駁' union SELECT 74, 'US-核駁' union SELECT 75, 'KR-核駁' 
	union SELECT 76, 'JP-核駁' union SELECT 77, 'EA-核駁' union SELECT 78, 'DE-核駁' union SELECT 79, 'EU-核駁' union SELECT 80, 'GB-核駁' union SELECT 81, 'RU-核駁'
	) a ;
	
	-- 第二部, 客戶名稱不會只有「华星」, 第一部, 客戶名稱只會有「华星」
	if (SELECT COUNT(*) FROM #tb_Split2 where ItemDesc like '%华星%' or ItemDesc like '%華星%' )>0
	 delete from #tmpItem where ItemNo > 60
	 
    print('1:'+convert(varchar(20),getdate(),126))
    -- 員工部別 (因該員工會多部別, 放在Emp_DS2裡, 所以要distinct )
	SELECT distinct a.user_name as Emp_ID, cn_name as Emp_Name,  isnull(a.Emp_DS,'') as Emp_DS,  isnull(a.Emp_DSNum,'') as Emp_DSNum,  isnull(a.Emp_Item,'') as Emp_Item, isnull(a.Emp_ItemNum,'') as Emp_ItemNum, 0 as Emp_Sort ,a.user_id
	into #tmpEmp
	FROM [dbo].[evw_Employee]  a 

	SELECT a.country_id,a.customer_name,a.PatentType,a.charge_date,a.case_volume,a.PatentType_Name,a.Case_id,a.case_status_id,a.business_type_id 
		   --,(select value from [ufn_split](a.case_volume,'-') a where a.ID=1) as CaseNo_l
		   ,(select value from [ufn_split](a.case_volume,'-') a where a.ID=2) as CaseNo_r 
		   into #tmpPatC_5All_1 FROM  [dbo].[evw_p_case_info] a 
    inner join #tb_Split2 s on a.customer_name like  s.ItemDesc +'%'
	WHERE a.charge_date between @p_StartDate AND @p_EndDate       -- 立案日 
	AND a.PatentType IN ('PN01', 'PN02', 'PN03','PN07')           -- 案件 

		-- 1.取得: 該案件之 查新, 新申請的「新進」資料
	SELECT CASE WHEN LEFT(a.CaseNo_r,1) in('M','CN') THEN 'CN 查新' END as ItemIN1,                   -- CN 查新(未完成) -->1.客戶名稱為華星, 2.案件編號有-M, 3.管制事項：完成初稿, 4.完成日為空白, 5.事務所到期日落在該月份
           CASE WHEN a.country_id='CN' AND a.PatentType IN ('PN01', 'PN02', 'PN03') AND  ics.case_status_zh_tw='撰稿中' THEN 'CN 新申請' END as ItemIN2,  -- 2.CN 新申請(新進)  -->1.國家為CN, 2.案件類別: PN01, PN02, PN03, 3.立案日落在該月份, 4.案件狀態：撰稿(RS01)
		   CASE WHEN a.country_id='WO' AND a.PatentType IN ('PN01','PN07') AND ics.case_status_zh_tw='撰稿中' THEN 'PCT 新申請' END as ItemIN3,         -- 3.PCT 新申請(新進) -->1.國家為PCT, 2.案件類別: PN01, PN07, 3.立案日落在該月份, 4.案件狀態：撰稿(RS01)
		   CASE WHEN a.country_id NOT IN ('CN','WO' ) AND a.PatentType IN ('PN01') AND b2.business_type_code='PI' AND ics.case_status_zh_tw='撰稿中' THEN a.country_id+' 新申請' END as ItemIN4, -- 4.XX 新申請(新進) --> 1.國家為XX, 2.案件類別: PN01 , 3.是 PCT國家階段, 4.立案日落在該月份, 5.案件狀態：撰稿(RS01)
		   Convert(varchar(7),a.charge_date,126) as YM_cr,a.case_volume as FlowKey, 
		   a.customer_name as Client_CompanyName, a.country_id, a.PatentType, a.PatentType_Name, ics.case_status_code as Status,
		   ics.case_status_zh_tw as Status_Names --,  InCharge,  InCharge_Name
          , e.Emp_ID, e.Emp_Name, e.Emp_DS, e.Emp_DSNum, e.Emp_Item, e.Emp_ItemNum,e.Emp_Sort 
		  into #tmpPatC_5All
	FROM #tmpPatC_5All_1 a
	 --inner join #tb_Split2 s on a.customer_name like '%'+s.ItemDesc +'%'
	Inner  JOIN [evw_p_proc_pic_list] ppl on ppl.Case_id=a.Case_id  --案件流程人员
    Inner  JOIN #tmpEmp e on  e.Emp_ID=ppl.pic_userID
	LEFT  JOIN i_case_status ics on ics.case_status_id=a.case_status_id
	LEFT  JOIN i_business_type b2 on b2.business_type_id=a.business_type_id 
    print('2:'+convert(varchar(20),getdate(),126))

	select *  into #tmpPatC_5  from (
	select CAST(ItemIN1 as varCHAR(20)) as ItemIN, a.* from #tmpPatC_5All a where ItemIN1<>''
	union
	select ItemIN2 as ItemIN, a.* from #tmpPatC_5All a where ItemIN2<>''
	union
	select ItemIN3 as ItemIN, a.* from #tmpPatC_5All a where ItemIN3<>''
	union
	select ItemIN4 as ItemIN, a.* from #tmpPatC_5All a where ItemIN4<>'' 
	) a
	; 
    print('3:'+convert(varchar(20),getdate(),126)) 

	-- 2.取得: ToDos  
	--;with tmpTodosAll_1 as(
	--select sn,proc_id,CaseType,CaseType_Name,CaseNo,TaskDescription,StartDate2,AttorneyDueDate,FinishedDate,AssignedTo_userid,
	--b.Emp_ID as AssignedTo,b.Emp_Name as AssignedTo_Name,Points,ExchangeRate,Matter,Matter_Name,PatentType,PatentType_Name,ToDosStatus,ToDosStatus_Name,
	--case_id
	--from evw_esn_todos a
	--inner join #tmpEmp b on a.AssignedTo_userid=b.user_id
	--where (a.StartDate2 between @p_StartDate AND @p_EndDate) OR        -- 起始日
	--	   (a.FinishedDate between @p_StartDate AND @p_EndDate) OR      -- 完成日
	--	   (a.AttorneyDueDate between @p_StartDate AND @p_EndDate)
	--	AND a.PatentType IN ('PN01', 'PN02', 'PN03','PN07')
	--)
    print('3-1:'+convert(varchar(20),getdate(),126)) 
		select sn,a.proc_id,CaseType,CaseType_Name,CaseNo,TaskDescription,StartDate2,AttorneyDueDate,FinishedDate,AssignedTo_userid,
	b.Emp_ID as AssignedTo,b.Emp_Name as AssignedTo_Name,Points,ExchangeRate,Matter,Matter_Name,PatentType,PatentType_Name,ToDosStatus,ToDosStatus_Name,a.case_id
	,isnull(c.review_stage,'') as review_stage
	into #tmpTodosAll_1
	from evw_esn_todos a
	inner join #tmpEmp b on a.AssignedTo_userid=b.user_id
	inner join p_proc_info c on a.proc_id=c.proc_id
	where 
		   ((a.StartDate2 between @p_StartDate AND @p_EndDate) OR        -- 起始日
		   (a.FinishedDate between @p_StartDate AND @p_EndDate) OR      -- 完成日
		   (a.AttorneyDueDate between @p_StartDate AND @p_EndDate))
		AND a.PatentType IN ('PN01', 'PN02', 'PN03','PN07')

		
    print('3-2:'+convert(varchar(20),getdate(),126)) 
	SELECT a.* , case when ibt.business_type_code='PN' THEN 'Y' END as PctNationalPhase,p.country_id as office,Cast(a.sn as varchar(20)) as Flowkey 
	,p.customer_name as Client_CompanyName
	,(select value from [ufn_split](a.CaseNo,'-') a where a.ID=2) as CaseNo_r 
	,e.Emp_ID, e.Emp_Name,e.Emp_DSNum, e.Emp_Item, e.Emp_ItemNum, 0 as Emp_Sort ,e.Emp_DS
	into #tmpTodosAll
	FROM #tmpTodosAll_1 a
	inner join [evw_p_case_info] p on p.case_id=a.case_id
	--left join p_case_info p on p.case_id=a.case_id
	--left join c_customer c on p.customer_id=c.customer_id
    inner join #tb_Split2 s  on p.customer_name like s.ItemDesc +'%'
	--left join i_case_status ics on ics.case_status_id=p.case_status_
	left join i_business_type ibt on ibt.business_type_id=p.business_type_id
    left join #tmpEmp e on a.AssignedTo_userid=e.user_id
	;
    print('4:'+convert(varchar(20),getdate(),126))
	--return
	-- 3.取得: OA 的「新進」資料  
	SELECT CASE WHEN a.Office='CN' AND (CHARINDEX('審查意見',a.TaskDescription)>0 OR CHARINDEX('审查意见',a.TaskDescription)>0)  THEN 'CN OA' END as ItemIN1,         -- CN OA(新進) -->1.國家為CN , 2.抓管制事項：审查意见/驳回, 3.起始日落在該月份, 4.案件狀態：答辯中-撰稿(RS05.1)
		   CASE WHEN a.Office='TW' AND review_stage<>''  AND (CHARINDEX('申復',a.TaskDescription)>0 OR CHARINDEX('申复',a.TaskDescription)>0 OR CHARINDEX('提出再審',a.TaskDescription)>0) THEN 'TW OA' END as ItemIN2,    -- TW OA(新進) -->1.國家為TW, 2.抓管制事項：申復/提出再審 3.起始日落在該月份, 4.案件狀態：答辯中(RS05)
		   CASE WHEN a.Office='US' AND review_stage<>''  AND (CHARINDEX('response',LOWER(a.TaskDescription))>0 OR CHARINDEX('election',LOWER(a.TaskDescription))>0 OR CHARINDEX('advisory action',LOWER(a.TaskDescription))>0 OR CHARINDEX('parte quayle',LOWER(a.TaskDescription))>0)  THEN 'US OA' END as ItemIN3, -- US OA(新進) -->1.國家為US, 2.抓管制事項：Respnose/Election/Advisory Action/parte quayle  3.起始日落在該月份, 4.案件狀態：答辯中(RS05)
		   CASE WHEN a.Office='KR' AND review_stage<>''  AND (CHARINDEX('response',LOWER(a.TaskDescription))>0 OR CHARINDEX('Re-examination',LOWER(a.TaskDescription))>0 OR CHARINDEX('appeal',LOWER(a.TaskDescription))>0 OR CHARINDEX('final rejection',LOWER(a.TaskDescription))>0)  THEN 'KR OA' END as ItemIN4,    -- KR OA(新進) -->1.國家為KR, 2.抓管制事項：Response/Request for Re-examination/Appeal/final rejection 3.起始日落在該月份, 4.案件狀態：答辯中(RS05)
		   CASE WHEN a.Office='JP' AND review_stage<>''  AND review_stage<>'' AND (CHARINDEX('response',LOWER(a.TaskDescription))>0 OR CHARINDEX('appeal',LOWER(a.TaskDescription))>0 OR CHARINDEX('行政訴訟',a.TaskDescription)>0 )  THEN 'JP OA' END as ItemIN5,      -- JP OA(新進) -->1.國家為JP, 2.抓管制事項：Response/Appeal/行政訴訟  3.起始日落在該月份, 4.案件狀態：答辯中(RS05)
		   CASE WHEN a.Office NOT IN ('CN', 'TW', 'US','KR', 'JP') AND review_stage<>''  AND CHARINDEX('response',LOWER(a.TaskDescription))>0 THEN a.Office+' OA' END as ItemIN6,     -- XX OA(新進) -->1.國家為XX, 2.抓管制事項：Response  3.起始日落在該月份, 4.案件狀態：答辯中(RS05)
		   CASE WHEN a.TaskDescription='RCE' THEN 'RCE' END as ItemIN7,                                                                 -- RCE(新進) -->1.不分國家, 2.抓管制事項：RCE, 3.起始日落在該月份
		   CASE WHEN a.TaskDescription='IDS' THEN 'IDS' END as ItemIN8,                                                                 -- IDS(新進) -->1.不分國家, 2.抓管制事項：IDS, 3.起始日落在該月份
		   CASE WHEN (CHARINDEX('繳費領證',a.TaskDescription)>0 OR CHARINDEX('缴纳领证',a.TaskDescription)>0) THEN '繳費領證' END as ItemIN9, -- 繳費領證(新進) -->1.不分國家, 2.抓管制事項：繳費領證, 3.起始日落在該月份
		   CASE WHEN ( CHARINDEX('駁回',a.TaskDescription)>0 OR CHARINDEX('驳回',a.TaskDescription)>0) THEN a.Office+'-核駁' END as ItemIN10,  
		  Convert(varchar(7),a.StartDate2,126)  as YM_ST, a.*,  getdate() as sysDate 
	into #tmpTodos5_1All 
	FROM #tmpTodosAll a
	WHERE a.StartDate2 between @p_StartDate AND @p_EndDate 
	; 

	select CAST(ItemIN1 as varCHAR(20)) as ItemIN, a.* into #tmpTodos5_1 from #tmpTodos5_1All a where ItemIN1<>''; 
	insert #tmpTodos5_1 
	select ItemIN2 as ItemIN, a.* from #tmpTodos5_1All a where ItemIN2<>'' 
	union select ItemIN3 as ItemIN, a.* from #tmpTodos5_1All a where ItemIN3<>'' union select ItemIN4 as ItemIN, a.* from #tmpTodos5_1All a where ItemIN4<>''
	union select ItemIN5 as ItemIN, a.* from #tmpTodos5_1All a where ItemIN5<>'' union select ItemIN6 as ItemIN, a.* from #tmpTodos5_1All a where ItemIN6<>''
	union select ItemIN7 as ItemIN, a.* from #tmpTodos5_1All a where ItemIN7<>'' union select ItemIN8 as ItemIN, a.* from #tmpTodos5_1All a where ItemIN8<>''
	union select ItemIN9 as ItemIN, a.* from #tmpTodos5_1All a where ItemIN9<>'' union select ItemIN10 as ItemIN, a.* from #tmpTodos5_1All a where ItemIN10<>''; 
	-- ALTER TABLE tmpTodos5_1 ADD INDEX(`CaseNo`);

    print('5:'+convert(varchar(20),getdate(),126))  
	-- 4.取得: OA 的「「完成」資料 
	SELECT CASE WHEN LEFT(a.CaseNo_r,1) in('M','CN') AND (CHARINDEX('提出報告',a.TaskDescription)>0 OR CHARINDEX('提出报告',a.TaskDescription)>0) THEN 'CN 查新' END as ItemFH1,  -- CN 查新(完成) -->1.案件編號有-M, 3.案件狀態：結案(RS11), 4.管制事項：提出報告, 5.完成日落在該月份
		   CASE WHEN a.Office='CN' AND review_stage=''  AND a.PatentType IN ('PN01', 'PN02', 'PN03') AND a.TaskDescription='完成初稿'   THEN 'CN 新申請' END as ItemFH2,  -- CN 新申請(完成) -->1.國家為CN, 2.案件類別: PN01, PN02, PN03, 3.管制事項：完成初稿, 4.完成日落在該月份, 5. 案件程序:中國發明申請(CNP01)
		   CASE WHEN a.Office='WO' AND review_stage='' AND a.PatentType IN ('PN01','PN07') AND a.TaskDescription='完成初稿' THEN 'PCT 新申請' END as ItemFH3,         -- PCT 新申請(完成)-->1.國家為PCT, 2.案件類別: PN01, PN07, 3.管制事項：完成初稿, 4.完成日落在該月份, 5. 案件程序:PCT國際申請(WOP01)
		   CASE WHEN a.Office='TW' AND review_stage='' AND a.PatentType='PN01' AND a.PctNationalPhase='Y' AND a.TaskDescription='完成初稿'  THEN 'TW 新申請' END as ItemFH5, -- TW 新申請(完成)-->1.國家為TW, 2.案件類別: PN01, PN07, 3.管制事項：完成初稿, 4.完成日落在該月份, 5. 案件程序:台灣發明申請(TWP01)
		   CASE WHEN a.Office NOT IN ('CN', 'WO','TW') AND review_stage='' AND (LEFT(a.CaseNo_r,1)<>'M')
					 AND a.PatentType='PN01' AND a.PctNationalPhase='Y' AND a.TaskDescription='完成初稿' THEN a.Office+' 新申請' END as ItemFH6,   -- XX 新申請(完成) -->1.國家為XX, 2.案件類別: PN01 , 3.是 PCT國家階段, 4.管制事項：完成初稿, 5.完成日落在該月份, 6. 案件程序:專利申請(P01)
				
		   CASE WHEN Office='CN' AND review_stage<>''  AND CHARINDEX('完成初稿',a.TaskDescription)>0   THEN 'CN OA' END as ItemFH7, -- CN OA(完成) -->1.國家為CN, 2.抓管制事項：完成初稿(都含), 3.完成日落在該月份, 4.案件程序: 中國發明審查(CNP02)
		   CASE WHEN Office='TW' AND review_stage<>''  AND a.TaskDescription='完成初稿'  THEN 'TW OA' END as ItemFH8,           -- TW OA(完成) -->1.國家為TW, 2.抓管制事項：完成初稿(只有這4個字), 4.完成日落在該月份, 4.案件程序: 台灣發明審查(TWP02)
		   CASE WHEN Office='US' AND review_stage<>''  AND a.TaskDescription='完成初稿'  THEN 'US OA' END as ItemFH9,           -- US OA(完成) -->1.國家為US, 2.抓管制事項：完成初稿(只有這4個字), 4.完成日落在該月份, 4.案件程序: 美國Utility審查(USP02)
		   CASE WHEN  Office NOT IN ('CN', 'TW','US') AND review_stage<>''  AND a.TaskDescription='完成初稿' THEN a.Office+' OA' END as ItemFH10,  -- XX OA(完成) -->1.國家為XX,  2.抓管制事項：完成初稿(只有這4個字), 4.完成日落在該月份, 4.案件程序: 專利審查(P02)
				
		   CASE WHEN Office='CN' AND CHARINDEX('核駁報導',a.TaskDescription)>0  THEN 'CN-核駁' END as ItemFH71, -- CN OA-核駁(完成) -->1.國家為CN, 2.抓管制事項：核駁報導(都含), 3.完成日落在該月份, 4.案件程序: 中國發明審查(CNP02)
		   CASE WHEN a.TaskDescription='核駁報導' AND a.Office NOT IN('CN') THEN a.Office+'-核駁' END as ItemFH81, -- XX OA-核駁(未完成) -->1.國家為XX, 2.管制事項：完成初稿(只有這4個字), 3.案件狀態：答辯中(RS05), 4.完成日為空白, 5.事務到期日落在該月份

		   CASE WHEN CHARINDEX('rce', LOWER(a.TaskDescription))>0 THEN 'RCE' END as ItemFH91,     -- RCE(完成) -->1.不分國家, 2.抓管制事項：RCE -->完成日落在該月份
		   CASE WHEN CHARINDEX('ids', LOWER(a.TaskDescription))>0 THEN 'IDS' END as ItemFH101,     -- IDS(完成) -->1.不分國家, 2.抓管制事項：IDS -->完成日落在該月份
		   CASE WHEN CHARINDEX('繳費領證', a.TaskDescription)>0 THEN '繳費領證' END as ItemFH111,  -- 繳費領證(完成) -->1.不分國家, 2.管制事項有「繳費領證」該項, 3.抓管制事項：完成初稿 -->完成日落在該月份
			Convert(varchar(7),a.FinishedDate,126)  as YM_FH, a.*
	into #tmpTodos5_2All
	FROM #tmpTodosAll a
	WHERE a.FinishedDate between @p_StartDate AND @p_EndDate 
	  AND (CHARINDEX('完成初稿',a.TaskDescription)>0 OR CHARINDEX('提出報告',a.TaskDescription)>0 OR CHARINDEX('提出报告',a.TaskDescription)>0 OR 
           CHARINDEX('rce', LOWER(a.TaskDescription))>0 OR CHARINDEX('ids', LOWER(a.TaskDescription))>0 OR CHARINDEX('繳費領證', a.TaskDescription)>0 OR 
		   CHARINDEX('核駁報導', a.TaskDescription)>0 
		   )
	;   

    print('6:'+convert(varchar(20),getdate(),126)) 
	select CAST(ItemFH1 as varCHAR(20)) as ItemFH, a.* into #tmpTodos5_2 from #tmpTodos5_2All a where ItemFH1<>'';
	insert #tmpTodos5_2 
	select ItemFH2 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH2<>''
	union select ItemFH3 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH3<>''-- union select ItemFH4 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH4<>''
	union select ItemFH5 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH5<>'' union select ItemFH6 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH6<>''
	union select ItemFH7 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH7<>'' union select ItemFH8 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH8<>''
	union select ItemFH9 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH9<>'' union select ItemFH10 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH10<>''
	union select ItemFH71 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH71<>'' union select ItemFH81 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH81<>'' 
	union select ItemFH91 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH91<>''
	union select ItemFH101 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH101<>'' union select ItemFH111 as ItemFH, a.* from #tmpTodos5_2All a where ItemFH111<>'';
	 
	  

    print('7:'+convert(varchar(20),getdate(),126)) 
	-- 5.取得:「未完成」資料 
	SELECT CASE WHEN LEFT(a.CaseNo_r,1) in('M','CN') AND (CHARINDEX('提出報告',a.TaskDescription)>0 OR CHARINDEX('提出报告',a.TaskDescription)>0) THEN 'CN 查新' END as Item_NotFH1,    -- CN 查新(未完成) -->1.客戶名稱為華星, 2.案件編號有-M, 3.管制事項：提出报告, 4.完成日為空白, 5.事務到期日落在該月份
		   CASE WHEN a.Office='CN' AND review_stage='' AND a.PatentType IN ('PN01', 'PN02', 'PN03') AND a.TaskDescription='完成初稿'  THEN 'CN 新申請' END as Item_NotFH2, -- CN 新申請(未完成) -->1.國家為CN, 2.案件類別: PN01, PN02, PN03, 3.管制事項：完成初稿(只有這4個字), 4.案件狀態：撰稿(RS01), 5.完成日為空白, 6.事務到期日落在該月份
		   CASE WHEN a.Office='WO' AND review_stage='' AND a.PatentType IN ('PN01','PN07') AND a.TaskDescription='完成初稿' THEN 'PCT 新申請' END as Item_NotFH3,        -- PCT 新申請(未完成)-->1.國家為PCT, 2.案件類別: PN01, PN07, 3.管制事項：完成初稿(只有這4個字), 4.案件狀態：撰稿(RS01), 5.完成日為空白, 6.事務到期日落在該月份
		   CASE WHEN a.Office NOT IN ('CN', 'WO') and review_stage='' AND a.PatentType='PN01' AND a.PctNationalPhase='Y' AND a.TaskDescription='完成初稿'  THEN a.Office+' 新申請' END as Item_NotFH4,    -- XX 新申請(未完成) -->1.國家為XX, 2.案件類別: PN01 , 3.是 PCT國家階段, 4.管制事項：完成初稿(只有這4個字), 5.案件狀態：撰稿(RS01), 5.完成日為空白, 6.事務到期日落在該月份
				
		   CASE WHEN a.Office IN('CN') and CHARINDEX('完成初稿',a.TaskDescription)>0 AND review_stage<>''   THEN 'CN OA' END as Item_NotFH5,      -- CN OA(未完成) -->1.國家為CN, 2.管制事項：完成初稿(都含), 3.案件狀態：答辯中-撰稿(RS05.1), 4.完成日為空白, 5.事務到期日落在該月份
		   CASE WHEN a.TaskDescription='完成初稿' AND review_stage<>''  AND a.Office NOT IN('CN') THEN a.Office+' OA' END as Item_NotFH6, -- XX OA(未完成) -->1.國家為XX, 2.管制事項：完成初稿(只有這4個字), 3.案件狀態：答辯中(RS05), 4.完成日為空白, 5.事務到期日落在該月份

		   CASE WHEN a.Office IN('CN') and CHARINDEX('核駁報導',a.TaskDescription)>0 THEN 'CN-核駁' END as Item_NotFH51,      -- CN OA-核駁(未完成) -->1.國家為CN, 2.管制事項：完成初稿(都含), 3.案件狀態：答辯中-撰稿(RS05.1), 4.完成日為空白, 5.事務到期日落在該月份
		   CASE WHEN a.TaskDescription='核駁報導' AND a.Office NOT IN('CN') THEN a.Office+'-核駁' END as Item_NotFH61, -- XX OA-核駁(未完成) -->1.國家為XX, 2.管制事項：完成初稿(只有這4個字), 3.案件狀態：答辯中(RS05), 4.完成日為空白, 5.事務到期日落在該月份

		   CASE WHEN CHARINDEX('rce', LOWER(a.TaskDescription))>0 THEN 'RCE' END as Item_NotFH7,       -- RCE(未完成) -->1.不分國家, 2.管制事項：「RCE」該項, 3.完成日為空白, 4.事務到期日落在該月份
		   CASE WHEN CHARINDEX('ids', LOWER(a.TaskDescription))>0 THEN 'IDS' END as Item_NotFH8,       -- IDS(未完成) -->1.不分國家, 2.管制事項：「IDS」該項, 3.完成日為空白, 4.事務到期日落在該月份
		   CASE WHEN CHARINDEX('繳費領證', a.TaskDescription)>0  THEN '繳費領證' END as Item_NotFH9,   -- 繳費領證(未完成) -->1.不分國家, 2.管制事項：「繳費領證」該項, 3.完成日為空白, 4.事務到期日落在該月份

		   CASE WHEN (a.AttorneyDueDate=''  or a.AttorneyDueDate is null) THEN '' ELSE  Convert(varchar(7),a.AttorneyDueDate,126) END as YM_AD, a.*
	into #tmpTodos5_3All
	FROM #tmpTodosAll a
	WHERE ((a.AttorneyDueDate between @p_StartDate AND @p_EndDate ) AND (a.finishedDate='' or a.finishedDate is null)) 
	  AND (CHARINDEX('完成初稿',a.TaskDescription)>0 OR CHARINDEX('提出報告',a.TaskDescription)>0 OR CHARINDEX('提出报告',a.TaskDescription)>0 OR 
           CHARINDEX('rce', LOWER(a.TaskDescription))>0 OR CHARINDEX('ids', LOWER(a.TaskDescription))>0 OR CHARINDEX('繳費領證', a.TaskDescription)>0 OR 
		   CHARINDEX('核駁報導', a.TaskDescription)>0 )
	;
	select CAST(Item_NotFH1 as varCHAR(20)) as Item_NotFH, a.* into #tmpTodos5_3 from #tmpTodos5_3All a where Item_NotFH1<>'';
	Insert into #tmpTodos5_3
	select Item_NotFH2 as Item_NotFH, a.* from #tmpTodos5_3All a where Item_NotFH2<>''
	Union select Item_NotFH3 as Item_NotFH, a.* from #tmpTodos5_3All a where Item_NotFH3<>''
	Union select Item_NotFH4 as Item_NotFH, a.* from #tmpTodos5_3All a where Item_NotFH4<>''
	Union select Item_NotFH5 as Item_NotFH, a.* from #tmpTodos5_3All a where Item_NotFH5<>''
	Union select Item_NotFH6 as Item_NotFH, a.* from #tmpTodos5_3All a where Item_NotFH6<>''
	Union select Item_NotFH7 as Item_NotFH, a.* from #tmpTodos5_3All a where Item_NotFH7<>''
	Union select Item_NotFH8 as Item_NotFH, a.* from #tmpTodos5_3All a where Item_NotFH8<>''
	Union select Item_NotFH9 as Item_NotFH, a.* from #tmpTodos5_3All a where Item_NotFH9<>''
	Union select Item_NotFH51 as Item_NotFH, a.* from #tmpTodos5_3All a where Item_NotFH51<>''
	Union select Item_NotFH61 as Item_NotFH, a.* from #tmpTodos5_3All a where Item_NotFH61<>'';
    print('8:'+convert(varchar(20),getdate(),126))  
    --print(convert(varchar(20),getdate(),126)) 
	-- ALTER TABLE tmpTodos5_3 ADD INDEX(`CaseNo`);
	--*/ 
	; 
	-- 6.結果
DECLARE @SqlString varchar(max)= '', @SqlJoinString varchar(max)= '', @CommonString varchar(max)= '', @CommonStringJoin1 varchar(max)= '', @CommonStringJoin2 varchar(max)= '',
@CommonStringJoin3 varchar(max)= '', @CommonStringJoin4 varchar(max)= '', @SortString varchar(500)= '', @cnt tinyint= 1, @cntT varchar(3)= '', @cntO varchar(3)= '', 
@groupcase1 varchar(200)= '', @groupcase2 varchar(200)= '', @groupcase3 varchar(200)= '', @groupcase4 varchar(200)= '', @groupcase varchar(200)= '', @p_YMT_value varchar(7);

WHILE @cnt < 13
BEGIN
	SET @cntT = RIGHT(REPLICATE('0', 2) + CAST(@cnt AS varchar), 2); -- 補零
	SET @cntO = CAST(@cnt AS varchar);
	SET @p_YMT_value =
	(
		SELECT Value
		FROM #p_YMT
		WHERE id = @cntO
	);	 
	if @p_YMT_value is not null
	BEGIN
	SET @CommonString = @CommonString + 'CASE WHEN ''' + @p_EndDateYM + ''' >= ''' + @p_YMT_value + '''  THEN 1 ELSE 0 END v' + @cntT + ',STUFF ((SELECT distinct '','' + (CASE WHEN attr_IN' + @cntT 
	+ '<>'''' THEN attr_IN' + @cntT + ' END) @groupcase FOR XML PATH('''')), 1, 1, N'''') as attr_IN' + @cntT + '_todos2, SUM(Isnull(IN' + @cntT + ',0)) as ''新進_' + @cntT 
	+ ''', STUFF ((SELECT distinct '','' + (CASE WHEN attr_FH' + @cntT + '<>'''' THEN attr_FH' + @cntT + ' END) @groupcase FOR XML PATH('''')), 1, 1, N'''') as attr_FH' 
	+ @cntT + '_todos2, SUM(Isnull(FH' + @cntT + ',0)) as ''完成_' + @cntT + ''',';
	SET @CommonStringJoin1 = @CommonStringJoin1 + 'SUM(CASE WHEN YM_cr= ''' + @p_YMT_value + ''' THEN 1 ELSE 0 END) as IN' + @cntT + ',STUFF ((SELECT distinct '','' + (CASE WHEN p.YM_cr= ''' + @p_YMT_value + ''' THEN FlowKey END)  @groupcase FOR XML PATH('''')), 1, 1, N'''')  as attr_IN' + @cntT + ',' + ' 0 as FH' + @cntT + ', '''' as attr_FH' + @cntT + ',';
	SET @CommonStringJoin2 = @CommonStringJoin2 + 'SUM(CASE WHEN YM_ST=''' + @p_YMT_value + ''' THEN 1 ELSE 0 END) as IN' + @cntT + ',STUFF ((SELECT distinct '','' + (CASE WHEN YM_ST= ''' + @p_YMT_value + ''' THEN FlowKey END)  @groupcase FOR XML PATH('''')), 1, 1, N'''')  as attr_IN' + @cntT + ',' + ' 0 as FH' + @cntT + ', '''' as attr_FH' + @cntT + ',';
	SET @CommonStringJoin3 = @CommonStringJoin3 + '0 as IN' + @cntT + ', '''' as attr_IN' + @cntT + ',' + 'SUM(CASE WHEN YM_FH= ''' + @p_YMT_value + ''' THEN 1 ELSE 0 END) as FH' + @cntT + ', STUFF ((SELECT distinct '','' + (CASE WHEN YM_FH= ''' + @p_YMT_value + ''' THEN FlowKey END)  @groupcase FOR XML PATH('''')), 1, 1, N'''')  as attr_FH' + @cntT + ',';
	SET @CommonStringJoin4 = @CommonStringJoin4 + '0 as IN' + @cntT + ', '''' as attr_IN' + @cntT + ',' + '0 as FH' + @cntT + ', '''' as attr_FH' + @cntT + ', ';
	END
	SET @cnt = @cnt + 1;
END;
SET @CommonString = @CommonString + +'1 as v13, STUFF ((SELECT distinct '','' + (CASE WHEN att_cntNotFH<>'''' THEN att_cntNotFH END) @groupcase FOR XML PATH('''')), 1, 1, N'''') as attr_NotFH_todos2, SUM(isnull(cntNotFH,0)) as 未完成 ';

SET @CommonStringJoin1 = @CommonStringJoin1 + ' 0 as cntNotFH, '''' as att_cntNotFH ';

SET @CommonStringJoin2 = @CommonStringJoin2 + ' 0 as cntNotFH, '''' as att_cntNotFH ';

SET @CommonStringJoin3 = @CommonStringJoin3 + ' 0 as cntNotFH, '''' as att_cntNotFH ';

SET @CommonStringJoin4 = @CommonStringJoin4 + ' COUNT(Item_NotFH) as cntNotFH, STUFF ((SELECT distinct '','' + FlowKey  @groupcase FOR XML PATH('''')), 1, 1, N'''') as attr_cntNotFH '; 

IF @p_RptType = 'byItem'  -- by 項目
BEGIN 
	SET @groupcase = ' from #tmpItem p LEFT JOIN #tmp_SqlJoin q  ON p.ItemName=q.ItemIN  where p.ItemNo=a.ItemNo and p.ItemName=a.ItemName  ';
	SET @groupcase1 = ' from #tmpPatC_5 p  WHERE p.ItemIN<>'''' and p.ItemIN=a.ItemIN ';
	SET @groupcase2 = ' from #tmpTodos5_1 p  WHERE p.ItemIN<>'''' and p.ItemIN=a.ItemIN   ';
	SET @groupcase3 = ' from #tmpTodos5_2 p WHERE p.ItemFH<>'''' and p.ItemFH=a.ItemFH  ';
	SET @groupcase4 = ' from #tmpTodos5_3 p where p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH ';
	SET @SqlJoinString = @SqlJoinString + ' select a.* into #tmp_SqlJoin from (
	 SELECT ItemIN, ' + replace(@CommonStringJoin1, '@groupcase', @groupcase1) +',count(Emp_ID) as Emp_ID   ' + 'FROM #tmpPatC_5 a WHERE ItemIN<>'''' GROUP BY ItemIN,Emp_ID  ' 
	 + 'Union all ' + 'SELECT ItemIN, ' + replace(@CommonStringJoin2, '@groupcase', @groupcase2) +',count(Emp_ID) as Emp_ID  ' +'FROM #tmpTodos5_1 a WHERE ItemIN<>'''' GROUP BY ItemIN,Emp_ID  '
	 + 'Union all ' + 'SELECT ItemFH as ItemIN, ' + replace(@CommonStringJoin3, '@groupcase', @groupcase3) +',count(Emp_ID) as Emp_ID  ' + 'FROM #tmpTodos5_2 a WHERE ItemFH<>'''' GROUP BY ItemFH,Emp_ID  ' 
	 + 'Union all ' + 'SELECT Item_NotFH as ItemIN, ' + replace(@CommonStringJoin4, '@groupcase', @groupcase4) +',count(Emp_ID)  as Emp_ID ' +'FROM #tmpTodos5_3 a where Item_NotFH<>'''' GROUP BY Item_NotFH,Emp_ID  ) a  order by ItemIN';  
	--select cast(@SqlJoinString as varchar(max)); --debug query
		--Exec (@SqlJoinString+' ; select * from   #tmp_SqlJoin ');  
	SET @SqlString = @SqlString + @SqlJoinString + ' ;';
	SET @SqlString = @SqlString + 'SELECT a.ItemName as attr_ItemName, a.ItemName as 項目, '''' as attr_Emp_ID,'
	--+'sum(isnull(Emp_ID,0)) as 人數, ' 
	+ replace(@CommonString, '@groupcase', @groupcase) + '  ' + 'FROM #tmpItem a ' 
	+ 'INNER JOIN #tmp_SqlJoin b ON a.ItemName=b.ItemIN ' + ' GROUP BY a.ItemNo, a.ItemName  Order by a.ItemNo ;' ;
END;
ELSE
BEGIN
	IF @p_RptType = 'byDept'
	BEGIN 
		-- by 所別 
		SET @groupcase = '  from #tmpItem p LEFT JOIN #tmp_SqlJoin q  ON p.ItemName=q.ItemIN  where p.ItemNo=a.ItemNo and p.ItemName=a.ItemName and q.Emp_DS=b.Emp_DS and q.Emp_Sort=b.Emp_Sort ';
		SET @groupcase1 = ' from #tmpPatC_5 p  WHERE p.ItemIN<>'''' and p.ItemIN=a.ItemIN and p.Emp_DS=a.Emp_DS and p.Emp_Sort=a.Emp_Sort  ';
		SET @groupcase2 = ' from #tmpTodos5_1 p  WHERE p.ItemIN<>'''' and p.ItemIN=a.ItemIN and p.Emp_DS=a.Emp_DS and p.Emp_Sort=a.Emp_Sort  ';
		SET @groupcase3 = ' from #tmpTodos5_2 p WHERE p.ItemFH<>'''' and p.ItemFH=a.ItemFH and p.Emp_DS=a.Emp_DS and p.Emp_Sort=a.Emp_Sort ';
		SET @groupcase4 = ' from #tmpTodos5_3 p where p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH and p.Emp_DS=a.Emp_DS and p.Emp_Sort=a.Emp_Sort ';
		SET @SqlJoinString = @SqlJoinString + 'select a.* into #tmp_SqlJoin from (
							 SELECT  ItemIN, Emp_DS, Emp_Sort,' + replace(@CommonStringJoin1, '@groupcase', @groupcase1) +',count(Emp_ID) as Emp_ID   ' +'FROM #tmpPatC_5 a WHERE ItemIN<>'''' GROUP BY ItemIN, Emp_DS, Emp_Sort,Emp_ID   ' 
							 + 'Union all ' + 'SELECT  ItemIN, Emp_DS, Emp_Sort,' + replace(@CommonStringJoin2, '@groupcase', @groupcase2) + ',count(Emp_ID) as Emp_ID   ' +'FROM #tmpTodos5_1 a WHERE ItemIN<>''''  GROUP BY ItemIN, Emp_DS, Emp_Sort ,Emp_ID   ' 
							 + 'Union all ' + 'SELECT ItemFH as ItemIN, Emp_DS, Emp_Sort, ' + replace(@CommonStringJoin3, '@groupcase', @groupcase3) +',count(Emp_ID) as Emp_ID   ' + 'FROM #tmpTodos5_2 a WHERE ItemFH<>''''  GROUP BY ItemFH, Emp_DS, Emp_Sort,Emp_ID   ' 
							 + 'Union all ' + 'SELECT Item_NotFH as ItemIN, Emp_DS, Emp_Sort, ' + replace(@CommonStringJoin4, '@groupcase', @groupcase4) +',count(Emp_ID) as Emp_ID   ' + 'FROM #tmpTodos5_3 a where Item_NotFH<>''''  GROUP BY Item_NotFH, Emp_DS, Emp_Sort,Emp_ID    ) a order by ItemIN';  
		--select cast(@SqlJoinString as varchar(max)); --debug query
		--Exec (@SqlJoinString+' ; select * from   #tmp_SqlJoin ');  
		SET @SqlString = @SqlString + @SqlJoinString + ' ;';
		--SET @SqlString = @SqlString + 'SELECT a.ItemName as attr_ItemName, a.ItemName as 項目, Emp_DS as attr_Emp_DS,  ISNULL(Emp_DS,''未指定所別'') as 所別, ' + replace(@CommonString, '@groupcase', @groupcase) 
		SET @SqlString = @SqlString + 'SELECT a.ItemName as attr_ItemName,  a.ItemName as 項目, Emp_DS as attr_Emp_DS,case when  ISNULL(Emp_DS,'''')='''' Then ''未指定所別'' Else Emp_DS END as 所別,'''' as attr_Emp_ID,'
		--+'sum(isnull(Emp_ID,0)) as 人數, ' 
		+ replace(@CommonString, '@groupcase', @groupcase) 
		+ '  ' + 'FROM #tmpItem a ' + 'INNER JOIN #tmp_SqlJoin b ON a.ItemName=b.ItemIN ' + ' GROUP BY a.ItemNo, a.ItemName, Emp_DS ,Emp_Sort
		Order by a.ItemNo, CASE Emp_DS WHEN ''台北所'' then 10 WHEN ''台中所'' THEN 20 WHEN ''高雄所'' 
		THEN 30 WHEN ''上海所'' THEN 40 WHEN ''深圳所'' THEN 50 WHEN
		''武漢所'' THEN 60 WHEN ''蘇州所'' THEN 70 WHEN ''外包人員'' THEN 80 WHEN ''小計'' THEN 999 ELSE 990 END, Emp_Sort ; ' ;
	END;
	ELSE
	BEGIN
		IF @p_RptType = 'byDS'
		BEGIN 
			-- by 部別
			SET @groupcase = ' from #tmpItem p LEFT JOIN #tmp_SqlJoin q ON p.ItemName=q.ItemIN where  p.ItemNo=a.ItemNo  and p.ItemName=a.ItemName and q.Emp_Item=b.Emp_Item   and q.Emp_DS=b.Emp_DS   ';
			SET @groupcase1 = ' from #tmpPatC_5 p  WHERE p.ItemIN<>'''' and p.ItemIN=a.ItemIN  and p.Emp_DS=a.Emp_DS   and p.Emp_Item=a.Emp_Item   and p.Emp_Itemnum=a.Emp_Itemnum     ';
			SET @groupcase2 = ' from #tmpTodos5_1 p  WHERE p.ItemIN<>'''' and p.ItemIN=a.ItemIN  and p.Emp_DS=a.Emp_DS   and p.Emp_Item=a.Emp_Item   and p.Emp_Itemnum=a.Emp_Itemnum ';
			SET @groupcase3 = ' from #tmpTodos5_2 p WHERE p.ItemFH<>'''' and p.ItemFH=a.ItemFH  and p.Emp_DS=a.Emp_DS   and p.Emp_Item=a.Emp_Item   and p.Emp_Itemnum=a.Emp_Itemnum ';
			SET @groupcase4 = ' from #tmpTodos5_3 p where p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH  and p.Emp_DS=a.Emp_DS   and p.Emp_Item=a.Emp_Item   and p.Emp_Itemnum=a.Emp_Itemnum ';
			SET @SqlJoinString = @SqlJoinString + 'select a.* into #tmp_SqlJoin from (
								 SELECT  ItemIN, Emp_DS, Emp_Item,Emp_Itemnum ,   ' + replace(@CommonStringJoin1, '@groupcase', @groupcase1) +',count(a.Emp_ID) as Emp_ID  ' +  'FROM #tmpPatC_5 a WHERE ItemIN<>'''' GROUP BY ItemIN, Emp_DS, Emp_Item ,Emp_Itemnum,Emp_ID  ' 
								 + 'Union all ' + 'SELECT  ItemIN, Emp_DS, Emp_Item,Emp_Itemnum ,  ' + replace(@CommonStringJoin2, '@groupcase', @groupcase2) +',count(a.Emp_ID) as Emp_ID  ' +  'FROM #tmpTodos5_1 a WHERE ItemIN<>''''  GROUP BY ItemIN, Emp_DS, Emp_Item ,Emp_Itemnum,Emp_ID  ' 
								 + 'Union all ' + 'SELECT ItemFH as ItemIN,Emp_DS, Emp_Item,Emp_Itemnum ,  ' + replace(@CommonStringJoin3, '@groupcase', @groupcase3) +',count(a.Emp_ID) as Emp_ID  ' +  'FROM #tmpTodos5_2 a WHERE ItemFH<>''''  GROUP BY ItemFH, Emp_DS, Emp_Item,Emp_Itemnum,Emp_ID   ' 
								 + 'Union all ' + 'SELECT Item_NotFH as ItemIN, Emp_DS,Emp_Item,Emp_Itemnum ,  ' + replace(@CommonStringJoin4, '@groupcase', @groupcase4) +',count(a.Emp_ID) as Emp_ID  ' +  'FROM #tmpTodos5_3 a where Item_NotFH<>''''  GROUP BY Item_NotFH, Emp_DS, Emp_Item,Emp_Itemnum,Emp_ID   ) a   order by ItemIN';  
			--select cast(@SqlJoinString as varchar(max)); --debug query
			--Exec (@SqlJoinString+' ;  select * from tmp_SqlJoin   ');    
			--Exec (@SqlJoinString+' ; ');    
			SET @SqlString = @SqlString + @SqlJoinString + ' ;';
			SET @SqlString = @SqlString + 'SELECT  a.ItemName as attr_ItemName, a.ItemName as 項目, Emp_DS as attr_Emp_DS, case when  ISNULL(Emp_DS,'''')='''' Then ''未指定所別'' Else Emp_DS END as 所別,  Emp_Item as attr_Emp_Item, ISNULL(Emp_Item,'''') as 部別,'''' as attr_Emp_ID,'
			--+'sum(isnull(Emp_ID,0)) as 人數,  ' 
			+ replace(@CommonString, '@groupcase', @groupcase) + '  ' + 'FROM #tmpItem a ' + 'INNER JOIN #tmp_SqlJoin b ON a.ItemName=b.ItemIN ' + ' GROUP BY  a.ItemNo, a.ItemName, Emp_Item,Emp_DS
		Order by a.ItemNo, CASE Emp_DS WHEN ''台北所'' then 10 WHEN ''台中所'' THEN 20 WHEN ''高雄所'' 
		THEN 30 WHEN ''上海所'' THEN 40 WHEN ''深圳所'' THEN 50 WHEN
	   ''武漢所'' THEN 60 WHEN ''蘇州所'' THEN 70 WHEN ''外包人員'' THEN 80 WHEN ''小計'' THEN 999 ELSE 990 END ; ';
		END;
	END;
END;
    print('9:'+convert(varchar(20),getdate(),126)) 
EXEC (@SqlString+' ;IF OBJECT_ID(''tempdb..#tmp_SqlJoin'', ''U'') IS NOT NULL DROP TABLE #tmp_SqlJoin; ');
--SELECT CAST(@SqlString AS VARCHAR(MAX)); --debug query
    print('10:'+convert(varchar(20),getdate(),126)) 
	IF OBJECT_ID('tempdb..#tmpTodosAll_1', 'U') IS NOT NULL DROP TABLE #tmpTodosAll_1
	IF OBJECT_ID('tempdb..#tmpPatC_5All_1', 'U') IS NOT NULL DROP TABLE #tmpPatC_5All_1
	IF OBJECT_ID('tempdb..#tmpTodosAll', 'U') IS NOT NULL DROP TABLE #tmpTodosAll  
	IF OBJECT_ID('tempdb..#p_YMT', 'U') IS NOT NULL DROP TABLE #p_YMT
	IF OBJECT_ID('tempdb..#tb_Split2', 'U') IS NOT NULL DROP TABLE #tb_Split2
	IF OBJECT_ID('tempdb..#tmpItem', 'U') IS NOT NULL DROP TABLE #tmpItem
	IF OBJECT_ID('tempdb..#tmpEmp', 'U') IS NOT NULL DROP TABLE #tmpEmp 
	IF OBJECT_ID('tempdb..#tmpPatC_5All', 'U') IS NOT NULL DROP TABLE #tmpPatC_5All
	IF OBJECT_ID('tempdb..#tmpTodosAll_3', 'U') IS NOT NULL DROP TABLE #tmpTodosAll_3
	IF OBJECT_ID('tempdb..#tmpPatC_5', 'U') IS NOT NULL DROP TABLE #tmpPatC_5
	IF OBJECT_ID('tempdb..#tmpTodos5TDList', 'U') IS NOT NULL DROP TABLE #tmpTodos5TDList 
	IF OBJECT_ID('tempdb..#tmpTodos5_1All', 'U') IS NOT NULL DROP TABLE #tmpTodos5_1All
	IF OBJECT_ID('tempdb..#tmpTodos5_1', 'U') IS NOT NULL DROP TABLE #tmpTodos5_1
	IF OBJECT_ID('tempdb..#tmpTodos5_2All', 'U') IS NOT NULL DROP TABLE #tmpTodos5_2All
	IF OBJECT_ID('tempdb..#tmpTodos5_2', 'U') IS NOT NULL DROP TABLE #tmpTodos5_2 
	IF OBJECT_ID('tempdb..#tmpTodos5_3All', 'U') IS NOT NULL DROP TABLE #tmpTodos5_3All
	IF OBJECT_ID('tempdb..#tmpTodos5_3', 'U') IS NOT NULL DROP TABLE #tmpTodos5_3
END

GO

--DECLARE @RC int 

---- TODO: 在此處設定參數值。

--EXECUTE @RC = [dbo].[rpt_CustCaseTot_YM] 
--   @p_YM_F='2020-03'
--  ,@p_YM_T='2020-03'
--  ,@p_RptType='byds' -- byItem ,bydept,byds
--  ,@p_CustName=''
--GO  
--rpt_PatentCase_DS123 '2019-12-01','2019-12-31','2';


