﻿
Alter PROCEDURE rpt_FinishCase_DS1(
	@p_DateF    varchar(10),
    @p_DateT    varchar(10)
)
AS
BEGIN
	-- 專利一部完成案件統計
	 
	Declare @p_CustName  varchar(20);
    SET @p_CustName='华星';
		-- 取得「客戶名稱」的 recordset 
	SELECT ID as ItemNo,replace(replace(value, char(13),''), char(10),'') as ItemDesc into #tb_Split2 FROM [ufn_split](@p_CustName, ';') ; 
    
    -- 員工部別 (因該員工會多部別, 放在Emp_DS2裡, 所以要distinct )
	--SELECT distinct a.Emp_ID, Emp_Name, emp_N1, Emp_N2, Emp_N3, Emp_DS, Emp_DSNum, Emp_Item, Emp_ItemNum, Emp_Sort
	--into #tmpEmp
	--FROM vw_employee a

	SELECT distinct a.user_name as Emp_ID, cn_name as Emp_Name, b.Emp_DS, b.Emp_DSNum, b.Emp_Item, b.Emp_ItemNum, 0 as Emp_Sort ,a.user_id
	--, emp_N1, Emp_N2, Emp_N3
	into #tmpEmp
	FROM [evw_s_user_info]  a
	left join [dbo].[evw_qResult_Emp] b on a.user_name=b.LoginID 
    ; 
	--ALTER TABLE tmpEmp ADD INDEX(`Emp_ID`);    

	 -- 取得RPT項目List 
	select * into #tmpItem from (
	SELECT 11 as ItemNo, 'CN 新案' as ItemName union 
    SELECT 12, 'PCT 新案' union SELECT 13, 'US 新案' union 
	SELECT 21, 'CN OA' union SELECT 22, 'US OA' union SELECT 23, 'KR OA' union SELECT 25, 'JP OA' union SELECT 26, 'EU OA' union 
	SELECT 27, 'DE OA' union SELECT 28, 'GB OA' union SELECT 29, 'EA OA' union SELECT 50, 'BR OA') a ;

	-- 1.取得: ToDos 
		SELECT a.*,case when ics.case_status_code='NF_P'  THEN 'Y' END as PctNationalPhase --,ISNULL(e.Dept_ID,'') as AssignedTo_DeptID, ISNULL(e.Dept_name,'') as AssignedTo_DeptName
	, e.Emp_ID, e.Emp_DS, c.customer_name as Client_CompanyName,cast(a.sn as varchar(10)) as FlowKey ,
           e.Emp_DSNum, e.Emp_Item, e.Emp_ItemNum, e.Emp_Sort,(select value from [ufn_split](case_volume,'-') a where a.ID=2) as CaseNo_r,b.country_id as office
	into #tmpTodosAll
    FROM esn_todos a 
    left JOIN  p_case_info b ON a.case_id=b.case_id
	left join c_customer c on b.customer_id=c.customer_id
    inner join #tb_Split2 s  on c.customer_name like '%'+s.ItemDesc +'%'
	left join #tmpEmp e on a.AssignedTo_userid=e.user_id
	left join i_case_status ics on ics.case_status_id=b.case_status_id
	WHERE a.AttorneyDueDate between  @p_DateF AND @p_DateT
	  AND (a.FinishedDate='' or  a.FinishedDate is null)
	  AND a.PatentType IN ('PN01', 'PN02', 'PN03','PN07')
	  AND CHARINDEX('完成初稿',a.TaskDescription)>0 ;

	--select * into #tmpTodosAll from (
	--SELECT a.*, b.PctNationalPhase, e.Emp_ID, e.Emp_DS, e.Emp_DSNum, e.Emp_Item, e.Emp_ItemNum, e.Emp_Sort
 --   FROM vw_Todos a
 --   inner join tb_split2 s on a.Client_CompanyName REGEXP BINARY replace(replace(s.ItemDesc, char(13),''), char(10),'')   
	--LEFT JOIN patentcase b ON a.CaseNo=b.CaseNo
 --   left join tmpEmp     e ON a.AssignedTo=e.Emp_ID
	--WHERE a.FinishedDate between @p_DateF AND @p_DateT
	--  AND a.PatentType IN ('PN01', 'PN02', 'PN03','PN07')  AND (LOCATE('完成初稿',a.TaskDescription)>0 )
	--) a ;

	-- 2.取得:「已完成」資料 
	 
	SELECT CASE WHEN a.Office='CN' AND a.TaskDescription='完成初稿' AND a.Matter='CNP01' THEN 'CN 新案' END as ItemFH1,  -- CN 新申請(完成) -->1.國家為CN, 2.案件類別: PN01, PN02, PN03, 3.管制事項：完成初稿, 4.完成日落在該月份, 5. 案件程序:中國發明申請(CNP01)
		   CASE WHEN a.Office='PCT' AND a.TaskDescription='完成初稿' AND a.Matter='WOP01' THEN 'PCT 新案' END as ItemFH2,         -- PCT 新申請(完成)-->1.國家為PCT, 2.案件類別: PN01, PN07, 3.管制事項：完成初稿, 4.完成日落在該月份, 5. 案件程序:PCT國際申請(WOP01)
		   CASE WHEN a.Office='US' AND a.PatentType='PN01' AND a.PctNationalPhase='Y' AND a.TaskDescription='完成初稿' AND a.Matter='USP01' THEN 'US 新案' END as ItemFH3, -- US 新申請(完成)-->1.國家為US, 2.案件類別: PN01, PN07, 3.管制事項：完成初稿, 4.完成日落在該月份, 5. 案件程序:美國Utility申請(USP01)
				
		   CASE WHEN Office='CN' AND CHARINDEX('完成初稿',a.TaskDescription)>0 AND a.Matter='CNP02'  THEN 'CN OA' END as ItemFH4, -- CN OA(完成) -->1.國家為CN, 2.抓管制事項：完成初稿(都含), 3.完成日落在該月份, 4.案件程序: 中國發明審查(CNP02)
		   CASE WHEN Office='US' AND a.TaskDescription='完成初稿' AND a.Matter='USP02'  THEN 'US OA' END as ItemFH5,           -- US OA(完成) -->1.國家為US, 2.抓管制事項：完成初稿(只有這4個字), 4.完成日落在該月份, 4.案件程序: 美國Utility審查(USP02)
		   CASE WHEN Office='TW' AND a.TaskDescription='完成初稿' AND a.Matter='TWP02'  THEN 'TW OA' END as ItemFH6,           -- TW OA(完成) -->1.國家為TW, 2.抓管制事項：完成初稿(只有這4個字), 4.完成日落在該月份, 4.案件程序: 台灣發明審查(TWP02)
		   CASE WHEN  Office NOT IN ('CN', 'TW','US') AND a.TaskDescription='完成初稿' AND a.Matter='P02' THEN a.Office+' OA' END as ItemFH7,  -- XX OA(完成) -->1.國家為XX,  2.抓管制事項：完成初稿(只有這4個字), 4.完成日落在該月份, 4.案件程序: 專利審查(P02)
				
		   LEFT(a.FinishedDate,7) as YM_FH, a.*
	into #tmpTodos2
	FROM #tmpTodosAll a
	;  

		 select * into #tmpTodos3 from (
	select CAST(ItemFH1 as CHAR(20)) as ItemFH, a.* from #tmpTodos2 a where ItemFH1<>''
	union select ItemFH2 as ItemFH, a.* from #tmpTodos2 a where ItemFH2<>''
	union select ItemFH3 as ItemFH, a.* from #tmpTodos2 a where ItemFH3<>''
	union select ItemFH4 as ItemFH, a.* from #tmpTodos2 a where ItemFH4<>''
	union select ItemFH5 as ItemFH, a.* from #tmpTodos2 a where ItemFH5<>''
	union select ItemFH6 as ItemFH, a.* from #tmpTodos2 a where ItemFH6<>''
	union select ItemFH7 as ItemFH, a.* from #tmpTodos2 a where ItemFH7<>''
	) a;
    -- select * from tmpTodos3;

	-- 顯示結果 

	SELECT AssignedTo as attr_AssignedTo, AssignedTo_Name as attr_AssignedToName, Emp_DS as attr_EmpDS, Emp_Item as attr_EmpItem,
		   AssignedTo+' '+AssignedTo_Name as 承辦人, Emp_DS as 部別, 
           'tdr CurPT' as 'class_1',
		   STUFF ((select ','+ p.FlowKey from #tmpTodos3 p 
		   where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA')  
		   and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')  attr_point_todos, sum(points) as 承辦人完成點數, 
		   'corGre tdr CurPT' as 'class_1','' attr_CNNC_todos, SUM(CASE WHEN ItemFH='CN 新案' THEN 1 ELSE 0 END) as CN新案,
		     STUFF ((select ','+CASE WHEN p.ItemFH='PCT 新案' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA')
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'') attr_PCTNC_todos, SUM(CASE WHEN ItemFH='PCT 新案' THEN 1 ELSE 0 END) as PCT新案,
		    STUFF ((select ','+CASE WHEN p.ItemFH='US新案' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') 
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'') attr_USNC_todos, SUM(CASE WHEN a.ItemFH='US 新案' THEN 1 ELSE 0 END) as US新案,
		    STUFF ((select ','+CASE WHEN p.ItemFH='US新案' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') 
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')   attr_TotNC_todos, SUM(CASE WHEN ItemFH IN ('CN 新案','PCT 新案','US 新案') THEN 1 ELSE 0 END) as 總計,
		    STUFF ((select ','+CASE WHEN p.ItemFH='CN OA' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') 
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')  attr_CNOA_todos, SUM(CASE WHEN ItemFH='CN OA' THEN 1 ELSE 0 END) as 'CN OA',
		    STUFF ((select ','+CASE WHEN p.ItemFH='US OA' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') 
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')  attr_USOA_todos, SUM(CASE WHEN ItemFH='US OA' THEN 1 ELSE 0 END) as 'US OA',
		    STUFF ((select ','+CASE WHEN p.ItemFH='KR OA' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') 
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')  attr_KROA_todos, SUM(CASE WHEN ItemFH='KR OA' THEN 1 ELSE 0 END) as 'KR OA',
		    STUFF ((select ','+CASE WHEN p.ItemFH='JP OA' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') 
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')  attr_JPOA_todos, SUM(CASE WHEN ItemFH='JP OA' THEN 1 ELSE 0 END) as 'JP OA',
		    STUFF ((select ','+CASE WHEN p.ItemFH='EU OA' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA')
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')  attr_EUOA_todos, SUM(CASE WHEN ItemFH='EU OA' THEN 1 ELSE 0 END) as 'EU OA',
		                                                                                        
		    STUFF ((select ','+CASE WHEN p.ItemFH='DE OA' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') 
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')  attr_DEOA_todos, SUM(CASE WHEN ItemFH='DE OA' THEN 1 ELSE 0 END) as 'DE OA',
		    STUFF ((select ','+CASE WHEN p.ItemFH='GB OA' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA')
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')  attr_GBOA_todos, SUM(CASE WHEN ItemFH='GB OA' THEN 1 ELSE 0 END) as 'GB OA',
		    STUFF ((select ','+CASE WHEN p.ItemFH='EA OA' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA')
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')  attr_EAOA_todos, SUM(CASE WHEN ItemFH='EA OA' THEN 1 ELSE 0 END) as 'EA OA',
		    STUFF ((select ','+CASE WHEN p.ItemFH='BR OA' THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') 
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'')  attr_BROA_todos, SUM(CASE WHEN ItemFH='BR OA' THEN 1 ELSE 0 END) as 'BR OA',
		   'corOre tdr CurPT' as 'class_1', 
		    STUFF ((select ','+CASE WHEN p.ItemFH IN ('CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') THEN  p.FlowKey END from #tmpTodos3 p
			where p.ItemFH<>'' AND p.Emp_Item='專利一部'  AND p.ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') 
			and p.AssignedTo=a.AssignedTo and p.AssignedTo_Name=a.AssignedTo_Name and p.Emp_DSNum=a.Emp_DSNum and p.Emp_ItemNum=a.Emp_ItemNum  FOR XML PATH('')
			), 1, 1, N'') attr_TotOA_todos, 
		   SUM(CASE WHEN ItemFH IN ('CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA') THEN 1 ELSE 0 END) as '總計 OA'
	--into #tmpResult1
	FROM #tmpTodos3 a
	WHERE ItemFH<>'' AND Emp_Item='專利一部'  AND ItemFH IN ('CN 新案','PCT 新案','US 新案','CN OA','US OA','KR OA','JP OA','EU OA','DE OA','GB OA','EA OA','BR OA')
	GROUP BY AssignedTo, AssignedTo_Name, Emp_DS, Emp_Item, Emp_DSNum, Emp_ItemNum, Emp_Sort
    Order by Emp_DSNum, Emp_ItemNum, Emp_Sort; 


	IF OBJECT_ID('tempdb..#tmpEmp', 'U') IS NOT NULL DROP TABLE #tmpEmp
	IF OBJECT_ID('tempdb..#tmpTodos6_3All', 'U') IS NOT NULL DROP TABLE #tmpTodos6_3All
	IF OBJECT_ID('tempdb..#tmpTodosAll', 'U') IS NOT NULL DROP TABLE #tmpTodosAll
	IF OBJECT_ID('tempdb..#tmpTodos2', 'U') IS NOT NULL DROP TABLE #tmpTodos2
	IF OBJECT_ID('tempdb..#tmpTodos3', 'U') IS NOT NULL DROP TABLE #tmpTodos3 
	IF OBJECT_ID('tempdb..#tb_Split2', 'U') IS NOT NULL DROP TABLE #tb_Split2
END
GO
DECLARE @RC int 

-- TODO: 在此處設定參數值。

EXECUTE @RC = [dbo].rpt_FinishCase_DS1 
	@p_DateF='2019-12-01',
    @p_DateT='2019-12-31'
GO  