alter PROCEDURE [dbo].rpt_CustCaseTot_YM_NotFinish ( 
	@p_YM_F varchar(7),        -- 區期年月起值
	@p_YM_T varchar(7),        -- 區期年月迄值
    @p_RptType varchar(10),    -- 報表類別 RptType = byItem 項目 , byDept 所別, byDS 部別 
    @p_CustName nvarchar(100) 
   )
AS
BEGIN
-- 案件統計表by項目, 案件統計表by所別, 案件統計表by部別
    -- call rpt_CustCaseTot_YM('201901','201906','byDS',''); 
	
	Declare @p_EmpItem varchar(1),@Emp_ItemNo varchar(50),@p_StartDate datetime,@p_EndDate datetime;
	Declare @p_EndDateYM varchar(7),@i tinyint=1; 

	set @p_StartDate =Convert(datetime,@p_YM_F+'-01',126) ;
	set @p_EndDate =DATEADD(day,-1,DATEADD(month, 1,cast(@p_YM_T+'-01' as datetime))) ;   
	set @p_EndDateYM=Convert(varchar(7),@p_EndDate,126);
	select 99 as id ,Convert(varchar(7),@p_EndDate,126)  as value into #p_YMT	 
	WHILE @i < 13
	BEGIN 
		insert into #p_YMT (id,Value)
		values(@i,Convert(varchar(7),DATEADD(month,@i-1,@p_StartDate) ,126))
		Set @i=@i+1;
	END   
 	-- 取得「客戶名稱」的 recordset 
	SELECT ID as ItemNo,replace(replace(value, char(13),''), char(10),'') as ItemDesc into #tb_Split2 FROM [ufn_split](@p_CustName, ';') ;  
     
 -- 取得RPT項目List 
	SELECT * into #tmpItem FROM (
	SELECT 1 as ItemNo, 'CN 查新' as ItemName union SELECT 2, 'CN 新申請' union SELECT 3, 'PCT 新申請' union 
	SELECT 4, 'US 新申請' union SELECT 5, 'KR 新申請' union SELECT 6, 'JP 新申請' union SELECT 7, 'EA 新申請' union SELECT 8, 'EU 新申請' union 
	SELECT 9, 'IN 新申請' union SELECT 10, 'TW 新申請' union SELECT 11, 'DE 新申請' union SELECT 12, 'GB 新申請' union SELECT 13, 'RU 新申請' union 
	SELECT 41, 'CN OA' union SELECT 42, 'TW OA' union SELECT 43, 'US OA' union SELECT 45, 'KR OA' union SELECT 46, 'JP OA' union 
	SELECT 47, 'EA OA' union SELECT 48, 'DE OA' union SELECT 49, 'EU OA' union SELECT 50, 'GB OA' union SELECT 51, 'RU OA' union 
	SELECT 52, 'RCE' union SELECT 53, 'IDS' union SELECT 54, '繳費領證'  union SELECT 99, '總計') a;
	-- 第二部, 客戶名稱不會只有「华星」, 第一部, 客戶名稱只會有「华星」
	insert #tmpItem
	SELECT * FROM (
		SELECT 61 as ItemNo, 'CN OA-核駁' as ItemName union SELECT 62, 'TW OA-核駁' union SELECT 63, 'US OA-核駁' union SELECT 65, 'KR OA-核駁' union SELECT 66, 'JP OA-核駁' union 
	    SELECT 67, 'EA OA-核駁' union SELECT 68, 'DE OA-核駁' union SELECT 69, 'EU OA-核駁' union SELECT 70, 'GB OA-核駁' union SELECT 71, 'RU OA-核駁'
	) a WHERE @p_CustName<>'华星' AND (SELECT COUNT(*) FROM #tb_Split2) >=1;
     
    -- 員工部別 (因該員工會多部別, 放在Emp_DS2裡, 所以要distinct )
	SELECT distinct a.user_name as Emp_ID, cn_name as Emp_Name, a.Emp_DS, a.Emp_DSNum, a.Emp_Item, a.Emp_ItemNum, 0 as Emp_Sort ,a.user_id
	--, emp_N1, Emp_N2, Emp_N3
	into #tmpEmp
	FROM [dbo].[evw_Employee]  a  
	-- 1.取得: ToDos  
    print('1:'+convert(varchar(20),getdate(),126)) 
	;with tmpTodosAll_1 as(
	select sn,proc_id,CaseType,CaseType_Name,CaseNo,TaskDescription,StartDate2,AttorneyDueDate,FinishedDate,AssignedTo_userid,
	b.Emp_ID as AssignedTo,b.Emp_Name as AssignedTo_Name,Points,ExchangeRate,Matter,Matter_Name,PatentType,PatentType_Name,ToDosStatus,ToDosStatus_Name,
	case_id,b.*
	from evw_esn_todos a
	inner join #tmpEmp b on a.AssignedTo_userid=b.user_id
	where (a.StartDate2 between @p_StartDate AND @p_EndDate) OR        -- 起始日
		   (a.FinishedDate between @p_StartDate AND @p_EndDate) OR      -- 完成日
		   (a.AttorneyDueDate between @p_StartDate AND @p_EndDate)
		AND a.PatentType IN ('PN01', 'PN02', 'PN03','PN07')
	)
	SELECT a.* , case when ics.case_status_zh_tw='撰稿中' THEN 'Y' END as PctNationalPhase,p.country_id as office,Cast(a.sn as varchar(20)) as Flowkey
	,(select value from [ufn_split](a.CaseNo,'-') u where u.ID=2) as CaseNo_r
	,p.customer_name as Client_CompanyName,ics.case_status_zh_tw as Status_Name
	into #tmpTodosAll
	FROM tmpTodosAll_1 a
	inner join [evw_p_case_info] p on p.case_id=a.case_id
    inner join #tb_Split2 s  on p.customer_name like s.ItemDesc +'%'
	left join i_case_status ics on ics.case_status_id=p.case_status_id 
	;
	
    print('2:'+convert(varchar(20),getdate(),126)) 
	; -- ALTER TABLE tmpTodosAll ADD INDEX(`CaseNo`);
     
	 
	-- 2.取得:「未完成」資料 
	 
	SELECT CASE WHEN  LEFT(a.CaseNo_r,1)='M'  
					  AND (CHARINDEX('提出報告',a.TaskDescription)>0 OR CHARINDEX('提出报告',a.TaskDescription)>0) THEN 'CN 查新' END as Item_NotFH1,                   -- CN 查新(未完成) -->1.客戶名稱為華星, 2.案件編號有-M, 3.管制事項：完成初稿, 4.完成日為空白, 5.事務所到期日落在該月份
		   CASE WHEN a.Office='CN' AND a.PatentType IN ('PN01', 'PN02', 'PN03') AND a.TaskDescription='完成初稿' THEN 'CN 新申請' END as Item_NotFH2, -- CN 新申請(未完成) -->1.國家為CN, 2.案件類別: PN01, PN02, PN03, 3.管制事項：完成初稿(只有這4個字), 4.案件狀態：撰稿(RS01), 5.完成日為空白, 6.事務到期日落在該月份
		   CASE WHEN a.Office='WO' AND a.PatentType IN ('PN01','PN07') AND a.TaskDescription='完成初稿'  THEN 'PCT 新申請' END as Item_NotFH3,        -- PCT 新申請(未完成)-->1.國家為PCT, 2.案件類別: PN01, PN07, 3.管制事項：完成初稿(只有這4個字), 4.案件狀態：撰稿(RS01), 5.完成日為空白, 6.事務到期日落在該月份
		   CASE WHEN a.Office NOT IN ('CN','WO') AND a.PatentType='PN01' AND a.PctNationalPhase='Y' AND a.TaskDescription='完成初稿' THEN a.Office+' 新申請'  END as Item_NotFH4,    -- XX 新申請(未完成) -->1.國家為XX, 2.案件類別: PN01 , 3.是 PCT國家階段, 4.管制事項：完成初稿(只有這4個字), 5.案件狀態：撰稿(RS01), 5.完成日為空白, 6.事務到期日落在該月份
				
		   CASE WHEN CHARINDEX('完成初稿',a.TaskDescription)>0 THEN 'CN OA' END as Item_NotFH5,      -- CN OA(未完成) -->1.國家為CN, 2.管制事項：完成初稿(都含), 3.案件狀態：答辯中-撰稿(RS05.1), 4.完成日為空白, 5.事務到期日落在該月份
		   CASE WHEN a.TaskDescription='完成初稿' AND a.Office NOT IN('CN','WO') THEN a.Office+' OA' END as Item_NotFH6, -- XX OA(未完成) -->1.國家為XX, 2.管制事項：完成初稿(只有這4個字), 3.案件狀態：答辯中(RS05), 4.完成日為空白, 5.事務到期日落在該月份

		   CASE WHEN CHARINDEX('rce', LOWER(a.TaskDescription))>0 THEN 'RCE' END as Item_NotFH7,                  -- RCE(未完成) -->1.不分國家, 2.管制事項有「RCE」該項, 3.管制事項：完成初稿(只有這4個字),  4.完成日為空白, 5.事務到期日落在該月份
		   CASE WHEN CHARINDEX('ids', LOWER(a.TaskDescription))>0 THEN 'IDS' END as Item_NotFH8,                  -- IDS(未完成) -->1.不分國家, 2.管制事項有「IDS」該項, 3.管制事項：完成初稿(只有這4個字),  4.完成日為空白, 5.事務到期日落在該月份
		   CASE WHEN CHARINDEX('繳費領證', a.TaskDescription)>0  THEN '繳費領證' END as Item_NotFH9,   -- 繳費領證(未完成) -->1.不分國家, 2.管制事項有「繳費領證」該項, 3.管制事項：完成初稿(只有這4個字),  4.完成日為空白, 5.事務到期日落在該月份
				
		   CASE WHEN CHARINDEX('核駁報導',a.TaskDescription)>0  THEN 'CN OA-核駁' END as Item_NotFH15,      -- CN OA-核駁(未完成) -->1.國家為CN, 2.管制事項：核駁報導(都含), 3.案件狀態：答辯中-撰稿(RS05.1), 4.完成日為空白, 5.事務到期日落在該月份
		   CASE WHEN a.TaskDescription='核駁報導'  AND a.Office NOT IN('CN','WO') THEN a.Office+' OA-核駁' END as Item_NotFH16, -- XX OA-核駁(未完成) -->1.國家為XX, 2.管制事項：核駁報導(只有這4個字), 3.案件狀態：答辯中(RS05), 4.完成日為空白, 5.事務到期日落在該月份
                      
		   a.FlowKey, a.CaseNo, a.PctNationalPhase,  a.AttorneyDueDate, a.FinishedDate, getdate() as sysDate, 
		   CASE WHEN a.AttorneyDueDate='' THEN '' ELSE Convert(varchar(7),a.AttorneyDueDate,126) END as YM_AD, 
		   CASE WHEN (a.FinishedDate between @p_StartDate AND @p_EndDate) THEN Convert(varchar(7),a.FinishedDate,126)  ELSE '' END as YM_FH,
		   --CASE WHEN FinishedDate=''or FinishedDate is null  THEN getdate() ELSE FinishedDate END as FinishedDate2, 
		   a.StartDate2, 
		   CASE WHEN a.AttorneyDueDate<>'' THEN DATEDIFF(day,getdate(),AttorneyDueDate) ELSE 0 END as NotFH_Days, 
		   a.AssignedTo, a.AssignedTo_Name--, a.AssignedTo_DeptID, a.AssignedTo_DeptName, a.Matter, a.MatterName, a.Attorney, a.Attorney_Nationality, a.Office, a.Office_Name, a.Client, a.CaseType, a.CaseType_Desc
		   , a.Emp_ID, a.Emp_DS, a.Emp_DSNum, a.Emp_Item, a.Emp_Sort,
		   CASE WHEN a.AssignedTo='' THEN '未指定承辦人' ELSE AssignedTo_Name END as AssignedTo_Name2, a.TaskDescription, a.PatentType, PatentType_Name
		   , a.ToDosStatus, a.ToDosStatus_Name  , a.Client_CompanyName
		   ,ISNULL(b.CaseLevel,'') as CaseLevel, ISNULL(b.CaseLevelDesc,'') as CaseLevelDesc, ISNULL(c.IsPriority,'') as IsPriority, ISNULL(c.IsPriorityDesc,'') as IsPriorityDesc
		   into #tmpTodos6_3All
	FROM #tmpTodosAll a
    left join evw_qresult_CaseLevel b on a.CaseNo=b.CaseNo
    left join evw_qresult_caseispriority c on a.CaseNo=c.CaseNo
	; 
    print('3:'+convert(varchar(20),getdate(),126)) 
	 select * into #tmpTodos6_3 from (
	select CAST(Item_NotFH1 as CHAR(20)) as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH1<>''
	union
	select Item_NotFH2 as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH2<>''
	union
	select Item_NotFH3 as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH3<>''
	union
	select Item_NotFH4 as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH4<>''
	union
	select Item_NotFH5 as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH5<>''
	union
	select Item_NotFH6 as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH6<>''
	union
	select Item_NotFH7 as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH7<>''
	union
	select Item_NotFH8 as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH8<>''
	union
	select Item_NotFH8 as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH9<>''
	union
	select Item_NotFH15 as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH15<>''
	union
	 select Item_NotFH16 as Item_NotFH, a.* from #tmpTodos6_3All a where Item_NotFH16<>''
	) a;
    print('4:'+convert(varchar(20),getdate(),126)) 
	-- ALTER TABLE tmpTodos6_3 ADD INDEX(`CaseNo`);
	
	--select * from #tmpTodosAll
	--select * from #tmpTodos6_3All
	--select * from #tmpTodos6_3

    -- 3.暫存檔
	-- 3-1.新增項目之重要案件小計列暫存檔 
	SELECT Item_NotFH, AssignedTo_Name2, emp_DS, Emp_Item, emp_Sort, YM_AD, AttorneyDueDate, sysDate, FlowKey
	into #tmpTodos6_Levelsum
    FROM #tmpTodos6_3 WHERE (CaseLevel='1' OR IsPriority='Y');  -- CaseLevel=專利等級: 1=重要專利, 2=常規專利,  IsPriority=是否優先處理: Y=是
    
    if not exists(select * FROM #tmpTodos6_Levelsum where Item_NotFH='CN 查新')  
	begin
       insert #tmpTodos6_Levelsum SELECT 'CN 查新' as Item_NotFH, '' as AssignedTo_Name2, '' as emp_DS, '' as Emp_Item, '' as emp_Sort, '' as YM_AD, '' as AttorneyDueDate, '' as sysDate, '' as FlowKey;    
    end  ;
	 --SELECT * FROM tmpTodos6_3 WHERE (CaseLevel='1' OR IsPriority='Y');  -- CaseLevel=專利等級: 1=重要專利, 2=常規專利,  IsPriority=是否優先處理: Y=是
    
	-- 3-2.新增項目小計列暫存檔
	--DROP TEMPORARY TABLE IF EXISTS tmpTodos6_4sum;
	--CREATE TEMPORARY TABLE tmpTodos6_4sum as
	--SELECT * FROM tmpTodos6_3;

	-- 3-3.新增總計列暫存檔
	--DROP TEMPORARY TABLE IF EXISTS tmpTodos6_4tot;
	--CREATE TEMPORARY TABLE tmpTodos6_4tot as
	--SELECT * FROM tmpTodos6_3;
 
        
	 -- 5.結果 

		declare @SqlString varchar(max)='',@SqlJoinString varchar(max)='',@CommonString varchar(max)='',@CommonStringJoin1  varchar(max)=''
				,@CommonStringJoin2  varchar(max)='',@CommonStringJoin3  varchar(max)='',@CommonStringJoin4  varchar(max)='',@SortString varchar(500)='', @cnt tinyint=1,@cntT varchar(3)='',@cntO varchar(3)='' 
			,@groupcase1 varchar(200)='',@groupcase2 varchar(200)='',@groupcase3 varchar(200)='',@groupcase4 varchar(200)='',@groupcase varchar(200)='',@p_YMT_value varchar(7);  
	WHILE @cnt < 13
	BEGIN 
		Set @cntT= RIGHT(REPLICATE('0',2) + CAST(@cnt as varchar),2); -- 補零
		Set @cntO= CAST(@cnt as varchar); 
		Set @p_YMT_value= (select Value from #p_YMT where id=@cntO) ;  
		set @CommonString=@CommonString 
		+'CASE WHEN '''+@p_EndDateYM+''' >= '''+@p_YMT_value+'''  THEN 1 ELSE 0 END v'+@cntT
		+',STUFF ((SELECT distinct '','' + (CASE WHEN attr_NotFN'+@cntT+'<>'''' THEN attr_NotFN'+@cntT+' END) @groupcase FOR XML PATH('''')), 1, 1, N'''') as attr_NotFN'+@cntT+'_todos2, SUM(ISNULL(NotFN'+@cntT+',0)) as 逾期_'+@cntT
		+', STUFF ((SELECT distinct '','' + (CASE WHEN attr_YesFN'+@cntT+'<>'''' THEN attr_YesFN'+@cntT+' END) @groupcase FOR XML PATH('''')), 1, 1, N'''') as attr_YesFN'+@cntT+'_todos2, SUM(ISNULL(YesFN'+@cntT+',0)) as 未逾期_'+@cntT+','
	
		Set @CommonStringJoin1=@CommonStringJoin1 
		+ 'STUFF ((SELECT distinct '','' + (CASE WHEN YM_AD= '''+@p_YMT_value+'''  AND  AttorneyDueDate < sysDate THEN FlowKey END)  @groupcase FOR XML PATH('''')), 1, 1, N'''')   as attr_NotFN'+@cntT
		+', SUM(CASE WHEN (YM_AD='''+@p_YMT_value+''' AND  AttorneyDueDate < sysDate) THEN 1 ELSE 0 END) as NotFN'+@cntT
		+',STUFF ((SELECT distinct '','' + (CASE WHEN YM_AD= '''+@p_YMT_value+'''  AND  AttorneyDueDate  >= sysDate THEN FlowKey END)  @groupcase FOR XML PATH('''')), 1, 1, N'''')  as attr_YesFN'+@cntT
		+', SUM(CASE WHEN (YM_AD='''+@p_YMT_value+''' AND  AttorneyDueDate >= sysDate) THEN 1 ELSE 0 END) as YesFN'+@cntT+',';

	  SET @cnt = @cnt + 1;
	END
		set @CommonString=@CommonString +'1 as v13, STUFF ((SELECT distinct '','' + (CASE WHEN attr_sum<>'''' THEN attr_sum END) @groupcase FOR XML PATH('''')), 1, 1, N'''') as attr_sum_todos2,SUM(ISNULL(FNSUM,0)) as 小計 ';
		Set @CommonStringJoin1=@CommonStringJoin1+'STUFF ((SELECT distinct '','' + FlowKey @groupcase FOR XML PATH('''')), 1, 1, N'''')  as attr_sum, COUNT(distinct FlowKey) as FNSUM ';
		Set @CommonStringJoin2=replace(@CommonStringJoin1,' COUNT(distinct FlowKey)','SUM(CASE WHEN ISNULL(FlowKey,'''')<>'''' THEN 1 ELSE 0 END)');
		Set @CommonStringJoin3=@CommonStringJoin1;
		Set @CommonStringJoin4=@CommonStringJoin1;

	 IF @p_RptType='byDS'  
	 BEGIN
        -- 5-1.byDS 部別
	     Set @groupcase=' from #tmp_SqlJoin p where a.ItemName=p.Item_NotFH  and b.Emp_Item=p.Emp_Item and b.emp_DS=p.emp_DS  '
		 --Set @groupcase1=' from #tmpTodos6_3 p  WHERE p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH and p.AssignedTo=a.AssignedTo and p.emp_DSNum=a.emp_DSNum and p.emp_DS=a.emp_DS and p.Emp_Item=a.Emp_Item     '
		 Set @groupcase1=' from #tmpTodos6_3 p  WHERE p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH   and p.AssignedTo=a.AssignedTo    and p.emp_DS=a.emp_DS    and p.emp_DSNum=a.emp_DSNum    and p.Emp_Item=a.Emp_Item     '
		 Set @groupcase2=' from #tmpTodos6_Levelsum p WHERE p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH    '
		 Set @groupcase3=' from #tmpTodos6_3 p WHERE p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH   '
		 Set @groupcase4=' from #tmpTodos6_3 p where p.Item_NotFH<>''''    '

		  Set @SqlJoinString=@SqlJoinString+'select a.* into #tmp_SqlJoin from (
		 SELECT Item_NotFH, AssignedTo+'' ''+AssignedTo_Name as AssignedTo_Name2, emp_DS, 
				   CASE WHEN ISNULL(Emp_Item,'''')='''' THEN ''沒指定部別'' ELSE Emp_Item END as Emp_Item,  
				   CASE WHEN ISNULL(emp_Sort,'''')='''' THEN 666 ELSE emp_Sort END as emp_Sort, ' + replace(@CommonStringJoin1 ,'@groupcase',@groupcase1) 
		 +'FROM #tmpTodos6_3 a where Item_NotFH<>'''' 
            GROUP BY Item_NotFH, AssignedTo, AssignedTo_Name, emp_DS, emp_DSNum, Emp_Item, emp_Sort '
		 +'Union all '
		 +'SELECT Item_NotFH, '''' as AssignedTo_Name2, '''' as emp_DS, ''重要小計'' as Emp_Item, 9977 as emp_Sort, ' + replace(@CommonStringJoin2,'@groupcase',@groupcase2) 
		 +'FROM #tmpTodos6_Levelsum a where Item_NotFH<>'''' GROUP BY Item_NotFH '
		 +'Union all '
		 +'SELECT Item_NotFH, '''' as AssignedTo_Name2, '''' as emp_DS, ''小計'' as Emp_Item, 9988 as emp_Sort, ' + replace(@CommonStringJoin3 ,'@groupcase',@groupcase3) 
		 +'FROM #tmpTodos6_3 a where Item_NotFH<>'''' GROUP BY Item_NotFH '
		 +'Union all '
		 +'SELECT ''總計'' as Item_NotFH, ''總計'' as AssignedTo_Name2, ''總計'' as emp_DS, ''總計'' as Emp_Item, 9999 as emp_Sort, ' + replace(@CommonStringJoin4 ,'@groupcase',@groupcase4) 
		 +'FROM #tmpTodos6_3 a where Item_NotFH<>'''' ) a ' ;  
		 --select cast(@SqlJoinString as varchar(max)); --debug query
		SET @SqlString=@SqlString+@SqlJoinString+' ;';
		 --Exec (@SqlJoinString+'  ');    
		 
		 set @SqlString=@SqlString+'SELECT a.ItemName as attr_ItemName, ISNULL(b.Emp_Item,'''') as attr_empcol2, a.ItemName as 項目, ISNULL(b.Emp_Item,'''') as attr_EmpItem, ISNULL(b.Emp_Item,'''') as 部別,  '+ replace(@CommonString,'@groupcase',@groupcase) +'   '
		 +'FROM #tmpItem a '
		 +'INNER JOIN #tmp_SqlJoin b ON a.ItemName=b.Item_NotFH
			GROUP BY a.ItemNo, a.ItemName,Emp_Item, Emp_Sort ,emp_DS
			Order by a.ItemNo, CASE WHEN RIGHT(Emp_Item,2)=''小計'' THEN 0 ELSE SUM(FNSUM) END DESC , Emp_Sort;  '  
			+'IF OBJECT_ID(''tempdb..#tmp_SqlJoin'', ''U'') IS NOT NULL DROP TABLE #tmp_SqlJoin;'  
        END
	ELSE IF @p_RptType='byDept'   
	BEGIN
        -- 5-2.byDept 所別
		 Set @groupcase=' from #tmp_SqlJoin p where a.ItemName=p.Item_NotFH  and b.Emp_Item=p.Emp_Item and b.emp_DS=p.emp_DS '
		 Set @groupcase1=' from #tmpTodos6_3 p  WHERE p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH and p.AssignedTo=a.AssignedTo and p.emp_DS=a.emp_DS   and p.emp_DSNum=a.emp_DSNum   and p.Emp_Item=a.Emp_Item     '
		 Set @groupcase2=' from #tmpTodos6_Levelsum p WHERE p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH    '
		 Set @groupcase3=' from #tmpTodos6_3 p WHERE p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH   '
		 Set @groupcase4=' from #tmpTodos6_3 p where p.Item_NotFH<>''''    '

		  Set @SqlJoinString=@SqlJoinString+'select a.* into #tmp_SqlJoin from (
		 SELECT Item_NotFH, AssignedTo+'' ''+AssignedTo_Name as AssignedTo_Name2, 
				   CASE WHEN ISNULL(emp_DS,'''')='''' THEN ISNULL(Emp_DS,''沒指定所別'') ELSE emp_DS END as emp_DS, emp_DSNum,
				   CASE WHEN ISNULL(Emp_Item,'''')='''' THEN ''沒指定部別'' ELSE Emp_Item END as Emp_Item, 
				   CASE WHEN ISNULL(emp_Sort,'''')='''' THEN 666 ELSE emp_Sort END as emp_Sort, ' + replace(@CommonStringJoin1 ,'@groupcase',@groupcase1) 
		 +'FROM #tmpTodos6_3 a where Item_NotFH<>'''' 
            GROUP BY Item_NotFH, AssignedTo, AssignedTo_Name, emp_DS, emp_DSNum, Emp_Item, emp_Sort '
		 +'Union all '
		 +'SELECT Item_NotFH, '''' as AssignedTo_Name2, ''重要小計'' as emp_DS, 9977 as emp_DSNum, '''' as Emp_Item, 9977 as emp_Sort , ' + replace(@CommonStringJoin2,'@groupcase',@groupcase2) 
		 +'FROM #tmpTodos6_Levelsum a where Item_NotFH<>'''' GROUP BY Item_NotFH '
		 +'Union all '
		 +'SELECT Item_NotFH, '''' as AssignedTo_Name2, ''小計'' as emp_DS, 9988 as emp_DSNum, '''' as Emp_Item, 9988 as emp_Sort, ' + replace(@CommonStringJoin3 ,'@groupcase',@groupcase3) 
		 +'FROM #tmpTodos6_3 a where Item_NotFH<>'''' GROUP BY Item_NotFH '
		 +'Union all '
		 +'SELECT ''總計'' as Item_NotFH, ''總計'' as AssignedTo_Name2, ''總計'' as emp_DS, 9988 as emp_DSNum, ''總計'' as Emp_Item, 9999 as emp_Sort, ' + replace(@CommonStringJoin4 ,'@groupcase',@groupcase4) 
		 +'FROM #tmpTodos6_3 a where Item_NotFH<>'''' ) a ' ;  
		 --select cast(@SqlJoinString as varchar(max)); --debug query
		SET @SqlString=@SqlString+@SqlJoinString+' ;';
		 --Exec (@SqlJoinString+' ;');    

		 set @SqlString=@SqlString+'SELECT a.ItemName as attr_ItemName, ISNULL(b.emp_DS,'''') as attr_EmpCol2, a.ItemName as 項目, ISNULL(b.emp_DS,'''') as attr_EmpDS, ISNULL(b.emp_DS,'''') as 所別,  '+ replace(@CommonString,'@groupcase',@groupcase) +'  '
		 +'FROM #tmpItem a '
		 +'INNER JOIN #tmp_SqlJoin b ON a.ItemName=b.Item_NotFH
			GROUP BY a.ItemNo, a.ItemName, emp_DS,Emp_DSNum,Emp_Item
			Order by a.ItemNo, CASE WHEN RIGHT(emp_DS,2)=''小計'' THEN 0 ELSE SUM(FNSUM) END DESC, Emp_DSNum ;  '
			+'IF OBJECT_ID(''tempdb..#tmp_SqlJoin'', ''U'') IS NOT NULL DROP TABLE #tmp_SqlJoin;'  
		END
	ELSE IF  @p_RptType='byPeople' 
	 BEGIN
        -- 5-3.byPeople 人員
	     Set @groupcase=' from #tmp_SqlJoin p where a.ItemName=p.Item_NotFH  and b.AssignedTo_Name2=p.AssignedTo_Name2 and b.Emp_Item=p.Emp_Item and b.emp_DS=p.emp_DS   '
		 Set @groupcase1=' from #tmpTodos6_3 p  WHERE p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH and p.AssignedTo=a.AssignedTo and p.emp_DS=a.emp_DS and p.Emp_Item=a.Emp_Item     '
		 Set @groupcase2=' from #tmpTodos6_Levelsum p WHERE p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH    '
		 Set @groupcase3=' from #tmpTodos6_3 p WHERE p.Item_NotFH<>'''' and p.Item_NotFH=a.Item_NotFH   '
		 Set @groupcase4=' from #tmpTodos6_3 p where p.Item_NotFH<>''''    '

		  Set @SqlJoinString=@SqlJoinString+'select a.* into #tmp_SqlJoin from (
		 SELECT Item_NotFH, CASE WHEN Emp_ID LIKE ''12%'' THEN AssignedTo_Name+''(''+Emp_ID+'')'' ELSE AssignedTo_Name END as AssignedTo_Name2,  
				   CASE WHEN ISNULL(emp_DS,'''')='''' THEN ISNULL(emp_DS,'''') ELSE emp_DS END as emp_DS, 
				   CASE WHEN ISNULL(Emp_Item,'''')='''' THEN ''沒指定部別'' ELSE Emp_Item END as Emp_Item, 
				   CASE WHEN ISNULL(emp_Sort,'''')='''' THEN 666 ELSE emp_Sort END as emp_Sort, ' + replace(@CommonStringJoin1 ,'@groupcase',@groupcase1) 
		 +'FROM #tmpTodos6_3 a where Item_NotFH<>'''' GROUP BY Item_NotFH, AssignedTo, AssignedTo_Name, emp_DS,Emp_ID, Emp_Item, emp_Sort '
		 +'Union all '
		 +'SELECT Item_NotFH, ''重要小計'' as AssignedTo_Name2, '''' as emp_DS, '''' as Emp_Item, 9977 as emp_Sort  , ' + replace(@CommonStringJoin2,'@groupcase',@groupcase2) 
		 +'FROM #tmpTodos6_Levelsum a where Item_NotFH<>'''' GROUP BY Item_NotFH '
		 +'Union all '
		 +'SELECT Item_NotFH, ''小計'' as AssignedTo_Name2, '''' as emp_DS, '''' as Emp_Item, 9988 as emp_Sort, ' + replace(@CommonStringJoin3 ,'@groupcase',@groupcase3) 
		 +'FROM #tmpTodos6_3 a where Item_NotFH<>'''' GROUP BY Item_NotFH '
		 +'Union all '
		 +'SELECT ''總計'' as Item_NotFH, ''總計'' as AssignedTo_Name2, ''總計'' as emp_DS, ''總計'' as Emp_Item, 9999 as emp_Sort, ' + replace(@CommonStringJoin4 ,'@groupcase',@groupcase4) 
		 +'FROM #tmpTodos6_3 a where Item_NotFH<>'''' ) a ' ;  
		SET @SqlString=@SqlString+@SqlJoinString+' ;';
		 --select cast(@SqlJoinString as varchar(max)); --debug query
		 --Exec (@SqlJoinString+' ;');    

		 set @SqlString=@SqlString+'SELECT a.ItemName as attr_ItemName, ISNULL(b.AssignedTo_Name2,'''') as attr_EmpCol2, a.ItemName as 項目, ISNULL(b.AssignedTo_Name2,'''') as attr_AssignedTo_Name2, ISNULL(b.AssignedTo_Name2,'''') as 承辦人員,  
									 b.Emp_Item as attr_Emp_Item, b.Emp_Item as 部別, b.emp_DS as attr_emp_DS, b.emp_DS as 所別,  '+ replace(@CommonString,'@groupcase',@groupcase) +'  '
		 +'FROM #tmpItem a '
		 +'INNER JOIN #tmp_SqlJoin b ON a.ItemName=b.Item_NotFH
		GROUP BY a.ItemNo, a.ItemName, AssignedTo_Name2, emp_Sort, Emp_Item, Emp_DS       
        Order by a.ItemNo, CASE WHEN RIGHT(AssignedTo_Name2,2)=''小計'' THEN 0 ELSE SUM(FNSUM) END DESC,emp_Sort,  AssignedTo_Name2 ; '  
		+'IF OBJECT_ID(''tempdb..#tmp_SqlJoin'', ''U'') IS NOT NULL DROP TABLE #tmp_SqlJoin;'  
	END 
   
   --select cast(@SqlString as varchar(max)); --debug query
    Exec (@SqlString );     
    
	IF OBJECT_ID('tempdb..#p_YMT', 'U') IS NOT NULL DROP TABLE #p_YMT
	IF OBJECT_ID('tempdb..#tmpEmp', 'U') IS NOT NULL DROP TABLE #tmpEmp
	IF OBJECT_ID('tempdb..#tmpItem', 'U') IS NOT NULL DROP TABLE #tmpItem
	IF OBJECT_ID('tempdb..#tmpTodosAll', 'U') IS NOT NULL DROP TABLE #tmpTodosAll
	IF OBJECT_ID('tempdb..#tmpTodos6TDList', 'U') IS NOT NULL DROP TABLE #tmpTodos6TDList
	IF OBJECT_ID('tempdb..#tmpTodos6_3All', 'U') IS NOT NULL DROP TABLE #tmpTodos6_3All
	IF OBJECT_ID('tempdb..#tmpTodos6_3', 'U') IS NOT NULL DROP TABLE #tmpTodos6_3
	IF OBJECT_ID('tempdb..#tmpTodos6_Levelsum', 'U') IS NOT NULL DROP TABLE #tmpTodos6_Levelsum
	IF OBJECT_ID('tempdb..#tb_Split2', 'U') IS NOT NULL DROP TABLE #tb_Split2
END
GO
DECLARE @RC int 

-- TODO: 在此處設定參數值。

EXECUTE @RC = [dbo].rpt_CustCaseTot_YM_NotFinish 
   @p_YM_F='2020-01'
  ,@p_YM_T='2020-01'
  ,@p_RptType='bydept' -- byPeople ,bydept,byds
  ,@p_CustName='华星'
GO  