﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Models.CommonModel;
using static WebAPI.Tool.Common;

namespace WebAPI.Controllers
{
    [RoutePrefix("Esn_Subitem")]
    public class Esn_Todos_FlowController : ApiController
    {
        public class Sns
        {
            public String todos_sn { get; set; }
            public String Flow_id { get; set; }
        }

        HttpResponseMessage result;
        CommonResponseMsg response;
        MessageList_ETF Outmsg;
        String connString ;

        public Esn_Todos_FlowController()
        {
            if (Outmsg == null) Outmsg = new MessageList_ETF();
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["eflow_cur"].ConnectionString;
        }


        /// <summary>
        /// 取得歷史明細
        /// </summary>
        /// <param name="Get_Flow_his"></param>
        /// <returns></returns>
        [Route("GetFlowSns")]
        [CorsHandle]
        [HttpPost]
        //[HttpGet]
        public HttpResponseMessage Get_Flow_Sns(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());

                List<Esn_Todos_FlowModel> Hislist = new List<Esn_Todos_FlowModel>();
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        Esn_Todos_FlowModel hisT = new Esn_Todos_FlowModel();
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @" select a.ConfirmTime
                            ,Case When a.ConfirmUserClass='PG' Then '程序' When a.ConfirmUserClass='PE' Then '承辦人'  When a.ConfirmUserClass='Leader' Then '主管' else '其他' End as ConfirmUserClass
                            ,Case When a.ConfirmMethod='CF' Then '確認' When a.ConfirmMethod='RJ' Then '退回'  When a.ConfirmMethod='RV' Then '撤回'  else '其他' End  as ConfirmMethod
                            ,a.Create_time,d.cn_name as Create_User_Name,b.Step_Text as ""From"",c.Step_Text as ""To"",a.Description
                            from esn_Todos_flow_his a
                            left join esn_todos_Flow_StepType b on a.FromType_id = b.id
                            left join esn_todos_Flow_StepType c on a.ToType_id = c.id
                            left join evw_Employee d  on a.Create_User_id = d.user_id
                            where a.Flow_id = @Flow_id
                    "
                        };
                        cmd.Parameters.AddWithValue("@Flow_id", obj_input["Flowid"].ToString());
                        DataSet ds = SqlToDs(cmd);
                        DateTime? ConfirmTime;
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            ConfirmTime = (DateTime?)dr["ConfirmTime"];
                            hisT = new Esn_Todos_FlowModel()
                            {

                                ConfirmTime = ConfirmTime,
                                ConfirmUserClass = dr["ConfirmUserClass"].ToString(),
                                ConfirmMethod = dr["ConfirmMethod"].ToString(),
                                Create_User_Name = dr["Create_User_Name"].ToString(),
                                From = dr["From"].ToString(),
                                To = dr["To"].ToString(),
                                Description = dr["Description"].ToString()
                            };
                            Hislist.Add(hisT);
                            //Hislist.OrderByDescending(p => p.ConfirmTime);
                        }
                    }

                    response.Code = "1";
                    response.Msg = Hislist;
                    result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                }
                catch (Exception e)
                {

                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        /// <summary>
        /// 取得歷史明細
        /// </summary>
        /// <param name="Get_Flow_his"></param>
        /// <returns></returns>
        [Route("GetFlowHis")]
        [CorsHandle]
        [HttpPost]
        //[HttpGet]
        public HttpResponseMessage Get_Flow_his(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());

                List<Esn_Todos_FlowModel> Hislist = new List<Esn_Todos_FlowModel>();
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        Esn_Todos_FlowModel hisT = new Esn_Todos_FlowModel();
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @" select a.ConfirmTime
                            ,Case When a.ConfirmUserClass='PG' Then '程序' When a.ConfirmUserClass='PE' Then '承辦人'  When a.ConfirmUserClass='Leader' Then '主管' else '其他' End as ConfirmUserClass
                            ,Case When a.ConfirmMethod='CF' Then '確認' When a.ConfirmMethod='RJ' Then '退回'  When a.ConfirmMethod='RV' Then '撤回'  
                            When a.ConfirmMethod='RJTOp' Then '轉運營辦'   When a.ConfirmMethod='CFTLd' Then '待轉運營辦'   else '其他' End  as ConfirmMethod
                            ,a.Create_time,d.cn_name as Create_User_Name,b.Step_Text as ""From"",c.Step_Text as ""To"",a.Description
                            from esn_Todos_flow_his a
                            left join esn_todos_Flow_StepType b on a.FromType_id = b.id
                            left join esn_todos_Flow_StepType c on a.ToType_id = c.id
                            left join evw_Employee d  on a.Create_User_id = d.user_id
                            where a.Flow_id = @Flow_id
                    "
                        };
                        cmd.Parameters.AddWithValue("@Flow_id", obj_input["Flowid"].ToString());
                        DataSet ds = SqlToDs(cmd);
                        DateTime? ConfirmTime;
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            ConfirmTime = (DateTime?)dr["ConfirmTime"];
                            hisT = new Esn_Todos_FlowModel()
                            {

                                ConfirmTime = ConfirmTime,
                                ConfirmUserClass = dr["ConfirmUserClass"].ToString(),
                                ConfirmMethod = dr["ConfirmMethod"].ToString(),
                                Create_User_Name = dr["Create_User_Name"].ToString(),
                                From = dr["From"].ToString(),
                                To = dr["To"].ToString(),
                                Description = dr["Description"].ToString()
                            };
                            Hislist.Add(hisT);
                            //Hislist.OrderByDescending(p => p.ConfirmTime);
                        }
                    }

                    response.Code = "1";
                    response.Msg = Hislist;
                    result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                }
                catch (Exception e)
                {

                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        /// <summary>
        /// 取得EHR匯出歷史
        /// </summary>
        /// <param ></param>
        /// <returns></returns>
        [Route("GetExportEHRhis")]
        [CorsHandle]
        [HttpPost]
        //[HttpGet]
        public HttpResponseMessage Get_ExportEHR_his(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());

                try
                {
                    List<ExportEHR_hisModel> Hislist = new List<ExportEHR_hisModel>();
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        ExportEHR_hisModel hisT ;
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"select b.cn_name, a.* from esn_todos_SettleLog a 
                                            left join s_user_info b on a.Create_user_id=b.user_id   
                                            where a.Create_user_id=@Create_user_id "
                        };
                        cmd.Parameters.AddWithValue("@Create_user_id", obj_input["gUserID_wade"].ToString());
                        DataSet ds = SqlToDs(cmd);
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            hisT = new ExportEHR_hisModel()
                            {
                                id = (int)dr["id"],
                                SaveData = dr["SaveData"].ToString(),
                                update_time =(DateTime?) dr["update_time"] ,
                                update_user_id = dr["update_user_id"].ToString(),
                                Create_time = (DateTime?)dr["Create_time"],
                                Create_user_id = dr["Create_user_id"].ToString(),
                                cn_name = dr["cn_name"].ToString(),
                            };
                            Hislist.Add(hisT);
                        }
                    }

                    response.Code = "1";
                    response.Msg = Hislist;
                    result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                }
                catch (Exception e)
                {

                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        /// <summary>
        /// 取得EHR匯出歷史單筆細節
        /// </summary>
        /// <param ></param>
        /// <returns></returns>
        [Route("GetExportEHRhis_Detail")]
        [CorsHandle]
        [HttpPost]
        //[HttpGet]
        public HttpResponseMessage Get_ExportEHR_hisDetail(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());

                try
                {
                    string JsonString = "";
                   List <ExportEHR_hisModel> Hislist = new List<ExportEHR_hisModel>();
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"select b.cn_name, a.* from esn_todos_SettleLog a 
                                            left join s_user_info b on a.Create_user_id=b.user_id   
                                            where a.Create_user_id=@Create_user_id and a.id=@id "
                        };
                        cmd.Parameters.AddWithValue("@Create_user_id", obj_input["gUserID_wade"].ToString());
                        cmd.Parameters.AddWithValue("@id", obj_input["id"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        foreach (DataRow dr in dt.Rows)
                        {
                            JsonString = dr["SaveData"].ToString();
                        }
                      
                    }
                    response.Code = "1";
                    response.Msg = JsonString;
                    result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                }
                catch (Exception e)
                {

                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        /// <summary>
        /// FLOW 保存
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [Route("SaveEsnTodosFlow")]
        [CorsHandle]
        [HttpPost]
        [HttpGet]
        public HttpResponseMessage Save_Esn_Todos_Flow(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {

                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        int IsConfirm;
                        List<String> return_msgs = new List<string>(), return_msg_error = new List<string>()
                            , Confirm_Class = new List<string>();
                        List<Esn_Todos_Flow_StepTypeModel> AllStepType = new List<Esn_Todos_Flow_StepTypeModel>();
                        String return_msg, Confirm_Method = obj_input["Confirm_Method"].ToString();
                        switch (Confirm_Method)
                        {
                            case "CF":
                                IsConfirm = 1; return_msg = "確認完成"; break;
                            case "RV":
                                IsConfirm = 0; return_msg = ""; break;
                            case "RJ":
                                IsConfirm = 0; return_msg = "已退回"; break;
                            case "CFTLd":
                                IsConfirm = 0; return_msg = "提交成功"; break;
                            case "RJTOp":
                                IsConfirm = 0; return_msg = "已轉至運營辦"; break;
                            case "LA": 
                                IsConfirm = 1; return_msg = "請求提成完成"; break;
                            case "LAL":
                                IsConfirm = 0; return_msg = "請求提成完成"; break;
                            default:
                                IsConfirm = 0; return_msg = "已退回"; break;
                        }
                        SqlCommand cmd = new SqlCommand("", Conn);
                        DataSet ds;
                        #region 取得Flow驗證身分
                        cmd.CommandText = @"select * from esn_todos_Flow_StepType a";
                        ds = SqlToDs(cmd);
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            AllStepType.Add(new Esn_Todos_Flow_StepTypeModel()
                            {
                                id = Convert.ToInt32(dr["id"]),
                                update_time = Convert.ToDateTime(dr["update_time"]),
                                Map_Class = dr["Map_Class"].ToString(),
                                Step_Text = dr["Step_Text"].ToString(),
                                Step_Id_Next = Convert.ToInt32(dr["Step_Id_Next"]),
                                Step_Value = dr["Step_Value"].ToString(),
                                Step_Id_previous = Convert.ToInt32(dr["Step_Id_previous"]),
                                update_user_id = dr["update_user_id"].ToString()
                            }
                            );
                        }
                        #endregion

                        #region 取得該員身分
                        cmd.CommandText = @"select * from evw_Employee a
                                            where a.user_id= @user_id 　and a.is_enabled=1 and isnull(Emp_LeaveDate,'')=''";
                        cmd.Parameters.AddWithValue("@user_id", obj_input["Wade_User_ID"].ToString());
                        //cmd.Parameters.AddWithValue("@user_id", "FD67D192-041B-4725-A3E1-CB5E62A5CC61");//test

                        ds = SqlToDs(cmd);

                        Confirm_Class.Add("PE");//預設有承辦人
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            if (dr["is_programmer"].ToString() == "1") Confirm_Class.Add("PG");
                            if (dr["is_dept_manager"].ToString() == "1") Confirm_Class.Add("Leader");
                        }
                        #endregion
                        //Confirm_Class.Add("PG"); Confirm_Class.Add("Leader"); //test 
                        #region 取得FLOW相關
                        cmd.CommandText = @"select　ets.Settle_Date,case when ets.isClosed=1  then 1 else 0 end SettleisClosed,et.*,etf.id AS Flowid,etf.*,
                            etfs.* FROM esn_todos et 
                            left join esn_todos_Flow etf on et.sn=etf.esn_todos_sn
                            left join esn_todos_Flow_StepType etfs on etfs.id=etf.StepType_id
							left join esn_todos_points etp on etp.sn=et.sn
							left join evw_Employee eel on eel.user_id=et.AssignedTo_userid
							left join esn_todos_Settle ets on ets.DSNum =eel.Emp_DSNum  and DATEDIFF(MONTH,etp.date_points_settlement,ets.Settle_Date)=0
                            where et.sn in(@Esn_Todos_Sn)

                          ";

                        List<Sns> items = JsonConvert.DeserializeObject<List<Sns>>(obj_input["Sns"].ToString());
                        var parameters = new string[items.Count];
                        cmd.Parameters.Clear();
                        for (int i = 0; i < items.Count; i++)
                        {
                            //parameters[i] = string.Format("@Esn_Todos_Sn_{0}", i);
                            //cmd.Parameters.AddWithValue(parameters[i], items[i].todos_sn);

                            parameters[i] = items[i].todos_sn;
                        }
                        cmd.CommandText = cmd.CommandText.Replace("@Esn_Todos_Sn", string.Format(string.Join(",", parameters)));
                        ds = SqlToDs(cmd);
                        #endregion

                        String Wade_User_ID = obj_input["Wade_User_ID"].ToString(), Reject_Description = obj_input["Reject_Description"].ToString(),
                            date0 = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"), Tsql = "",RJTOp="";

                        JToken JtSn;
                        //List<String> sql = new List<string>();
                        int StepType_id_Previous, StepType_id, StepType_idHis;
                        Boolean SettleisClosed = false;
                        DataRow dsr;
                        //foreach (DataRow dr in ds.Tables[0].Rows)
                        for (int i = 0; i < ds.Tables[0].Rows.Count; i++) 
                        {
                            dsr = ds.Tables[0].Rows[i];
                            RJTOp = "";
                            StepType_id_Previous = dsr["StepType_id_Previous"] == DBNull.Value ? 0 : Convert.ToInt32(dsr["StepType_id_Previous"]);
                            //StepType_id_next = Convert.ToInt32(dsr["StepType_id_next"]);
                            StepType_id = dsr["StepType_id"] == DBNull.Value ? 0 : Convert.ToInt32(dsr["StepType_id"]);
                            Esn_Todos_Flow_StepTypeModel CStepTypeNext = new Esn_Todos_Flow_StepTypeModel(), CStepTypeCur = new Esn_Todos_Flow_StepTypeModel();
                            JtSn = obj_input.SelectToken("$.Sns[?(@.todos_sn == '" + dsr["Sn"] + "')]");

                            if (dsr["esn_todos_sn"] == DBNull.Value) //insert
                            {
                              
                                if (JtSn["targetclass"] == null || string.IsNullOrEmpty(JtSn["targetclass"].ToString()))
                                {
                                    return_msg_error.Add(dsr["esn_todos_sn"] + ":無FLOW資料時,請設定目的身分代碼(設定targetclass )");
                                    continue;
                                }
                                 
                                CStepTypeCur = AllStepType.Where(p => p.Map_Class.Contains(JtSn["validclass"].ToString())).FirstOrDefault();
                                
                                    CStepTypeNext = AllStepType.Where(p => p.id == AllStepType.Where(p2 => p2.Map_Class == JtSn["targetclass"].ToString()).FirstOrDefault().id).FirstOrDefault();
                                CStepTypeCur = AllStepType.Where(p => p.id == Convert.ToInt32(CStepTypeNext.Step_Id_previous)).FirstOrDefault(); 
                                StepType_idHis = CStepTypeCur.id;
                                //else
                                //    CStepTypeNext = AllStepType.Where(p => p.id == CStepTypeCur.Step_Id_Next).FirstOrDefault();

                                //CStepTypeCur = CStepTypeNext;
                                Tsql += @"insert into esn_todos_Flow(esn_todos_sn,[StepType_id],[" + CStepTypeCur.Map_Class
                                     + @"_IsConfirm],StepType_id_Previous,Description,[create_user_id],[Create_time],update_user_id,update_time) "
                                     + " OUTPUT Inserted.id into @TempTable "
                                     + " values (" + dsr["sn"] + ",'" + CStepTypeNext.id + "'," + IsConfirm + ",'" + StepType_idHis
                                     + "',@Reject_Description,@Wade_User_ID,'" + date0 + "'" + ",@Wade_User_ID,'" + date0 + "'" + "); "
                                     ;
                            }
                            else //update
                            {
                                String Map_Class = dsr["Map_Class"].ToString();
                                #region 驗證  
                                //if (Map_Class != JtSn["validclass"].ToString())
                                //{
                                //    return_msg_error.Add(dsr["esn_todos_sn"] + ":該流程已異動, 不可變更");
                                //}
                                SettleisClosed = dsr["SettleisClosed"].ToString() == "1" ? true : false;
                                if (SettleisClosed)
                                    return_msg_error.Add(dsr["esn_todos_sn"] + ":該流程 "+ Convert.ToDateTime( dsr["Settle_Date"]).ToString(" yyyy年MM月 ") + "已關帳, 不可變更");
                                #endregion

                                //String Step_Value_previous = dsr["Step_Value_previous"].ToString(), Step_Value_Next = dsr["Step_Value_Next"].ToString();
                                Tsql = Tsql + "update esn_todos_Flow set ";

                                CStepTypeCur = AllStepType.Where(p => p.id == StepType_id).FirstOrDefault(); 
                                StepType_idHis = CStepTypeCur.id;

                                #region 確認是否有審核資格

                                //2021-08-20限制全取消
                                if (!Confirm_Class.Contains(Map_Class))
                                {
                                    //return_msg_error.Add(dsr["esn_todos_sn"] + ":無可審核該筆身分");
                                }
                                if (int.Parse(CStepTypeCur.Step_Value) > 90)
                                {
                                    //return_msg_error.Add(dsr["esn_todos_sn"] + ":審核流程已結束,不可確認");
                                }

                                #endregion 

                                if (Confirm_Method == "CF" || Confirm_Method == "CFTLd")
                                {
                                  
                                    CStepTypeNext = AllStepType.Where(p => p.id == CStepTypeCur.Step_Id_Next).FirstOrDefault();
                                }

                                if (Confirm_Method == "RJ")
                                {
                                    //Tsql = Tsql + "PG_IsConfirm =" + IsConfirm + "," + "PE_IsConfirm =" + IsConfirm + "," + "Leader_IsConfirm =" + IsConfirm + ","; //退回後,改為更新所有Flow狀態確認
                                    //CStepTypeNext = AllStepType.Where(p => p.Step_Value == Step_Value_previous).FirstOrDefault(); 
                                    CStepTypeNext = AllStepType.Where(p => p.id == CStepTypeCur.Step_Id_previous).FirstOrDefault();
                                }
                                else if (Confirm_Method == "RV")
                                {
                                    //CStepTypeNext = AllStepType.Where(p => p.id == StepType_id_Previous).FirstOrDefault();
                                    //CStepTypeCur.id = CStepTypeNext.id; //回復與下一步 同ID
                                    //Tsql = Tsql + CStepTypeNext.Map_Class + "_IsConfirm =" + IsConfirm + ",";
                                    CStepTypeNext = AllStepType.Where(p => p.id == StepType_id_Previous).FirstOrDefault();
                                    if (JtSn["validclass"].ToString()=="PG")
                                    { 
                                        RJTOp += String.Format(@"update esn_todos_points set date_points_settlement=null where sn=" + dsr["sn"] + ";");
                                         RJTOp += String.Format(@"update esn_todos_Flow set Is_Settlement=0 where esn_todos_sn=" + dsr["sn"] + ";");
                                    }
                                }
                                else if (Confirm_Method == "RJTOp")
                                {
                                    //Tsql = Tsql + "PG_IsConfirm =" + IsConfirm + "," + "PE_IsConfirm =" + IsConfirm + "," + "Leader_IsConfirm =" + IsConfirm + ","; //退回後,改為更新所有Flow狀態確認
                                    //CStepTypeNext = AllStepType.Where(p => p.Step_Value == Step_Value_previous).FirstOrDefault();
                                    RJTOp = String.Format(@"exec [dbo].esp_esn_Todos_V3_AssignStatus 'AS05' ," + dsr["sn"] + @",'',@todos_Reject_Desc_{0},'',@Wade_User_ID ;", i);
                                    cmd.Parameters.AddWithValue(string.Format("@todos_Reject_Desc_{0}",i), "承辦人:" + JtSn["todos_Reject_Desc"].ToString() + "<br>主管:" + Reject_Description );

                                    CStepTypeNext = AllStepType.Where(p => p.id == CStepTypeCur.Step_Id_previous).FirstOrDefault();
                                }
                                else
                                {
                                    //Tsql = Tsql + CStepTypeCur.Map_Class + "_IsConfirm =" + IsConfirm + ",";
                                    CStepTypeNext = AllStepType.Where(p => p.id == CStepTypeCur.Step_Id_Next).FirstOrDefault();
                                }

                                //有指定蓋過預設
                                if (JtSn["targetclass"] != null && !string.IsNullOrEmpty(JtSn["targetclass"].ToString()))
                                {
                                    CStepTypeNext = AllStepType.Where(p => p.id == AllStepType.Where(p2 => p2.Map_Class == JtSn["targetclass"].ToString()).FirstOrDefault().id).FirstOrDefault();
                                }

                                Tsql = Tsql + " StepType_id = '" + CStepTypeNext.id + "',StepType_id_Previous = '" + CStepTypeCur.id +
                                    "',Description = @Reject_Description,update_user_id=@Wade_User_ID,update_time='" + date0 + "' "
                                    + " output Inserted.id  into @TempTable where id =" + dsr["Flowid"] + ";"
                                    ;
                            }

                            Tsql += @"select @FlowId=id from @TempTable;
                                    insert into esn_todos_Flow_his  (Flow_id,ConfirmTime,FromType_id,ToType_id,ConfirmUserId,ConfirmUserClass,ConfirmMethod,Description,Create_User_id,Create_time) "
                                    + " values (@FlowId,'" + date0 + "','" + StepType_idHis + "','" + CStepTypeNext.id + "',@Wade_User_ID,'" + CStepTypeCur.Map_Class + "','" + Confirm_Method + "',@Reject_Description,@Wade_User_ID,'" + date0 + "'" + ") ;";
                            Tsql += RJTOp;
                        }

                        cmd.Parameters.AddWithValue("@Reject_Description", Reject_Description);
                        cmd.Parameters.AddWithValue("@Wade_User_ID", Wade_User_ID);
                        cmd.CommandText = @"declare  @TempTable TABLE(id INT) 
                                            declare @FlowId int " + Tsql;

                        return_msgs.Add(return_msg);
                        if (return_msg_error.Count == 0)
                        {
                            DataTable dt = SqlToDt(cmd);
                            response.Code = "1";
                            response.Msg = return_msgs;
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = return_msg_error;
                        }
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }


        [Route("SavePointSettlementLog")]
        [CorsHandle]
        [HttpPost]
        [HttpGet]
        public HttpResponseMessage Save_PointSettlement_Log(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                try
                {
                    JObject obj_input = JObject.Parse(input.ToString());
                    JArray obj_input_data= JArray.Parse(obj_input["SaveData"].ToString());

                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"Insert into esn_todos_SettleLog([SaveData],[Country],[update_time],[update_user_id],Create_time,Create_user_id)
                            values(@SaveData,@Country,getdate(),@gUserID_wade,getdate(),@gUserID_wade)"
                        };
                        cmd.Parameters.AddWithValue("@SaveData", obj_input["SaveData"].ToString());
                        cmd.Parameters.AddWithValue("@gUserID_wade", obj_input["gUserID_wade"].ToString());
                        cmd.Parameters.AddWithValue("@Country", obj_input["Country"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        response.Code = "1";
                        response.Msg = "匯出完畢";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }


    }

}
