﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using WebAPI.Models;
using WebAPI.Tool;

namespace WebAPI.Dal
{
    public class DalProcInfo : Dal
    {
        public CommonResponseMsg GetCtrlProc(string field = "*" ,string ctrl_proc_id = null, string ctrl_proc_name = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.i_ctrl_proc", field);
                if(string.IsNullOrEmpty(ctrl_proc_id))
                {
                    if(!string.IsNullOrEmpty(ctrl_proc_name))
                    {
                        sql += string.Format(@" where (ctrl_proc_zh_cn = '{0}' or ctrl_proc_zh_tw = '{0}') and is_enabled = 1", ctrl_proc_name);
                    }
                }
                else
                {
                    sql += string.Format(@" where ctrl_proc_id = '{0}' and is_enabled = 1", ctrl_proc_id);
                }
                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch(Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetCaseStatus(string field = "*", string case_status_id = null, string case_status_name = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.i_case_status", field);
                if (string.IsNullOrEmpty(case_status_id))
                {
                    if (!string.IsNullOrEmpty(case_status_name))
                    {
                        sql += string.Format(@" where (case_status_zh_cn = '{0}' or case_status_zh_tw = '{0}')", case_status_name);
                    }
                }
                else
                {
                    sql += string.Format(@" where case_status_id = '{0}'", case_status_id);
                }
                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetProcInfo(string field, string proc_id = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.p_proc_info ppi
                LEFT JOIN dbo.p_case_info pci ON ppi.case_id = pci.case_id
                LEFT JOIN dbo.i_ctrl_proc icp ON ppi.ctrl_proc_id = icp.ctrl_proc_id
                LEFT JOIN dbo.i_case_status ics ON ppi.review_stage = ics.case_status_id", field);
                sql += " where ppi.is_enabled = 1";
                if (!string.IsNullOrEmpty(proc_id))
                {
                    sql += string.Format(@" and proc_id = '{0}'", proc_id);
                }
                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetProcInfoByName(string field = "*", string case_volume = null, string proc_name = null, string case_status_name = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.p_proc_info ppi
                LEFT JOIN dbo.p_case_info pci ON ppi.case_id = pci.case_id
                LEFT JOIN dbo.i_ctrl_proc icp ON ppi.ctrl_proc_id = icp.ctrl_proc_id
                LEFT JOIN dbo.i_case_status ics ON ppi.review_stage = ics.case_status_id", field);
                sql += " where ppi.is_enabled = 1";
                if (!string.IsNullOrEmpty(case_volume))
                {
                    sql += string.Format(@" and case_volume = '{0}'", case_volume);
                }
                if (!string.IsNullOrEmpty(proc_name))
                {
                    sql += string.Format(@" and (ctrl_proc_zh_cn = '{0}' or ctrl_proc_zh_tw = '{0}')", proc_name);
                }
                if (!string.IsNullOrEmpty(case_status_name))
                {
                    sql += string.Format(@" and (case_status_zh_cn = '{0}' or case_status_zh_tw = '{0}')", case_status_name);
                }

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetProcInfoListForForecast(string customer_id, string time_field, string s_time, string e_time)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql_s_time = "";
                string sql_e_time = "";
                string sql_customer = "";
                if (!string.IsNullOrEmpty(s_time))
                {
                    sql_s_time = string.Format("AND ppi.{0} >= '{1} 00:00:00'", time_field, s_time);
                }
                if (!string.IsNullOrEmpty(e_time))
                {
                    sql_e_time = string.Format("AND ppi.{0} <= '{1} 23:59:59'", time_field, e_time);
                }
                if (!string.IsNullOrEmpty(customer_id))
                {
                    sql_customer += "AND pci.customer_id in('" + String.Join("','", customer_id.Split(',')) + "')";
                }
                string sql = string.Format(@"SELECT ppi.proc_id, pci.case_volume, pci.case_name, pci.case_name_en, cc.customer_id, cc.customer_name
                , ict.case_type_id, ict.case_type_zh_cn,
                ibt.business_type_id, ibt.business_type_zh_cn,
                ic.country_id, ic.country_zh_cn,
                iat.apply_type_id, iat.apply_type_zh_cn,
                icp.ctrl_proc_id, icp.ctrl_proc_zh_cn,
                ics.case_status_id, ics.case_status_zh_cn,
                ppi.create_time,
                last_one.last_flag
                FROM dbo.p_proc_info ppi
                INNER JOIN dbo.p_case_info pci ON ppi.case_id = pci.case_id
                INNER JOIN dbo.c_customer cc ON pci.customer_id = cc.customer_id
                INNER JOIN dbo.i_case_type ict ON pci.case_type_id = ict.case_type_id
                INNER JOIN dbo.i_country ic ON pci.country_id = ic.country_id
                INNER JOIN dbo.i_apply_type iat on pci.apply_type_id = iat.apply_type_id
                INNER JOIN dbo.i_ctrl_proc icp ON ppi.ctrl_proc_id = icp.ctrl_proc_id
                LEFT JOIN dbo.i_case_status ics ON ppi.review_stage = ics.case_status_id
                INNER JOIN dbo.i_business_type ibt ON pci.business_type_id = ibt.business_type_id
                LEFT JOIN (
                    SELECT ppi.case_id, ppi.ctrl_proc_id, 1 AS last_flag, MAX(ppi.create_time) AS create_time
                    FROM dbo.p_proc_info ppi,dbo.p_case_info pci
                    WHERE ppi.is_enabled = 1
                    {0}
                    {1}
                    {2}
                    AND ppi.ctrl_proc_id IN ('6DD56B2B-1E1A-4E8B-9AC0-760CD305506A','E18F6EC7-0343-4431-9F30-BB86D0AF22B6')
                    AND ppi.case_id = pci.case_id
                    AND pci.case_type_id = '31D1A147-2931-43B5-94AE-B72B1525BA8A'
                    GROUP BY ppi.case_id, ppi.ctrl_proc_id
                ) last_one ON ppi.case_id = last_one.case_id and ppi.ctrl_proc_id = last_one.ctrl_proc_id and ppi.create_time = last_one.create_time
                WHERE ppi.is_enabled = 1
                AND icp.ctrl_proc_id IN ('6DD56B2B-1E1A-4E8B-9AC0-760CD305506A','8b96378e-05a0-4a8d-b3d1-39af92fddaf5','E18F6EC7-0343-4431-9F30-BB86D0AF22B6')
                AND ict.case_type_id = '31D1A147-2931-43B5-94AE-B72B1525BA8A'
                {0}
                {1}
                {2}", sql_s_time, sql_e_time, sql_customer);

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public AnnualInfo GetAnnualInfo(int proc_stage, string case_type_id, string country_id, string apply_type_id)
        {
            string sql = "select     af.annual_fee_id, af.case_type_id, af.country_id, af.apply_type_id, af.begin_type, af.currency_id, af.update_user_id, af.update_time, fc.config_id, fc.year_from, \r\n                                                fc.year_to, fc.basic_fee, fc.basic_fee_small, fc.basic_fee_micro, fc.item_fee, fc.seq, fc.legal_due_year, fc.legal_due_month, fc.legal_due_day\r\n                        from         i_annual_fee as af inner join\r\n                                                i_annual_fee_config as fc on af.annual_fee_id = fc.annual_fee_id\r\n                        where     (af.case_type_id = @case_type_id) and (af.country_id = @country_id) and (af.apply_type_id = @apply_type_id)";
            Hashtable ht = new Hashtable();
            ht.Add("case_type_id", case_type_id);
            ht.Add("country_id", country_id);
            ht.Add("apply_type_id", apply_type_id);
            DataSet ds = sql_server_helper.GetDataSet(sql);

            if (ds.Tables[0].Rows.Count == 0)
            {
                return null;
            }
            AnnualInfo ai = new AnnualInfo();
            DataRow[] drs = ds.Tables[0].Select("seq=" + proc_stage.ToString());
            if (drs.Length == 0)
            {
                ai.proc_stage = -1;
                return ai;
            }
            ai.annual_fee_id = Convert.ToString(drs[0]["annual_fee_id"]);
            ai.begin_type = Convert.ToString(drs[0]["begin_type"]);
            ai.proc_stage = Convert.ToInt32(drs[0]["seq"]);
            ai.currency_id = Convert.ToString(drs[0]["currency_id"]);
            ai.basic_fee = Convert.ToDouble(drs[0]["basic_fee"]);
            ai.basic_fee_small = Convert.ToDouble(drs[0]["basic_fee_small"]);
            ai.basic_fee_micro = Convert.ToDouble(drs[0]["basic_fee_micro"]);
            ai.item_fee = Convert.ToDouble(drs[0]["item_fee"]);
            ai.legal_due_year = Convert.ToInt32(drs[0]["legal_due_year"]);
            ai.legal_due_month = Convert.ToInt32(drs[0]["legal_due_month"]);
            ai.legal_due_day = Convert.ToInt32(drs[0]["legal_due_day"]);
            return ai;
        }

        public int GetAnnualStageByProc(string proc_id, string country_id, ref string review_stage)
        {
            int num;
            int num1;
            string strSql = string.Concat("SELECT ctrl_proc_code,case_id FROM dbo.p_proc_info pr INNER JOIN dbo.i_ctrl_proc ct ON pr.ctrl_proc_id=ct.ctrl_proc_id WHERE proc_id='", proc_id, "' ");
            DataSet ds = null;
            ds = sql_server_helper.GetDataSet(strSql);
            Hashtable ht = new Hashtable();
            strSql = "SELECT     cs.case_status_code, cp.ctrl_proc_code\r\n                            FROM         p_proc_info AS pi INNER JOIN\r\n                                                  i_ctrl_proc AS cp ON pi.ctrl_proc_id = cp.ctrl_proc_id LEFT OUTER JOIN\r\n                                                  i_case_status AS cs ON pi.review_stage = cs.case_status_id\r\n                            WHERE     (pi.proc_id = @proc_id)";
            if (ds != null && ds.Tables[0].Rows.Count > 0)
            {
                if (Convert.ToString(ds.Tables[0].Rows[0]["ctrl_proc_code"]).ToUpper() == "GPC")
                {
                    string case_id = Convert.ToString(ds.Tables[0].Rows[0]["case_id"]);
                    strSql = "SELECT     cs.case_status_code, cp.ctrl_proc_code\r\n                            FROM         p_proc_info AS pi INNER JOIN i_ctrl_proc AS cp ON pi.ctrl_proc_id = cp.ctrl_proc_id\r\n                            left outer join i_case_status as cs on pi.review_stage=cs.case_status_id \r\n                            WHERE     (pi.case_id = @case_id) AND cp.ctrl_proc_code = N'NOA' AND (pi.is_enabled = 1) AND (pi.proc_id <> @proc_id)";
                    ht.Add("case_id", case_id);
                }
                if (Convert.ToString(ds.Tables[0].Rows[0]["ctrl_proc_code"]).ToUpper() == "AP")
                {
                    strSql = "SELECT case_status_code,'AF' as ctrl_proc_code FROM dbo.i_case_status WHERE case_status_code='AN2' ";
                }
            }
            ht.Add("proc_id", proc_id);
            ds = sql_server_helper.GetDataSet(strSql, ht);
            try
            {
                string code = Convert.ToString(ds.Tables[0].Rows[0][0]);
                if (code.StartsWith("AN"))
                {
                    int stage = Convert.ToInt32(code.Replace("AN", ""));
                    num = stage + 1;
                    strSql = string.Concat("SELECT case_status_id FROM i_case_status WHERE case_status_code = 'AN", num.ToString(), "'");
                    ds = sql_server_helper.GetDataSet(strSql);
                    if (ds.Tables[0].Rows.Count > 0)
                    {
                        review_stage = Convert.ToString(ds.Tables[0].Rows[0][0]);
                    }
                    num = stage;
                }
                else if (code.StartsWith("USAN"))
                {
                    int stage = Convert.ToInt32(code.Replace("USAN", ""));
                    num1 = stage + 1;
                    strSql = string.Concat("SELECT case_status_id FROM i_case_status WHERE case_status_code = 'USAN", num1.ToString(), "'");
                    ds = sql_server_helper.GetDataSet(strSql); 
                    if (ds.Tables[0].Rows.Count > 0)
                    {
                        review_stage = Convert.ToString(ds.Tables[0].Rows[0][0]);
                    }
                    num = stage;
                }
                else if (!(country_id == "US") || "AF".Equals(Convert.ToString(ds.Tables[0].Rows[0][1])))
                {
                    num = -1;
                }
                else
                {
                    int stage = 0;
                    num1 = stage + 1;
                    strSql = string.Concat("SELECT case_status_id FROM i_case_status WHERE case_status_code = 'USAN", num1.ToString(), "'");
                    ds = sql_server_helper.GetDataSet(strSql); 
                    if (ds.Tables[0].Rows.Count > 0)
                    {
                        review_stage = Convert.ToString(ds.Tables[0].Rows[0][0]);
                    }
                    num = stage;
                }
            }
            catch
            {
                num = -1;
            }
            return num;
        }
    }
}