﻿using System;
using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;
using System.Web.Cors;
using System.Web.Http.Cors;

public class CorsHandle : Attribute, ICorsPolicyProvider
{
    private CorsPolicy objProlicy;

    public CorsHandle()
    {
        // 建立一個跨網域存取的原則物件
        objProlicy = new CorsPolicy
        {
            SupportsCredentials = true,
        };

        // 在這裡透過資料庫或是設定的方式，可動態加入允許存取的來源網域清單
        objProlicy.Origins.Add("http://120.78.73.107:8888");
        objProlicy.Origins.Add("http://120.78.73.107:8088");
        objProlicy.Origins.Add("https://ipeasy.purplevineip.com");
        objProlicy.Origins.Add("https://ipeasy.essenptl.com");
        objProlicy.Origins.Add("http://127.0.0.1");
        objProlicy.Origins.Add("http://localhost");
        objProlicy.Origins.Add("https://dev.essenptl.com");
        objProlicy.Origins.Add("https://ite.essenptl.com");

        objProlicy.Methods.Add("GET");
        objProlicy.Methods.Add("POST");
        objProlicy.Methods.Add("DELETE");
        objProlicy.Methods.Add("PUT");
        objProlicy.Methods.Add("OPTIONS");
        objProlicy.Methods.Add("HEAD");

        objProlicy.Headers.Add("Origin");
        objProlicy.Headers.Add("Content-Type");
        objProlicy.Headers.Add("X-Auth-Token");
    }

    public Task<CorsPolicy> GetCorsPolicyAsync(HttpRequestMessage request, CancellationToken cancellationToken)
    {
        return Task.FromResult(objProlicy);
    }
}