﻿using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Data;
using System.Linq;
using System.Net;
using System.Reflection;
using System.Text;
using System.Web;
using WebAPI.Models;

namespace WebAPI.Tool
{
    public class Common
    {
        static public DataTable LinqQueryToDataTable<T>(IEnumerable<T> query)
        {
            DataTable tbl = new DataTable();
            PropertyInfo[] props = null;
            foreach (T item in query)
            {
                if (props == null) //尚未初始化
                {
                    Type t = item.GetType();
                    props = t.GetProperties();
                    foreach (PropertyInfo pi in props)
                    {
                        Type colType = pi.PropertyType;
                        //針對Nullable<>特別處理
                        if (colType.IsGenericType
                            && colType.GetGenericTypeDefinition() == typeof(Nullable<>))
                            colType = colType.GetGenericArguments()[0];
                        //建立欄位
                        tbl.Columns.Add(pi.Name, colType);
                    }
                }
                DataRow row = tbl.NewRow();
                foreach (PropertyInfo pi in props)
                    row[pi.Name] = pi.GetValue(item, null) ?? DBNull.Value;
                tbl.Rows.Add(row);
            }
            return tbl;
        }

        public static Dictionary<string, object> objToDBInput(string type, object obj)
        {
            List<MySqlParameter> list = new List<MySqlParameter>();
            Dictionary<string, object> output = new Dictionary<string, object>();
            string colName = "";
            string colNameAt = "";
            string colInsert = "";

            foreach (var prop in obj.GetType().GetProperties())
            {
                var propName = prop.Name;
                var propValue = prop.GetValue(obj);
                bool isInput = true;
                if (propValue == null)
                {
                    isInput = false;
                }
                else
                {
                    if (propValue.GetType() == typeof(DateTime) && (DateTime)propValue == DateTime.MinValue)
                    {
                        isInput = false;
                    }
                }
                if (isInput)
                {
                    list.Add(new MySqlParameter("@" + propName, propValue));
                    colName += propName + ",";
                    colNameAt += "@" + propName + ",";
                    colInsert += propName + "=" + "@" + propName + ",";
                }
            }
            if (colName.Length > 0)
            {
                colName = colName.Substring(0, colName.Length - 1);
            }
            if (colNameAt.Length > 0)
            {
                colNameAt = colNameAt.Substring(0, colNameAt.Length - 1);
            }
            if (colInsert.Length > 0)
            {
                colInsert = colInsert.Substring(0, colInsert.Length - 1);
            }
            MySqlParameter[] parms = list.ToArray();
            if (type == "insert")
            {
                output["sql"] = "(" + colName + ") values(" + colNameAt + ")";
            }
            else if (type == "update")
            {
                output["sql"] = colInsert;
            }
            output["parms"] = parms;
            return output;
        }

        public static CommonResponseMsg post(string url, Dictionary<string, string> parameters)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                using (var client = new WebClient())
                {
                    var values = new NameValueCollection();
                    foreach (string key in parameters.Keys)
                    {
                        values[key] = parameters[key];
                    }

                    var response = client.UploadValues(url, values);
                    var responseString = Encoding.UTF8.GetString(response);
                    responseString = System.Text.RegularExpressions.Regex.Unescape(responseString);
                    result.Code = "1";
                    result.Msg = responseString;
                    return result;
                }
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
                return result;
            }
        }

        public static CommonResponseMsg post_json(string url, object parameters)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                using (WebClient webClient = new WebClient())
                {
                    // 指定 WebClient 編碼
                    webClient.Encoding = Encoding.UTF8;
                    // 指定 WebClient 的 Content-Type header
                    webClient.Headers.Add(HttpRequestHeader.ContentType, "application/json");
                    // 指定 WebClient 的 authorization header
                    //webClient.Headers.Add("authorization", "token {apitoken}");

                    // 將 data 轉為 json
                    string json = JsonConvert.SerializeObject(parameters);
                    // 執行 post 動作
                    var result_post = webClient.UploadString(url, json);
                    result.Code = "1";
                    result.Msg = result_post;
                    return result;
                }
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
                return result;
            }
        }

        public static List<object> objToList(Object obj)
        {
            return ((IEnumerable)obj).Cast<object>().ToList();
        }

        public static object isJTokenNull(JToken jToken, object output)
        {
            object result = jToken;
            if (jToken == null)
            {
                result = output;
            }
            else
            {
                if (jToken.Type == JTokenType.Null)
                {
                    result = output;
                }
            }
            return result;
        }
    }
}