﻿using ExcelDataReader;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web;
using System.Web.Http;
using System.Web.Http.Cors;
using WebAPI.Models;
using WebAPI.Tool;
using static WebAPI.Models.CommonModel;

namespace WebAPI.Controllers
{
    public class SubProcInfoController : ApiController
    {
        public SubProcInfoController()
        {
        }


        #region 獲取主管派點申請
        [Route("SubProcInfo/SuggestPoints")]
        [CorsHandle]
        [HttpGet]

        public HttpResponseMessage GetSuggestPoints(string id)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                if (string.IsNullOrWhiteSpace(id))
                {
                    response.Code = "0";
                    response.Msg = "no id";
                }
                else
                {
                    SqlServerHelper sql_server_helper = new SqlServerHelper();
                    DataTable dt = sql_server_helper.GetTable("select * FROM dbo.esn_OthData where oth_ID = '" + id + "'");
                    response.Code = "1";
                    response.Msg = dt;
                }
                
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        #region 更新主管派點申請
        [Route("SubProcInfo/SuggestPoints")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage UpdateProcInfo_post(ParamModel param)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            string input = param.Input.ToString();
            if (string.IsNullOrWhiteSpace((input)))
            {
                response.Code = "0";
                response.Msg = "no input";
            }
            else
            {
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    string id = Common.isJTokenNull(obj_input["oth_ID"], "").ToString();
                    if (string.IsNullOrWhiteSpace(id))
                    {
                        response.Code = "0";
                        response.Msg = "no id";
                    }
                    else
                    {
                        SqlServerHelper sql_server_helper = new SqlServerHelper();

                        if (obj_input.Count>0)
                        {
                            string sql = string.Format(@"UPDATE dbo.esn_OthData
                                                            SET FldValue = '{1}', FldMemo = '{2}', oth_Status = 'U', updateUser = '{3}', update_time = GETDATE()
                                                            WHERE oth_ID = '{0}';
    
                                                            IF(@@ROWCOUNT = 0)
                                                            BEGIN
                                                                INSERT INTO dbo.esn_OthData (oth_ID, FldName, FldValue, FldMemo, oth_Status, updateUser, update_time)
                                                                VALUES('{0}', 'SuggestPoints', '{1}', '{2}', 'I', '{3}', GETDATE())
                                                            END;", id, obj_input["FldValue"].ToString(), obj_input["FldMemo"].ToString(), obj_input["updateUser"].ToString());
                            //string sql = @"UPDATE dbo.p_proc_info SET " + string.Join(",", list_fields.ToArray()) + " where proc_id = '" + id + "'";
                            int updated_count = sql_server_helper.ExecuteSqlCommand(sql);
                            response.Code = "1";
                            response.Msg = updated_count;
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = "no input";
                        }
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = e.Message;
                }
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        
    }
}