﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using WebAPI.Models;
using WebAPI.Tool;

namespace WebAPI.Dal
{
    public class DalFee : Dal
    {
        public CommonResponseMsg GetFeeTypeByName(string field, string case_type_id, string business_type_id, string apply_type_id, string country_id, string fee_cate_workitem, string fc_cate, string fee_type_name)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.i_fee_type", field);
                sql += " where is_enabled = 1 and is_work_item = 1";
                if (!string.IsNullOrEmpty(case_type_id))
                {
                    sql += string.Format(@" and (concat(';',case_type_id,';') like '%;{0};%' or case_type_id = 'ALL')", case_type_id);
                }
                if (!string.IsNullOrEmpty(business_type_id))
                {
                    sql += string.Format(@" and (concat(';',business_type_id,';') like '%;{0};%' or business_type_id = 'ALL')", business_type_id);
                }
                if (!string.IsNullOrEmpty(apply_type_id))
                {
                    sql += string.Format(@" and (concat(';',apply_type_id,';') like '%;{0};%' or apply_type_id = 'ALL')", apply_type_id);
                }
                if (!string.IsNullOrEmpty(country_id))
                {
                    sql += string.Format(@" and (concat(';',country_id,';') like '%;{0};%' or country_id = 'ALL')", country_id);
                }
                if (!string.IsNullOrEmpty(fee_cate_workitem))
                {
                    sql += string.Format(@" and fee_cate_workitem = '{0}'", fee_cate_workitem);
                }
                if (!string.IsNullOrEmpty(fc_cate))
                {
                    sql += string.Format(@" and fc_cate_id = '{0}'", fc_cate);
                }
                if (!string.IsNullOrEmpty(fee_type_name))
                {
                    sql += string.Format(@" and (fee_type_zh_cn = '{0}' or fee_type_zh_tw = '{0}')", fee_type_name);
                }

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetFeeTypeByRule(string field, string case_type_id, string business_type_id, string apply_type_id, string country_id, string fee_cate_workitem, string fc_cate, string fee_type_name)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.i_fee_type", field);
                sql += " where is_enabled = 1 and is_work_item = 1";
                if (!string.IsNullOrEmpty(case_type_id) && case_type_id != "ALL")
                {
                    sql += string.Format(@" and (concat(';',case_type_id,';') like '%;{0};%' or case_type_id = 'ALL')", case_type_id);
                }
                if (!string.IsNullOrEmpty(business_type_id) && business_type_id != "ALL")
                {
                    sql += string.Format(@" and (concat(';',business_type_id,';') like '%;{0};%' or business_type_id = 'ALL')", business_type_id);
                }
                if (!string.IsNullOrEmpty(apply_type_id) && apply_type_id != "ALL")
                {
                    sql += string.Format(@" and (concat(';',apply_type_id,';') like '%;{0};%' or apply_type_id = 'ALL')", apply_type_id);
                }
                if (!string.IsNullOrEmpty(country_id) && country_id != "ALL")
                {
                    sql += string.Format(@" and (concat(';',country_id,';') like '%;{0};%' or country_id = 'ALL')", country_id);
                }
                if (!string.IsNullOrEmpty(fee_cate_workitem))
                {
                    sql += string.Format(@" and fee_cate_workitem = '{0}'", fee_cate_workitem);
                }
                if (!string.IsNullOrEmpty(fc_cate))
                {
                    sql += string.Format(@" and fc_cate_id = '{0}'", fc_cate);
                }
                if (!string.IsNullOrEmpty(fee_type_name))
                {
                    sql += string.Format(@" and (fee_type_zh_cn = '{0}' or fee_type_zh_tw = '{0}')", fee_type_name);
                }

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetProcFeeList(string field, string proc_id, string fee_type_id)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.p_proc_fee_list", field);
                sql += string.Format(" where proc_id = '{0}' and fee_type_id = '{1}'", proc_id, fee_type_id);
               
                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }
    }
}