﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Models.CommonModel;
using static WebAPI.Tool.Common;

namespace WebAPI.Controllers
{
    [RoutePrefix("Esn_Subitem")]
    public class Esn_Todos_FlowController : ApiController
    {
        public class Sns
        {
            public String todos_sn { get; set; }
            public String Flow_id { get; set; }
        }

        HttpResponseMessage result;
        CommonResponseMsg response;
        MessageList_ETF Outmsg;
        String connString ;

        public Esn_Todos_FlowController()
        {
            if (Outmsg == null) Outmsg = new MessageList_ETF();
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["eflow_cur"].ConnectionString;
        }


        /// <summary>
        /// 取得歷史明細
        /// </summary>
        /// <param name="Get_Flow_his"></param>
        /// <returns></returns>
        [Route("GetFlowSns")]
        [CorsHandle]
        [HttpPost]
        //[HttpGet]
        public HttpResponseMessage Get_Flow_Sns(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());

                List<Esn_Todos_FlowModel> Hislist = new List<Esn_Todos_FlowModel>();
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        Esn_Todos_FlowModel hisT = new Esn_Todos_FlowModel();
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @" select a.ConfirmTime
                            ,Case When a.ConfirmUserClass='PG' Then '程序' When a.ConfirmUserClass='PE' Then '承辦人'  When a.ConfirmUserClass='Leader' Then '主管' else '其他' End as ConfirmUserClass
                            ,Case When a.ConfirmMethod='CF' Then '確認' When a.ConfirmMethod='RJ' Then '退回'  When a.ConfirmMethod='RV' Then '撤回'  else '其他' End  as ConfirmMethod
                            ,a.Create_time,d.cn_name as Create_User_Name,b.Step_Text as ""From"",c.Step_Text as ""To"",a.Description
                            from esn_Todos_flow_his a
                            left join esn_todos_Flow_StepType b on a.FromType_id = b.id
                            left join esn_todos_Flow_StepType c on a.ToType_id = c.id
                            left join evw_Employee d  on a.Create_User_id = d.user_id
                            where a.Flow_id = @Flow_id
                    "
                        };
                        cmd.Parameters.AddWithValue("@Flow_id", obj_input["Flowid"].ToString());
                        DataSet ds = SqlToDs(cmd);
                        DateTime? ConfirmTime;
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            ConfirmTime = (DateTime?)dr["ConfirmTime"];
                            hisT = new Esn_Todos_FlowModel()
                            {

                                ConfirmTime = ConfirmTime,
                                ConfirmUserClass = dr["ConfirmUserClass"].ToString(),
                                ConfirmMethod = dr["ConfirmMethod"].ToString(),
                                Create_User_Name = dr["Create_User_Name"].ToString(),
                                From = dr["From"].ToString(),
                                To = dr["To"].ToString(),
                                Description = dr["Description"].ToString()
                            };
                            Hislist.Add(hisT);
                            //Hislist.OrderByDescending(p => p.ConfirmTime);
                        }
                    }

                    response.Code = "1";
                    response.Msg = Hislist;
                    result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                }
                catch (Exception e)
                {

                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        /// <summary>
        /// 取得歷史明細
        /// </summary>
        /// <param name="Get_Flow_his"></param>
        /// <returns></returns>
        [Route("GetFlowHis")]
        [CorsHandle]
        [HttpPost]
        //[HttpGet]
        public HttpResponseMessage Get_Flow_his(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());

                List<Esn_Todos_FlowModel> Hislist = new List<Esn_Todos_FlowModel>();
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        Esn_Todos_FlowModel hisT = new Esn_Todos_FlowModel();
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @" select a.ConfirmTime
                            ,Case When a.ConfirmUserClass='PG' Then '程序' When a.ConfirmUserClass='PE' Then '承辦人'  When a.ConfirmUserClass='Leader' Then '主管' else '其他' End as ConfirmUserClass
                            ,Case When a.ConfirmMethod='CF' Then '確認' When a.ConfirmMethod='RJ' Then '退回'  When a.ConfirmMethod='RV' Then '撤回'  else '其他' End  as ConfirmMethod
                            ,a.Create_time,d.cn_name as Create_User_Name,b.Step_Text as ""From"",c.Step_Text as ""To"",a.Description
                            from esn_Todos_flow_his a
                            left join esn_todos_Flow_StepType b on a.FromType_id = b.id
                            left join esn_todos_Flow_StepType c on a.ToType_id = c.id
                            left join evw_Employee d  on a.Create_User_id = d.user_id
                            where a.Flow_id = @Flow_id
                    "
                        };
                        cmd.Parameters.AddWithValue("@Flow_id", obj_input["Flowid"].ToString());
                        DataSet ds = SqlToDs(cmd);
                        DateTime? ConfirmTime;
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            ConfirmTime = (DateTime?)dr["ConfirmTime"];
                            hisT = new Esn_Todos_FlowModel()
                            {

                                ConfirmTime = ConfirmTime,
                                ConfirmUserClass = dr["ConfirmUserClass"].ToString(),
                                ConfirmMethod = dr["ConfirmMethod"].ToString(),
                                Create_User_Name = dr["Create_User_Name"].ToString(),
                                From = dr["From"].ToString(),
                                To = dr["To"].ToString(),
                                Description = dr["Description"].ToString()
                            };
                            Hislist.Add(hisT);
                            //Hislist.OrderByDescending(p => p.ConfirmTime);
                        }
                    }

                    response.Code = "1";
                    response.Msg = Hislist;
                    result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                }
                catch (Exception e)
                {

                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        /// <summary>
        /// 取得EHR匯出歷史
        /// </summary>
        /// <param name="Get_ehr_his"></param>
        /// <returns></returns>
        [Route("GetExportEHRhis")]
        [CorsHandle]
        [HttpPost]
        //[HttpGet]
        public HttpResponseMessage Get_ExportEHR_his(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());

                try
                {
                    List<ExportEHR_hisModel> Hislist = new List<ExportEHR_hisModel>();
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        ExportEHR_hisModel hisT ;
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"select b.cn_name, a.* from esn_todos_SettleLog a 
                                            left join s_user_info b on a.Create_user_id=b.user_id   
                                            where a.Create_user_id=@Create_user_id "
                        };
                        cmd.Parameters.AddWithValue("@Create_user_id", obj_input["gUserID_wade"].ToString());
                        DataSet ds = SqlToDs(cmd);
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            hisT = new ExportEHR_hisModel()
                            {
                                id = (int)dr["id"],
                                SaveData = dr["SaveData"].ToString(),
                                update_time =(DateTime?) dr["update_time"] ,
                                update_user_id = dr["update_user_id"].ToString(),
                                Create_time = (DateTime?)dr["Create_time"],
                                Create_user_id = dr["Create_user_id"].ToString(),
                                cn_name = dr["cn_name"].ToString(),
                            };
                            Hislist.Add(hisT);
                        }
                    }

                    response.Code = "1";
                    response.Msg = Hislist;
                    result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                }
                catch (Exception e)
                {

                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        /// <summary>
        /// 取得EHR匯出歷史
        /// </summary>
        /// <param name="Get_ehr_his"></param>
        /// <returns></returns>
        [Route("GetExportEHRhis_Detail")]
        [CorsHandle]
        [HttpPost]
        //[HttpGet]
        public HttpResponseMessage Get_ExportEHR_hisDetail(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());

                try
                {
                    List<ExportEHR_hisModel> Hislist = new List<ExportEHR_hisModel>();
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        ExportEHR_hisModel hisT;
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"select b.cn_name, a.* from esn_todos_SettleLog a 
                                            left join s_user_info b on a.Create_user_id=b.user_id   
                                            where a.Create_user_id=@Create_user_id "
                        };
                        cmd.Parameters.AddWithValue("@Create_user_id", obj_input["gUserID_wade"].ToString());
                        DataSet ds = SqlToDs(cmd);
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            hisT = new ExportEHR_hisModel()
                            {
                                id = (int)dr["id"],
                                SaveData = dr["SaveData"].ToString(),
                                update_time = (DateTime?)dr["update_time"],
                                update_user_id = dr["update_user_id"].ToString(),
                                Create_time = (DateTime?)dr["Create_time"],
                                Create_user_id = dr["Create_user_id"].ToString(),
                                cn_name = dr["cn_name"].ToString(),
                            };
                            Hislist.Add(hisT);
                        }
                    }

                    response.Code = "1";
                    response.Msg = Hislist;
                    result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                }
                catch (Exception e)
                {

                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        [Route("SaveEsnTodosFlow")]
        [CorsHandle]
        [HttpPost]
        [HttpGet]
        public HttpResponseMessage Save_Esn_Todos_Flow(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {

                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        int IsConfirm;
                        List<String> return_msgs = new List<string>(), return_msg_error = new List<string>()
                            , Confirm_Class = new List<string>();
                        List<Esn_Todos_Flow_StepTypeModel> AllStepType = new List<Esn_Todos_Flow_StepTypeModel>();
                        String return_msg, Confirm_Method = obj_input["Confirm_Method"].ToString();
                        switch (Confirm_Method)
                        {
                            case "CF":
                                IsConfirm = 1; return_msg = "確認完成"; break;
                            case "RV":
                                IsConfirm = 0; return_msg = ""; break;
                            case "RJ":
                                IsConfirm = 0; return_msg = "已退回"; break;
                            case "RJOp":
                                IsConfirm = 0; return_msg = "已退至運營辦"; break;
                            default:
                                IsConfirm = 0; return_msg = "已退回"; break;
                        }
                        SqlCommand cmd = new SqlCommand("", Conn);
                        DataSet ds;
                        #region 取得Flow驗證身分
                        cmd.CommandText = @"select * from esn_todos_Flow_StepType a";
                        ds = SqlToDs(cmd);
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            AllStepType.Add(new Esn_Todos_Flow_StepTypeModel()
                            {
                                id = Convert.ToInt32(dr["id"]),
                                update_time = Convert.ToDateTime(dr["update_time"]),
                                Map_Class = dr["Map_Class"].ToString(),
                                Step_Text = dr["Step_Text"].ToString(),
                                Step_Value_Next = dr["Step_Value_Next"].ToString(),
                                Step_Value = dr["Step_Value"].ToString(),
                                Step_Value_previous = dr["Step_Value_previous"].ToString(),
                                update_user_id = dr["update_user_id"].ToString()
                            }
                            );
                        }
                        #endregion

                        #region 取得該員身分
                        cmd.CommandText = @"select * from evw_Employee a
                                            where a.user_id= @user_id 　and a.is_enabled=1 and isnull(Emp_LeaveDate,'')=''";
                        cmd.Parameters.AddWithValue("@user_id", obj_input["Wade_User_ID"].ToString());
                        //cmd.Parameters.AddWithValue("@user_id", "FD67D192-041B-4725-A3E1-CB5E62A5CC61");//test

                        ds = SqlToDs(cmd);

                        Confirm_Class.Add("PE");//預設有承辦人
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            if (dr["is_programmer"].ToString() == "1") Confirm_Class.Add("PG");
                            if (dr["is_dept_manager"].ToString() == "1") Confirm_Class.Add("Leader");
                        }
                        #endregion
                        //Confirm_Class.Add("PG"); Confirm_Class.Add("Leader"); //test 
                        #region 取得FLOW相關
                        cmd.CommandText = @"select　et.*,etf.id AS Flowid,etf.*,
                            etfs.* FROM esn_todos et 
                            left join esn_todos_Flow etf on et.sn=etf.esn_todos_sn
                            left join esn_todos_Flow_StepType etfs on etfs.id=etf.StepType_id
                                                        where et.sn in(@Esn_Todos_Sn)

                          ";

                        List<Sns> items = JsonConvert.DeserializeObject<List<Sns>>(obj_input["Sns"].ToString());
                        var parameters = new string[items.Count];
                        cmd.Parameters.Clear();
                        for (int i = 0; i < items.Count; i++)
                        {
                            parameters[i] = string.Format("@Esn_Todos_Sn_{0}", i);
                            cmd.Parameters.AddWithValue(parameters[i], items[i].todos_sn);
                        }
                        cmd.CommandText = cmd.CommandText.Replace("@Esn_Todos_Sn", string.Format(string.Join(",", parameters)));
                        ds = SqlToDs(cmd);
                        #endregion

                        String Wade_User_ID = obj_input["Wade_User_ID"].ToString(), Reject_Description = obj_input["Reject_Description"].ToString(),
                            date0 = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"), Tsql = "",RJOp="";

                        JToken JtSn;
                        //List<String> sql = new List<string>();
                        int StepType_id_Previous, StepType_id, StepType_idHis;
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            RJOp = "";
                            StepType_id_Previous = dr["StepType_id_Previous"] == DBNull.Value ? 0 : Convert.ToInt32(dr["StepType_id_Previous"]);
                            //StepType_id_next = Convert.ToInt32(dr["StepType_id_next"]);
                            StepType_id = dr["StepType_id"] == DBNull.Value ? 0 : Convert.ToInt32(dr["StepType_id"]);
                            Esn_Todos_Flow_StepTypeModel CStepTypeNext = new Esn_Todos_Flow_StepTypeModel(), CStepTypeCur = new Esn_Todos_Flow_StepTypeModel();
                            JtSn = obj_input.SelectToken("$.Sns[?(@.todos_sn == '" + dr["Sn"] + "')]");
                            if (dr["esn_todos_sn"] == DBNull.Value) //insert
                            {
                                CStepTypeCur = AllStepType.Where(p => p.Map_Class.Contains(JtSn["validclass"].ToString())).FirstOrDefault();

                                StepType_idHis = CStepTypeCur.id;
                                CStepTypeNext = AllStepType.Where(p => p.Map_Class.Contains("PE")).FirstOrDefault();
                                //CStepTypeCur = CStepTypeNext;
                                Tsql = @"insert into esn_todos_Flow(esn_todos_sn,[StepType_id],[" + CStepTypeCur.Map_Class
                                     + @"_IsConfirm],StepType_id_Previous,Description,[create_user_id],[Create_time],update_user_id,update_time) "
                                     + " OUTPUT Inserted.id into @TempTable "
                                     + " values (" + dr["sn"] + ",'" + CStepTypeNext.id + "'," + IsConfirm + ",'" + 1
                                     + "',@Reject_Description,@Wade_User_ID,'" + date0 + "'" + ",@Wade_User_ID,'" + date0 + "'" + "); "
                                     ;
                            }
                            else //update
                            {
                                String Map_Class = dr["Map_Class"].ToString();
                                #region 驗證  
                                //if (Map_Class != JtSn["validclass"].ToString())
                                //{
                                //    return_msg_error.Add(dr["esn_todos_sn"] + ":該流程已異動, 不可變更");
                                //}

                                #endregion
                                CStepTypeCur = AllStepType.Where(p => p.id == StepType_id).FirstOrDefault();
                                CStepTypeNext = AllStepType.Where(p => p.Step_Value == CStepTypeCur.Step_Value_Next).FirstOrDefault();
                                String Step_Value_previous = dr["Step_Value_previous"].ToString(), Step_Value_Next = dr["Step_Value_Next"].ToString();
                                Tsql = Tsql + "update esn_todos_Flow set ";

                                //確認是否有審核資格
                                if (Confirm_Method == "CF")
                                {
                                    if (!Confirm_Class.Contains(Map_Class))
                                    {
                                        //return_msg_error.Add(dr["esn_todos_sn"] + ":無可審核該筆身分");
                                    }
                                    if (int.Parse(CStepTypeCur.Step_Value) > 90)
                                    {
                                        return_msg_error.Add(dr["esn_todos_sn"] + ":審核流程已結束,不可確認");
                                    }
                                }

                                if (Confirm_Method == "RJ")
                                {
                                    Tsql = Tsql + "PG_IsConfirm =" + IsConfirm + "," + "PE_IsConfirm =" + IsConfirm + "," + "Leader_IsConfirm =" + IsConfirm + ","; //退回後,改為更新所有Flow狀態確認
                                    CStepTypeNext = AllStepType.Where(p => p.Step_Value == Step_Value_previous).FirstOrDefault();
                                    StepType_idHis = CStepTypeCur.id;
                                }
                                else if (Confirm_Method == "RV")
                                {
                                    StepType_idHis = CStepTypeCur.id;
                                    CStepTypeNext = AllStepType.Where(p => p.id == StepType_id_Previous).FirstOrDefault();
                                    CStepTypeCur.id = CStepTypeNext.id; //回復與下一步 同ID
                                    Tsql = Tsql + CStepTypeNext.Map_Class + "_IsConfirm =" + IsConfirm + ",";
                                }
                                else if (Confirm_Method == "RJOp")
                                {
                                    Tsql = Tsql + "PG_IsConfirm =" + IsConfirm + "," + "PE_IsConfirm =" + IsConfirm + "," + "Leader_IsConfirm =" + IsConfirm + ","; //退回後,改為更新所有Flow狀態確認
                                    CStepTypeNext = AllStepType.Where(p => p.Step_Value == Step_Value_previous).FirstOrDefault();
                                    StepType_idHis = CStepTypeCur.id;
                                    RJOp= @"exec [dbo].esp_esn_Todos_V3_AssignStatus 'FlowAS01' ," + dr["sn"] + @",'',@Reject_Description,@Wade_User_ID";
                                    
                                }
                                else
                                {
                                    Tsql = Tsql + CStepTypeCur.Map_Class + "_IsConfirm =" + IsConfirm + ",";
                                    StepType_idHis = CStepTypeCur.id;
                                }
                                Tsql = Tsql + " StepType_id = '" + CStepTypeNext.id + "',StepType_id_Previous = '" + CStepTypeCur.id +
                                    "',Description = @Reject_Description,update_user_id=@Wade_User_ID,update_time='" + date0 + "' "
                                    + " output Inserted.id  into @TempTable where id =" + dr["Flowid"] + ";"
                                    ;
                            }

                            Tsql += @"select @FlowId=id from @TempTable;
                                    insert into esn_todos_Flow_his  (Flow_id,ConfirmTime,FromType_id,ToType_id,ConfirmUserId,ConfirmUserClass,ConfirmMethod,Description,Create_User_id,Create_time) "
                                    + " values (@FlowId,'" + date0 + "','" + StepType_idHis + "','" + CStepTypeNext.id + "',@Wade_User_ID,'" + CStepTypeCur.Map_Class + "','" + Confirm_Method + "',@Reject_Description,@Wade_User_ID,'" + date0 + "'" + ") ;";
                            Tsql += RJOp;
                           cmd.Parameters.AddWithValue("@Reject_Description", Reject_Description);
                            cmd.Parameters.AddWithValue("@Wade_User_ID", Wade_User_ID);
                        }

                        cmd.CommandText = @"declare  @TempTable TABLE(id INT) 
                                            declare @FlowId int " + Tsql;

                        return_msgs.Add(return_msg);
                        if (return_msg_error.Count == 0)
                        {
                            DataTable dt = SqlToDt(cmd);
                            response.Code = "1";
                            response.Msg = return_msgs;
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = return_msg_error;
                        }
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }


        [Route("SavePointSettlementLog")]
        [CorsHandle]
        [HttpPost]
        [HttpGet]
        public HttpResponseMessage Save_PointSettlement_Log(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                try
                {
                    JObject obj_input = JObject.Parse(input.ToString());
                    JArray obj_input_data= JArray.Parse(obj_input["SaveData"].ToString());

                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"Insert into esn_todos_SettleLog([SaveData],[Country],[update_time],[update_user_id],Create_time,Create_user_id)
                            values(@SaveData,@Country,getdate(),@gUserID_wade,getdate(),@gUserID_wade)"
                        };
                        cmd.Parameters.AddWithValue("@SaveData", obj_input["SaveData"].ToString());
                        cmd.Parameters.AddWithValue("@gUserID_wade", obj_input["gUserID_wade"].ToString());
                        cmd.Parameters.AddWithValue("@Country", obj_input["Country"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        response.Code = "1";
                        response.Msg = "匯出完畢";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
    }

}
