﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Web.Http;
using System.Web.Http.Cors;
using WebAPI.Models;
using static WebAPI.Models.CommonModel;
using static WebAPI.Tool.Common;

namespace WebAPI.Controllers
{
    [RoutePrefix("Esn_Subitem")]
    public class Esn_Todos_FlowController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response  ;
        MessageList_ETF Outmsg;
        public Esn_Todos_FlowController()
        {
            if (Outmsg == null) Outmsg = new MessageList_ETF();
             result = new HttpResponseMessage(HttpStatusCode.OK);
             response = new CommonResponseMsg();
        }

        /// <summary>
        /// 取得歷史明細
        /// </summary>
        /// <param name="Get_Flow_his"></param>
        /// <returns></returns>
        [Route("GetFlowHis")]
        [CorsHandle]
        [HttpPost]
        //[HttpGet]
        public HttpResponseMessage Get_Flow_his(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                String connString = ConfigurationManager.ConnectionStrings["eflow_cur"].ConnectionString;
                JObject obj_input = JObject.Parse(input.ToString());

                List<Esn_Todos_FlowModel> Hislist = new List<Esn_Todos_FlowModel>();
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        Esn_Todos_FlowModel hisT = new Esn_Todos_FlowModel();
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @" select top 100 a.ConfirmTime
                        ,Case When a.ConfirmUserClass='PG' Then '程序' When a.ConfirmUserClass='PE' Then '承辦人'  When a.ConfirmUserClass='Leader' Then '主管' else '其他' End as ConfirmUserClass
                        ,Case When a.ConfirmMethod='CF' Then '確認' When a.ConfirmMethod='RJ' Then '退回'  When a.ConfirmMethod='RV' Then '撤回'  else '其他' End  as ConfirmMethod
                        ,a.Create_time,d.cn_name as Create_User_Name,b.Step_Text as ""From"",c.Step_Text as ""To"",a.Description
                        from esn_Todos_flow_his a
                        left join esn_todos_Flow_StepType b on a.FromType_id = b.id
                        left join esn_todos_Flow_StepType c on a.ToType_id = c.id
                        left join evw_Employee d  on a.Create_User_id = d.user_id
                        where a.Flow_id = @Flow_id
                        order by ConfirmTime desc
                    "
                        };
                        cmd.Parameters.AddWithValue("@Flow_id", obj_input["Flowid"].ToString());
                        DataSet ds = SqlToDs(cmd);
                        DateTime? ConfirmTime;
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            ConfirmTime = (DateTime?)dr["ConfirmTime"];
                            hisT = new Esn_Todos_FlowModel()
                            {

                                ConfirmTime = ConfirmTime,
                                ConfirmUserClass = dr["ConfirmUserClass"].ToString(),
                                ConfirmMethod = dr["ConfirmMethod"].ToString(),
                                Create_User_Name = dr["Create_User_Name"].ToString(),
                                From = dr["From"].ToString(),
                                To = dr["To"].ToString(),
                                Description = dr["Description"].ToString()
                            };
                            Hislist.Add(hisT);
                        }
                    }

                    response.Code = "1";
                    response.Msg = Hislist;
                    result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                }
                catch (Exception e)
                {

                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
    }
}
