﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.IO;
using System.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Tool.Common;
namespace WebAPI.Controllers
{
    [RoutePrefix("Esn_Subitem")]
    public class Esn_todosController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public Esn_todosController()
        {
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["DefaultConnection"].ConnectionString;
        }
        /// <summary>
        /// 取得歷史明細
        /// </summary>
        /// <param name="Get_cur_his_id"></param>
        /// <returns></returns> 
        /// 
        [Route("show_sub_todos_data")]
        [HttpPost]
        public HttpResponseMessage show_sub_todos_data(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        ;
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @";with didata as (
	                            SELECT badge, CASE  WHEN b.text_zh_tw IN ('台北','台中' ,'高雄' ) THEN 'TW'  ELSE 'CN'  END AS dico
			                            FROM ehr_employee a
			                            LEFT JOIN ehr_dictionary b ON a.EmpCustom1 = b.value  AND b.dictionary_name = 'eCD_EmpCustom1' AND b.is_enabled = 1 
                            ),todosData as(
                            SELECT DISTINCT td.*, tds.date_points_settlement, tds.date_points_settlement_pic_confirm
			                            FROM (
				                            SELECT DISTINCT td.SN, case_id, finishedDate AS finish_date, CustDueDate, LegalDueDate AS legal_due_date, todosStatus_name AS todos_status_name, taskDescription AS taskName, assignedTo_userID, AssignStatus_name, Points, proc_id, matter_name
				                            FROM esn_Todos td
				                            WHERE td.SN IN (@SN)
				                            ) td
			                            LEFT JOIN esn_todos_points tds ON tds.sn = td.sn
                            ),Otherjoin as(
	                            SELECT   DISTINCT t11.*, ci1.country_id, ci1.case_volume, ci1.case_name, fui.cn_name AS fcn_name, CASE 
				                            WHEN isnull(fui.main_email, '') = ''  THEN fui.email  ELSE fui.main_email
				                            END AS fmain_email, ci1.flow_user_id, apply_type_zh_tw, business_type_zh_tw, c1.customer_name, etf.id AS Flow_id, etf.StepType_id, etf.PE_IsConfirm, 
				                            etf.PG_IsConfirm, etf.Leader_IsConfirm, etf.Description, etf.StepType_id_Previous, etfs.Map_Class, etfs.id AS Map_Class_StepType_id, 
				                            etf.Is_Settlement, etfs.Step_Value, etf.update_user_id, etab.points_tobe, au.main_email, au.director_email, au.director_name, 
				                            isnull(au.cn_name, ' ') AS cn_name, eqeau.Emp_DSContury AS auco, eqefui.Emp_DSContury AS fuico
				                            --,(select dico from CTE1 where badge=au.director_badge ) as  dico
                                            ,isnull(cp3.ctrl_proc_zh_tw,('[IPS:' + matter_name + ']')) as TaskL1Name
				                            , dico
		                            FROM todosData t11
		                            LEFT JOIN evw_p_case_info ci1 ON t11.case_id = ci1.case_id
		                            LEFT JOIN c_customer c1 ON c1.customer_id = ci1.customer_id
		                            LEFT JOIN esn_todos_Flow etf ON etf.esn_todos_sn = t11.sn
		                            LEFT JOIN esn_todos_Flow_his etfh ON etf.id = etfh.Flow_id
		                            LEFT JOIN esn_todos_Flow_StepType etfs ON etf.StepType_id = etfs.id
		                            LEFT JOIN esn_Todos_auto_points etab ON etab.sn = t11.sn
		                            LEFT JOIN evw_Employee fui ON fui.user_id = ci1.flow_user_id
		                            LEFT JOIN evw_Employee au ON t11.AssignedTo_userid = au.user_id
		                            LEFT JOIN didata di ON au.director_badge = di.badge
		                            LEFT JOIN evw_qResult_EmpDS eqefui ON eqefui.Emp_DSNum = fui.Emp_DSNum
		                            LEFT JOIN evw_qResult_EmpDS eqeau ON eqeau.Emp_DSNum = au.Emp_DSNum
                                    LEFT JOIN p_proc_info pc3 ON pc3.proc_id = t11.proc_id
                                    LEFT JOIN i_ctrl_proc cp3 ON pc3.ctrl_proc_id = cp3.ctrl_proc_id
                            )
                            SELECT SN AS attr_SN, 'caseNo' AS class_1, case_id AS attr_case_id, case_volume AS attr_caseNo, case_volume AS 案件編號, ('' + country_id + '') AS '國家', 'tdTitle' AS class_1
                            , ('' + case_name + '/' + customer_name + '' ) AS '案件名稱/客戶名稱', 'LL' AS class_applyType, apply_type_zh_tw AS '申請類型', 'LL' AS class_todo
                            , ('' + TaskL1Name + '/' + taskName + '') AS '處理事項/子事項', 'LL' AS class_status, todos_status_name AS '子事項狀態', director_email AS attr_directoremail,
                            cast(director_name AS NVARCHAR(100)) AS attr_directorname, main_email AS attr_mainemail, assignedTo_userID AS attr_userID, auco AS attr_auco, 
                            dico AS attr_dico, ('' + cast(cn_name AS NVARCHAR(100)) + '') AS 承辦人員, flow_user_id AS attr_flowuserid, fmain_email AS attr_fmainemail, fuico AS attr_fuico, 
                            cast(fcn_name AS NVARCHAR(100)) AS 流程人員, ('' + convert(VARCHAR, legal_due_date, 23) + '') AS '官方期限', finish_date AS 完成日, CustDueDate AS 客戶期限, 
                            'tdr' AS class_1, Points AS 系統派點, 'LL' AS class_assignStatus, AssignStatus_name AS '指派狀態', 'tdr' AS class_1, 'date_points_settlement' AS class_2, 
                            date_points_settlement AS 提成確認日, Flow_id AS attr_Flowid, isnull(Map_Class, 'NF') AS attr_MapClass, StepType_id_Previous AS attr_StepTypeidPrevious, 
                            Is_Settlement AS attr_IsSettlement, update_user_id AS attr_updateuserid, isnull(Step_Value, '0') AS 目前審核流程
                            , 'checkbox2' AS attr_type, 'Field_PG' AS class_c1, (CASE  WHEN PG_IsConfirm = 1 THEN 1 ELSE NULL END ) AS 程序已確認
                            , 'checkbox2' AS attr_type, 'Field_PE' AS class_c2, (CASE WHEN PE_IsConfirm = 1 THEN 1 ELSE NULL END ) AS 承辦人已確認
                            , 'checkbox2' AS attr_type, 'Field_Leader' AS class_c3, (CASE WHEN Leader_IsConfirm = 1 THEN 1 ELSE NULL END ) AS 主管已確認
                            , Description AS 退回原因
                           	From Otherjoin
                            "
                        };
                        cmd.Parameters.AddWithValue("@SN", obj_input["SN"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        response.Code = "1";
                        response.Msg = "匯出完畢";

                        response.Code = "1";
                        string JSONString = string.Empty;
                        JSONString = JsonConvert.SerializeObject(dt);
                        response.Msg = JSONString;
                        result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        [Route("UpdateDatePointsSettlement")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Update_date_points_settlement(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {

                        String sns = obj_input["SN"].ToString();
                        String sqlstr = @"select td.SN, tdp.SN as SN_tdp,td.points,AssignedTo_userid,tdp.date_points_settlement,td.TaskDescription,etfs.Map_Class,td.CaseNo,etfs.Step_Text ,eel.*   FROM esn_todos td 
                                          left join esn_todos_points tdp on tdp.sn=td.sn
                                          left join evw_Employee eel on eel.user_id=td.AssignedTo_userid
                                          left join esn_todos_Flow etf on etf.esn_todos_sn=td.sn
										  left join esn_todos_Flow_StepType etfs on etfs.id=etf.StepType_id
                                          WHERE td.sn in (" + sns + ")";
                        String value = obj_input["value"].ToString();
                        value = value == "" ? "null" : obj_input["value"].ToString();
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = sqlstr
                        };
                        cmd.Parameters.AddWithValue("@SN", obj_input["SN"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        cmd.CommandText = @" select ets.* from esn_todos_Settle ets
											left join evw_qResult_EmpDS eqe on ets.DSNum=eqe.Emp_DSNum";
                        DataTable dtSettle = SqlToDt(cmd);
                        List<Esn_todos_SettleModel> SettleMataData = new List<Esn_todos_SettleModel>();
                        foreach (DataRow drs in dtSettle.Rows)
                        {
                            Esn_todos_SettleModel etsm = new Esn_todos_SettleModel()
                            {
                                Settle_Date = Convert.ToDateTime(drs["Settle_Date"]),
                                Create_time = Convert.ToDateTime(drs["Create_time"]),
                                update_time = Convert.ToDateTime(drs["update_time"]),
                                Create_user_id = drs["Create_user_id"].ToString(),
                                DeptNum = drs["DeptNum"].ToString(),
                                DSNum = drs["DSNum"].ToString(),
                                ItemNum = drs["ItemNum"].ToString(),
                                update_user_id = drs["update_user_id"].ToString(),
                                isClosed = Convert.ToBoolean(drs["isClosed"])
                            };
                            SettleMataData.Add(etsm);
                        }
                        String sqldeclare;int batchcount = 100;
                        String point, AssignedTo_userID, Emp_DSNum, TaskDescription, CaseNo, Map_Class, SN;
                        DateTime date_points_settlement;
                        DataRow dr;
                        List<String> return_msgs = new List<string>(), return_msg_error = new List<string>(), return_sn = new List<string>();
                        sqldeclare = "declare  @TempTable TABLE(id INT) declare @FlowId int; ";
                        cmd.Parameters.Clear(); sqlstr = "";
                        List<String> batchSql = new List<string>(); 
                        for (int i = 0; i < dt.Rows.Count; i++)
                        {
                            dr = dt.Rows[i];
                            point = dr["points"].ToString();

                            date_points_settlement = dr["date_points_settlement"] == DBNull.Value ? Convert.ToDateTime("1900-01-01") : Convert.ToDateTime(dr["date_points_settlement"]);
                            Emp_DSNum = dr["Emp_DSNum"].ToString();
                            TaskDescription = dr["TaskDescription"].ToString();
                            CaseNo = dr["CaseNo"].ToString();
                            Map_Class = dr["Map_Class"].ToString();
                            AssignedTo_userID = dr["AssignedTo_userID"].ToString();

                            #region 邏輯比對
                                #region 關帳
                                Esn_todos_SettleModel etsm = SettleMataData.Where(a => (a.Settle_Date.ToString("yyyyMM").Equals(date_points_settlement.ToString("yyyyMM"))
                                                                                           ) && a.DSNum == Emp_DSNum && a.isClosed == true).FirstOrDefault(),
                                                          etsm2 = SettleMataData.Where(a => (a.Settle_Date.ToString("yyyyMM").Equals(Convert.ToDateTime(value).ToString("yyyyMM"))
                                                               ) && a.DSNum == Emp_DSNum && a.isClosed == true).FirstOrDefault();
                                String etsmmsg = "承辦人:<font color='blue'> " + dr["cn_name"].ToString() + " </font> 案件編號: <font color='blue'>" + CaseNo + " </font>子事項:<font color='blue'>" + TaskDescription+ "</font>";
                                if (etsm != null)
                                {
                                    return_msg_error.Add(etsmmsg + date_points_settlement.ToString("yyyy年MM月 ").ToString() + " 已關帳,不可變更<br>");
                                    continue;
                                }
                                else if (etsm2 != null)
                                {
                                    return_msg_error.Add(etsmmsg + Convert.ToDateTime(value).ToString("yyyy年MM月 ").ToString() + " 已關帳,不可結算<br>");
                                    continue;
                                }
                            #endregion
                            #region 程序不可結算
                            if (Map_Class == "PG" || Map_Class == "RJTOp" || Map_Class == "AMTCC" || Map_Class == "AMTOp")
                            {
                                return_msg_error.Add(etsmmsg + "在 " +dr["Step_Text"].ToString() + " 步驟,不可結算<br>");
                                continue;
                            }
                            #endregion
                            #endregion
                            SN = dr["SN"].ToString();
                            if (dr["SN_tdp"] == DBNull.Value)
                            {
                                //sqlstr += string.Format(@"insert into esn_todos_points(sn,date_points_settlement,date_points_settlement_AssignTo,date_points_settlement_Point,update_user_id,update_time) 
                                //            values (@SN{0},@value,@AssignedTo_userID{0},@points{0},@gWadeID,getdate()); ", i);
                                sqlstr += string.Format(@"insert into esn_todos_points(sn,date_points_settlement,date_points_settlement_AssignTo,date_points_settlement_Point,update_user_id,update_time) 
                                            values ({0},@value,'{1}',{2},@gWadeID,getdate()); ", SN, AssignedTo_userID, point);
                            }
                            else
                            {
                                //sqlstr += string.Format(@"update esn_todos_points set date_points_settlement=@value,date_points_settlement_AssignTo=@AssignedTo_userID{0}
                                //            ,date_points_settlement_Point=@points{0} ,update_user_id=@gWadeID,Update_time=GETDATE() where SN =@SN{0};", i);
                                sqlstr += string.Format(@"update esn_todos_points set date_points_settlement=@value,date_points_settlement_AssignTo='{1}'
                                            ,date_points_settlement_Point='{2}' ,update_user_id=@gWadeID,Update_time=GETDATE() where SN ={0};", SN, AssignedTo_userID, point);
                            }
                            //cmd.Parameters.AddWithValue(string.Format("@SN{0}", i), dr["SN"].ToString());
                            //cmd.Parameters.AddWithValue(string.Format("@AssignedTo_userID{0}", i), AssignedTo_userID);
                            //cmd.Parameters.AddWithValue(string.Format("@points{0}", i), point);

                            //sqlstr += string.Format(@"update esn_todos_Flow Set Is_Settlement = 1,update_user_id = @gWadeID,Update_time = GETDATE(),StepType_id_Previous=StepType_id
                            //            ,StepType_id =(select id from esn_todos_Flow_StepType a where a.Map_Class='HR') output INSERTED.id INTO @TempTable where esn_todos_sn =@SN{0};
                            //            select @FlowId=id from @TempTable;
                            //           insert into esn_todos_Flow_his(Flow_id,ConfirmTime,FromType_id,ToType_id,ConfirmUserId,ConfirmUserClass,ConfirmMethod,Description,Create_User_id,Create_time) 
                            //           select id as Flow_id,GETDATE(),a.StepType_id_Previous,StepType_id,@gWadeID,'HR','SL','結算日期:' + @value,@gWadeID,GETDATE() from esn_todos_Flow a where a.id=@FlowId;
                            //            ", i);
                            sqlstr += string.Format(@"update esn_todos_Flow Set Is_Settlement = 1,update_user_id = @gWadeID,Update_time = GETDATE(),StepType_id_Previous=StepType_id
                                        ,StepType_id =(select id from esn_todos_Flow_StepType a where a.Map_Class='HR') output INSERTED.id INTO @TempTable where esn_todos_sn ={0};
                                        select @FlowId=id from @TempTable;
                                       insert into esn_todos_Flow_his(Flow_id,ConfirmTime,FromType_id,ToType_id,ConfirmUserId,ConfirmUserClass,ConfirmMethod,Description,Create_User_id,Create_time) 
                                       select id as Flow_id,GETDATE(),a.StepType_id_Previous,StepType_id,@gWadeID,'HR','SL','結算日期:' + @valueText,@gWadeID,GETDATE() from esn_todos_Flow a where a.id=@FlowId;
                                        ", SN);
                            return_sn.Add(SN);

                            
                            if (i % batchcount == batchcount-1 || i== dt.Rows.Count-1) //固定筆數 存入批次語法
                            {
                                batchSql.Add(sqldeclare + sqlstr);
                                sqlstr = "";
                            }

                        }
                        cmd.Parameters.AddWithValue("@value", value);
                        cmd.Parameters.AddWithValue("@valueText", DateTime.Parse(value).ToString("yyyy-MM"));
                        cmd.Parameters.AddWithValue("@gWadeID", obj_input["gWadeID"].ToString());

                        string JSONString = string.Empty;
                        if (return_msg_error.Count == 0)
                        {
                            foreach (string sql in batchSql)
                            {
                                cmd.CommandText = sql;
                                dt = SqlToDt(cmd);
                            }
                            return_msgs.Add("設定結算完畢");


                            if (return_sn.Count > 0)
                            {
                                String fields = "convert(varchar(10),date_points_settlement,126) as date_points_settlement,date_points_settlement_pic_confirm ";
                                SqlCommand cmd2 = new SqlCommand("", Conn)
                                {
                                    CommandText = "select SN, " + fields +
                                  " from esn_todos_points a left join evw_Employee b on a.date_points_settlement_AssignTo=b.user_id where  SN in (" +
                                   String.Join(",", return_sn) + ")"
                                };
                                dt = SqlToDt(cmd2);
                                JSONString = JsonConvert.SerializeObject(dt);

                            }

                            response.Code = "1";
                            response.Msg = return_msgs;
                            response.ExtraInfo = JSONString;
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = return_msg_error;
                            response.ExtraInfo = JSONString;
                        }
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        [Route("batchUpdate_points")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage batchUpdate_points(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {

                        String sns = obj_input["SN"].ToString();
                        String sqlstr = @"select td.SN, tdp.SN as SN_tdp,td.points,AssignedTo_userid  FROM esn_todos td 
                                          left join esn_todos_points tdp on tdp.sn=td.sn  
                                          WHERE td.sn in (" + sns + ")";
                        String value = obj_input["value"].ToString();
                        value = value == "" ? "null" : obj_input["value"].ToString();
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = sqlstr
                        };
                        cmd.Parameters.AddWithValue("@SN", obj_input["SN"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        String point, AssignedTo_userID;
                        DataRow dr;
                        sqlstr = "declare  @TempTable TABLE(id INT) declare @FlowId int; ";
                        cmd.Parameters.Clear();
                        for (int i = 0; i < dt.Rows.Count; i++)
                        {
                            dr = dt.Rows[i];
                            point = dr["points"].ToString();
                            AssignedTo_userID = dr["AssignedTo_userID"].ToString();
                            if (dr["SN_tdp"] == DBNull.Value)
                            {
                                sqlstr += string.Format(@"insert into esn_todos_points(sn,date_points_settlement,date_points_settlement_AssignTo,date_points_settlement_Point,update_user_id,update_time) 
                                            values (@SN{0},@value,@AssignedTo_userID{0},@points{0},@gWadeID,getdate()); ", i);
                            }
                            else
                            {
                                sqlstr += string.Format(@"update esn_todos_points set date_points_settlement=@value,date_points_settlement_AssignTo=@AssignedTo_userID{0}
                                            ,date_points_settlement_Point=@points{0} ,update_user_id=@gWadeID,Update_time=GETDATE() where SN =@SN{0};", i);

                            }
                            cmd.Parameters.AddWithValue(string.Format("@SN{0}", i), dr["SN"].ToString());
                            cmd.Parameters.AddWithValue(string.Format("@AssignedTo_userID{0}", i), AssignedTo_userID);
                            cmd.Parameters.AddWithValue(string.Format("@points{0}", i), point);

                            sqlstr += string.Format(@"update esn_todos_Flow Set Is_Settlement = 1,update_user_id = @gWadeID,Update_time = GETDATE()
                                        ,StepType_id =(select id from esn_todos_Flow_StepType a where a.Map_Class='HR') output INSERTED.id INTO @TempTable where esn_todos_sn =@SN{0};
                                        select @FlowId=id from @TempTable;
                                       insert into esn_todos_Flow_his(Flow_id,ConfirmTime,FromType_id,ToType_id,ConfirmUserId,ConfirmUserClass,ConfirmMethod,Description,Create_User_id,Create_time) 
                                       select id as Flow_id,@value,a.StepType_id,StepType_id,@gWadeID,'HR','SL','確認日期:' + @value,@gWadeID,GETDATE() from esn_todos_Flow a where a.id=@FlowId;
                                        ", i);


                        }
                        cmd.Parameters.AddWithValue("@value", value);
                        cmd.Parameters.AddWithValue("@gWadeID", obj_input["gWadeID"].ToString());
                        cmd.CommandText = sqlstr;
                        dt = SqlToDt(cmd);
                        response.Code = "1";
                        string JSONString = string.Empty;
                        JSONString = JsonConvert.SerializeObject(dt);
                        response.Msg = "結算完畢";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        /// <summary>
        /// 案件統計 SP測試1
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [Route("rpt_CustCaseTot_board")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage rpt_CustCaseTot_board(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        String sqlstr = "[dbo].[rpt_CustCaseTot_board] @Start_YM,@End_YM,@RptType,@CustName,@DisplayType,@DataMode  ;";
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = sqlstr
                        };
                        cmd.CommandTimeout = 600;
                        cmd.Parameters.AddWithValue("@Start_YM", obj_input["Start_YM"].ToString());
                        cmd.Parameters.AddWithValue("@End_YM", obj_input["End_YM"].ToString());
                        cmd.Parameters.AddWithValue("@RptType", obj_input["RptType"].ToString());
                        cmd.Parameters.AddWithValue("@CustName", obj_input["CustName"].ToString());
                        cmd.Parameters.AddWithValue("@DisplayType", obj_input["DisplayType"].ToString());
                        cmd.Parameters.AddWithValue("@DataMode", obj_input["DataMode"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        string JSONString = string.Empty;
                        JSONString = JsonConvert.SerializeObject(dt);
                        response.Msg = JSONString;
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }


        [Route("rpt_PerformanceMonth_Flow")]
        [CorsHandle]
        [HttpPost]
        [HttpGet]
        public HttpResponseMessage rpt_PerformanceMonth_Flow(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"
        Declare @p_ReportType varchar(20),@p_ReportType2 varchar(20), @p_Date_settlement_begin DateTime,@p_Date_settlement_end DateTime
        DECLARE @Emp_ID VARCHAR(50),@Emp_ItemNo  VARCHAR(20),@QryEmpItem  VARCHAR(20)= '' ,@QryEmpDS  VARCHAR(20)= '' ,@p_isComfirm varchar(1),@p_gtPoint int
        ,@IsPG bit=0,@PGJoin  varchar(max)='',@p_flow_user_id_also VARCHAR(50);
 
	        select * into #tb_Split from ufn_split(@p_params,',')
	        select @p_ReportType=value from #tb_Split where id=1
	        select @p_isComfirm=value from #tb_Split where id=2 
	        select @p_gtPoint=value from #tb_Split where id=3
	        select @p_Date_settlement_begin=value from #tb_Split where id=4
	        select @p_Date_settlement_end=value from #tb_Split where id=5
	        select @p_ReportType2=value from #tb_Split where id=6
	 
	         "
                        };
                        //cmd.Parameters.AddWithValue("@SaveData", obj_input["SaveData"].ToString());
                        //cmd.Parameters.AddWithValue("@gUserID_wade", obj_input["gUserID_wade"].ToString());
                        //cmd.Parameters.AddWithValue("@Country", obj_input["Country"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        response.Code = "1";
                        response.Msg = "匯出完畢";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
    }


}
