﻿using ExcelDataReader;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web;
using System.Web.Http;
using System.Web.Http.Cors;
using WebAPI.Models;
using WebAPI.Tool;
using static WebAPI.Models.CommonModel;

namespace WebAPI.Controllers
{
    public class ProcInfoController : ApiController
    {
        public ProcInfoController()
        {
        }


        #region 獲取處理事項訊息
        [Route("ProcInfo")]
        [CorsHandle]
        [HttpGet]

        public HttpResponseMessage GetProcInfo(string id, string fields)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                if (string.IsNullOrWhiteSpace(id))
                {
                    response.Code = "0";
                    response.Msg = "no id";
                }
                else
                {
                    SqlServerHelper sql_server_helper = new SqlServerHelper();
                    string sql_fields = "";
                    if(string.IsNullOrWhiteSpace(fields))
                    {
                        sql_fields += "*";
                    }
                    else
                    {
                        sql_fields += fields.Trim();
                    }
                    DataTable dt = sql_server_helper.GetTable("select " + sql_fields + " FROM dbo.p_proc_info where proc_id = '" + id + "'");
                    response.Code = "1";
                    response.Msg = dt;
                }
                
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        #region 更新處理事項訊息
        [Route("ProcInfo")]
        [CorsHandle]
        [HttpPut]

        public HttpResponseMessage UpdateProcInfo(string id, [FromBody]dynamic input)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            string a = input.ToString();
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                if (string.IsNullOrWhiteSpace((id)))
                {
                    response.Code = "0";
                    response.Msg = "no id";
                }
                else
                {
                    SqlServerHelper sql_server_helper = new SqlServerHelper();
                    JObject obj_input = JObject.Parse(input.ToString());
                    List<string> list_fields = new List<string>();
                    foreach (var jt in obj_input)
                    {
                        if (jt.Value.Type == JTokenType.Integer || jt.Value.Type == JTokenType.Float)
                        {
                            list_fields.Add(jt.Key + " = " + jt.Value);
                        }
                        else
                        {
                            list_fields.Add(jt.Key + " = '" + jt.Value + "'");
                        }
                    }

                    if (list_fields.Count > 0)
                    {
                        string sql = "UPDATE dbo.p_proc_info SET " + string.Join(",", list_fields.ToArray()) + " where proc_id = '" + id + "'";
                        int updated_count = sql_server_helper.ExecuteSqlCommand(sql);
                        response.Code = "1";
                        response.Msg = updated_count;
                    }
                    else
                    {
                        response.Code = "0";
                        response.Msg = "no input";
                    }
                }

            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion


        #region 更新處理事項訊息
        [Route("ProcInfo")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage UpdateProcInfo_post(ParamModel param)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            string input = param.Input.ToString();
            if (string.IsNullOrWhiteSpace((input)))
            {
                response.Code = "0";
                response.Msg = "no input";
            }
            else
            {
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    string id = Common.isJTokenNull(obj_input["id"], "").ToString();
                    if (string.IsNullOrWhiteSpace(id))
                    {
                        response.Code = "0";
                        response.Msg = "no id";
                    }
                    else
                    {
                        SqlServerHelper sql_server_helper = new SqlServerHelper();

                        List<string> list_fields = new List<string>();
                        foreach (var jt in obj_input)
                        {
                            if (jt.Key != "id")
                            {
                                if (jt.Value.Type == JTokenType.Integer || jt.Value.Type == JTokenType.Float)
                                {
                                    list_fields.Add(jt.Key + " = " + jt.Value);
                                }
                                else
                                {
                                    list_fields.Add(jt.Key + " = '" + jt.Value + "'");
                                }
                            }
                        }

                        if (list_fields.Count > 0)
                        {
                            string sql = "UPDATE dbo.p_proc_info SET " + string.Join(",", list_fields.ToArray()) + " where proc_id = '" + id + "'";
                            int updated_count = sql_server_helper.ExecuteSqlCommand(sql);
                            response.Code = "1";
                            response.Msg = updated_count;
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = "no input";
                        }
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = e.Message;
                }
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        
    }
}