﻿using ExcelDataReader;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web;
using System.Web.Http;
using System.Web.Http.Cors;
using WebAPI.Dal;
using WebAPI.Models;
using WebAPI.Tool;
using static WebAPI.Models.CommonModel;

namespace WebAPI.Controllers
{
    public class ProcInfoController : ApiController
    {
        public ProcInfoController()
        {
        }


        #region 獲取處理事項訊息
        [Route("ProcInfo")]
        [CorsHandle]
        [HttpGet]

        public HttpResponseMessage GetProcInfo(string id, string fields)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                if (string.IsNullOrWhiteSpace(id))
                {
                    response.Code = "0";
                    response.Msg = "no id";
                }
                else
                {
                    SqlServerHelper sql_server_helper = new SqlServerHelper();
                    string sql_fields = "";
                    if(string.IsNullOrWhiteSpace(fields))
                    {
                        sql_fields += "*";
                    }
                    else
                    {
                        sql_fields += fields.Trim();
                    }
                    DataTable dt = sql_server_helper.GetTable("select " + sql_fields + " FROM dbo.p_proc_info where proc_id = '" + id + "'");
                    response.Code = "1";
                    response.Msg = dt;
                }
                
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        #region 更新處理事項訊息
        [Route("ProcInfo")]
        [CorsHandle]
        [HttpPut]

        public HttpResponseMessage UpdateProcInfo(string id, [FromBody]dynamic input)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            string a = input.ToString();
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                if (string.IsNullOrWhiteSpace((id)))
                {
                    response.Code = "0";
                    response.Msg = "no id";
                }
                else
                {
                    SqlServerHelper sql_server_helper = new SqlServerHelper();
                    JObject obj_input = JObject.Parse(input.ToString());
                    List<string> list_fields = new List<string>();
                    foreach (var jt in obj_input)
                    {
                        if (jt.Value.Type == JTokenType.Integer || jt.Value.Type == JTokenType.Float)
                        {
                            list_fields.Add(jt.Key + " = " + jt.Value);
                        }
                        else
                        {
                            list_fields.Add(jt.Key + " = '" + jt.Value + "'");
                        }
                    }

                    if (list_fields.Count > 0)
                    {
                        string sql = "UPDATE dbo.p_proc_info SET " + string.Join(",", list_fields.ToArray()) + " where proc_id = '" + id + "'";
                        int updated_count = sql_server_helper.ExecuteSqlCommand(sql);
                        response.Code = "1";
                        response.Msg = updated_count;
                    }
                    else
                    {
                        response.Code = "0";
                        response.Msg = "no input";
                    }
                }

            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion


        #region 更新處理事項訊息
        [Route("ProcInfo")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage UpdateProcInfo_post(ParamModel param)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            string input = param.Input.ToString();
            if (string.IsNullOrWhiteSpace((input)))
            {
                response.Code = "0";
                response.Msg = "no input";
            }
            else
            {
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    string id = Common.isJTokenNull(obj_input["id"], "").ToString();
                    if (string.IsNullOrWhiteSpace(id))
                    {
                        response.Code = "0";
                        response.Msg = "no id";
                    }
                    else
                    {
                        SqlServerHelper sql_server_helper = new SqlServerHelper();

                        List<string> list_fields = new List<string>();
                        foreach (var jt in obj_input)
                        {
                            if (jt.Key != "id")
                            {
                                if (jt.Value.Type == JTokenType.Integer || jt.Value.Type == JTokenType.Float)
                                {
                                    list_fields.Add(jt.Key + " = " + jt.Value);
                                }
                                else
                                {
                                    list_fields.Add(jt.Key + " = '" + jt.Value + "'");
                                }
                            }
                        }

                        if (list_fields.Count > 0)
                        {
                            string sql = "UPDATE dbo.p_proc_info SET " + string.Join(",", list_fields.ToArray()) + " where proc_id = '" + id + "'";
                            int updated_count = sql_server_helper.ExecuteSqlCommand(sql);
                            response.Code = "1";
                            response.Msg = updated_count;
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = "no input";
                        }
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = e.Message;
                }
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        #region 導入費用
        [Route("ProcInfo/Fee/Import")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage ProcInfoFeeImport()
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                var file = HttpContext.Current.Request.Files.Count > 0 ? HttpContext.Current.Request.Files[0] : null;
                //var input = HttpContext.Current.Request.Params;
                if (file != null)
                {
                    ExcelHelper excel_helper = new ExcelHelper();
                    CommonResponseMsg result_excel = excel_helper.LoadFromStream(file.InputStream, file.FileName);
                    DataSet ds_excel = (DataSet)result_excel.Msg;
                    if(result_excel.Code=="1" && ds_excel.Tables.Count > 0)
                    {
                        DataTable dt_excel = ds_excel.Tables[0];
                        dt_excel.Columns.Add("check_status", typeof(String));
                        DalProcInfo dal_proc_info = new DalProcInfo();
                        DalBaseInfo dal_base_info = new DalBaseInfo();
                        DalFee dal_fee = new DalFee();
                        DalCaseInfo dal_case_info = new DalCaseInfo();
                        CommonResponseMsg result_ctrl_proc = dal_proc_info.GetCtrlProc("ctrl_proc_id, case_type_id, ctrl_proc_zh_cn, ctrl_proc_zh_tw, proc_status_id, case_status_id");
                        CommonResponseMsg result_case_status = dal_proc_info.GetCaseStatus("case_status_id, case_type_id, case_status_zh_cn, case_status_zh_tw");
                        CommonResponseMsg result_fee_cate_workitem = dal_base_info.GetDictionaryByName("*", "fee_cate_workitem");//科目
                        CommonResponseMsg result_fc_cate = dal_base_info.GetFcCategory();//程序名稱
                            
                        //CommonResponseMsg result_case_type = dal_base_info.GetDataByTable("*", "i_case_type");//案件類型

                        if (result_ctrl_proc.Code == "1" && result_case_status.Code == "1")
                        {
                            DataTable dt_ctrl_proc = (DataTable)result_ctrl_proc.Msg;
                            DataTable dt_case_status = (DataTable)result_case_status.Msg;
                                
                            foreach (DataRow dr_proc in dt_excel.Rows)
                            {
                                CommonResponseMsg result_check = new CommonResponseMsg();
                                result_check.Code = "1";
                                result_check.Msg = "OK";

                                CommonResponseMsg result_case_info = dal_case_info.GetCaseInfoByCaseVolume("*", dr_proc["我方文号"].ToString());//案件信息
                                DataTable dt_case_info = (DataTable)result_case_info.Msg;
                                //檢查案件是否存在
                                if (result_check.Code == "1")
                                {
                                    if (result_case_info.Code == "0" || dt_case_info.Rows.Count != 1)
                                    {
                                        result_check.Code = "0";
                                        result_check.Msg = "此案號無法找到唯一的案件";
                                    }
                                }

                                //檢查處理事項是否存在且唯一
                                if (result_check.Code == "1")
                                {
                                    string proc_id = dr_proc["处理事项ID"].ToString();
                                    if (string.IsNullOrEmpty(proc_id))
                                    {
                                        string case_volume = dr_proc["我方文号"].ToString();
                                        string proc_name = dr_proc["处理事项"].ToString();
                                        if (!string.IsNullOrEmpty(case_volume) && !string.IsNullOrEmpty(proc_name))
                                        {
                                            CommonResponseMsg result_proc_info = dal_proc_info.GetProcInfoByName("proc_id", dr_proc["我方文号"].ToString(), dr_proc["处理事项"].ToString(), dr_proc["案件阶段"].ToString());
                                            if (result_proc_info.Code == "0" || ((DataTable)result_proc_info.Msg).Rows.Count != 1)
                                            {
                                                result_check.Code = "0";
                                                result_check.Msg = "此案号 + 处理事项名称无法找到唯一的处理事项";
                                            }
                                        }
                                        else
                                        {
                                            result_check.Code = "0";
                                            result_check.Msg = "需要有处理事项ID或是案号+处理事项名称";
                                        }
                                    }
                                    else
                                    {
                                        CommonResponseMsg result_proc_info = dal_proc_info.GetProcInfo("proc_id", dr_proc["处理事项ID"].ToString());
                                        if (result_proc_info.Code == "0" || ((DataTable)result_proc_info.Msg).Rows.Count != 1)
                                        {
                                            result_check.Code = "0";
                                            result_check.Msg = "此ID无法找到唯一的处理事项";
                                        }
                                    }
                                }
                                //檢查工作項目是否存在
                                if (result_check.Code == "1")
                                {
                                    if (result_fee_cate_workitem.Code == "1" && result_fc_cate.Code == "1" && result_case_info.Code == "1")
                                    {
                                        DataTable dt_fee_cate_workitem = (DataTable)result_fee_cate_workitem.Msg;
                                        DataTable dt_fc_cate = (DataTable)result_fc_cate.Msg;

                                        DataRow[] selected_fee_cate_workitem = dt_fee_cate_workitem.Select(string.Format("text = '{0}' or text_zh_cn = '{0}' or text_zh_tw = '{0}'", dr_proc["科目"].ToString()));
                                        DataRow[] selected_fc_cate = dt_fc_cate.Select(string.Format("text_zh_cn = '{0}' or text_zh_tw = '{0}'", dr_proc["程序名称"].ToString()));
                                        if (selected_fee_cate_workitem.Length > 0 && selected_fc_cate.Length > 0)
                                        {
                                            CommonResponseMsg result_fee_type = dal_fee.GetFeeTypeByName("fee_type_id", dt_case_info.Rows[0]["case_type_id"].ToString(), dt_case_info.Rows[0]["business_type_id"].ToString(), dt_case_info.Rows[0]["apply_type_id"].ToString(), dt_case_info.Rows[0]["country_id"].ToString(),  selected_fee_cate_workitem.FirstOrDefault()["value"].ToString(), selected_fc_cate.FirstOrDefault()["fc_cate_id"].ToString(), dr_proc["工作项目"].ToString());
                                            if(result_fee_type.Code=="0" || ((DataTable)result_fee_type.Msg).Rows.Count!=1)
                                            {
                                                result_check.Msg = "无法找到唯一的工作项目";
                                            }
                                        }
                                        else
                                        {
                                            result_check.Code = "0";
                                            result_check.Msg = "科目或程序名称不正确";
                                        }
                                    }
                                    else
                                    {
                                        result_check.Code = "0";
                                        result_check.Msg = "需要有我方文号、科目、程序名称以及费用名称";
                                    }
                                }
                                dr_proc["check_status"] = result_check.Msg;
                            }
                            response.Code = "1";
                            response.Msg = dt_excel;
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = "DB Access Fail";
                        }
                    }
                    else
                    {
                        response.Code = "0";
                        response.Msg = "File Parsed Fail";
                    }
                }
                else
                {
                    response.Code = "0";
                    response.Msg = "No File";
                }
                //DataSet ds = excel_helper.LoadFromStream();
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion


    }
}