﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Tool.Common;
namespace WebAPI.Controllers
{
    [RoutePrefix("Esn_Subitem")]
    public class Esn_todos_SettleController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public Esn_todos_SettleController()
        { 
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["eflow_cur"].ConnectionString;
        }
        /// <summary>
        /// 取得關帳最後日期
        /// </summary>
        /// <para ></param>
        /// <returns></returns> 
        /// 
        [Route("getSettleDate")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage get_Settle_Date(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        ;
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @" 
                              SELECT  top 1 isClosed, Settle_Date
                                  FROM esn_todos_Settle a
                                    inner join  esn_todos_Settle_config b on a.DeptNum=b.DeptNum and a.DSNum=b.DSNum and a.ItemNum=b.ItemNum 
                                  where  [settle_date] between @Settle_Date and @Settle_Date  and b.is_enabled = 1;
                              SELECT  top 1 DATEADD(month,1,[settle_date]) as settle_date_next
                                 FROM esn_todos_Settle a
                                 inner join  esn_todos_Settle_config b on a.DeptNum=b.DeptNum and a.DSNum=b.DSNum and a.ItemNum=b.ItemNum 
                                  where isClosed=1
                                  order by [settle_date] desc;
                            "
                        };

                        string Settle_Date = obj_input["Settle_Date"].ToString() == "" ? "" : obj_input["Settle_Date"].ToString() + "-01";
                        cmd.Parameters.AddWithValue("@Settle_Date", Settle_Date);
                        cmd.Parameters.AddWithValue("@user_id", obj_input["gWadeID"].ToString());
                        DataSet ds = SqlToDs(cmd);
                        JObject jdata = new JObject();
                        if (ds.Tables[0].Rows.Count > 0)
                        {
                            DateTime dtemp = (DateTime)ds.Tables[0].Rows[0]["Settle_Date"] ;
                            jdata["Settle_Date"] = dtemp.ToString("yyyy-MM");
                            jdata["isClosed"] = ds.Tables[0].Rows[0]["isClosed"].ToString();
                        }
                        else
                        {
                            DateTime dtemp;
                            if (obj_input["Settle_Date"].ToString() != "")
                            {
                                dtemp = Convert.ToDateTime(obj_input["Settle_Date"].ToString());
                            }
                            else
                            {
                                dtemp = (DateTime)ds.Tables[1].Rows[0]["settle_date_next"];
                            }
                            jdata["Settle_Date"] = dtemp.ToString("yyyy-MM");
                            jdata["isClosed"] = "0";

                        }
                        //dt.Columns["settle_date_next"].ReadOnly = false; 
                   
                        response.Code = "1";
                        response.Msg = "success";
                        string JSONString = string.Empty;
                        JSONString = JsonConvert.SerializeObject(jdata);
                        response.Msg = JSONString;
                        result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        [Route("UpdateEsntodosSettle")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Update_Esn_todos_Settle(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    { 
                        String sqlstr = @"select * from esn_todos_Settle_config a
                                        where a. user_id=@user_id and is_enabled=1;";
                        SqlCommand cmd = new SqlCommand("",Conn)
                        {
                            CommandText = sqlstr
                        };
                        cmd.Parameters.AddWithValue("@user_id", obj_input["gWadeID"].ToString());
                        DataTable dtL1 = SqlToDt(cmd);
                        //cmd.Parameters.Clear();
                        StringBuilder strsql = new StringBuilder();
                        String wherecase ;
                        DataRow drL1;
                        for(int i=0;i< dtL1.Rows.Count;i++)
                        {
                            drL1 = dtL1.Rows[i];
                            wherecase = "";
                         
                                wherecase += " and DSNum = @DSNum" + i; 
                                cmd.Parameters.AddWithValue("@DSNum" + i, drL1["DSNum"].ToString());
                                wherecase += " and DeptNum = @DeptNum" + i;
                                cmd.Parameters.AddWithValue("@DeptNum" + i, drL1["DeptNum"].ToString());
                                wherecase += " and ItemNum = @ItemNum" + i;
                                cmd.Parameters.AddWithValue("@ItemNum" + i, drL1["ItemNum"].ToString());
                            #region MERGE版

                            //strsql.Append(String.Format(@"MERGE INTO esn_todos_Settle WITH(HOLDLOCK)  as target
                            //USING(select DSNum, DeptNum, ItemNum, Settle_Date from esn_todos_Settle where Settle_Date
                            //between @Settle_Date and @Settle_Date " + wherecase + @" ) as source(DSNum, DeptNum, ItemNum, Settle_Date)
                            //on(target.DSNum = source.DSNum and target.DeptNum = source.DeptNum and target.ItemNum = source.ItemNum and target.Settle_Date = source.Settle_Date)
                            //WHEN MATCHED THEN UPDATE SET isClosed = 1, update_time = getdate(), update_user_id = @user_id, Create_user_id = @user_id, Create_time = getdate()
                            //WHEN NOT MATCHED THEN INSERT(DSNum,DeptNum,ItemNum,isClosed, update_time, update_user_id, Create_user_id, Create_time) 
                            //VALUES(@DSNum{0},@DeptNum{0},@ItemNum{0},1,@user_id,getdate(),@user_id,getdate())", i));
                            #endregion

                            #region MERGE版

                            strsql.Append(String.Format(@"MERGE INTO esn_todos_Settle WITH(HOLDLOCK)  as target
                            USING(select @DSNum{0}, @DeptNum{0}, @ItemNum{0} ,@Settle_Date as Settle_Date  ) as source(DSNum, DeptNum, ItemNum, Settle_Date)
                            on(target.DSNum = source.DSNum and target.DeptNum = source.DeptNum and target.ItemNum = source.ItemNum and target.Settle_Date = source.Settle_Date)
                            WHEN MATCHED THEN UPDATE SET isClosed = 1, update_time = getdate(), update_user_id = @user_id, Create_user_id = @user_id, Create_time = getdate()
                            WHEN NOT MATCHED THEN INSERT(Settle_Date,DSNum,DeptNum,ItemNum,isClosed, update_user_id, update_time, Create_user_id, Create_time) 
                            VALUES(@Settle_Date,@DSNum{0},@DeptNum{0},@ItemNum{0},1,@user_id,getdate(),@user_id,getdate())
                            OUTPUT $action ", i));
                            #endregion 

                            //strsql.Append(@"update esn_todos_Settle set isClosed=0,update_time=getdate(),update_user_id=@user_id
                            //                where Settle_Date between @Settle_Date and  @Settle_Date ");
                            strsql.Append(";");
                        }  
                        cmd.Parameters.AddWithValue("@Settle_Date", Convert.ToDateTime(obj_input["Settle_Date"].ToString()));
                        cmd.CommandText = strsql.ToString();
                        DataTable dt = SqlToDt(cmd);

                        response.Code = "1";
                        response.Msg = "已關帳";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
    }
}
