﻿using Dapper;
using DapperQueryBuilder;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Configuration;
using System.Linq;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Tool.Common;
using System.Collections.Generic;

namespace WebAPI.Controllers
{
    public class WadeMailController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public WadeMailController()
        { 
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["DefaultConnection"].ConnectionString;
        }

        /// <summary>
        /// 取得 Mail_js內返稿文件命名規範 資訊
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [Route("Get_essen_back_file_rule")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Get_essen_back_file_rule(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                try
                {
                    JObject obj_input = JObject.Parse(input.ToString());
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        var dysql = Conn.QueryBuilder($@"
                                         select epci.customer_name,eppi.ctrl_proc_zh_tw,eppi.ctrl_proc_zh_cn,ebfr.* from evw_p_proc_info eppi
                                        left join evw_p_case_info epci on epci.case_id=eppi.case_id
                                        inner join essen_back_file_rule ebfr on eppi.ctrl_proc_id=ebfr.ctrl_proc_id and eppi.country_id=ebfr.country_id  and epci.customer_id=ebfr.customer_id
                                           /**where**/ ");
                        if (obj_input["proc_id"] != null)
                        {
                            string[] procids = obj_input["proc_id"].ToString().Split(',');
                            dysql.Where($"eppi.proc_id in ({procids})");
                        }
                        if (obj_input["case_id"] != null)
                        {
                            dysql.Where($"epci.case_id in ('{obj_input["case_id"].ToString()}')");
                        }
                        if (obj_input["Case_country_id"] != null)
                        {
                            dysql.Where($"epci.country_id = '{obj_input["Case_country_id"].ToString()}'");
                        }
                        if (obj_input["case_type_Code"] != null)
                        {
                            dysql.Where($"epci.case_type_Code = '{obj_input["case_type_Code"].ToString()}'");
                        }
                        if (obj_input["customer_name"] != null)
                        {
                            dysql.Where($"epci.customer_name like '{obj_input["customer_name"].ToString()}%'");
                        }

                        var results = dysql.Query();
                        response.Msg = JsonConvert.SerializeObject(results);
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
         

        /// <summary>
        /// 取得 處理事項,案件資訊
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [Route("ProcInfo/Get_evwProcInfo")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Get_evwProcInfo(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                try
                {
                    JObject obj_input = JObject.Parse(input.ToString());
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        string sql_fields = obj_input["sql_fields"] == null ? "*" : obj_input["sql_fields"].ToString();
                       FormattableString sql= $@" select * from evw_p_proc_info eppi
										 left join evw_p_case_info epci on epci.case_id=eppi.case_id
                                           /**where**/ ";
                        var dysql = Conn.QueryBuilder(sql); 
                        if (obj_input["proc_id"] != null)
                        {
                            string[] procids = obj_input["proc_id"].ToString().Split(',');
                            dysql.Where($"eppi.proc_id in ({procids})");
                        }
                        if (obj_input["case_id"] != null)
                        {
                            dysql.Where($"epci.case_id in ('{obj_input["case_id"].ToString()}')");
                        }
                        if (obj_input["Case_country_id"] != null)
                        {
                            dysql.Where($"epci.country_id = '{obj_input["Case_country_id"].ToString()}'");
                        }
                        if (obj_input["case_type_Code"] != null)
                        {
                            dysql.Where($"epci.case_type_Code = '{obj_input["case_type_Code"].ToString()}'");
                        }
                        if (obj_input["customer_name"] != null)
                        {
                            dysql.Where($"epci.customer_name like '{obj_input["customer_name"].ToString()}%'");
                        }

                        dysql += $" ORDER BY epci.case_id";

                        var results = dysql.Query(); 
                        
                        response.Msg = JsonConvert.SerializeObject(results);
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
    }
}
