﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Tool.Common;
namespace WebAPI.Controllers
{
    public class CustomerController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public CustomerController()
        { 
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["eflow_cur"].ConnectionString;
        } 
        [Route("Get_CustomerList")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Get_CustomerList(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"
                                    select customer_name,customer_id from c_customer a

                                where a.is_enabled=1 "
                        };
                        DataTable dt = SqlToDt(cmd);
                        response.Msg = JsonConvert.SerializeObject(dt);
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }


        [Route("Update_CustomerListTP")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Update_CustomerList(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"MERGE INTO essen_request_info WITH(HOLDLOCK)  as target USING(select * from essen_request_info a　where a.request_id=@request_id ) as source (request_id,customer_id)
                            on(target.request_id = source.request_id   )
                            WHEN MATCHED THEN UPDATE SET customer_id = @customer_id 
                            WHEN NOT MATCHED THEN INSERT(request_id,customer_id) 
                            VALUES(@request_id,@customer_id )"
                    };
                       

                        cmd.Parameters.AddWithValue("@customer_id", obj_input["customer_id"].ToString());
                        cmd.Parameters.AddWithValue("@request_id", obj_input["request_id"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        response.Msg = JsonConvert.SerializeObject(dt);
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        [Route("Update_CustomerList")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Update_CustomerList2(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"MERGE INTO essen_customer WITH(HOLDLOCK)  as target USING(select * from essen_customer a　where a.customer_id=@customer_id) as source (customer_id,request_customer_id)
                            on(target.customer_id = source.customer_id   )
                            WHEN MATCHED THEN UPDATE SET request_customer_id = @request_customer_id 
                            WHEN NOT MATCHED THEN INSERT(customer_id,request_customer_id) 
                            VALUES(@customer_id,@request_customer_id)"
                        };
                        cmd.Parameters.AddWithValue("@customer_id", obj_input["customer_id"].ToString());
                        cmd.Parameters.AddWithValue("@request_customer_id", obj_input["request_customer_id"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        response.Msg = JsonConvert.SerializeObject(dt);
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
    }


}
