﻿using ExcelDataReader;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web;
using System.Web.Http;
using System.Web.Http.Cors;
using WebAPI.Models;
using WebAPI.Tool;
using static WebAPI.Models.CommonModel;

namespace WebAPI.Controllers
{
    public class DictionaryController : ApiController
    {
        public DictionaryController()
        {
        }


        #region 獲取字典訊息
        [Route("Dictionary")]
        [CorsHandle]
        [HttpGet]

        public HttpResponseMessage GetDictionary(string name, string fields = null)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                if (string.IsNullOrWhiteSpace(name))
                {
                    response.Code = "0";
                    response.Msg = "no name";
                }
                else
                {
                    SqlServerHelper sql_server_helper = new SqlServerHelper();
                    string sql_fields = "";
                    if(string.IsNullOrWhiteSpace(fields))
                    {
                        sql_fields += "*";
                    }
                    else
                    {
                        sql_fields += fields.Trim();
                    }
                    DataTable dt = sql_server_helper.GetTable("select " + sql_fields + " FROM s_dictionary where dictionary_name = '" + name + "' order by seq");
                    response.Code = "1";
                    response.Msg = dt;
                }
                
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion
    }
}