﻿using Dapper;
using ExcelDataReader;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Web;
using System.Web.Http;
using System.Web.Http.Cors;
using WebAPI.Dal;
using WebAPI.Models;
using WebAPI.Tool;
using static WebAPI.Models.CommonModel;

namespace WebAPI.Controllers
{
    public class RequestController : ApiController
    {
        String connectionString = ConfigurationManager.ConnectionStrings["DefaultConnection"].ConnectionString;

        public RequestController()
        {
        }


        #region 獲取請款單費用
        [Route("Request/{request_id}/FeeList")]
        [CorsHandle]
        [HttpGet]

        public HttpResponseMessage GetProcInfo(string request_id)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                if (string.IsNullOrWhiteSpace(request_id))
                {
                    response.Code = "0";
                    response.Msg = "no request_id";
                }
                else
                {
                    using (SqlConnection conn = new SqlConnection(connectionString))
                    {
                        string sql = @"SELECT ppfl.fee_id, ppfl.proc_id, ppfl.currency_id, ppfl.fee_type_id, ppfl.amount, ppfl.request_id, ppfl.request_no, ppfl.pay_type, ppfl.pay_status, ppfl.coefficient, ppfl.rate, ppfl.tax_id, ppfl.tax_type, ppfl.price, ppfl.is_divided, ppfl.mid_currency_id, ppfl.mid_amount, ppfl.mid_is_divided, ppfl.ori_is_divided, ppfl.mid_rate, ppfl.ori_rate 
                                        FROM p_proc_fee_list ppfl
                                        INNER JOIN f_request_list frl ON ppfl.fee_id = frl.fee_id
                                        WHERE frl.request_id = @request_id";
                        var fee_list = conn.Query<PProcFeeList>(sql, new { request_id = request_id }).ToList();
                        response.Code = "1";
                        response.Msg = fee_list;
                    }
                }
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion
    }
}