﻿using Microsoft.International.Formatters;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Globalization;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;
using System.Web;
using static WebAPI.Models.CurHisModel;

namespace WebAPI.Models
{
    public class CommonModel
    {
         
        public class Message
        {
            public String outNoticemsg, outErrmsg, outCustmsg;
            public int code, Status;
        }
         
        public class MessageList
        {
            public List<Message> msglist; //報價規則
            public List<核稿歷史> CurHislist; //核稿評分歷史
            public List<核稿歷史Excel> CurHislist_Excel; //核稿評分歷史
            public int CurHislist_Count; //核稿評分歷史
            public int ListCode //回傳代碼
                , ErrCount; //錯誤筆數
            public String Listmsg; //回傳訊息
        }

        public static DataSet GetSqlToDs(SqlCommand cmd)
        {
            using (DataSet ds = new DataSet())
            {
                SqlDataAdapter da = new SqlDataAdapter
                {
                    SelectCommand = cmd
                };
                da.Fill(ds);
                return ds;
            }

        }
        public static DataTable InsertSqlToDr(SqlCommand cmd)
        {
            using (DataTable dt = new DataTable())
            {
                if (cmd.Connection.State == ConnectionState.Closed)
                    cmd.Connection.Open();
                dt.Load(cmd.ExecuteReader());
                cmd.Connection.Close();
                return dt;
            }
        }


        #region 共用函式
        public string EastAsia_Format(string Msg)
        {
            Match m;
            while ((m = Regex.Match(Msg, "\\d+")).Success)
            {
                int n = int.Parse(m.Value);
                string t =
                    EastAsiaNumericFormatter.FormatWithCulture("Ln", n,
                    null, new CultureInfo("zh-TW"));
                //"L"-大寫，壹貳參... "Ln"-一二三... "Lc"-貨幣，同L
                Msg = Msg.Substring(0, m.Index) + t +
                       Msg.Substring(m.Index + m.Value.Length);
            }
            return Msg;
        }


        #region 簡轉繁
        internal const int LOCALE_SYSTEM_DEFAULT = 0x0800;
        internal const int LCMAP_SIMPLIFIED_CHINESE = 0x02000000;
        internal const int LCMAP_TRADITIONAL_CHINESE = 0x04000000;

        [DllImport("kernel32", CharSet = CharSet.Auto, SetLastError = true)]
        internal static extern int LCMapString(int Locale, int dwMapFlags, string lpSrcStr, int cchSrc, [Out] string lpDestStr, int cchDest);
        public static string ToSimplified(string pSource)
        {
            String tTarget = new String(' ', pSource.Length);
            int tReturn = LCMapString(LOCALE_SYSTEM_DEFAULT, LCMAP_SIMPLIFIED_CHINESE, pSource, pSource.Length, tTarget, pSource.Length);
            return tTarget;
        }
        public static string ToTraditional(string pSource)
        {
            String tTarget = new String(' ', pSource.Length);
            int tReturn = LCMapString(LOCALE_SYSTEM_DEFAULT, LCMAP_TRADITIONAL_CHINESE, pSource, pSource.Length, tTarget, pSource.Length);
            return tTarget;
        }
        #endregion
        #endregion
    }
}