﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;
using WebAPI.Models;
using WebAPI.Tool;
using Dapper;
using System.Reflection;
using Dapper.Contrib.Extensions;

namespace WebAPI.Controllers
{
    public class UserInfoController : ApiController
    {
        String connectionString = ConfigurationManager.ConnectionStrings["DefaultConnection"].ConnectionString;

        public UserInfoController()
        {
        }


        #region 導入用戶
        [Route("UserInfo/Import")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage UserInfoImport()
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                var mode = HttpContext.Current.Request.Form["mode"];
                if (!string.IsNullOrEmpty(mode))
                {
                    if (mode == "check")
                    {
                        var file = HttpContext.Current.Request.Files.Count > 0 ? HttpContext.Current.Request.Files[0] : null;
                        if (file != null)
                        {

                            ExcelHelper excel_helper = new ExcelHelper();
                            CommonResponseMsg result_excel = excel_helper.LoadFromStream(file.InputStream, file.FileName);
                            DataSet ds_excel = (DataSet)result_excel.Msg;
                            if (result_excel.Code == "1" && ds_excel.Tables.Count > 0)
                            {
                                using (SqlConnection conn = new SqlConnection(connectionString))
                                {
                                    DataTable dt_excel = ds_excel.Tables[0];
                                    dt_excel.Columns.Add("check_status", typeof(String));
                                    dt_excel.Columns.Add("update_status", typeof(String));
                                    dt_excel.Columns.Add("import_data", typeof(String));
                                    dt_excel.Columns.Add("is_exist", typeof(String));
                                    string str_sql_get_all_dept = "SELECT * FROM dbo.s_dept_info WHERE is_enabled = @is_enabled";
                                    var list_dept_info = conn.Query<SDeptInfo>(str_sql_get_all_dept, new { is_enabled = 1 }).ToList();
                                    string str_sql_get_all_dept_user = "SELECT * FROM dbo.s_dept_user";
                                    var list_dept_user = conn.Query<SDeptUser>(str_sql_get_all_dept_user).ToList();
                                    string str_sql_get_all_user = "SELECT * FROM dbo.s_user_info WHERE is_enabled = @is_enabled";
                                    var list_user_info = conn.Query<SUserInfo>(str_sql_get_all_user, new { is_enabled = 1 }).ToList();

                                    int total_check_failed = 0;
                                    foreach (DataRow dr_emp in dt_excel.Rows)
                                    {
                                        CommonResponseMsg result_check = new CommonResponseMsg();
                                        result_check.Code = "1";
                                        result_check.Msg = "OK";

                                        List<SDeptInfo> exist_dept = null;
                                        List<SUserInfo> exist_user = null;
                                        List<SDeptUser> exist_dept_user = null;
                                        string emp_new_dept = dr_emp["新部門"].ToString();
                                        string emp_id = dr_emp["用戶名"].ToString();
                                        string[] arr_emp_new_dept = emp_new_dept.Split('\n');
                                        foreach(string dept_full_name in arr_emp_new_dept)
                                        {
                                            string[] arr_emp_new_dept1 = dept_full_name.Split(' ');
                                            string dept = arr_emp_new_dept1[arr_emp_new_dept1.Length-1];
                                            //檢查部門是否存在
                                            if (result_check.Code == "1")
                                            {
                                                exist_dept = list_dept_info.FindAll(x => Common.ToTraditional(x.dept_name) == Common.ToTraditional(dept));
                                                if (exist_dept == null || exist_dept.Count == 0)
                                                {
                                                    result_check.Code = "0";
                                                    result_check.Msg = "查無此部門";
                                                }
                                            }
                                            //檢查人員是否存在
                                            if (result_check.Code == "1")
                                            {
                                                exist_user = list_user_info.FindAll(x => x.user_name == emp_id);
                                                if (exist_user == null || exist_user.Count == 0)
                                                {
                                                    result_check.Code = "0";
                                                    result_check.Msg = "查無此帳號";
                                                }
                                            }
                                        }

                                        dr_emp["check_status"] = result_check.Msg;
                                        if (result_check.Code == "0")
                                        {
                                            total_check_failed++;
                                        }
                                        else
                                        {
                                            //檢查此帳號是否已有權限
                                            exist_dept_user = list_dept_user.FindAll(x => x.user_id == exist_user[0].user_id && x.dept_id == exist_dept[0].dept_id);
                                            SDeptUser dept_user = null;
                                            
                                            dept_user = new SDeptUser();
                                            dept_user.dept_id = exist_dept[0].dept_id;
                                            dept_user.user_id = exist_user[0].user_id;
                                            dept_user.role_id = "5870A24D-3799-4EF5-8919-A4C4313DE2DE";//部门成员
                                            /*if (arr_emp_new_dept.Length == 1)
                                            {
                                                dept_user.is_default = true;
                                            }
                                            else
                                            {
                                                dept_user.is_default = false;
                                            }*/
                                            //暫時不修改所屬部門
                                            dept_user.is_default = false;
                                            dept_user.user_type = 0;

                                            if (exist_dept_user == null || exist_dept_user.Count == 0)
                                            {    
                                                dr_emp["is_exist"] = "0";
                                            }
                                            else
                                            {
                                                dr_emp["is_exist"] = "1";
                                            }
                                            dr_emp["import_data"] = JsonConvert.SerializeObject(dept_user);   
                                        }
                                    }
                                    response.Code = "1";
                                    response.Msg = dt_excel;
                                    if (total_check_failed > 0)
                                        response.ExtraInfo = string.Format("{0}筆資料檢查異常，請修正後再次檢查", total_check_failed);
                                }
                            }
                            else
                            {
                                response.Code = "0";
                                response.Msg = "File Parsed Fail";
                            }
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = "No File";
                        }
                    }
                    else if (mode == "update")
                    {
                        List<EhrEmployee> list_ehr_employee = null;
                        using (SqlConnection conn = new SqlConnection(connectionString))
                        {
                            string str_sql_get_all_ehr_employee = "SELECT * FROM dbo.ehr_employee";
                            list_ehr_employee = conn.Query<EhrEmployee>(str_sql_get_all_ehr_employee).ToList(); 
                        }

                        var data_to_upload = HttpContext.Current.Request.Form["data_to_upload"];
                        var obj_list = Newtonsoft.Json.Linq.JArray.Parse(data_to_upload);

                        Dictionary<string, object> dic_result = new Dictionary<string, object>();
                        List<SDeptUser> list_to_update_dept_user = new List<SDeptUser>();
                        List<EhrEmployee> list_to_update_ehr_employee = new List<EhrEmployee>();
                        foreach (var item in obj_list)
                        {
                            SDeptUser dept_user = JsonConvert.DeserializeObject<SDeptUser>(item["import_data"].ToString());
                            if (item["is_exist"].ToString() == "0")
                            {    
                                list_to_update_dept_user.Add(dept_user);
                            }

                            var exist_emp = list_ehr_employee.FindAll(x => x.wade_user_id == dept_user.user_id);
                            if (exist_emp == null || exist_emp.Count == 0)
                            {
                                //EHR沒有資料
                            }
                            else
                            {
                                exist_emp[0].dept_id = dept_user.dept_id;
                                list_to_update_ehr_employee.Add(exist_emp[0]);
                            }
                        }
                        using (SqlConnection conn = new SqlConnection(connectionString))
                        {
                            var result_insert_dept_user = conn.Insert(list_to_update_dept_user);
                            var result_insert_ehr_employee = conn.Update(list_to_update_ehr_employee);

                            response.Code = "1";
                            response.Msg = $"權限更新{result_insert_dept_user}筆，用戶更新{result_insert_ehr_employee}筆";
                        }
                    }
                    else
                    {
                        response.Code = "0";
                        response.Msg = "Unknown Mode";
                    }
                }
                else
                {
                    response.Code = "0";
                    response.Msg = "No Mode";
                }
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion
    }
}