﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Tool.Common;
namespace WebAPI.Controllers
{
    public class CustomerController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public CustomerController()
        { 
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["eflow_cur"].ConnectionString;
        } 
        [Route("Get_CustomerList")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Get_CustomerList(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @"
                                    select customer_name from c_customer a
                                where a.is_enabled=1 "
                        };
                        DataTable dt = SqlToDt(cmd);
                        response.Msg = JsonConvert.SerializeObject(dt);
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
    }


}
