﻿using ExcelDataReader;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web;
using System.Web.Http;
using System.Web.Http.Cors;
using WebAPI.Models;
using WebAPI.Tool;
using static WebAPI.Models.CommonModel;

namespace WebAPI.Controllers
{
    public class InventorController : ApiController
    {
        public InventorController()
        {
        }


        #region 獲取發明人信息
        [Route("Inventor")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage GetInventor(ParamModel param)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                JObject obj_input = JObject.Parse(param.Input.ToString());
                try
                {
                    SqlServerHelper sql_server_helper = new SqlServerHelper();

                    List<string> list_condition = new List<string>();
                    foreach (var jt in (JObject)obj_input["condition"])
                    {
                        if (jt.Value.Type == JTokenType.Integer || jt.Value.Type == JTokenType.Float)
                        {
                            list_condition.Add(jt.Key + " = " + jt.Value);
                        }
                        else
                        {
                            list_condition.Add(jt.Key + " = '" + jt.Value + "'");
                        }
                    }

                    if (list_condition.Count > 0)
                    {
                        //string sql = "UPDATE dbo.p_proc_info SET " + string.Join(",", list_fields.ToArray()) + " where proc_id = '" + id + "'";
                        string sql = string.Format(@"SELECT {0} FROM dbo.p_case_info pci
                                        LEFT JOIN dbo.p_inventor_list pil ON pci.case_id = pil.obj_id
                                        LEFT JOIN dbo.i_inventor ii ON pil.inventor_id = ii.inventor_id
                                        WHERE {1}" , obj_input["field"].ToString(), string.Join(" and ", list_condition.ToArray()));

                        DataTable dt_inventor = sql_server_helper.GetTable(sql);
                        response.Code = "1";
                        response.Msg = dt_inventor;
                    }
                    else
                    {
                        response.Code = "0";
                        response.Msg = "no input";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = e.Message;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion
    }
}