﻿using Dapper;
using DapperQueryBuilder;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Tool.Common;
namespace WebAPI.Controllers
{
    public class WadeMailController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public WadeMailController()
        { 
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["DefaultConnection"].ConnectionString;
        }
        /// <summary>
        /// 取得 Mail_js內返稿文件命名規範 資訊
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [Route("Get_essen_back_file_rule")]
        [CorsHandle]    
        [HttpPost]
        public HttpResponseMessage Get_essen_back_file_rule(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                try
                {
                    JObject obj_input = JObject.Parse(input.ToString());
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        var dysql = Conn.QueryBuilder($@"
                                        SELECT cc.customer_name,icp.ctrl_proc_zh_tw,ebfr.* FROM essen_back_file_rule ebfr
                                        left join c_customer cc on cc.customer_id =ebfr.customer_id
                                        left join i_ctrl_proc icp on icp.ctrl_proc_id =ebfr.ctrl_proc_id
                                           /**where**/ ");
                        if (obj_input["ctrl_proc_id"] != null)
                        {
                            dysql.Where( $"icp.ctrl_proc_id in ({obj_input["ctrl_proc_id"].ToString()})");
                        }
                        if (obj_input["customer_id"] != null)
                        {
                            dysql.Where($"cc.customer_id in ({obj_input["customer_id"].ToString()})");
                        }
                        if (obj_input["country_id"] != null)
                        {
                            dysql.Where($" ebfr.country_id in ({obj_input["country_id"].ToString()})"); 
                        }  
                        var results = dysql.Query(); 
                        response.Msg = JsonConvert.SerializeObject(results);
                        response.Code = "1";
                    } 
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
         
    }
}
