﻿using ExcelDataReader;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using WebAPI.Models;

namespace WebAPI.Tool
{
    public class ExcelHelper
    {
        public CommonResponseMsg LoadFromStream(Stream stream, string file_name, bool use_column_data_type = false , bool use_header_row = true)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            DataSet ds;
            string extension = Path.GetExtension(file_name);

            //判斷格式套用讀取方法
            IExcelDataReader reader = null;
            if (extension == ".xls")
            {
                Console.WriteLine(" => XLS格式");
                reader = ExcelReaderFactory.CreateBinaryReader(stream, new ExcelReaderConfiguration()
                {
                    FallbackEncoding = Encoding.GetEncoding("big5")
                });
            }
            else if (extension == ".xlsx")
            {
                Console.WriteLine(" => XLSX格式");
                reader = ExcelReaderFactory.CreateOpenXmlReader(stream);
            }
            else if (extension == ".csv")
            {
                Console.WriteLine(" => CSV格式");
                reader = ExcelReaderFactory.CreateCsvReader(stream, new ExcelReaderConfiguration()
                {
                    FallbackEncoding = Encoding.GetEncoding("big5")
                });
            }
            else if (extension == ".txt")
            {
                Console.WriteLine(" => Text(Tab Separated)格式");
                reader = ExcelReaderFactory.CreateCsvReader(stream, new ExcelReaderConfiguration()
                {
                    FallbackEncoding = Encoding.GetEncoding("big5"),
                    AutodetectSeparators = new char[] { '\t' }
                });
            }

            //沒有對應產生任何格式
            if (reader == null)
            {
                result.Code = "-1";
                result.Msg = "Format Not Support";
            }

            using (reader)
            {
                ds = reader.AsDataSet(new ExcelDataSetConfiguration()
                {
                    UseColumnDataType = use_column_data_type,
                    ConfigureDataTable = (tableReader) => new ExcelDataTableConfiguration()
                    {
                        //設定讀取資料時是否忽略標題
                        UseHeaderRow = use_header_row
                    }
                });

                result.Code = "1";
                result.Msg = ds;
            }
            return result;
        }
    }
}