﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Tool.Common;
namespace WebAPI.Controllers
{
    [RoutePrefix("Esn_Subitem")]
    public class Esn_todos_SettleController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public Esn_todos_SettleController()
        { 
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["eflow_cur"].ConnectionString;
        }
        /// <summary>
        /// 取得關帳最早日期
        /// </summary>
        /// <para ></param>
        /// <returns></returns> 
        /// 
        [Route("getSettleDate")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage get_Settle_Date(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        ;
                        String @wherecase1="", @wherecase2="";
                        SqlCommand cmd = new SqlCommand("", Conn);
                        String strsql = "";
                        strsql += @" 
                              SELECT  top 1 CONVERT(varchar(7),Settle_Date,126) Settle_Month,(
								      SELECT  top 1 CONVERT(varchar(7),Settle_Date,126) Settle_Month from [esn_todos_Settle] a
                                left join [evw_qResult_EmpDS] b on a.DSNum=b.Emp_DSNum
                                left join [evw_qResult_Dept] c on a.DeptNum=c.targetID
                                left join [evw_qResult_EmpItem] d on a.ItemNum=d.Emp_ItemNum  
                                 where 1=1 @wherecase1
							    	order by Settle_Date
								) as minSettle_Month  from [esn_todos_Settle] a
                                left join [evw_qResult_EmpDS] b on a.DSNum=b.Emp_DSNum
                                left join [evw_qResult_Dept] c on a.DeptNum=c.targetID
                                left join [evw_qResult_EmpItem] d on a.ItemNum=d.Emp_ItemNum
                                where 1=1 @wherecase2
                            ";
                        if (obj_input["Permission_furtherSql"] != null)
                        {
                            JObject objPermission_furtherSql = JObject.Parse(obj_input["Permission_furtherSql"].ToString()); 
                            if (objPermission_furtherSql["firmID"] != null && !String.IsNullOrEmpty(objPermission_furtherSql["firmID"].ToString()))
                            {
                                @wherecase1 += " and b.ID in(@DSid)";
                                @wherecase2 += " and b.ID in(@DSid)";
                                @wherecase1 = @wherecase1.Replace("@DSid", objPermission_furtherSql["firmID"].ToString());
                                @wherecase2 = @wherecase2.Replace("@DSid", objPermission_furtherSql["firmID"].ToString());

                                //cmd.Parameters.Add("@DSid", objPermission_furtherSql["firmID"].ToString());
                            }
                        } 
                        if (obj_input["Settle_Date"] != null)
                        { 
                            @wherecase2 += "  and Settle_Date between @Settle_Date and @Settle_Date ";
                            strsql += "  and Settle_Date between @Settle_Date and @Settle_Date ";
                            cmd.Parameters.AddWithValue("@Settle_Date", obj_input["Settle_Date"].ToString());
                        }
                        if (obj_input["isClosed"] != null)
                        { 
                            @wherecase2 += "  and isClosed=@isClosed ";
                            cmd.Parameters.AddWithValue("@isClosed", (obj_input["isClosed"].ToString() == "1" ? true : false));
                        }
                
                        strsql = strsql.Replace("@wherecase1", @wherecase1).Replace("@wherecase2", @wherecase2);
                        strsql += " order by a.Settle_Date";
                        response.Code = "1";
                        cmd.CommandText = strsql;
                        DataTable dt = SqlToDt(cmd);
                         response.Msg = JsonConvert.SerializeObject(dt); 

                        result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        /// <summary>
        /// 取得結算資料狀態
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [Route("getesntodosSettle")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage get_esn_todos_Settle(ParamModel param) 
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn); 
                        String strsql = "" ; 
                                strsql += String.Format(@"select a.id, Settle_Date ,isClosed ,Emp_DS ,a.update_time,b.id as DStargetid,b.Emp_DSNum   from [esn_todos_Settle] a
                                inner join [evw_qResult_EmpDS] b on a.DSNum=b.Emp_DSNum
                                left join [evw_qResult_Dept] c on a.DeptNum=c.targetID
                                left join [evw_qResult_EmpItem] d on a.ItemNum=d.Emp_ItemNum
                                where 1=1  ");
                        if (obj_input["Permission_furtherSql"] != null)
                        {
                            JObject objPermission_furtherSql = JObject.Parse(obj_input["Permission_furtherSql"].ToString());
                            if (objPermission_furtherSql["firmID"] != null && !String.IsNullOrEmpty(objPermission_furtherSql["firmID"].ToString()))
                            {
                                strsql += " and b.ID in(@DSid)";
                                strsql = strsql.Replace("@DSid", objPermission_furtherSql["firmID"].ToString());
                                //cmd.Parameters.Add("@DSid", objPermission_furtherSql["firmID"].ToString());
                            }
                            if (objPermission_furtherSql["deptID"] != null && !String.IsNullOrEmpty(objPermission_furtherSql["deptID"].ToString()))
                            {
                                //strsql += " and DeptNum in(@DeptNum)";
                                //cmd.Parameters.Add("@DeptNum", objPermission_furtherSql["deptID"].ToString());
                            }
                            if (objPermission_furtherSql["workGroupID"] != null && !String.IsNullOrEmpty(objPermission_furtherSql["workGroupID"].ToString()))
                            {
                                //strsql += " and ItemNum in(@ItemNum)";
                                //cmd.Parameters.Add("@ItemNum", objPermission_furtherSql["workGroupID"].ToString());
                            }
                        }
                        if (obj_input["Settle_Date"]!=null && !String.IsNullOrEmpty(obj_input["Settle_Date"].ToString()) ) 
                        {
                            strsql += "  and Settle_Date between @Settle_Date_begin and @Settle_Date_end ";
                            DateTime Settle_Date = Convert.ToDateTime(obj_input["Settle_Date"].ToString());
                            cmd.Parameters.AddWithValue("@Settle_Date_begin", Settle_Date );
                            cmd.Parameters.AddWithValue("@Settle_Date_end", Settle_Date.AddMonths(1).AddDays(-1) );
                        }
                        if (obj_input["isClosed"] != null )  
                        {
                            strsql += "  and isClosed=@isClosed ";
                            cmd.Parameters.AddWithValue("@isClosed", (obj_input["isClosed"].ToString()=="1"?true:false));
                        }
                            cmd.CommandText = strsql;
                            DataTable dt = SqlToDt(cmd);
                            response.Msg = JsonConvert.SerializeObject(dt);
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        /// <summary>
        /// 更新結算資料狀態
        ///
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [Route("updateesntodosSettle")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage update_esn_todos_Settle(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn);
                        String strsql = "";
                        strsql += String.Format(@"update [esn_todos_Settle] set isClosed=@isClosed , update_user_id=@gUserID_wade ,update_time=GETDATE()
                                    where id in(@ids)  ");
                        cmd.Parameters.AddWithValue("@gUserID_wade", obj_input["gUserID_wade"].ToString());
                        cmd.Parameters.AddWithValue("@isClosed", obj_input["isClosed"].ToString() == "1" ? true : false);
                        JArray idsar = JArray.Parse(obj_input["ids"].ToString());
                        if (idsar.Count > 0)
                        {
                            string t = String.Join(",", obj_input["ids"]);
                            strsql = strsql.Replace("@ids", t);
                        }

                        cmd.CommandText = strsql;
                        DataTable dt = SqlToDt(cmd);
                        response.Msg = "設定完成";
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;

        }
        /// <summary>
        /// 關閉結算資料狀態
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [Route("closeesntodosSettle")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage close_esn_todos_Settle(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                if (obj_input["Settle_Date"] == null)
                {
                    response.Msg = "需設定關帳月份";
                    response.Code = "0";
                }
                else
                {
                    try
                    {
                        using (SqlConnection Conn = new SqlConnection(connString))
                        {
                            SqlCommand cmd = new SqlCommand("", Conn);
                            String strsql = "";
                            String wherecaseu = "", wherecasei = "";
                            strsql += String.Format(@"update [esn_todos_Settle] SET isClosed = @isClosed, update_time = getdate(), update_user_id =@gUserID_wade 
					        	from (select b.id as etsid,a.id as targetid, DSNum,DeptNum, ItemNum, Settle_Date  from  evw_qResult_EmpDS a inner join [esn_todos_Settle] b on a.Emp_DSNum=b.DSNum 
								 and Settle_Date between @Settle_Date and  @Settle_Date where 1=1 @wherecaseu ) a
								where a.etsid=id   ;
						select @@ROWCOUNT;
						
						MERGE INTO esn_todos_Settle WITH(HOLDLOCK)  as target
                                USING( select Emp_DSNum,DeptNum, ItemNum, @Settle_DateNext from (select a.id as targetid,Emp_DSNum,DeptNum, ItemNum, Settle_Date,b.id as etsid  from  evw_qResult_EmpDS a left join [esn_todos_Settle] b on a.Emp_DSNum=b.DSNum  
								 and Settle_Date between @Settle_Date and  @Settle_Date) L1 
								where 1=1 @wherecasei   ) as source(DSNum, DeptNum, ItemNum, Settle_Date)
                                on(target.DSNum = source.DSNum and target.Settle_Date = source.Settle_Date)
                                WHEN NOT MATCHED THEN INSERT(Settle_Date,DSNum,DeptNum,ItemNum,isClosed, update_user_id, update_time, Create_user_id, Create_time) 
                                VALUES(@Settle_DateNext,source.DSNum,'' ,'',0,@gUserID_wade,getdate(),@gUserID_wade,getdate())
                                OUTPUT $action; ");
                            if (obj_input["Permission_furtherSql"] != null)
                            {
                                JObject objPermission_furtherSql = JObject.Parse(obj_input["Permission_furtherSql"].ToString());
                                if (objPermission_furtherSql["firmID"] != null && !string.IsNullOrWhiteSpace(objPermission_furtherSql["firmID"].ToString()))
                                {
                                    wherecasei += "  and targetid in(" + objPermission_furtherSql["firmID"].ToString() + ")";
                                    wherecaseu += "  and a.id in(" + objPermission_furtherSql["firmID"].ToString() + ")";
                                }
                            }
                            DateTime Settle_Date = Convert.ToDateTime(obj_input["Settle_Date"].ToString());
               
                            if (obj_input["ids"] != null && !string.IsNullOrWhiteSpace(obj_input["ids"].ToString()))
                            {
                                    wherecaseu += "  and  b.id in(@ids)";
                                    wherecasei += "  and  etsid in(@ids)";
                            }
                            strsql = strsql.Replace("@wherecasei", wherecasei);
                            strsql = strsql.Replace("@wherecaseu", wherecaseu);

                            if (obj_input["ids"] != null && !string.IsNullOrWhiteSpace(obj_input["ids"].ToString()))
                            {
                                JArray idsar = JArray.Parse(obj_input["ids"].ToString());
                                if (idsar.Count > 0)
                                {
                                    string t = String.Join(",", obj_input["ids"]);
                                    strsql = strsql.Replace("@ids", t);
                                }
                            }

                            cmd.Parameters.AddWithValue("@Settle_Date", Settle_Date);
                            cmd.Parameters.AddWithValue("@Settle_DateNext", Settle_Date.AddMonths(1));
                            cmd.Parameters.AddWithValue("@isClosed", (obj_input["isClosed"].ToString() == "1" ? true : false));
      
                            cmd.Parameters.AddWithValue("@gUserID_wade", obj_input["gUserID_wade"].ToString());

                            cmd.CommandText = strsql;
                            DataTable dt = SqlToDt(cmd);
                            response.Msg = "開關帳設定完成";
                            response.Code = "1";
                        }
                    }
                    catch (Exception e)
                    {
                        response.Code = "0";
                        response.Msg = "Exception:" + e.StackTrace;
                    }
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        public DataTable get_esn_todos_Settle_config( String gWadeID, bool is_enabled)
        {
            DataTable dt=null;
            try
            {
                using (SqlConnection Conn = new SqlConnection(connString))
                {
                    String sqlstr = @"select * from esn_todos_Settle_config a
                                    left join evw_Employee b on a.user_id=b.user_id
                                     where a.user_id=@user_id and a.is_enabled=@is_enabled";
                    SqlCommand cmd = new SqlCommand("", Conn)
                    {
                        CommandText = sqlstr
                    };
                    cmd.Parameters.AddWithValue("@user_id", gWadeID);
                    cmd.Parameters.AddWithValue("@is_enabled", is_enabled);
                     dt = SqlToDt(cmd);
                    return dt;
                }
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = "Exception:" + e.StackTrace;
            }
            return dt;
        }

            
        [Route("insertEsntodosSettle")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage insert_Esn_todos_Settle(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("",Conn); 
                        DataTable dtL1 = get_esn_todos_Settle_config(obj_input["gWadeID"].ToString(), true);
                        String strsql="" ,wherecase ;
                        DataRow drL1;
                        if (dtL1 != null)
                        {
                            for (int i = 0; i < dtL1.Rows.Count; i++)
                            {
                                drL1 = dtL1.Rows[i];
                                wherecase = "";

                                wherecase += " and DSNum = @DSNum" + i;
                                cmd.Parameters.AddWithValue("@DSNum" + i, drL1["DSNum"].ToString());
                                wherecase += " and DeptNum = @DeptNum" + i;
                                cmd.Parameters.AddWithValue("@DeptNum" + i, drL1["DeptNum"].ToString());
                                wherecase += " and ItemNum = @ItemNum" + i;
                                cmd.Parameters.AddWithValue("@ItemNum" + i, drL1["ItemNum"].ToString());

                                #region MERGE版

                                strsql += String.Format(@"MERGE INTO esn_todos_Settle WITH(HOLDLOCK)  as target
                                USING(select @DSNum{0}, @DeptNum{0}, @ItemNum{0} ,@Settle_Date as Settle_Date  ) as source(DSNum, DeptNum, ItemNum, Settle_Date)
                                on(target.DSNum = source.DSNum and target.DeptNum = source.DeptNum and target.ItemNum = source.ItemNum and target.Settle_Date = source.Settle_Date)
                                WHEN MATCHED THEN UPDATE SET isClosed = 1, update_time = getdate(), update_user_id = @user_id, Create_user_id = @user_id, Create_time = getdate()
                                WHEN NOT MATCHED THEN INSERT(Settle_Date,DSNum,DeptNum,ItemNum,isClosed, update_user_id, update_time, Create_user_id, Create_time) 
                                VALUES(@Settle_Date,@DSNum{0},@DeptNum{0},@ItemNum{0},1,@user_id,getdate(),@user_id,getdate())
                                OUTPUT $action; ", i);
                                #endregion 

                                //strsql.Append(@"update esn_todos_Settle set isClosed=0,update_time=getdate(),update_user_id=@user_id
                                //                where Settle_Date between @Settle_Date and  @Settle_Date ");
                                strsql += ";";
                            }
                            cmd.Parameters.AddWithValue("@Settle_Date", Convert.ToDateTime(obj_input["Settle_Date"].ToString()));
                            cmd.Parameters.AddWithValue("@user_id", obj_input["gWadeID"].ToString());
                            cmd.CommandText = strsql;
                            DataTable dt = SqlToDt(cmd);
                            response.Msg = "已關帳";
                        }
                        else
                        {
                            response.Msg = "請設定有效啟用關帳權限"; 
                        }

                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }


        [Route("getCloseSettleConfigDS")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage get_CloseSettle_ConfigDS(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn);
                        String strsql = @"select top  1 a.*,b.cn_name from esn_todos_Settle_config a
                                        left join evw_Employee b on a.user_id=b.user_id
							where a.user_id=@user_id  ";

                        cmd.Parameters.AddWithValue("@user_id", obj_input["gWadeID"].ToString());
                        cmd.CommandText = strsql;
                        DataTable dt = SqlToDt(cmd);

                        response.Code = "1";
                        response.Msg = JsonConvert.SerializeObject(dt);
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        [Route("updateCloseSettleConfigDS")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage update_CloseSettle_ConfigDS(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn); 
                        String strsql = @"MERGE INTO esn_todos_Settle_config WITH(HOLDLOCK)  as target USING(select　@user_id as user_id ,@DSNum as DSNum,@DeptNum as DeptNum,@ItemNum as ItemNum) as source(user_id,DSNum,DeptNum,ItemNum)
                            on(target.user_id = source.user_id   )
                            WHEN MATCHED THEN UPDATE SET is_enabled = @is_enabled,DSNum=@DSNum,DeptNum=@DeptNum,ItemNum=@ItemNum, update_time = getdate(), update_user_id = @user_id, Create_user_id = @user_id, Create_time = getdate()
                            WHEN NOT MATCHED THEN INSERT(user_id,DSNum,DeptNum,ItemNum,is_enabled, update_user_id, update_time, Create_user_id, Create_time) 
                            VALUES(@user_id,@DSNum,@DeptNum,@ItemNum,1,@user_id,getdate(),@user_id,getdate())
                            OUTPUT $action ;";
                           
                        cmd.Parameters.AddWithValue("@ItemNum", obj_input["ItemNum"].ToString());
                        cmd.Parameters.AddWithValue("@is_enabled", obj_input["is_enabled"].ToString());
                        cmd.Parameters.AddWithValue("@DSNum", obj_input["DSNum"].ToString());
                        cmd.Parameters.AddWithValue("@DeptNum", obj_input["DeptNum"].ToString());
                        cmd.Parameters.AddWithValue("@user_id", obj_input["gWadeID"].ToString());
                        cmd.CommandText = strsql;
                        DataTable dt = SqlToDt(cmd);

                        response.Code = "1";
                        response.Msg = "已更新";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

            
    }
}
