﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using WebAPI.Models;
using WebAPI.Tool;

namespace WebAPI.Dal
{
    public class Dal
    {
        protected SqlServerHelper sql_server_helper = new SqlServerHelper();

        public CommonResponseMsg update_by_dict(string type, string table_name, Dictionary<string, object> dic, string where_col_name = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                CommonResponseMsg result_sql = DicToSql(type, table_name, dic, where_col_name);
                if (result_sql.Code == "1")
                {
                    result.Code = "1";
                    result.Msg = sql_server_helper.ExecuteSqlCommand(result_sql.Msg.ToString());
                }
            }
            catch(Exception e)
            {
                result.Code = "0";
                result.Msg = e.Message;
            }
            return result;
        }

        public static CommonResponseMsg DicToSql(string type, string table_name, Dictionary<string, object> dic, string where_col_name = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = "";
                List<string> list_col = new List<string>();
                List<string> list_val = new List<string>();
                if (type == "insert")
                {
                    foreach (string key in dic.Keys)
                    {
                        if (dic[key] != null)
                        {
                            list_col.Add(key);
                            if (dic[key].GetType() == typeof(int))
                            {
                                list_val.Add(dic[key].ToString());
                            }
                            else
                            {
                                list_val.Add(string.Format("'{0}'", dic[key].ToString()));
                            }
                        }
                    }
                    sql = string.Format("insert into {0} ({1}) values({2})", table_name, string.Join(",", list_col), string.Join(",", list_val));
                    result.Code = "1";
                    result.Msg = sql;
                }
                else if (type == "update")
                {
                    sql = string.Format("UPDATE {0} set ", table_name);
                    int i = 0;
                    foreach (string key in dic.Keys)
                    {
                        if (key == where_col_name || dic[key] == null)
                        {
                            continue;
                        }
                        if (i > 0)
                        {
                            sql += ", ";   
                        }
                        if (dic[key].GetType() == typeof(int))
                        {
                            sql += string.Format("{0} = {1}", key, dic[key].ToString());
                        }
                        else
                        {
                            sql += string.Format("{0} = '{1}'", key, dic[key].ToString());
                        }
                        i++;
                    }
                    if (string.IsNullOrEmpty(dic[where_col_name].ToString()))
                    {
                        result.Code = "0";
                        result.Msg = "where col empty";
                    }
                    else
                    {
                        if (dic[where_col_name].GetType() == typeof(int))
                            sql += string.Format(" where {0} = {1}", where_col_name, dic[where_col_name].ToString());
                        else
                            sql += string.Format(" where {0} = '{1}'", where_col_name, dic[where_col_name].ToString());

                        result.Code = "1";
                        result.Msg = sql;
                    }

                }
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }
    }
}