﻿using Dapper;
using DapperQueryBuilder;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Tool.Common;
namespace WebAPI.Controllers
{
    public class EssenToCrmController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public EssenToCrmController()
        { 
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["DefaultConnection"].ConnectionString;
        }
        /// <summary>
        /// 取得 essen_request_info 資訊
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [Route("Get_essen_request_info")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Get_essen_request_info(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                try
                {
                    JObject obj_input = JObject.Parse(input.ToString());
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        var dysql = Conn.QueryBuilder($@"  select eri.request_id,eri.customer_id,invoice_title from essen_request_info eri 
                                            left join i_request_info iri on eri.request_id=iri.request_id 
                                           /**where**/ ");
                        if (obj_input["request_id"] != null)
                        {
                            dysql.Where( $"eri.request_id = {obj_input["request_id"].ToString()}");
                        }
                        if (obj_input["customer_id"] != null)
                        {
                            dysql.Where($" eri.customer_id = {obj_input["customer_id"].ToString()}"); 
                        }  
                        var results = dysql.Query(); 
                        response.Msg = JsonConvert.SerializeObject(results);
                        response.Code = "1";
                    } 
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
         
    }
}
