﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.IO;
using System.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Web;
using Dapper;
using Dapper.Contrib.Extensions;
using System.Web.Http;
using WebAPI.Models;
using MySql.Data.MySqlClient;
using static WebAPI.Tool.Common;
using System.Text;

namespace WebAPI.Controllers 
{
    [RoutePrefix("RoleInfo")]
    public class RoleInfoController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public RoleInfoController()
        {
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["DefaultConnection"].ConnectionString;
        }
       /// <summary>
       /// 取得角色資訊
       /// </summary>
       /// <param name="param"></param>
       /// <returns></returns>
        [Route("Get_s_role_info")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Get_s_role_info(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    string JSONString = string.Empty;
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        string sqlstr = @"select c.* from evw_Employee a
                                            left join s_user_role b on a.user_id = b.user_id
                                            left join s_role_info c on b.role_id = c.role_id
                                            where a.user_id = @user_id ";
                        if (obj_input["role_code"] != null)
                        {
                            sqlstr += " and role_code=@role_code";
                        }
                        var results = Conn.Query<Get_s_role_infoModel>(sqlstr
                        , new
                        {
                            user_id = obj_input["user_id"] == null ? "" : obj_input["user_id"].ToString(),
                            role_code = obj_input["role_code"] == null ? "" : obj_input["role_code"].ToString()
                        }
                        , commandType: CommandType.Text);
                        JSONString = JsonConvert.SerializeObject(results);
                    }

                    response.Msg = JSONString;
                    response.Code = "1";
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
    }
}
