﻿using Dapper;
using ExcelDataReader;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Web;
using System.Web.Http;
using System.Web.Http.Cors;
using WebAPI.Dal;
using WebAPI.Models;
using WebAPI.Tool;
using static WebAPI.Models.CommonModel;

namespace WebAPI.Controllers
{
    public class ProcInfoController : ApiController
    {
        String connectionString = ConfigurationManager.ConnectionStrings["DefaultConnection"].ConnectionString;

        public ProcInfoController()
        {
        }


        #region 獲取處理事項訊息
        [Route("ProcInfo")]
        [CorsHandle]
        [HttpGet]

        public HttpResponseMessage GetProcInfo(string id, string fields)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                if (string.IsNullOrWhiteSpace(id))
                {
                    response.Code = "0";
                    response.Msg = "no id";
                }
                else
                {
                    SqlServerHelper sql_server_helper = new SqlServerHelper();
                    string sql_fields = "";
                    if(string.IsNullOrWhiteSpace(fields))
                    {
                        sql_fields += "*";
                    }
                    else
                    {
                        sql_fields += fields.Trim();
                    }
                    DataTable dt = sql_server_helper.GetTable("select " + sql_fields + " FROM dbo.p_proc_info where proc_id = '" + id + "'");
                    response.Code = "1";
                    response.Msg = dt;
                }
                
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        #region 更新處理事項訊息
        [Route("ProcInfo")]
        [CorsHandle]
        [HttpPut]

        public HttpResponseMessage UpdateProcInfo(string id, [FromBody]dynamic input)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            string a = input.ToString();
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                if (string.IsNullOrWhiteSpace((id)))
                {
                    response.Code = "0";
                    response.Msg = "no id";
                }
                else
                {
                    SqlServerHelper sql_server_helper = new SqlServerHelper();
                    JObject obj_input = JObject.Parse(input.ToString());
                    List<string> list_fields = new List<string>();
                    foreach (var jt in obj_input)
                    {
                        if (jt.Value.Type == JTokenType.Integer || jt.Value.Type == JTokenType.Float)
                        {
                            list_fields.Add(jt.Key + " = " + jt.Value);
                        }
                        else
                        {
                            list_fields.Add(jt.Key + " = '" + jt.Value + "'");
                        }
                    }

                    if (list_fields.Count > 0)
                    {
                        string sql = "UPDATE dbo.p_proc_info SET " + string.Join(",", list_fields.ToArray()) + " where proc_id = '" + id + "'";
                        int updated_count = sql_server_helper.ExecuteSqlCommand(sql);
                        response.Code = "1";
                        response.Msg = updated_count;
                    }
                    else
                    {
                        response.Code = "0";
                        response.Msg = "no input";
                    }
                }

            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion


        #region 更新處理事項訊息
        [Route("ProcInfo")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage UpdateProcInfo_post(ParamModel param)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            string input = param.Input.ToString();
            if (string.IsNullOrWhiteSpace((input)))
            {
                response.Code = "0";
                response.Msg = "no input";
            }
            else
            {
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    string id = Common.isJTokenNull(obj_input["id"], "").ToString();
                    if (string.IsNullOrWhiteSpace(id))
                    {
                        response.Code = "0";
                        response.Msg = "no id";
                    }
                    else
                    {
                        SqlServerHelper sql_server_helper = new SqlServerHelper();

                        List<string> list_fields = new List<string>();
                        foreach (var jt in obj_input)
                        {
                            if (jt.Key != "id")
                            {
                                if (jt.Value.Type == JTokenType.Integer || jt.Value.Type == JTokenType.Float)
                                {
                                    list_fields.Add(jt.Key + " = " + jt.Value);
                                }
                                else
                                {
                                    list_fields.Add(jt.Key + " = '" + jt.Value + "'");
                                }
                            }
                        }

                        if (list_fields.Count > 0)
                        {
                            string sql = "UPDATE dbo.p_proc_info SET " + string.Join(",", list_fields.ToArray()) + " where proc_id = '" + id + "'";
                            int updated_count = sql_server_helper.ExecuteSqlCommand(sql);
                            response.Code = "1";
                            response.Msg = updated_count;
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = "no input";
                        }
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = e.Message;
                }
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        #region 導入費用
        [Route("ProcInfo/Fee/Import")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage ProcInfoFeeImport()
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                string mode = HttpContext.Current.Request.Form["mode"];
                string user_id = HttpContext.Current.Request.Form["user_id"];
                if (string.IsNullOrEmpty(user_id))
                {
                    user_id = System.Configuration.ConfigurationManager.AppSettings["user_id"];
                }
                bool ignore_exist_fee = true;
                if(HttpContext.Current.Request.Form["ignore_exist_fee"]!=null)
                {
                    if (HttpContext.Current.Request.Form["ignore_exist_fee"] == "0")
                    {
                        ignore_exist_fee = false;
                    }
                }
                if (!string.IsNullOrEmpty(mode))
                {
                    if (mode == "check")
                    {
                        var file = HttpContext.Current.Request.Files.Count > 0 ? HttpContext.Current.Request.Files[0] : null;
                        if (file != null)
                        {
                            ExcelHelper excel_helper = new ExcelHelper();
                            CommonResponseMsg result_excel = excel_helper.LoadFromStream(file.InputStream, file.FileName);
                            DataSet ds_excel = (DataSet)result_excel.Msg;
                            if (result_excel.Code == "1" && ds_excel.Tables.Count > 0)
                            {
                                DataTable dt_excel = ds_excel.Tables[0];
                                dt_excel.Columns.Add("id", typeof(String));
                                dt_excel.Columns.Add("check_status", typeof(String));
                                dt_excel.Columns.Add("update_status", typeof(String));
                                dt_excel.Columns.Add("import_data", typeof(String));
                                DalProcInfo dal_proc_info = new DalProcInfo();
                                DalBaseInfo dal_base_info = new DalBaseInfo();
                                DalFee dal_fee = new DalFee();
                                DalCaseInfo dal_case_info = new DalCaseInfo();

                                CommonResponseMsg result_ctrl_proc = dal_proc_info.GetCtrlProc("ctrl_proc_id, case_type_id, ctrl_proc_zh_cn, ctrl_proc_zh_tw, proc_status_id, case_status_id, country_id, business_type_id, apply_type_id");
                                CommonResponseMsg result_case_status = dal_proc_info.GetCaseStatus("case_status_id, case_type_id, case_status_zh_cn, case_status_zh_tw");
                                CommonResponseMsg result_fee_cate_workitem = dal_base_info.GetDictionaryByName("*", "fee_cate_workitem");//科目
                                CommonResponseMsg result_fo_tax_rate_name = dal_base_info.GetDictionaryByName("*", "fo_tax_rate_name");//稅別
                                CommonResponseMsg result_tax_type = dal_base_info.GetDictionaryByName("*", "tax_type");//稅計算類型
                                CommonResponseMsg result_fc_cate = dal_base_info.GetFcCategory();//程序名稱
                                CommonResponseMsg result_currency = dal_base_info.GetDataByTable("*", "i_currency");//幣別
                                CommonResponseMsg result_customer = dal_base_info.GetDataByTable("customer_id, customer_name, customer_name_en", "c_customer", true);//客戶
                                CommonResponseMsg result_case_type = dal_base_info.GetDataByTable("*", "i_case_type");//案件類型
                                CommonResponseMsg result_country = dal_base_info.GetDataByTable("*", "i_country");//國家
                                CommonResponseMsg result_apply_type = dal_base_info.GetDataByTable("*", "i_apply_type");//申請類型
                                CommonResponseMsg result_business_type = dal_base_info.GetDataByTable("*", "i_business_type");//業務類型

                                if (result_ctrl_proc.Code == "1" && result_case_status.Code == "1" && result_fee_cate_workitem.Code == "1" && result_fo_tax_rate_name.Code == "1" && result_tax_type.Code == "1" && result_fc_cate.Code == "1" && result_currency.Code == "1" && result_customer.Code == "1" && result_case_type.Code == "1" && result_country.Code == "1" && result_apply_type.Code == "1" && result_business_type.Code == "1")
                                {
                                    DataTable dt_ctrl_proc = (DataTable)result_ctrl_proc.Msg;
                                    DataTable dt_case_status = (DataTable)result_case_status.Msg;
                                    DataTable dt_fee_cate_workitem = (DataTable)result_fee_cate_workitem.Msg;
                                    DataTable dt_fo_tax_rate_name = (DataTable)result_fo_tax_rate_name.Msg;
                                    DataTable dt_tax_type = (DataTable)result_tax_type.Msg;
                                    DataTable dt_fc_cate = (DataTable)result_fc_cate.Msg;
                                    DataTable dt_currency = (DataTable)result_currency.Msg;
                                    DataTable dt_customer = (DataTable)result_customer.Msg;
                                    DataTable dt_case_type = (DataTable)result_case_type.Msg;
                                    DataTable dt_country = (DataTable)result_country.Msg;
                                    DataTable dt_apply_type = (DataTable)result_apply_type.Msg;
                                    DataTable dt_business_type = (DataTable)result_business_type.Msg;

                                    int total_check_failed = 0;
                                    foreach (DataRow dr_excel in dt_excel.Rows)
                                    {
                                        CommonResponseMsg result_check = new CommonResponseMsg();
                                        result_check.Code = "1";
                                        result_check.Msg = "OK";

                                        DataRow[] selected_ctrl_proc = null;
                                        DataRow[] selected_case_status = null;
                                        DataRow[] selected_fee_cate_workitem = null;
                                        DataRow[] selected_fo_tax_rate_name = null;
                                        DataRow[] selected_tax_type = null;
                                        DataRow[] selected_fc_cate = null;
                                        DataRow[] selected_currency = null;
                                        DataRow[] selected_customer = null;
                                        DataRow[] selected_case_type = null;
                                        DataRow[] selected_country = null;
                                        DataRow[] selected_apply_type = null;
                                        DataRow[] selected_business_type = null;

                                        DataTable dt_proc_info = null;
                                        DataTable dt_fee_type = null;

                                        DataRow dr_best_match_fee = null;

                                        CommonResponseMsg result_case_info = dal_case_info.GetCaseInfoByCaseVolume("*", dr_excel["我方文号"].ToString());//案件信息
                                        DataTable dt_case_info = (DataTable)result_case_info.Msg;
                                        //檢查案件是否存在
                                        if (result_check.Code == "1")
                                        {
                                            if (result_case_info.Code == "0" || dt_case_info.Rows.Count != 1)
                                            {
                                                result_check.Code = "0";
                                                result_check.Msg = "此案號無法找到唯一的案件";
                                            }
                                        }

                                        //檢查excel值是否合法
                                        if (result_check.Code == "1")
                                        {
                                            if (dt_excel.Columns.Contains("客户名称"))
                                            {
                                                result_check = CheckInputValid(dt_customer, "客户名称", dr_excel["客户名称"].ToString(), string.Format("customer_name = '{0}'", dr_excel["客户名称"].ToString()), true, ref selected_customer);
                                            }
                                        }
                                        if (result_check.Code == "1")
                                        {
                                            if (dt_excel.Columns.Contains("案件类型"))
                                            {
                                                result_check = CheckInputValid(dt_case_type, "案件类型", dr_excel["案件类型"].ToString(), string.Format("case_type_zh_cn = '{0}' or case_type_zh_tw = '{0}'", dr_excel["案件类型"].ToString()), true, ref selected_case_type);
                                            }
                                            else
                                            {
                                                result_check = CheckInputValid(dt_case_type, "案件类型", dt_case_info.Rows[0]["case_type_id"].ToString(), string.Format("case_type_id = '{0}'", dt_case_info.Rows[0]["case_type_id"].ToString()), true, ref selected_case_type);
                                            }
                                        }
                                        if (result_check.Code == "1")
                                        {
                                            if (dt_excel.Columns.Contains("申请国家"))
                                            {
                                                result_check = CheckInputValid(dt_country, "申请国家", dr_excel["申请国家"].ToString(), string.Format("country_id = '{0}'", dr_excel["申请国家"].ToString()), true, ref selected_country);
                                            }
                                            else
                                            {
                                                result_check = CheckInputValid(dt_country, "申请国家", dt_case_info.Rows[0]["country_id"].ToString(), string.Format("country_id = '{0}'", dt_case_info.Rows[0]["country_id"].ToString()), true, ref selected_country);
                                            }
                                        }
                                        if (result_check.Code == "1")
                                        {
                                            if (dt_excel.Columns.Contains("申请类型"))
                                            {
                                                result_check = CheckInputValid(dt_apply_type, "申请类型", dr_excel["申请类型"].ToString(), string.Format("(apply_type_zh_cn = '{0}' or apply_type_zh_tw = '{0}') and (country_id = '{1}' or country_id = 'ALL') and case_type_id = '{2}'", dr_excel["申请类型"].ToString(), selected_country.FirstOrDefault()["country_id"], selected_case_type.FirstOrDefault()["case_type_id"]), true, ref selected_apply_type);
                                            }
                                            else
                                            {
                                                result_check = CheckInputValid(dt_apply_type, "申请类型", dt_case_info.Rows[0]["apply_type_id"].ToString(), string.Format("(apply_type_id = '{0}') and (country_id = '{1}' or country_id = 'ALL') and case_type_id = '{2}'", dt_case_info.Rows[0]["apply_type_id"].ToString(), selected_country.FirstOrDefault()["country_id"], selected_case_type.FirstOrDefault()["case_type_id"]), true, ref selected_apply_type);
                                            }
                                        }
                                        if (result_check.Code == "1")
                                        {
                                            if (dt_excel.Columns.Contains("业务类型"))
                                            {
                                                result_check = CheckInputValid(dt_business_type, "业务类型", dr_excel["业务类型"].ToString(), string.Format("(business_type_zh_cn = '{0}' or business_type_zh_tw = '{0}') and case_type_id = '{1}'", dr_excel["业务类型"].ToString(), selected_case_type.FirstOrDefault()["case_type_id"]), true, ref selected_business_type);
                                            }
                                            else
                                            {
                                                result_check = CheckInputValid(dt_business_type, "业务类型", dt_case_info.Rows[0]["business_type_id"].ToString(), string.Format("(business_type_id = '{0}') and case_type_id = '{1}'", dt_case_info.Rows[0]["business_type_id"].ToString(), selected_case_type.FirstOrDefault()["case_type_id"]), true, ref selected_business_type);
                                            }
                                        }
                                        if (result_check.Code == "1")
                                        {
                                            if (dt_excel.Columns.Contains("处理事项"))
                                            {
                                                result_check = CheckInputValid(dt_ctrl_proc, "处理事项", dr_excel["处理事项"].ToString(), string.Format("(ctrl_proc_zh_cn = '{0}' or ctrl_proc_zh_tw = '{0}') and (';'+country_id+';' like '%;{1};%' or country_id = 'ALL') and (';'+business_type_id+';' like '%;{2};%' or business_type_id = 'ALL') and (';'+apply_type_id+';' like '%;{3};%' or apply_type_id = 'ALL') and ';'+case_type_id+';' like '%;{4};%'",
                                                    dr_excel["处理事项"].ToString(),
                                                    selected_country.FirstOrDefault()["country_id"],
                                                    selected_business_type.FirstOrDefault()["business_type_id"],
                                                    selected_apply_type.FirstOrDefault()["apply_type_id"],
                                                    selected_case_type.FirstOrDefault()["case_type_id"]), true, ref selected_ctrl_proc);
                                            }
                                        }
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_case_status, "案件阶段", dr_excel["案件阶段"].ToString(), string.Format("(case_status_zh_cn = '{0}' or case_status_zh_tw = '{0}') and case_type_id = '{1}'", dr_excel["案件阶段"].ToString(), selected_case_type.FirstOrDefault()["case_type_id"]), false, ref selected_case_status);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_fee_cate_workitem, "科目", dr_excel["科目"].ToString(), string.Format("text = '{0}' or text_zh_cn = '{0}' or text_zh_tw = '{0}'", dr_excel["科目"].ToString()), true, ref selected_fee_cate_workitem);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_fc_cate, "程序名称", dr_excel["程序名称"].ToString(), string.Format("text_zh_cn = '{0}' or text_zh_tw = '{0}'", dr_excel["程序名称"].ToString()), true, ref selected_fc_cate);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_currency, "币别", dr_excel["币别"].ToString(), string.Format("currency_id = '{0}'", dr_excel["币别"].ToString()), true, ref selected_currency);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_fo_tax_rate_name, "税别", dr_excel["税别"].ToString(), string.Format("text = '{0}' or text_zh_cn = '{0}' or text_zh_tw = '{0}'", dr_excel["税别"].ToString()), false, ref selected_fo_tax_rate_name);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_tax_type, "内含/外加", dr_excel["内含/外加"].ToString(), string.Format("text = '{0}' or text_zh_cn = '{0}' or text_zh_tw = '{0}'", dr_excel["内含/外加"].ToString()), false, ref selected_tax_type);

                                        //檢查處理事項是否存在且唯一
                                        if (result_check.Code == "1")
                                        {
                                            string proc_id = dr_excel["处理事项ID"].ToString();
                                            if (string.IsNullOrEmpty(proc_id))
                                            {
                                                string case_volume = dr_excel["我方文号"].ToString();
                                                string proc_name = dr_excel["处理事项"].ToString();
                                                if (!string.IsNullOrEmpty(case_volume) && !string.IsNullOrEmpty(proc_name))
                                                {
                                                    CommonResponseMsg result_proc_info = dal_proc_info.GetProcInfoByName("*", dr_excel["我方文号"].ToString(), dr_excel["处理事项"].ToString(), dr_excel["案件阶段"].ToString());
                                                    dt_proc_info = (DataTable)result_proc_info.Msg;
                                                    if (result_proc_info.Code == "0" || dt_proc_info.Rows.Count != 1)
                                                    {
                                                        result_check.Code = "0";
                                                        result_check.Msg = "此案号 + 处理事项名称无法找到唯一的处理事项";
                                                    }
                                                }
                                                else
                                                {
                                                    result_check.Code = "0";
                                                    result_check.Msg = "需要有处理事项ID或是案号+处理事项名称";
                                                }
                                            }
                                            else
                                            {
                                                CommonResponseMsg result_proc_info = dal_proc_info.GetProcInfo("proc_id", dr_excel["处理事项ID"].ToString());
                                                dt_proc_info = (DataTable)result_proc_info.Msg;
                                                if (result_proc_info.Code == "0" || dt_proc_info.Rows.Count != 1)
                                                {
                                                    result_check.Code = "0";
                                                    result_check.Msg = "此ID无法找到唯一的处理事项";
                                                }
                                            }
                                        }
                                        
                                        //檢查工作項目是否存在
                                        if (result_check.Code == "1")
                                        {
                                            CommonResponseMsg result_fee_type = dal_fee.GetFeeTypeByName("*",
                                                                                                            selected_case_type.FirstOrDefault()["case_type_id"].ToString(),
                                                                                                            selected_business_type.FirstOrDefault()["business_type_id"].ToString(),
                                                                                                            selected_apply_type.FirstOrDefault()["apply_type_id"].ToString(),
                                                                                                            selected_country.FirstOrDefault()["country_id"].ToString(),
                                                                                                            selected_fee_cate_workitem.FirstOrDefault()["value"].ToString(),
                                                                                                            selected_fc_cate.FirstOrDefault()["fc_cate_id"].ToString(),
                                                                                                            dr_excel["费用名称"].ToString());
                                            dt_fee_type = (DataTable)result_fee_type.Msg;
                                            
                                            if (result_fee_type.Code == "0" || dt_fee_type.Rows.Count == 0)
                                            {
                                                result_check.Code = "0";
                                                result_check.Msg = "无法找到唯一的工作项目";
                                            }
                                            else
                                            {
                                                dr_best_match_fee = get_best_match_fee(dt_fee_type);
                                            }
                                        }

                                        //檢查是否存在相同費用
                                        if (result_check.Code == "1")
                                        {
                                            CommonResponseMsg result_proc_fee_list = dal_fee.GetProcFeeList("*", dt_proc_info.Rows[0]["proc_id"].ToString(), dr_best_match_fee["fee_type_id"].ToString());
                                            DataTable dt_proc_fee_list = (DataTable)result_proc_fee_list.Msg;
                                            if (result_proc_fee_list.Code == "1" && dt_proc_fee_list.Rows.Count > 0)
                                            {
                                                if(ignore_exist_fee)
                                                    result_check.Code = "2";
                                                else
                                                    result_check.Code = "1";
                                                result_check.Msg = "該處理事項已存在相同費用";
                                            }
                                        }

                                        dr_excel["check_status"] = result_check.Msg;
                                        if (result_check.Code == "0")
                                        {
                                            total_check_failed++;
                                        }
                                        else if (result_check.Code == "2")
                                        {

                                        }
                                        else if (result_check.Code == "1")
                                        {
                                            CommonResponseMsg result_agency_list = dal_case_info.GetpAgencyList("*", dt_case_info.Rows[0]["case_id"].ToString());
                                            DataTable dt_agency_list = (DataTable)result_agency_list.Msg;
                                            Dictionary<string, object> dic_proc_fee = new Dictionary<string, object>();
                                            dic_proc_fee["invoice_no"] = "";
                                            dic_proc_fee["workitem_desc"] = dr_best_match_fee["workitem_desc"].ToString();
                                            dic_proc_fee["out_bill_no"] = "";
                                            dic_proc_fee["notice_date"] = null;
                                            dic_proc_fee["request_date"] = null;
                                            dic_proc_fee["tax_id"] = selected_fo_tax_rate_name.Length > 0 ? selected_fo_tax_rate_name.FirstOrDefault()["value"] : "";
                                            dic_proc_fee["recieve_currency_id"] = "CNY";
                                            dic_proc_fee["price"] = dr_excel["金额"].ToString();
                                            dic_proc_fee["receive_due_date"] = null;
                                            dic_proc_fee["request_no"] = "";
                                            dic_proc_fee["pay_due_date"] = string.IsNullOrEmpty(dr_excel["缴费期限"].ToString()) ? null : DateTime.Parse(dr_excel["缴费期限"].ToString()).ToString("yyyy/MM/dd");
                                            dic_proc_fee["pay_type"] = "0";
                                            dic_proc_fee["mid_amount"] = Math.Round(Convert.ToDecimal(float.Parse(dr_excel["金额"].ToString()) * float.Parse(dr_excel["数量"].ToString()) * float.Parse(dr_excel["汇率"].ToString())), 2, MidpointRounding.AwayFromZero);
                                            dic_proc_fee["recieve_amount"] = "0";
                                            dic_proc_fee["mid_is_divided"] = "0";
                                            dic_proc_fee["receive_date"] = null;
                                            dic_proc_fee["tax_type"] = selected_tax_type.Length > 0 ? selected_tax_type.FirstOrDefault()["value"] : "";
                                            dic_proc_fee["coefficient"] = dr_excel["数量"].ToString();
                                            dic_proc_fee["ori_rate"] = dr_excel["汇率"].ToString();
                                            dic_proc_fee["fee_type_id"] = dr_best_match_fee["fee_type_id"].ToString();
                                            dic_proc_fee["receive_status"] = "MW";
                                            dic_proc_fee["fee_id"] = Guid.NewGuid().ToString().ToUpper();
                                            dic_proc_fee["pay_date"] = null;
                                            dic_proc_fee["mid_currency_id"] = "CNY";
                                            dic_proc_fee["remark2"] = "";
                                            dic_proc_fee["proc_id"] = dt_proc_info.Rows[0]["proc_id"].ToString();
                                            dic_proc_fee["is_confirm"] = 0;
                                            dic_proc_fee["invoice_time"] = null;
                                            dic_proc_fee["remark"] = "";
                                            dic_proc_fee["currency_id"] = dr_excel["币别"].ToString();
                                            dic_proc_fee["mid_rate"] = null;
                                            dic_proc_fee["out_bill_date"] = null;
                                            dic_proc_fee["amount"] = float.Parse(dr_excel["金额"].ToString()) * float.Parse(dr_excel["数量"].ToString());
                                            dic_proc_fee["agency_id"] = (result_agency_list.Code == "1" && dt_agency_list.Rows.Count > 0) ? dt_agency_list.Rows[0]["agency_id"].ToString() : null;
                                            dic_proc_fee["ori_is_divided"] = "0";
                                            dic_proc_fee["update_time"] = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss");
                                            dic_proc_fee["update_user_id"] = user_id;

                                            dr_excel["import_data"] = JsonConvert.SerializeObject(dic_proc_fee);
                                            dr_excel["id"] = dic_proc_fee["fee_id"];
                                        }
                                    }
                                    response.Code = "1";
                                    response.Msg = dt_excel;
                                    if (total_check_failed > 0)
                                        response.ExtraInfo = string.Format("{0}筆資料檢查異常，請修正後再次檢查", total_check_failed);
                                }
                                else
                                {
                                    response.Code = "0";
                                    response.Msg = "DB Access Fail";
                                }
                            }
                            else
                            {
                                response.Code = "0";
                                response.Msg = "File Parsed Fail";
                            }
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = "No File";
                        }
                    }
                    else if(mode=="update")
                    {
                        DalProcInfo dal_proc_info = new DalProcInfo();
                        var data_to_upload = HttpContext.Current.Request.Form["data_to_upload"];
                        var obj_fee_list = JArray.Parse(data_to_upload);

                        Dictionary<string, object> dic_result = new Dictionary<string, object>();
                        foreach (var item in obj_fee_list)
                        {
                            var dic = item.ToObject<Dictionary<string, object>>();
                            //CommonResponseMsg result_update = new CommonResponseMsg();
                            //dic_result[item["fee_id"].ToString()] = "1";
                            CommonResponseMsg result_update = dal_proc_info.update_by_dict("insert", "p_proc_fee_list", dic);
                            dic_result[item["fee_id"].ToString()] = result_update.Msg;
                            LogHelper.WriteInfoLog(string.Format(@"{0};{1};{2}", result_update.Code, result_update.Msg, item["fee_id"]), this.GetType().Name+":"+ MethodBase.GetCurrentMethod().Name);
                            Thread.Sleep(500);
                        }
                        response.Code = "1";
                        response.Msg = dic_result;
                    }
                    else
                    {
                        response.Code = "0";
                        response.Msg = "Unknown Mode";
                    }
                }
                else
                {
                    response.Code = "0";
                    response.Msg = "No Mode";
                }
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        protected DataRow get_best_match_fee(DataTable dt_fee_list)
        {
            DataRow temp_row = dt_fee_list.Rows[0];
            if (dt_fee_list.Rows.Count > 1)
            {
                DataRow[] selected_fee1 = dt_fee_list.Select(string.Format("case_type_id <> 'ALL' and business_type_id <> 'ALL' and country_id <> 'ALL' and apply_type_id <> 'ALL'"));
                DataRow[] selected_fee2 = dt_fee_list.Select(string.Format("case_type_id <> 'ALL' and business_type_id = 'ALL' and country_id <> 'ALL' and apply_type_id <> 'ALL'"));
                DataRow[] selected_fee3 = dt_fee_list.Select(string.Format("case_type_id <> 'ALL' and business_type_id <> 'ALL' and country_id = 'ALL' and apply_type_id <> 'ALL'"));
                if (selected_fee1.Length > 0)
                    temp_row = selected_fee1[0];
                else if (selected_fee2.Length > 0)
                    temp_row = selected_fee2[0];
                else if (selected_fee3.Length > 0)
                    temp_row = selected_fee3[0];
            }

            return temp_row;
        }

        #region 導入處理事項
        [Route("ProcInfo/Import")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage ProcInfoImport()
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                var mode = HttpContext.Current.Request.Form["mode"];
                if (!string.IsNullOrEmpty(mode))
                {
                    if (mode == "check")
                    {
                        var file = HttpContext.Current.Request.Files.Count > 0 ? HttpContext.Current.Request.Files[0] : null;
                        if (file != null)
                        {
                            ExcelHelper excel_helper = new ExcelHelper();
                            CommonResponseMsg result_excel = excel_helper.LoadFromStream(file.InputStream, file.FileName);
                            DataSet ds_excel = (DataSet)result_excel.Msg;
                            if (result_excel.Code == "1" && ds_excel.Tables.Count > 0)
                            {
                                DataTable dt_excel = ds_excel.Tables[0];
                                dt_excel.Columns.Add("id", typeof(String));
                                dt_excel.Columns.Add("check_status", typeof(String));
                                dt_excel.Columns.Add("update_status", typeof(String));
                                dt_excel.Columns.Add("import_data", typeof(String));
                                DalProcInfo dal_proc_info = new DalProcInfo();
                                DalBaseInfo dal_base_info = new DalBaseInfo();
                                DalFee dal_fee = new DalFee();
                                DalCaseInfo dal_case_info = new DalCaseInfo();
                                CommonResponseMsg result_ctrl_proc = dal_proc_info.GetCtrlProc("ctrl_proc_id, case_type_id, ctrl_proc_zh_cn, ctrl_proc_zh_tw, proc_status_id, case_status_id");
                                CommonResponseMsg result_case_status = dal_proc_info.GetCaseStatus("case_status_id, case_type_id, case_status_zh_cn, case_status_zh_tw");
                               
                                if (result_ctrl_proc.Code == "1" && result_case_status.Code == "1")
                                {
                                    DataTable dt_ctrl_proc = (DataTable)result_ctrl_proc.Msg;
                                    DataTable dt_case_status = (DataTable)result_case_status.Msg;

                                    int total_check_failed = 0;
                                    foreach (DataRow dr_proc in dt_excel.Rows)
                                    {
                                        CommonResponseMsg result_check = new CommonResponseMsg();
                                        result_check.Code = "1";
                                        result_check.Msg = "OK";

                                        DataTable dt_proc_info = null;

                                        CommonResponseMsg result_case_info = dal_case_info.GetCaseInfoByCaseVolume("*", dr_proc["我方文号"].ToString());//案件信息
                                        DataTable dt_case_info = (DataTable)result_case_info.Msg;
                                        //檢查案件是否存在
                                        if (result_check.Code == "1")
                                        {
                                            if (result_case_info.Code == "0" || dt_case_info.Rows.Count != 1)
                                            {
                                                result_check.Code = "0";
                                                result_check.Msg = "此案號無法找到唯一的案件";
                                            }
                                        }

                                        Dictionary<string, object> dic_proc_info = new Dictionary<string, object>();
                                        //檢查處理事項是否存在且唯一
                                        if (result_check.Code == "1")
                                        {
                                            string proc_id = dr_proc["处理事项ID"].ToString();
                                            if (string.IsNullOrEmpty(proc_id))
                                            {
                                                string case_volume = dr_proc["我方文号"].ToString();
                                                string proc_name = dr_proc["处理事项"].ToString();
                                                if (!string.IsNullOrEmpty(case_volume) && !string.IsNullOrEmpty(proc_name))
                                                {
                                                    CommonResponseMsg result_proc_info = dal_proc_info.GetProcInfoByName("*", dr_proc["我方文号"].ToString(), dr_proc["处理事项"].ToString(), dr_proc["案件阶段"].ToString());
                                                    dt_proc_info = (DataTable)result_proc_info.Msg;
                                                    if (result_proc_info.Code == "0" || dt_proc_info.Rows.Count != 1)
                                                    {
                                                        result_check.Code = "0";
                                                        result_check.Msg = "此案号 + 处理事项名称无法找到唯一的处理事项";
                                                    }
                                                    else
                                                    {
                                                        dic_proc_info["proc_id"] = dt_proc_info.Rows[0]["proc_id"].ToString();
                                                    }
                                                }
                                                else
                                                {
                                                    result_check.Code = "0";
                                                    result_check.Msg = "需要有处理事项ID或是案号+处理事项名称";
                                                }
                                            }
                                            else
                                            {
                                                CommonResponseMsg result_proc_info = dal_proc_info.GetProcInfo("proc_id", dr_proc["处理事项ID"].ToString());
                                                dt_proc_info = (DataTable)result_proc_info.Msg;
                                                if (result_proc_info.Code == "0" || dt_proc_info.Rows.Count != 1)
                                                {
                                                    result_check.Code = "0";
                                                    result_check.Msg = "此ID无法找到唯一的处理事项";
                                                }
                                            }
                                        }
                                        
                                        dr_proc["check_status"] = result_check.Msg;
                                        if (result_check.Code == "0")
                                        {
                                            total_check_failed++;
                                        }
                                        else
                                        {
                                            CommonResponseMsg result_agency_list = dal_case_info.GetpAgencyList("*", dt_case_info.Rows[0]["case_id"].ToString());
                                            DataTable dt_agency_list = (DataTable)result_agency_list.Msg;
                                            if (dr_proc["返发明人日"] != null && !string.IsNullOrEmpty(dr_proc["返发明人日"].ToString()))
                                            {
                                                dic_proc_info["back_inventor_date"] = DateTime.Parse(dr_proc["返发明人日"].ToString()).ToString("yyyy-MM-dd");
                                            }
                                            if (dr_proc["返稿日"] != null && !string.IsNullOrEmpty(dr_proc["返稿日"].ToString()))
                                            {
                                                dic_proc_info["back_date"] = DateTime.Parse(dr_proc["返稿日"].ToString()).ToString("yyyy-MM-dd");
                                            }
                                            if (dr_proc["客户期限"] != null && !string.IsNullOrEmpty(dr_proc["客户期限"].ToString()))
                                            {
                                                dic_proc_info["cus_due_date"] = DateTime.Parse(dr_proc["客户期限"].ToString()).ToString("yyyy-MM-dd");
                                            }
                                            dr_proc["id"] = dic_proc_info["proc_id"];
                                            dr_proc["import_data"] = JsonConvert.SerializeObject(dic_proc_info); 
                                        }
                                    }
                                    response.Code = "1";
                                    response.Msg = dt_excel;
                                    if (total_check_failed > 0)
                                        response.ExtraInfo = string.Format("{0}筆資料檢查異常，請修正後再次檢查", total_check_failed);
                                }
                                else
                                {
                                    response.Code = "0";
                                    response.Msg = "DB Access Fail";
                                }
                            }
                            else
                            {
                                response.Code = "0";
                                response.Msg = "File Parsed Fail";
                            }
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = "No File";
                        }
                    }
                    else if (mode == "update")
                    {
                        DalProcInfo dal_proc_info = new DalProcInfo();
                        var data_to_upload = HttpContext.Current.Request.Form["data_to_upload"];
                        var obj_fee_list = JArray.Parse(data_to_upload);

                        Dictionary<string, object> dic_result = new Dictionary<string, object>();
                        foreach (var item in obj_fee_list)
                        {
                            var dic = item.ToObject<Dictionary<string, object>>();
                            CommonResponseMsg result_sql = dal_proc_info.update_by_dict("update", "p_proc_info", dic, "proc_id");
                            dic_result[item["proc_id"].ToString()] = result_sql.Msg;
                            LogHelper.WriteInfoLog($"{this.GetType().Name}_{MethodBase.GetCurrentMethod().Name}:{item["proc_id"]}_{result_sql.Code}_{result_sql.Msg}");
                            Thread.Sleep(1000);
                        }
                        response.Code = "1";
                        response.Msg = dic_result;
                    }
                    else
                    {
                        response.Code = "0";
                        response.Msg = "Unknown Mode";
                    }
                }
                else
                {
                    response.Code = "0";
                    response.Msg = "No Mode";
                }
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        #region 根據規則生成處理事項費用
        [Route("ProcInfo/FeeListForecast")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage ProcInfoFeeListForecast()
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                var mode = HttpContext.Current.Request.Form["mode"];
                if (!string.IsNullOrEmpty(mode))
                {
                    if (mode == "check")
                    {
                        var file = HttpContext.Current.Request.Files.Count > 0 ? HttpContext.Current.Request.Files[0] : null;
                        if (file != null)
                        {
                            ExcelHelper excel_helper = new ExcelHelper();
                            CommonResponseMsg result_excel = excel_helper.LoadFromStream(file.InputStream, file.FileName);
                            DataSet ds_excel = (DataSet)result_excel.Msg;
                            if (result_excel.Code == "1" && ds_excel.Tables.Count > 0)
                            {
                                DataTable dt_excel = ds_excel.Tables[0];
                                dt_excel.Columns.Add("id", typeof(String));
                                dt_excel.Columns.Add("check_status", typeof(String));
                                dt_excel.Columns.Add("update_status", typeof(String));
                                dt_excel.Columns.Add("import_data", typeof(String));
                                DalProcInfo dal_proc_info = new DalProcInfo();
                                DalBaseInfo dal_base_info = new DalBaseInfo();
                                DalFee dal_fee = new DalFee();
                                DalCaseInfo dal_case_info = new DalCaseInfo();
                                CommonResponseMsg result_ctrl_proc = dal_proc_info.GetCtrlProc("ctrl_proc_id, case_type_id, ctrl_proc_zh_cn, ctrl_proc_zh_tw, proc_status_id, case_status_id, country_id, business_type_id, apply_type_id");
                                CommonResponseMsg result_case_status = dal_proc_info.GetCaseStatus("case_status_id, case_type_id, case_status_zh_cn, case_status_zh_tw");
                                CommonResponseMsg result_fee_cate_workitem = dal_base_info.GetDictionaryByName("*", "fee_cate_workitem");//科目
                                CommonResponseMsg result_fo_tax_rate_name = dal_base_info.GetDictionaryByName("*", "fo_tax_rate_name");//稅別
                                CommonResponseMsg result_tax_type = dal_base_info.GetDictionaryByName("*", "tax_type");//稅計算類型
                                CommonResponseMsg result_fc_cate = dal_base_info.GetFcCategory();//程序名稱
                                CommonResponseMsg result_currency = dal_base_info.GetDataByTable("*", "i_currency");//幣別
                                CommonResponseMsg result_customer = dal_base_info.GetDataByTable("customer_id, customer_name, customer_name_en", "c_customer", true);//客戶
                                CommonResponseMsg result_case_type = dal_base_info.GetDataByTable("*", "i_case_type");//案件類型
                                CommonResponseMsg result_country = dal_base_info.GetDataByTable("*", "i_country");//國家
                                CommonResponseMsg result_apply_type = dal_base_info.GetDataByTable("*", "i_apply_type");//申請類型
                                CommonResponseMsg result_business_type = dal_base_info.GetDataByTable("*", "i_business_type");//業務類型
                                if (result_ctrl_proc.Code == "1" && result_case_status.Code == "1" && result_fee_cate_workitem.Code == "1" && result_fo_tax_rate_name.Code == "1" && result_tax_type.Code == "1" && result_fc_cate.Code == "1" && result_currency.Code == "1" && result_customer.Code == "1" && result_case_type.Code == "1" && result_country.Code == "1" && result_apply_type.Code == "1" && result_business_type.Code=="1")
                                {
                                    DataTable dt_ctrl_proc = (DataTable)result_ctrl_proc.Msg;
                                    DataTable dt_case_status = (DataTable)result_case_status.Msg;
                                    DataTable dt_fee_cate_workitem = (DataTable)result_fee_cate_workitem.Msg;
                                    DataTable dt_fo_tax_rate_name = (DataTable)result_fo_tax_rate_name.Msg;
                                    DataTable dt_tax_type = (DataTable)result_tax_type.Msg;
                                    DataTable dt_fc_cate = (DataTable)result_fc_cate.Msg;
                                    DataTable dt_currency = (DataTable)result_currency.Msg;
                                    DataTable dt_customer = (DataTable)result_customer.Msg;
                                    DataTable dt_case_type = (DataTable)result_case_type.Msg;
                                    DataTable dt_country = (DataTable)result_country.Msg;
                                    DataTable dt_apply_type = (DataTable)result_apply_type.Msg;
                                    DataTable dt_business_type = (DataTable)result_business_type.Msg;
                                    Dictionary<string, object> dic_fee_rule = new Dictionary<string, object>();
                                    int total_check_failed = 0;
                                    foreach (DataRow dr_excel in dt_excel.Rows)
                                    {
                                        CommonResponseMsg result_check = new CommonResponseMsg();
                                        result_check.Code = "1";
                                        result_check.Msg = "OK";

                                        DataRow[] selected_ctrl_proc = null;
                                        DataRow[] selected_case_status = null;
                                        DataRow[] selected_fee_cate_workitem = null;
                                        DataRow[] selected_fo_tax_rate_name = null;
                                        DataRow[] selected_tax_type = null;
                                        DataRow[] selected_fc_cate = null;
                                        DataRow[] selected_currency = null;
                                        DataRow[] selected_customer = null;
                                        DataRow[] selected_case_type = null;
                                        DataRow[] selected_country = null;
                                        DataRow[] selected_apply_type = null;
                                        DataRow[] selected_business_type = null;

                                        DataTable dt_proc_info = null;
                                        DataTable dt_fee_type = null;

                                        //檢查excel值是否合法
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_customer, "客户名称", dr_excel["客户名称"].ToString(), string.Format("customer_name = '{0}'", dr_excel["客户名称"].ToString()), true, ref selected_customer);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_case_type, "案件类型", dr_excel["案件类型"].ToString(), string.Format("case_type_zh_cn = '{0}' or case_type_zh_tw = '{0}'", dr_excel["案件类型"].ToString()), true, ref selected_case_type);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_country, "申请国家", dr_excel["申请国家"].ToString(), string.Format("country_id = '{0}'", dr_excel["申请国家"].ToString()), true, ref selected_country);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_apply_type, "申请类型", dr_excel["申请类型"].ToString(), string.Format("(apply_type_zh_cn = '{0}' or apply_type_zh_tw = '{0}') and (country_id = '{1}' or country_id = 'ALL') and case_type_id = '{2}'", dr_excel["申请类型"].ToString(), selected_country.FirstOrDefault()["country_id"], selected_case_type.FirstOrDefault()["case_type_id"]), true, ref selected_apply_type);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_business_type, "业务类型", dr_excel["业务类型"].ToString(), string.Format("(business_type_zh_cn = '{0}' or business_type_zh_tw = '{0}') and case_type_id = '{1}'", dr_excel["业务类型"].ToString(), selected_case_type.FirstOrDefault()["case_type_id"]), true, ref selected_business_type);
                                        if (result_check.Code == "1")
                                        {
                                            result_check = CheckInputValid(dt_ctrl_proc, "处理事项", dr_excel["处理事项"].ToString(), string.Format("(ctrl_proc_zh_cn = '{0}' or ctrl_proc_zh_tw = '{0}') and (';'+country_id+';' like '%;{1};%' or country_id = 'ALL') and (';'+business_type_id+';' like '%;{2};%' or business_type_id = 'ALL') and (';'+apply_type_id+';' like '%;{3};%' or apply_type_id = 'ALL') and ';'+case_type_id+';' like '%;{4};%'",
                                                dr_excel["处理事项"].ToString(),
                                                selected_country.FirstOrDefault()["country_id"],
                                                selected_business_type.FirstOrDefault()["business_type_id"],
                                                selected_apply_type.FirstOrDefault()["apply_type_id"],
                                                selected_case_type.FirstOrDefault()["case_type_id"]), true, ref selected_ctrl_proc);
                                        }
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_case_status, "案件阶段", dr_excel["案件阶段"].ToString(), string.Format("(case_status_zh_cn = '{0}' or case_status_zh_tw = '{0}') and case_type_id = '{1}'", dr_excel["案件阶段"].ToString(), selected_case_type.FirstOrDefault()["case_type_id"]), false, ref selected_case_status);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_fee_cate_workitem, "科目", dr_excel["科目"].ToString(), string.Format("text = '{0}' or text_zh_cn = '{0}' or text_zh_tw = '{0}'", dr_excel["科目"].ToString()), false, ref selected_fee_cate_workitem);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_fc_cate, "程序名称", dr_excel["程序名称"].ToString(), string.Format("text_zh_cn = '{0}' or text_zh_tw = '{0}'", dr_excel["程序名称"].ToString()), false, ref selected_fc_cate);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_currency, "币别", dr_excel["币别"].ToString(), string.Format("currency_id = '{0}'", dr_excel["币别"].ToString()), false, ref selected_currency);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_fo_tax_rate_name, "税别", dr_excel["税别"].ToString(), string.Format("text = '{0}' or text_zh_cn = '{0}' or text_zh_tw = '{0}'", dr_excel["税别"].ToString()), false, ref selected_fo_tax_rate_name);
                                        if (result_check.Code == "1")
                                            result_check = CheckInputValid(dt_tax_type, "内含/外加", dr_excel["内含/外加"].ToString(), string.Format("text = '{0}' or text_zh_cn = '{0}' or text_zh_tw = '{0}'", dr_excel["内含/外加"].ToString()), false, ref selected_tax_type);

                                        //檢查工作項目是否存在
                                        if (result_check.Code == "1")
                                        {
                                            CommonResponseMsg result_fee_type = dal_fee.GetFeeTypeByRule("*",
                                                                                                            selected_case_type.FirstOrDefault()["case_type_id"].ToString(),
                                                                                                            selected_business_type.FirstOrDefault()["business_type_id"].ToString(),
                                                                                                            selected_apply_type.FirstOrDefault()["apply_type_id"].ToString(),
                                                                                                            selected_country.FirstOrDefault()["country_id"].ToString(),
                                                                                                            selected_fee_cate_workitem.FirstOrDefault()["value"].ToString(),
                                                                                                            selected_fc_cate.FirstOrDefault()["fc_cate_id"].ToString(),
                                                                                                            dr_excel["费用名称"].ToString());
                                            dt_fee_type = (DataTable)result_fee_type.Msg;
                                            if (result_fee_type.Code == "0" || dt_fee_type.Rows.Count == 0)
                                            {
                                                result_check.Code = "0";
                                                result_check.Msg = "无法找到唯一的工作项目";
                                            }
                                            else
                                            {
                                                string rule_name = string.Format("{0}_{1}_{2}_{3}_{4}_{5}_{6}_{7}",
                                                    (selected_customer != null ? selected_customer.FirstOrDefault()["customer_id"] : ""),
                                                    (selected_case_type != null ? selected_case_type.FirstOrDefault()["case_type_id"] : ""),
                                                    (selected_business_type != null ? selected_business_type.FirstOrDefault()["business_type_id"] : ""),
                                                    (selected_country != null ? selected_country.FirstOrDefault()["country_id"] : ""),
                                                    (selected_apply_type != null ? selected_apply_type.FirstOrDefault()["apply_type_id"] : ""),
                                                    (selected_ctrl_proc != null ? selected_ctrl_proc.FirstOrDefault()["ctrl_proc_id"] : ""),
                                                    (selected_case_status != null ? selected_case_status.FirstOrDefault()["case_status_id"] : ""),
                                                    (dr_excel["费用名称"].ToString().Contains("英文PCT")?"1":"0"));
                                                rule_name = rule_name.Replace("ALL", ".+");
                                                if (!dic_fee_rule.Keys.Contains(rule_name))
                                                {
                                                    dic_fee_rule[rule_name] = new List<DataRow>();
                                                }
                                                ((List<DataRow>)dic_fee_rule[rule_name]).Add(dr_excel);
                                            }
                                        }

                                        //檢查是否存在相同費用
                                        /*CommonResponseMsg result_proc_fee_list = dal_fee.GetProcFeeList("*", dt_proc_info.Rows[0]["proc_id"].ToString(), dt_fee_type.Rows[0]["fee_type_id"].ToString());
                                        DataTable dt_proc_fee_list = (DataTable)result_proc_fee_list.Msg;
                                        if (result_proc_fee_list.Code == "1" && dt_proc_fee_list.Rows.Count > 0)
                                        {
                                            result_check.Code = "2";
                                            result_check.Msg = "該處理事項已存在相同費用";
                                        }*/

                                        dr_excel["check_status"] = result_check.Msg;
                                        if (result_check.Code == "0")
                                        {
                                            total_check_failed++;
                                        }
                                        else if (result_check.Code == "2")
                                        {

                                        }
                                        else if (result_check.Code == "1")
                                        {
                                          
                                        }
                                    }

                                    response.Code = "1";
                                    response.Msg = dt_excel;
                                    if (total_check_failed > 0)
                                        response.ExtraInfo = string.Format("{0}筆資料檢查異常，請修正後再次檢查", total_check_failed);
                                    else
                                    {
                                        //從excel獲取客戶清單
                                        DataView view = new DataView(dt_excel);
                                        DataTable dt_distinct_customer = view.ToTable(true, "客户名称");
                                        List<string> list_customer_id = new List<string>();
                                        foreach (DataRow dr in dt_distinct_customer.Rows)
                                        {
                                            DataRow selected_customer = dt_customer.Select(string.Format("customer_name='{0}'", dr[0])).FirstOrDefault();
                                            if (selected_customer != null)
                                            {
                                                string customer_id = selected_customer["customer_id"].ToString();
                                                list_customer_id.Add(customer_id);
                                                //break;
                                            }
                                        }
                                        CommonResponseMsg result_proc_info_list_for_forecast = dal_proc_info.GetProcInfoListForForecast(string.Join(",", list_customer_id.ToArray()), "create_time", "2021-01-01", "");
                                        DataTable dt_output = CreateFeeForecast((DataTable)result_proc_info_list_for_forecast.Msg, dic_fee_rule);
                                        response.Code = "2";
                                        response.Msg = dt_output;
                                    }
                                }
                                else
                                {
                                    response.Code = "0";
                                    response.Msg = "DB Access Fail";
                                }
                            }
                            else
                            {
                                response.Code = "0";
                                response.Msg = "File Parsed Fail";
                            }
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = "No File";
                        }
                    }
                    else if (mode == "update")
                    {
                        DalProcInfo dal_proc_info = new DalProcInfo();
                        var data_to_upload = HttpContext.Current.Request.Form["data_to_upload"];
                        var obj_fee_list = JArray.Parse(data_to_upload);

                        Dictionary<string, object> dic_result = new Dictionary<string, object>();
                        foreach (var item in obj_fee_list)
                        {
                            var dic = item.ToObject<Dictionary<string, object>>();
                            //CommonResponseMsg result_update = new CommonResponseMsg();
                            //dic_result[item["fee_id"].ToString()] = "1";
                            CommonResponseMsg result_update = dal_proc_info.update_by_dict("insert", "p_proc_fee_list", dic);
                            dic_result[item["fee_id"].ToString()] = result_update.Msg;

                            LogHelper.WriteInfoLog(string.Format(@"{0};{1};{2}", result_update.Code, result_update.Msg, item["fee_id"]), this.GetType().Name + ":" + MethodBase.GetCurrentMethod().Name);
                        }
                        response.Code = "1";
                        response.Msg = dic_result;
                    }
                    else
                    {
                        response.Code = "0";
                        response.Msg = "Unknown Mode";
                    }
                }
                else
                {
                    response.Code = "0";
                    response.Msg = "No Mode";
                }
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        protected CommonResponseMsg CheckInputValid(DataTable dt, string name, string value, string condition, bool is_required, ref DataRow[] selected)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            result.Code = "1";
            result.Msg = "OK";
            if (string.IsNullOrEmpty(value))
            {
                if (is_required)
                {
                    result.Code = "0";
                    result.Msg = name + "需填寫";
                }
            }
            else
            {
                if (value == "ALL")
                {
                    DataRow[] temp_rows = new DataRow[1];
                    DataRow temp_row = dt.NewRow();
                    temp_row[0] = "ALL";
                    temp_rows[0] = temp_row;
                    selected = temp_rows;
                }
                else
                {
                    selected = dt.Select(condition);
                }
                if (selected.Length == 0)
                {
                    result.Code = "0";
                    result.Msg = "無此" + name;
                }
            }
            return result;
        }

        protected DataTable CreateFeeForecast(DataTable dt_proc_list, Dictionary<string, object> dic_rule)
        {
            DataTable dt = new DataTable();
            dt.Columns.Add("我方文号", typeof(String));
            dt.Columns.Add("案件类型", typeof(String));
            dt.Columns.Add("业务类型", typeof(String));
            dt.Columns.Add("申请国家", typeof(String));
            dt.Columns.Add("申请类型", typeof(String));
            dt.Columns.Add("客户名称", typeof(String));
            dt.Columns.Add("处理事项ID", typeof(String));
            dt.Columns.Add("处理事项", typeof(String));
            dt.Columns.Add("案件阶段", typeof(String));
            dt.Columns.Add("科目", typeof(String));
            dt.Columns.Add("程序名称", typeof(String));
            dt.Columns.Add("费用名称", typeof(String));
            dt.Columns.Add("金额", typeof(Decimal));
            dt.Columns.Add("币别", typeof(String));
            dt.Columns.Add("税别", typeof(String));
            dt.Columns.Add("内含/外加", typeof(String));
            dt.Columns.Add("缴费期限", typeof(String));
            dt.Columns.Add("备注", typeof(String));
            foreach (DataRow dr in dt_proc_list.Rows)
            {
                if (dr["case_volume"].ToString() == "SZ190740-CN")
                {
                    string a = "";
                }
                string rule_name = string.Format("{0}_{1}_{2}_{3}_{4}_{5}_{6}_{7}",
                                                    dr["customer_id"],
                                                    dr["case_type_id"],
                                                    dr["business_type_id"],
                                                    dr["country_id"],
                                                    dr["apply_type_id"],
                                                    dr["ctrl_proc_id"],
                                                    dr["case_status_id"],
                                                    (dr["country_id"].ToString() == "WO" && !string.IsNullOrEmpty(dr["case_name_en"].ToString()) ? "1" : "0"));

                DataRow new_row = dt.NewRow();
                new_row["我方文号"] = dr["case_volume"];
                new_row["案件类型"] = dr["case_type_zh_cn"];
                new_row["业务类型"] = dr["business_type_zh_cn"];
                new_row["申请国家"] = dr["country_id"];
                new_row["申请类型"] = dr["apply_type_zh_cn"];
                new_row["客户名称"] = dr["customer_name"];
                new_row["处理事项ID"] = dr["proc_id"];
                new_row["处理事项"] = dr["ctrl_proc_zh_cn"];
                new_row["案件阶段"] = dr["case_status_zh_cn"];

                List<DataRow> rule_fired = null;
                foreach (string key in dic_rule.Keys)
                {
                    Match m = Regex.Match(rule_name, key, RegexOptions.IgnoreCase);
                    if (m.Length > 0)
                    {
                        rule_fired = (List<DataRow>)dic_rule[key];
                        break;
                    }
                }

                if (rule_fired != null && rule_fired.Count > 0)
                {
                    foreach (DataRow dr_rule in rule_fired)
                    {
                        DataRow rule_row = dt.NewRow();
                        rule_row.ItemArray = new_row.ItemArray.Clone() as object[];

                        if ((dr["ctrl_proc_zh_cn"].ToString() == "新申请" || dr["ctrl_proc_zh_cn"].ToString() == "申请前检索") && dr["last_flag"] == DBNull.Value)
                        {
                            //新申请跟申请前检索只有最後一次收費
                        }
                        else
                        {
                            rule_row["科目"] = dr_rule["科目"];
                            rule_row["程序名称"] = dr_rule["程序名称"];
                            rule_row["费用名称"] = dr_rule["费用名称"];
                            rule_row["金额"] = Convert.ToDecimal(dr_rule["金额"]);
                            rule_row["币别"] = dr_rule["币别"];
                            rule_row["税别"] = dr_rule["税别"];
                            rule_row["内含/外加"] = dr_rule["内含/外加"];
                            rule_row["缴费期限"] = "";
                            rule_row["备注"] = "";
                        }
                        dt.Rows.Add(rule_row);
                    }
                }
                else
                {
                    dt.Rows.Add(new_row);
                }
            }
            return dt;
        }

        #region 查詢流程節點處理人
        [Route("ProcInfo/Flow/Doer")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage get_procinfo_flow_doer()
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                var case_volume = HttpContext.Current.Request.Form["case_volume"];
                var country_id = HttpContext.Current.Request.Form["country_id"];
                List<string> list_country_id = null;
                var customer_name = HttpContext.Current.Request.Form["customer_name"];
                var ctrl_proc_id = HttpContext.Current.Request.Form["ctrl_proc_id"];
                var proc_status_id = HttpContext.Current.Request.Form["proc_status_id"];
                var finish_date_s = HttpContext.Current.Request.Form["finish_date_s"];
                var finish_date_e = HttpContext.Current.Request.Form["finish_date_e"];
                var node_id = HttpContext.Current.Request.Form["node_id"];

                using (SqlConnection conn = new SqlConnection(connectionString))
                {
                    string str_sql = @"select pci.case_volume,cc.customer_name,icp.ctrl_proc_zh_cn,ics.case_status_zh_cn,ips.proc_status_zh_cn,ppi.finish_date,sfn.node_name_zh_cn,sui.cn_name,sfh.audit_time,sat.audit_type_zh_cn,sfh.remark
                                        from p_case_info pci
                                        inner join p_proc_info ppi on pci.case_id = ppi.case_id
                                        inner join i_ctrl_proc icp on ppi.ctrl_proc_id = icp.ctrl_proc_id
                                        inner join c_customer cc on pci.customer_id = cc.customer_id
                                        left join i_proc_status ips on ppi.proc_status_id = ips.proc_status_id
                                        inner join e_filing_info efi on pci.case_id = efi.case_id and ppi.proc_id = efi.proc_id
                                        inner join s_flow_history sfh on efi.filing_id = sfh.obj_id
                                        inner join s_flow_node sfn on sfh.node_id = sfn.node_id
                                        inner join s_user_info sui on sfh.audit_user_id = sui.user_id
                                        left join s_audit_type sat on sfh.audit_type_id = sat.audit_id
                                        left join i_case_status ics on ppi.review_stage = ics.case_status_id";
                    List<string> arr_where = new List<string>();
                    if (case_volume!=null && !string.IsNullOrEmpty(case_volume))
                    {
                        arr_where.Add("pci.case_volume like @case_volume");
                        case_volume = "%" + case_volume + "%";
                    }
                    if (country_id != null && !string.IsNullOrEmpty(country_id))
                    {
                        list_country_id = country_id.Split(',').ToList();
                        arr_where.Add("pci.country_id in @list_country_id");
                    }
                    if (customer_name != null && !string.IsNullOrEmpty(customer_name))
                    {
                        arr_where.Add("cc.customer_name like @customer_name");
                        customer_name = "%" + customer_name + "%";
                    }
                    if (ctrl_proc_id != null && !string.IsNullOrEmpty(ctrl_proc_id))
                    {
                        arr_where.Add("ppi.ctrl_proc_id = @ctrl_proc_id");
                    }
                    if (proc_status_id != null && !string.IsNullOrEmpty(proc_status_id))
                    {
                        arr_where.Add("ppi.proc_status_id = @proc_status_id");
                    }
                    if (finish_date_s != null && !string.IsNullOrEmpty(finish_date_s))
                    {
                        arr_where.Add("ppi.finish_date >= @finish_date_s");
                        finish_date_s = finish_date_s + " 00:00:00";
                    }
                    if (finish_date_e != null && !string.IsNullOrEmpty(finish_date_e))
                    {
                        arr_where.Add("ppi.finish_date <= @finish_date_e");
                        finish_date_e = finish_date_e + " 23:59:59";
                    }
                    if (node_id != null && !string.IsNullOrEmpty(node_id))
                    {
                        arr_where.Add("sfn.node_id = @node_id");
                    }
                    if(arr_where.Count>0)
                    {
                        str_sql += " where ";
                        str_sql += string.Join(" and ", arr_where);
                    }
                    List<dynamic> list_flow_doer = conn.Query<dynamic>(str_sql, 
                        new { case_volume = case_volume,
                            list_country_id = list_country_id,
                            customer_name = customer_name,
                            ctrl_proc_id = ctrl_proc_id,
                            proc_status_id = proc_status_id,
                            finish_date_s = finish_date_s,
                            finish_date_e = finish_date_e,
                            node_id = node_id
                        }).ToList();
                    response.Code = "1";
                    response.Msg = list_flow_doer;
                }
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        /// <summary>
        /// 取得期限變更歷史資料
        /// </summary>
        /// <param name="param">取得JSON</param>
        /// <returns></returns>
        [Route("ProcInfo/Get_p_case_status_history_topcus_due_date")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Get_p_case_status_history_topcus_due_date(ParamModel param)
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    SqlServerHelper sql_server_helper = new SqlServerHelper();
                    DataTable dt;
                    using (SqlCommand sqlcmd=new SqlCommand())
                    {
                        sqlcmd.CommandText = @"select top 1 cus_due_date_old from p_case_status_history a   where a.case_id=@proc_id and isnull(a.cus_due_date_old,'')!=''
                                    order by cus_due_date_old";
                        sqlcmd.Parameters.AddWithValue("@proc_id", obj_input["proc_id"].ToString());
                        dt= sql_server_helper.GetTable(sqlcmd);
                    } 
                    response.Code = "1";
                    response.Msg = dt;
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }

            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
    }
}