﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Http;
using WebAPI.Tool;

namespace WebAPI
{
    public static class WebApiConfig
    {
        public static void Register(HttpConfiguration config)
        {
            LogHelper.InitLog4Net(HttpContext.Current.Server.MapPath("\\log4net.config"));


            Version version = System.Reflection.Assembly.GetExecutingAssembly().GetName().Version;
            DateTime buildDate = DateTime.Now;
            string displayableVersion = $"{version} 啟動時間:({buildDate})"; 
            LogHelper.WriteInfoLog("建置版本:" + displayableVersion);

            //EnableCors
            config.EnableCors();
            // Web API 設定和服務

            // Web API 路由
            config.MapHttpAttributeRoutes();

            config.Routes.MapHttpRoute(
                name: "DefaultApi",
                routeTemplate: "api/{controller}/{id}",
                defaults: new { id = RouteParameter.Optional }
            );

            config.Routes.MapHttpRoute(
                name: "solApi",
                routeTemplate: "sol/{controller}/{id}",
                defaults: new { id = RouteParameter.Optional }
            );

        }
    }
}
