﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Http;
using WebAPI.Tool;

namespace WebAPI
{
    public static class WebApiConfig
    {
        public static void Register(HttpConfiguration config)
        {
            LogHelper.InitLog4Net(HttpContext.Current.Server.MapPath("\\log4net.config"));

            //EnableCors
            config.EnableCors();
            // Web API 設定和服務

            // Web API 路由
            config.MapHttpAttributeRoutes();

            config.Routes.MapHttpRoute(
                name: "DefaultApi",
                routeTemplate: "api/{controller}/{id}",
                defaults: new { id = RouteParameter.Optional }
            );

            config.Routes.MapHttpRoute(
                name: "solApi",
                routeTemplate: "sol/{controller}/{id}",
                defaults: new { id = RouteParameter.Optional }
            );

        }
    }
}
