﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Web.Http;
using System.Web.Http.Cors;
using WebAPI.Models;
using static WebAPI.Models.CommonModel;

namespace WebAPI.Controllers
{
    public class Esn_Todos_FlowController : ApiController
    {
        MessageList_ETF Outmsg;
        public Esn_Todos_FlowController()
        {
            if (Outmsg == null) Outmsg = new MessageList_ETF();
        }

        /// <summary>
        /// 取得歷史明細
        /// </summary>
        /// <param name="Get_Flow_his"></param>
        /// <returns></returns>
        [Route("Get_Flow_his")]
        //[EnableCors(origins: "http://120.78.73.107:8888,https://ipeasy.purplevineip.com,https://ipeasy.essenptl.com,http://localhost:8002",
        //headers: "*", methods: "*", SupportsCredentials = true)]
        [CorsHandle]
        [HttpPost]
        [HttpGet]
        public MessageList_ETF Get_Flow_his(int Flowid)
        {
            String connString = ConfigurationManager.ConnectionStrings["eflow_cur"].ConnectionString;

            List<Esn_Todos_Flow_his> Hislist = new List<Esn_Todos_Flow_his>();
            try
            {
                using (SqlConnection Conn = new SqlConnection(connString))
                {
                    Esn_Todos_Flow_his hisT = new Esn_Todos_Flow_his();
                    SqlCommand cmd = new SqlCommand("", Conn)
                    {
                        CommandText = @" select top 100 a.ConfirmTime
                        ,Case When a.ConfirmUserClass='PG' Then '程序' When a.ConfirmUserClass='PE' Then '承辦人'  When a.ConfirmUserClass='Leader' Then '主管' else '其他' End as ConfirmUserClass
                        ,Case When a.ConfirmMethod='CF' Then '確認' When a.ConfirmMethod='RJ' Then '退回'  When a.ConfirmMethod='RV' Then '撤回'  else '其他' End  as ConfirmMethod
                        ,a.Create_time,a.Create_User_id,b.Step_Text as ""From"",c.Step_Text as ""To"",a.Description
                        from esn_Todos_flow_his a
                        left
                        join esn_todos_Flow_StepType b on a.FromType_id = b.id
                        left
                        join esn_todos_Flow_StepType c on a.ToType_id = c.id
                        where a.Flow_id = @Flow_id
                        order by ConfirmTime desc
                    "
                    };
                    cmd.Parameters.AddWithValue("@Flow_id", Flowid);
                    DataSet ds = SqlToDs(cmd);
                    foreach (DataRow dr in ds.Tables[0].Rows)
                    {
                        hisT = new Esn_Todos_Flow_his()
                        {
                            ConfirmTime = (DateTime?)dr["ConfirmTime"],
                            ConfirmUserClass = dr["ConfirmUserClass"].ToString(),
                            ConfirmMethod = dr["ConfirmMethod"].ToString(),
                            Create_time = (DateTime?)dr["Create_time"],
                            Create_User_id = dr["Create_User_id"].ToString(),
                            From = dr["From"].ToString(),
                            To = dr["To"].ToString(),
                            Description = dr["Description"].ToString()
                        };
                        Hislist.Add(hisT);
                    }
                }
                             
                Outmsg.FlowHislist = Hislist;
                Outmsg.ListCode = 0;
                Outmsg.Listmsg = "success";
            }
            catch (Exception e)
            {
                Outmsg.ListCode = 1;
                Outmsg.Listmsg = "Exception:" + e.StackTrace;
            }
            return Outmsg;
        }
    }
}
