﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Tool.Common;
namespace WebAPI.Controllers
{
    [RoutePrefix("Esn_Subitem")]
    public class Esn_todos_SettleController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public Esn_todos_SettleController()
        { 
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["eflow_cur"].ConnectionString;
        }
        /// <summary>
        /// 取得關帳最後日期
        /// </summary>
        /// <para ></param>
        /// <returns></returns> 
        /// 
        [Route("getSettleDate")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage get_Settle_Date(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        ;
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @" 
                              SELECT  top 1 isClosed, Settle_Date
                                  FROM esn_todos_Settle a
                                    inner join  esn_todos_Settle_config b on a.DSNum=b.DSNum  -- and a.DeptNum=b.DeptNum   and a.ItemNum=b.ItemNum 
                                  where  [settle_date] between @Settle_Date and @Settle_Date  and b.is_enabled = 1;
                              SELECT  top 1 DATEADD(month,1,[settle_date]) as settle_date_next
                                 FROM esn_todos_Settle a
                                 inner join  esn_todos_Settle_config b on a.DeptNum=b.DeptNum and a.DSNum=b.DSNum and a.ItemNum=b.ItemNum 
                                  where isClosed=1
                                  order by [settle_date] desc;
                            "
                        };

                        string Settle_Date = obj_input["Settle_Date"].ToString() == "" ? "" : obj_input["Settle_Date"].ToString() + "-01";
                        cmd.Parameters.AddWithValue("@Settle_Date", Settle_Date);
                        cmd.Parameters.AddWithValue("@user_id", obj_input["gWadeID"].ToString());
                        DataSet ds = SqlToDs(cmd);
                        JObject jdata = new JObject();
                        if (ds.Tables[0].Rows.Count > 0)
                        {
                            DateTime dtemp = (DateTime)ds.Tables[0].Rows[0]["Settle_Date"] ;
                            jdata["Settle_Date"] = dtemp.ToString("yyyy-MM");
                            jdata["isClosed"] = ds.Tables[0].Rows[0]["isClosed"].ToString();
                        }
                        else
                        {
                            DateTime dtemp;
                            if (obj_input["Settle_Date"].ToString() != "")
                            {
                                dtemp = Convert.ToDateTime(obj_input["Settle_Date"].ToString());
                            }
                            else
                            {
                                dtemp = (DateTime)ds.Tables[1].Rows[0]["settle_date_next"];
                            }
                            jdata["Settle_Date"] = dtemp.ToString("yyyy-MM");
                            jdata["isClosed"] = "0";

                        }
                        //dt.Columns["settle_date_next"].ReadOnly = false; 
                   
                        response.Code = "1";
                        response.Msg = "success";
                        string JSONString = string.Empty;
                        JSONString = JsonConvert.SerializeObject(jdata);
                        response.Msg = JSONString;
                        result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        [Route("getesntodosSettle")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage get_esn_todos_Settle(ParamModel param) 
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn); 
                        String strsql = "", Permission_furtherSql = obj_input["Permission_furtherSql"].ToString(); 
                                strsql += String.Format(@"select a.id, Settle_Date ,isClosed ,Emp_DS ,a.update_time   from [esn_todos_Settle] a
                                left join [evw_qResult_EmpDS] b on a.DSNum=b.Emp_DSNum
                                left join [evw_qResult_Dept] c on a.DeptNum=c.targetID
                                left join [evw_qResult_EmpItem] d on a.ItemNum=d.Emp_ItemNum
                                where 1=1  ");

                        JObject objPermission_furtherSql = JObject.Parse(obj_input["Permission_furtherSql"].ToString()); 
                        if (obj_input["Settle_Date"]!=null) 
                        {
                            strsql += "  and Settle_Date between @Settle_Date and @Settle_Date ";
                            cmd.Parameters.Add("@Settle_Date", obj_input["Settle_Date"].ToString());
                        }
                        if (obj_input["isClosed"] != null )  
                        {
                            strsql += "  and isClosed=@isClosed ";
                            cmd.Parameters.Add("@isClosed", (obj_input["isClosed"].ToString()=="1"?true:false));
                        }
                        if (objPermission_furtherSql["firmID"] != null  ) 
                        {
                            strsql += " and b.ID in(@DSid)";
                            strsql= strsql.Replace("@DSid", objPermission_furtherSql["firmID"].ToString());
                            //cmd.Parameters.Add("@DSid", objPermission_furtherSql["firmID"].ToString());
                        }
                        if (objPermission_furtherSql["deptID"] != null  ) 
                        {
                            //strsql += " and DeptNum in(@DeptNum)";
                            //cmd.Parameters.Add("@DeptNum", objPermission_furtherSql["deptID"].ToString());
                        }
                        if (objPermission_furtherSql["workGroupID"] != null )
                        { 
                            //strsql += " and ItemNum in(@ItemNum)";
                            //cmd.Parameters.Add("@ItemNum", objPermission_furtherSql["workGroupID"].ToString());
                        }  
                            cmd.CommandText = strsql;
                            DataTable dt = SqlToDt(cmd);
                            response.Msg = JsonConvert.SerializeObject(dt);
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        [Route("updateesntodosSettle")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage update_esn_todos_Settle(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn);
                        String strsql = "" ;
                        strsql += String.Format(@"update [esn_todos_Settle] set isClosed=@isClosed , update_user_id=@gUserID_wade ,update_time=GETDATE()
                                    where id in(@ids)  ");
                        cmd.Parameters.AddWithValue("@gUserID_wade", obj_input["gUserID_wade"].ToString());
                        cmd.Parameters.AddWithValue("@isClosed", obj_input["isClosed"].ToString()=="1"?true:false);
                        JArray idsar =JArray.Parse( obj_input["ids"].ToString());
                        if (idsar.Count>0)
                        { 
                            string t= String.Join(",", obj_input["ids"]);
                            strsql=strsql.Replace("@ids", t);
                        }
                        
                        cmd.CommandText = strsql;
                        DataTable dt = SqlToDt(cmd);
                        response.Msg = "設定完成";
                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        public DataTable get_esn_todos_Settle_config( String gWadeID, bool is_enabled)
        {
            DataTable dt=null;
            try
            {
                using (SqlConnection Conn = new SqlConnection(connString))
                {
                    String sqlstr = @"select * from esn_todos_Settle_config a
                                    left join evw_Employee b on a.user_id=b.user_id
                                     where a.user_id=@user_id and a.is_enabled=@is_enabled";
                    SqlCommand cmd = new SqlCommand("", Conn)
                    {
                        CommandText = sqlstr
                    };
                    cmd.Parameters.AddWithValue("@user_id", gWadeID);
                    cmd.Parameters.AddWithValue("@is_enabled", is_enabled);
                     dt = SqlToDt(cmd);
                    return dt;
                }
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = "Exception:" + e.StackTrace;
            }
            return dt;
        }

            
        [Route("insertEsntodosSettle")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage insert_Esn_todos_Settle(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("",Conn); 
                        DataTable dtL1 = get_esn_todos_Settle_config(obj_input["gWadeID"].ToString(), true);
                        String strsql="" ,wherecase ;
                        DataRow drL1;
                        if (dtL1 != null)
                        {
                            for (int i = 0; i < dtL1.Rows.Count; i++)
                            {
                                drL1 = dtL1.Rows[i];
                                wherecase = "";

                                wherecase += " and DSNum = @DSNum" + i;
                                cmd.Parameters.AddWithValue("@DSNum" + i, drL1["DSNum"].ToString());
                                wherecase += " and DeptNum = @DeptNum" + i;
                                cmd.Parameters.AddWithValue("@DeptNum" + i, drL1["DeptNum"].ToString());
                                wherecase += " and ItemNum = @ItemNum" + i;
                                cmd.Parameters.AddWithValue("@ItemNum" + i, drL1["ItemNum"].ToString());

                                #region MERGE版

                                strsql += String.Format(@"MERGE INTO esn_todos_Settle WITH(HOLDLOCK)  as target
                                USING(select @DSNum{0}, @DeptNum{0}, @ItemNum{0} ,@Settle_Date as Settle_Date  ) as source(DSNum, DeptNum, ItemNum, Settle_Date)
                                on(target.DSNum = source.DSNum and target.DeptNum = source.DeptNum and target.ItemNum = source.ItemNum and target.Settle_Date = source.Settle_Date)
                                WHEN MATCHED THEN UPDATE SET isClosed = 1, update_time = getdate(), update_user_id = @user_id, Create_user_id = @user_id, Create_time = getdate()
                                WHEN NOT MATCHED THEN INSERT(Settle_Date,DSNum,DeptNum,ItemNum,isClosed, update_user_id, update_time, Create_user_id, Create_time) 
                                VALUES(@Settle_Date,@DSNum{0},@DeptNum{0},@ItemNum{0},1,@user_id,getdate(),@user_id,getdate())
                                OUTPUT $action; ", i);
                                #endregion 

                                //strsql.Append(@"update esn_todos_Settle set isClosed=0,update_time=getdate(),update_user_id=@user_id
                                //                where Settle_Date between @Settle_Date and  @Settle_Date ");
                                strsql += ";";
                            }
                            cmd.Parameters.AddWithValue("@Settle_Date", Convert.ToDateTime(obj_input["Settle_Date"].ToString()));
                            cmd.Parameters.AddWithValue("@user_id", obj_input["gWadeID"].ToString());
                            cmd.CommandText = strsql;
                            DataTable dt = SqlToDt(cmd);
                            response.Msg = "已關帳";
                        }
                        else
                        {
                            response.Msg = "請設定有效啟用關帳權限"; 
                        }

                        response.Code = "1";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        [Route("getCloseSettleConfigDS")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage get_CloseSettle_ConfigDS(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn);
                        String strsql = @"select top  1 a.*,b.cn_name from esn_todos_Settle_config a
                                        left join evw_Employee b on a.user_id=b.user_id
							where a.user_id=@user_id  ";

                        cmd.Parameters.AddWithValue("@user_id", obj_input["gWadeID"].ToString());
                        cmd.CommandText = strsql;
                        DataTable dt = SqlToDt(cmd);

                        response.Code = "1";
                        response.Msg = JsonConvert.SerializeObject(dt);
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

        [Route("updateCloseSettleConfigDS")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage update_CloseSettle_ConfigDS(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        SqlCommand cmd = new SqlCommand("", Conn); 
                        String strsql = @"MERGE INTO esn_todos_Settle_config WITH(HOLDLOCK)  as target USING(select　@user_id as user_id ,@DSNum as DSNum,@DeptNum as DeptNum,@ItemNum as ItemNum) as source(user_id,DSNum,DeptNum,ItemNum)
                            on(target.user_id = source.user_id   )
                            WHEN MATCHED THEN UPDATE SET is_enabled = @is_enabled,DSNum=@DSNum,DeptNum=@DeptNum,ItemNum=@ItemNum, update_time = getdate(), update_user_id = @user_id, Create_user_id = @user_id, Create_time = getdate()
                            WHEN NOT MATCHED THEN INSERT(user_id,DSNum,DeptNum,ItemNum,is_enabled, update_user_id, update_time, Create_user_id, Create_time) 
                            VALUES(@user_id,@DSNum,@DeptNum,@ItemNum,1,@user_id,getdate(),@user_id,getdate())
                            OUTPUT $action ;";
                           
                        cmd.Parameters.AddWithValue("@ItemNum", obj_input["ItemNum"].ToString());
                        cmd.Parameters.AddWithValue("@is_enabled", obj_input["is_enabled"].ToString());
                        cmd.Parameters.AddWithValue("@DSNum", obj_input["DSNum"].ToString());
                        cmd.Parameters.AddWithValue("@DeptNum", obj_input["DeptNum"].ToString());
                        cmd.Parameters.AddWithValue("@user_id", obj_input["gWadeID"].ToString());
                        cmd.CommandText = strsql;
                        DataTable dt = SqlToDt(cmd);

                        response.Code = "1";
                        response.Msg = "已更新";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }

            
    }
}
