﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using WebAPI.Models;
using WebAPI.Tool;

namespace WebAPI.Dal
{
    public class DalBaseInfo
    {
        SqlServerHelper sql_server_helper = new SqlServerHelper();
        
        public CommonResponseMsg GetDictionaryByName(string field = "*", string dictionary_name = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.s_dictionary", field);

                if (!string.IsNullOrEmpty(dictionary_name))
                {
                    sql += string.Format(@" where dictionary_name = '{0}'", dictionary_name);
                }

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetFcCategory(string field = "*", string fc_cate_id = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.i_fc_category", field);
                sql += " where is_enabled = 1";
                if (!string.IsNullOrEmpty(fc_cate_id))
                {
                    sql += string.Format(@" and fc_cate_id = '{0}'", fc_cate_id);
                }

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetDataByTable(string field, string table_name, string primary_key = null, string id = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.{1}", field, table_name);
                if (!string.IsNullOrEmpty(id))
                {
                    sql += string.Format(@" where {0} = '{1}'", primary_key, id);
                }

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }
    }
}