﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using WebAPI.Models;
using WebAPI.Tool;

namespace WebAPI.Dal
{
    public class DalBaseInfo : Dal
    {   
        public CommonResponseMsg GetDictionaryByName(string field = "*", string dictionary_name = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.s_dictionary", field);

                if (!string.IsNullOrEmpty(dictionary_name))
                {
                    sql += string.Format(@" where dictionary_name = '{0}'", dictionary_name);
                }

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetFcCategory(string field = "*", string fc_cate_id = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.i_fc_category", field);
                sql += " where is_enabled = 1";
                if (!string.IsNullOrEmpty(fc_cate_id))
                {
                    sql += string.Format(@" and fc_cate_id = '{0}'", fc_cate_id);
                }

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetDataByTable(string field, string table_name, bool? is_enabled=null, string primary_key = null, string id = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.{1}", field, table_name);
                Dictionary<string, object> dic_condition = new Dictionary<string, object>();
                if (!string.IsNullOrEmpty(id))
                {
                    dic_condition[primary_key] = id;
                }
                if (is_enabled != null)
                {
                    dic_condition["is_enabled"] = is_enabled;
                }
                int i = 0;
                foreach(string key in dic_condition.Keys)
                {
                    if (i > 0)
                        sql += " and ";
                    else
                        sql += " where ";
                    if (dic_condition[key].GetType() == typeof(int))
                        sql += string.Format(@"{0} = {1}", key, dic_condition[key]);
                    else
                        sql += string.Format(@"{0} = '{1}'", key, dic_condition[key]);
                    i++;
                }

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }
    }
}