﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using WebAPI.Models;
using WebAPI.Tool;

namespace WebAPI.Dal
{
    public class DalProcInfo
    {
        SqlServerHelper sql_server_helper = new SqlServerHelper();
        public CommonResponseMsg GetCtrlProc(string field = "*" ,string ctrl_proc_id = null, string ctrl_proc_name = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.i_ctrl_proc", field);
                if(string.IsNullOrEmpty(ctrl_proc_id))
                {
                    if(!string.IsNullOrEmpty(ctrl_proc_name))
                    {
                        sql += string.Format(@" where (ctrl_proc_zh_cn = '{0}' or ctrl_proc_zh_tw = '{0}') and is_enabled = 1", ctrl_proc_name);
                    }
                }
                else
                {
                    sql += string.Format(@" where ctrl_proc_id = '{0}' and is_enabled = 1", ctrl_proc_id);
                }
                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch(Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetCaseStatus(string field = "*", string case_status_id = null, string case_status_name = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.i_case_status", field);
                if (string.IsNullOrEmpty(case_status_id))
                {
                    if (!string.IsNullOrEmpty(case_status_name))
                    {
                        sql += string.Format(@" where (case_status_zh_cn = '{0}' or case_status_zh_tw = '{0}')", case_status_name);
                    }
                }
                else
                {
                    sql += string.Format(@" where case_status_id = '{0}'", case_status_id);
                }
                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetProcInfo(string field, string proc_id = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.p_proc_info ppi
                LEFT JOIN dbo.p_case_info pci ON ppi.case_id = pci.case_id
                LEFT JOIN dbo.i_ctrl_proc icp ON ppi.ctrl_proc_id = icp.ctrl_proc_id
                LEFT JOIN dbo.i_case_status ics ON ppi.review_stage = ics.case_status_id", field);
                sql += " where ppi.is_enabled = 1";
                if (!string.IsNullOrEmpty(proc_id))
                {
                    sql += string.Format(@" and proc_id = '{0}'", proc_id);
                }
                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }

        public CommonResponseMsg GetProcInfoByName(string field = "*", string case_volume = null, string proc_name = null, string case_status_name = null)
        {
            CommonResponseMsg result = new CommonResponseMsg();
            try
            {
                string sql = string.Format(@"SELECT {0} FROM dbo.p_proc_info ppi
                LEFT JOIN dbo.p_case_info pci ON ppi.case_id = pci.case_id
                LEFT JOIN dbo.i_ctrl_proc icp ON ppi.ctrl_proc_id = icp.ctrl_proc_id
                LEFT JOIN dbo.i_case_status ics ON ppi.review_stage = ics.case_status_id", field);
                sql += " where ppi.is_enabled = 1";
                if (!string.IsNullOrEmpty(case_volume))
                {
                    sql += string.Format(@" and case_volume = '{0}'", case_volume);
                }
                if (!string.IsNullOrEmpty(proc_name))
                {
                    sql += string.Format(@" and (ctrl_proc_zh_cn = '{0}' or ctrl_proc_zh_cn = '{0}')", proc_name);
                }
                if (!string.IsNullOrEmpty(case_status_name))
                {
                    sql += string.Format(@" and (case_status_zh_cn = '{0}' or case_status_zh_tw = '{0}')", case_status_name);
                }

                DataTable dt = sql_server_helper.GetTable(sql);
                result.Code = "1";
                result.Msg = dt;
            }
            catch (Exception err)
            {
                result.Code = "0";
                result.Msg = err.Message;
            }
            return result;
        }
    }
}