﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Net;
using System.Net.Http;
using System.Web.Http;
using WebAPI.Models;
using static WebAPI.Tool.Common;
namespace WebAPI.Controllers
{
    [RoutePrefix("Esn_Subitem")]
    public class Esn_todos_SettleController : ApiController
    {
        HttpResponseMessage result;
        CommonResponseMsg response;
        String connString;

        public Esn_todos_SettleController()
        { 
            result = new HttpResponseMessage(HttpStatusCode.OK);
            response = new CommonResponseMsg();
            connString = ConfigurationManager.ConnectionStrings["eflow_cur"].ConnectionString;
        }
        /// <summary>
        /// 取得關帳最後日期
        /// </summary>
        /// <para ></param>
        /// <returns></returns> 
        /// 
        [Route("getSettleDate")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage get_Settle_Date(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                        ;
                        SqlCommand cmd = new SqlCommand("", Conn)
                        {
                            CommandText = @" 
                              SELECT  top 1 isClosed, Settle_Date
                                  FROM esn_todos_Settle a
                                  where  [settle_date] between @Settle_Date and @Settle_Date ;
                              SELECT  top 1 DATEADD(month,1,[settle_date]) as settle_date_next
                                  FROM esn_todos_Settle
                                  where isClosed=1
                                  order by [settle_date] desc;
                            "
                        };

                        string Settle_Date = obj_input["Settle_Date"].ToString() == "" ? "" : obj_input["Settle_Date"].ToString() + "-01";
                        cmd.Parameters.AddWithValue("@Settle_Date", Settle_Date);
                        DataSet ds = SqlToDs(cmd);
                        JObject jdata = new JObject();
                        if (ds.Tables[0].Rows.Count > 0)
                        {
                            DateTime dtemp = (DateTime)ds.Tables[0].Rows[0]["Settle_Date"] ;
                            jdata["Settle_Date"] = dtemp.ToString("yyyy-MM");
                            jdata["isClosed"] = ds.Tables[0].Rows[0]["isClosed"].ToString();
                        }
                        else
                        {
                            DateTime dtemp;
                            if (obj_input["Settle_Date"].ToString() != "")
                            {
                                dtemp = Convert.ToDateTime(obj_input["Settle_Date"].ToString());
                            }
                            else
                            {
                                dtemp = (DateTime)ds.Tables[1].Rows[0]["settle_date_next"];
                            }
                            jdata["Settle_Date"] = dtemp.ToString("yyyy-MM");
                            jdata["isClosed"] = "0";

                        }
                        //dt.Columns["settle_date_next"].ReadOnly = false; 
                   
                        response.Code = "1";
                        response.Msg = "success";
                        string JSONString = string.Empty;
                        JSONString = JsonConvert.SerializeObject(jdata);
                        response.Msg = JSONString;
                        result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        [Route("UpdateSettle")]
        [CorsHandle]
        [HttpPost]
        public HttpResponseMessage Update_Esn_todos_Settle(ParamModel param)
        {
            if (param != null && param.Input != null && !string.IsNullOrWhiteSpace((param.Input.ToString())))
            {
                string input = param.Input.ToString();
                JObject obj_input = JObject.Parse(input.ToString());
                try
                {
                    using (SqlConnection Conn = new SqlConnection(connString))
                    {
                         
                        String sns = obj_input["SN"].ToString();
                        String sqlstr = @"select td.SN, tdp.SN as SN_tdp,td.points,AssignedTo_userid  FROM esn_todos td 
                                          left join esn_todos_points tdp on tdp.sn=td.sn  
                                          WHERE td.sn in ("+ sns +")";
                        String value = obj_input["value"].ToString();
                        value = value == "" ? "null" : obj_input["value"].ToString();
                        SqlCommand cmd = new SqlCommand("",Conn)
                        {
                            CommandText = sqlstr
                        };
                        cmd.Parameters.AddWithValue("@SN", obj_input["SN"].ToString());
                        DataTable dt = SqlToDt(cmd);
                        String point, AssignedTo_userID ;
                        DataRow dr;
                        sqlstr = "declare  @TempTable TABLE(id INT) declare @FlowId int; ";
                        cmd.Parameters.Clear();
                        for (int i = 0;i< dt.Rows.Count;i++ )
                        {
                            dr = dt.Rows[i];
                            point = dr["points"].ToString();
                            AssignedTo_userID = dr["AssignedTo_userID"].ToString();
                            if (dr["SN_tdp"] == DBNull.Value)
                            {
                                sqlstr += string.Format(@"insert into esn_todos_points(sn,date_points_settlement,date_points_settlement_AssignTo,date_points_settlement_Point,update_user_id,update_time) 
                                            values (@SN{0},@value,@AssignedTo_userID{0},@points{0},@gWadeID,getdate()); ", i);
                            }
                            else
                            {
                                sqlstr += string.Format(@"update esn_todos_points set date_points_settlement=@value,date_points_settlement_AssignTo=@AssignedTo_userID{0}
                                            ,date_points_settlement_Point=@points{0} ,update_user_id=@gWadeID,Update_time=GETDATE() where SN =@SN{0};", i);

                            }
                            cmd.Parameters.AddWithValue(string.Format("@SN{0}",i), dr["SN"].ToString());
                            cmd.Parameters.AddWithValue(string.Format("@AssignedTo_userID{0}", i), AssignedTo_userID);
                            cmd.Parameters.AddWithValue(string.Format("@points{0}", i), point);

                            sqlstr += string.Format(@"update esn_todos_Flow Set Is_Settlement = 1,update_user_id = @gWadeID,Update_time = GETDATE()
                                        ,StepType_id =(select id from esn_todos_Flow_StepType a where a.Map_Class='HR') output INSERTED.id INTO @TempTable where esn_todos_sn =@SN{0};
                                        select @FlowId=id from @TempTable;
                                       insert into esn_todos_Flow_his(Flow_id,ConfirmTime,FromType_id,ToType_id,ConfirmUserId,ConfirmUserClass,ConfirmMethod,Description,Create_User_id,Create_time) 
                                       select id as Flow_id,@value,a.StepType_id,StepType_id,@gWadeID,'HR','SL','確認日期:' + @value,@gWadeID,GETDATE() from esn_todos_Flow a where a.id=@FlowId;
                                        ", i);

                             
                        }
                        cmd.Parameters.AddWithValue("@value", value);
                        cmd.Parameters.AddWithValue("@gWadeID", obj_input["gWadeID"].ToString());
                        cmd.CommandText = sqlstr;
                        dt = SqlToDt(cmd);
                        response.Code = "1";
                        string JSONString = string.Empty;
                        JSONString = JsonConvert.SerializeObject(dt);
                        response.Msg = "確認完畢";
                    }
                }
                catch (Exception e)
                {
                    response.Code = "0";
                    response.Msg = "Exception:" + e.StackTrace;
                }
            }
            else
            {
                response.Code = "0";
                response.Msg = "no input or format error";
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
    }
}
