﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;
using WebAPI.Models;
using WebAPI.Tool;
using Dapper;
using System.Reflection;
using Dapper.Contrib.Extensions;

namespace WebAPI.Controllers
{
    public class UserInfoController : ApiController
    {
        String connectionString = ConfigurationManager.ConnectionStrings["DefaultConnection"].ConnectionString;

        public UserInfoController()
        {
        }


        #region 導入用戶
        [Route("UserInfo/ImportDeptUser")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage UserInfoImport()
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                var mode = HttpContext.Current.Request.Form["mode"];
                if (!string.IsNullOrEmpty(mode))
                {
                    if (mode == "check")
                    {
                        var file = HttpContext.Current.Request.Files.Count > 0 ? HttpContext.Current.Request.Files[0] : null;
                        if (file != null)
                        {

                            ExcelHelper excel_helper = new ExcelHelper();
                            CommonResponseMsg result_excel = excel_helper.LoadFromStream(file.InputStream, file.FileName);
                            DataSet ds_excel = (DataSet)result_excel.Msg;
                            if (result_excel.Code == "1" && ds_excel.Tables.Count > 0)
                            {
                                using (SqlConnection conn = new SqlConnection(connectionString))
                                {
                                    DataTable dt_excel = ds_excel.Tables[0];
                                    dt_excel.Columns.Add("check_status", typeof(String));
                                    dt_excel.Columns.Add("update_status", typeof(String));
                                    dt_excel.Columns.Add("import_data", typeof(String));
                                    string str_sql_get_all_dept = "SELECT * FROM dbo.s_dept_info WHERE is_enabled = @is_enabled";
                                    var list_dept_info = conn.Query<SDeptInfo>(str_sql_get_all_dept, new { is_enabled = 1 }).ToList();
                                    string str_sql_get_all_dept_user = "SELECT * FROM dbo.s_dept_user";
                                    var list_dept_user = conn.Query<SDeptUser>(str_sql_get_all_dept_user).ToList();
                                    string str_sql_get_all_user = "SELECT * FROM dbo.s_user_info WHERE is_enabled = @is_enabled";
                                    var list_user_info = conn.Query<SUserInfo>(str_sql_get_all_user, new { is_enabled = 1 }).ToList();

                                    int total_check_failed = 0;
                                    foreach (DataRow dr_emp in dt_excel.Rows)
                                    {
                                        CommonResponseMsg result_check = new CommonResponseMsg();
                                        result_check.Code = "1";
                                        result_check.Msg = "OK";

                                        List<SDeptInfo> exist_dept = null;
                                        List<SUserInfo> exist_user = null;
                                        List<SDeptUser> exist_dept_user = null;
                                        string emp_new_dept = dr_emp["新部門"].ToString();
                                        string emp_id = dr_emp["用戶名"].ToString();
                                        string is_default = dr_emp["所屬部門"].ToString();

                                        string[] arr_emp_new_dept = emp_new_dept.Split(' ');
                                        string dept = arr_emp_new_dept[arr_emp_new_dept.Length-1];
                                        //檢查部門是否存在
                                        if (result_check.Code == "1")
                                        {
                                            exist_dept = list_dept_info.FindAll(x => Common.ToTraditional(x.dept_name) == Common.ToTraditional(dept));
                                            if (exist_dept == null || exist_dept.Count == 0)
                                            {
                                                result_check.Code = "0";
                                                result_check.Msg = "查無此部門";
                                            }
                                        }
                                        //檢查人員是否存在
                                        if (result_check.Code == "1")
                                        {
                                            exist_user = list_user_info.FindAll(x => x.user_name == emp_id);
                                            if (exist_user == null || exist_user.Count == 0)
                                            {
                                                result_check.Code = "0";
                                                result_check.Msg = "查無此帳號";
                                            }
                                        }
                                        

                                        dr_emp["check_status"] = result_check.Msg;
                                        if (result_check.Code == "0")
                                        {
                                            total_check_failed++;
                                        }
                                        else
                                        {
                                            //檢查此帳號是否已有權限
                                            List<SDeptInfo> list_all_dept = new List<SDeptInfo>();
                                            list_all_dept.Add(exist_dept[0]);//當前部門
                                            list_all_dept.AddRange(get_all_sub_dept(exist_dept[0]));//子部門
                                            list_all_dept = list_all_dept.Distinct().ToList();
                                            List<DeptUserImportViewModel> list_dept_user_to_update = new List<DeptUserImportViewModel>();
                                            bool is_sub = false;
                                            foreach (SDeptInfo item_dept in list_all_dept)
                                            {
                                                exist_dept_user = list_dept_user.FindAll(x => x.user_id == exist_user[0].user_id && x.dept_id == item_dept.dept_id);
                                                DeptUserImportViewModel dept_user = new DeptUserImportViewModel();
                                                SDeptUser dept_user_temp = new SDeptUser();
                                                dept_user.dept_id = item_dept.dept_id;
                                                dept_user_temp.dept_id = item_dept.dept_id;
                                                dept_user.user_id = exist_user[0].user_id;
                                                dept_user_temp.user_id = exist_user[0].user_id;
                                                if (dr_emp["負責人"].ToString() == "是" && !is_sub)
                                                {
                                                    dept_user.role_id = "2EC47EE0-956D-4E83-A497-F05F4C1516B7";//部門負責人
                                                    dept_user_temp.role_id = "2EC47EE0-956D-4E83-A497-F05F4C1516B7";//部門負責人
                                                }
                                                else
                                                {
                                                    dept_user.role_id = "5870A24D-3799-4EF5-8919-A4C4313DE2DE";//部门成员
                                                    dept_user_temp.role_id = "5870A24D-3799-4EF5-8919-A4C4313DE2DE";//部门成员
                                                }
                                                if (is_default == "是" && !is_sub)
                                                {
                                                    dept_user.is_default = true;
                                                }
                                                else
                                                {
                                                    dept_user.is_default = false;
                                                }
                                                //測試期間暫時不修改所屬部門
                                                //dept_user.is_default = false;
                                                dept_user_temp.is_default = false;
                                                dept_user.user_type = 0;
                                                dept_user_temp.user_type = 0;

                                                if (exist_dept_user == null || exist_dept_user.Count == 0)
                                                {
                                                    dept_user.is_exist = "0";
                                                }
                                                else
                                                {
                                                    dept_user.is_exist = "1";
                                                    dept_user.identity_id = exist_dept_user[0].identity_id;
                                                }
                                                if (is_sub)
                                                {
                                                    dept_user.is_sub = "1";
                                                }
                                                else
                                                {
                                                    dept_user.is_sub = "0";
                                                }
                                                list_dept_user_to_update.Add(dept_user);
                                                list_dept_user.Add(dept_user_temp);//避免已添加過的部門重複添加
                                                is_sub = true;
                                            }
                                            dr_emp["import_data"] = JsonConvert.SerializeObject(list_dept_user_to_update);   
                                        }
                                    }
                                    response.Code = "1";
                                    response.Msg = dt_excel;
                                    if (total_check_failed > 0)
                                        response.ExtraInfo = string.Format("{0}筆資料檢查異常，請修正後再次檢查", total_check_failed);
                                }
                            }
                            else
                            {
                                response.Code = "0";
                                response.Msg = "File Parsed Fail";
                            }
                        }
                        else
                        {
                            response.Code = "0";
                            response.Msg = "No File";
                        }
                    }
                    else if (mode == "update")
                    {
                        List<EhrEmployee> list_ehr_employee = null;
                        List<SUserInfo> list_user_info = null;
                        using (SqlConnection conn = new SqlConnection(connectionString))
                        {
                            string str_sql_get_all_ehr_employee = "SELECT * FROM dbo.ehr_employee";
                            list_ehr_employee = conn.Query<EhrEmployee>(str_sql_get_all_ehr_employee).ToList();
                            string str_sql_get_all_user = "SELECT * FROM dbo.s_user_info WHERE is_enabled = @is_enabled";
                            list_user_info = conn.Query<SUserInfo>(str_sql_get_all_user, new { is_enabled = 1 }).ToList();
                        }

                        var data_to_upload = HttpContext.Current.Request.Form["data_to_upload"];
                        var obj_list = Newtonsoft.Json.Linq.JArray.Parse(data_to_upload);

                        Dictionary<string, object> dic_result = new Dictionary<string, object>();
                        List<SDeptUser> list_to_clean_dept_user_is_default = new List<SDeptUser>();
                        List<SDeptUser> list_to_insert_dept_user = new List<SDeptUser>();
                        List<SDeptUser> list_to_update_dept_user = new List<SDeptUser>();
                        List<SUserInfo> list_to_update_user_info = new List<SUserInfo>();
                        List<EhrEmployee> list_to_update_ehr_employee = new List<EhrEmployee>();
                        using (SqlConnection conn = new SqlConnection(connectionString))
                        {
                            foreach (var item in obj_list)
                            {
                                List<DeptUserImportViewModel> list_dept_user = JsonConvert.DeserializeObject<List<DeptUserImportViewModel>>(item["import_data"].ToString());
                                foreach (DeptUserImportViewModel dept_user_vm in list_dept_user)
                                {
                                    SDeptUser dept_user = new SDeptUser();
                                    dept_user.authority = dept_user_vm.authority;
                                    dept_user.country = dept_user_vm.country;
                                    dept_user.dept_id = dept_user_vm.dept_id;
                                    dept_user.identity_id = dept_user_vm.identity_id;
                                    dept_user.is_default = dept_user_vm.is_default;
                                    dept_user.role_id = dept_user_vm.role_id;
                                    dept_user.user_id = dept_user_vm.user_id;
                                    dept_user.user_type = dept_user_vm.user_type;
                                    //清除原所屬部門
                                    if (dept_user_vm.is_default == true)
                                    {
                                        string str_sql_get_dept_user_is_default = "SELECT * FROM dbo.s_dept_user WHERE is_default = @is_default and user_id = @user_id";
                                        var list_dept_user_info = conn.Query<SDeptUser>(str_sql_get_dept_user_is_default, new { is_default = 1, user_id = dept_user_vm.user_id }).ToList();
                                        if(list_dept_user_info.Count>0)
                                        {
                                            SDeptUser item_to_clean_dept_user_is_default = list_dept_user_info[0];
                                            item_to_clean_dept_user_is_default.is_default = false;
                                            list_to_clean_dept_user_is_default.Add(item_to_clean_dept_user_is_default);
                                        }
                                    }

                                    if (dept_user_vm.is_exist == "0")
                                    {
                                        list_to_insert_dept_user.Add(dept_user);
                                    }
                                    else
                                    {
                                        dept_user.identity_id = dept_user_vm.identity_id;
                                        list_to_update_dept_user.Add(dept_user);
                                    }

                                    if (dept_user_vm.is_default == true)
                                    {
                                        var exist_emp = list_ehr_employee.FindAll(x => x.wade_user_id == dept_user.user_id);
                                        if (exist_emp == null || exist_emp.Count == 0)
                                        {
                                            //EHR沒有資料
                                        }
                                        else
                                        {
                                            //更新ehr_employee的dept_id，Penny自訂組織判斷用
                                            exist_emp[0].dept_id = dept_user.dept_id;
                                            list_to_update_ehr_employee.Add(exist_emp[0]);
                                        }

                                        var exist_user_info = list_user_info.FindAll(x => x.user_id == dept_user.user_id);
                                        if (exist_user_info == null || exist_user_info.Count == 0)
                                        {
                                            //Wade沒有資料
                                        }
                                        else
                                        {
                                            //更新Wade user_info的dept_id
                                            exist_user_info[0].dept_id = dept_user.dept_id;
                                            list_to_update_user_info.Add(exist_user_info[0]);
                                        }
                                    }
                                }
                            }
                            var result_clean_dept_user = conn.Update(list_to_clean_dept_user_is_default);
                            var result_update_user_info = conn.Update(list_to_update_user_info);
                            var result_insert_dept_user = conn.Insert(list_to_insert_dept_user);
                            var result_update_dept_user = conn.Update(list_to_update_dept_user);
                            var result_insert_ehr_employee = conn.Update(list_to_update_ehr_employee);

                            response.Code = "1";
                            response.Msg = $"權限更新{result_insert_dept_user}筆，用戶更新{result_insert_ehr_employee}筆";
                        }
                    }
                    else
                    {
                        response.Code = "0";
                        response.Msg = "Unknown Mode";
                    }
                }
                else
                {
                    response.Code = "0";
                    response.Msg = "No Mode";
                }
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        #region 導入用戶
        [Route("UserInfo/ResetICDeptUser")]
        [CorsHandle]
        [HttpPost]

        public HttpResponseMessage ResetICDeptUser()
        {
            HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
            CommonResponseMsg response = new CommonResponseMsg();
            try
            {
                using (SqlConnection conn = new SqlConnection(connectionString))
                {
                    List<SDeptUser> list_to_insert_dept_user = new List<SDeptUser>();
                    List<SDeptUser> list_to_update_dept_user = new List<SDeptUser>();
                    var emp_id = HttpContext.Current.Request.Form["emp_id"];
                    string str_sql_get_list_ic_user = "";
                    List<SUserInfo> list_ic_user = null;
                    if (string.IsNullOrEmpty(emp_id))
                    {
                        //獲取所有流程人員
                        str_sql_get_list_ic_user = @"select *
                                                        from s_user_info
                                                        where user_id in
                                                        (select wade_user_id
                                                        from evw_ehr_employee_zh_tw
                                                        where job_status = '在職' and
                                                        (first_dept = '財務及投融資部' or second_dept = '商標業務組' or third_dept = '流程部' or fourth_dept in ('專案管理及PVIP作業組','內外代理業務流程組','外內代理業務流程組')) and
                                                        isnull(wade_user_id,'') != '')";
                        list_ic_user = conn.Query<SUserInfo>(str_sql_get_list_ic_user).ToList();
                    }
                    else
                    {
                        str_sql_get_list_ic_user = @"select * FROM dbo.s_user_info
                                                        WHERE user_name IN @list_user_name
                                                        ";
                        list_ic_user = conn.Query<SUserInfo>(str_sql_get_list_ic_user, new { list_user_name = emp_id.Split(',').ToList() }).ToList();
                    }

                    //獲取所有專利部組織
                    //string str_sql_get_list_dept = @"SELECT * FROM dbo.s_dept_info WHERE dept_full_name LIKE('%内内%') OR dept_full_name LIKE('%内外%') OR dept_full_name LIKE('%外内%')";
                    //改為獲取所有有效組織
                    string str_sql_get_list_dept = @"SELECT * FROM dbo.s_dept_info WHERE is_enabled = 1";
                    var list_dept = conn.Query<SDeptInfo>(str_sql_get_list_dept).ToList();

                    //獲取所有權限
                    string str_sql_get_all_dept_user = "SELECT * FROM dbo.s_dept_user";
                    var list_dept_user = conn.Query<SDeptUser>(str_sql_get_all_dept_user).ToList();

                    //找出缺少的權限
                    foreach (SUserInfo user_info in list_ic_user)
                    {
                        foreach (SDeptInfo dept_info in list_dept)
                        {
                            var exist_dept_user = list_dept_user.FindAll(x => x.user_id == user_info.user_id && x.dept_id == dept_info.dept_id);
                            SDeptUser dept_user = new SDeptUser();
                            dept_user.dept_id = dept_info.dept_id;
                            dept_user.user_id = user_info.user_id;
                            dept_user.role_id = "5870A24D-3799-4EF5-8919-A4C4313DE2DE";//部门成员
                            dept_user.is_default = false;
                            dept_user.user_type = 0;
                            if (exist_dept_user == null || exist_dept_user.Count == 0)
                            {
                                list_to_insert_dept_user.Add(dept_user);
                            }
                            else
                            {
                                dept_user.identity_id = exist_dept_user[0].identity_id;
                                list_to_update_dept_user.Add(dept_user);
                            }
                        }
                    }
                    var result_insert_dept_user = conn.Insert(list_to_insert_dept_user);
                    string a = "";
                }
            }
            catch (Exception e)
            {
                response.Code = "0";
                response.Msg = e.Message;
            }
            result.Content = new StringContent(JsonConvert.SerializeObject(response), System.Text.Encoding.UTF8, "application/json");
            return result;
        }
        #endregion

        protected List<SDeptInfo>get_all_sub_dept(SDeptInfo dept)
        {
            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                List<SDeptInfo> list_all_sub_dept = new List<SDeptInfo>();
                string str_sql_get_dept = "SELECT * FROM dbo.s_dept_info where parent_id = @parent_id";
                List<SDeptInfo> list_sub_dept = conn.Query<SDeptInfo>(str_sql_get_dept, new { parent_id = dept.dept_id }).ToList();
                foreach(SDeptInfo sub_dept in list_sub_dept)
                {
                    list_all_sub_dept.Add(sub_dept);
                    list_all_sub_dept.AddRange(get_all_sub_dept(sub_dept));
                }
                return list_all_sub_dept;
            }
        }
    }
}