// const devConfig = require('./config/config.dev');
// const buildConfig = require('./config/config.build');
// module.exports = process.env.NODE_ENV === 'production' ? buildConfig : devConfig;

const path = require('path')
module.exports = {
    productionSourceMap: false,
    css: {
        extract: false,
    },
    // 修改 pages 入口
    pages: {
        index: {
            entry: 'example/main.js',
            template: 'public/index.html',
            filename: 'index.html'
        }
    },
    // 扩展 webpack 配置
    chainWebpack: config => {
        // @ 默认指向 src 目录，这里要改成 examples
        // 另外也可以新增一个 ~ 指向 packages
        config.resolve.alias
            .set('@', path.resolve('packages'))
            .set('@utils', path.resolve('utils'))
            .set('@config', path.resolve('config'))
            .set('@api', path.resolve('api'))
            
        // 把 packages 和 examples 加入编译，因为新增的文件默认是不被 webpack 处理的
        config.module
            .rule('js')
            .include.add(/packages/)
            .end()
            .include.add(/examples/)
            .end()
            .use('babel')
            .loader('babel-loader')
            .tap(options => {
                // 修改它的选项...
                return options
            })
    }
}