import graphRequest from '@utils/GraphApiService'
import Vue from 'vue'

Vue.mixin({
  methods: {
    async downloadFile(excelFileName) {
      try {
        const formData = new FormData()
        formData.append('fileName', excelFileName)
        const response = await graphRequest.post('Word/DownloadFile', formData, { responseType: 'blob' })
        if (response) {
          const blob = new Blob([response])
          const downloadElement = document.createElement('a')
          const href = window.URL.createObjectURL(blob)
          downloadElement.href = href
          downloadElement.download = excelFileName.split('\\').pop().split('/').pop()
          document.body.appendChild(downloadElement)
          downloadElement.click()
          document.body.removeChild(downloadElement)
          window.URL.revokeObjectURL(href)
        }
      } catch (error) {
        console.log('error', error)
        this.$refs.upload.abort()
        this.$message.error('下载档案失败!')
      }
    }
  }
})
