import pLink from './aComponent'
import splitTool from './splitTool'
// 存放组件的数组
const components = [
  pLink,
  splitTool
]

// 全局注册
const install = function( Vue, opt = {} ) {
  components.forEach(item => {
      register( Vue, item )
  })
}

export default install

if (typeof window !== 'undefined' && window.Vue) {
  install(window.Vue);
}
/**
* 注册组件
* @param { vue } _v
* @param { component } com
*/
function register ( _v, com ) {
  if(typeof _v !== 'function' && typeof com !== 'object') return
  _v.component( com.name, com)
}
// 按需暴露
export {
  install,
  pLink,
  splitTool
}