import service from '@utils/GraphApiService'
import request from '@utils/requestService'
export function fetchCnToCpc(baseURL, data) {
  return service({
    baseURL: baseURL,
    url: 'api/v1.0/Word/CN2CPC',
    method: 'POST',
    data
  })
}

export function fetchCntToPct(baseURL, data) {
  return service({
    baseURL: baseURL,
    url: 'api/v1.0/Word/CN2PCT',
    method: 'post',
    data
  })
}

export function fetchPctToCn(baseURL, data) {
  return service({
    baseURL: baseURL,
    url: 'api/v1.0/Word/PCT2CN',
    method: 'POST',
    data
  })
}

export function fetchConvertEquations(baseURL, data) {
  return service({
    baseURL: baseURL,
    url: 'api/v1.0/Word/ConvertEquations',
    method: 'POST',
    data
  })
}

export function fetchDownloadFile(baseURL, params) {
  return service({
    baseURL: baseURL,
    url: 'api/v1.0/RequestPayment/DownloadFile',
    method: 'get',
    responseType: 'blob',
    params
  })
}

export function fetchWordPic(baseURL, data) {
  return request({
    baseURL: baseURL,
    url: 'api/Aspose/GetWordAllPic',
    method: 'post',
    responseType: 'blob',
    data
  })
}