const path = require('path')
const resolve = dir => path.join(__dirname, '../', dir);

module.exports = {
  pages: {
    index: {
      entry: 'example/main.js',
      template: 'public/index.html',
      filename: 'index.html'
    }
  },
  chainWebpack: config => {
    config.module
      .rule('js')
      .include
      .add('/packages')
      .end()
      .use('babel')
      .loader('babel-loader')
      .tap(options => {
          return options
      })
  },
  configureWebpack: config=>{
    Object.assign(config.resolve, {
      alias: {
        '@': resolve('packages'),
        '@utils': resolve('utils'),
        '@config': resolve('config'),
        '@api': resolve('api')
      }
    })
  }
}