import axios from 'axios'
import { Message } from 'element-ui'

const service = axios.create({
  baseURL: "https://dev.essenptl.com/dev2/wade_ext",
  // withCredentials: true,
  timeout: 1500000
})

// response interceptor
service.interceptors.response.use(
  async response => {
    const res = response.data
    // 判斷是否為檔案類型
    if (response.config.responseType === 'blob') return res

    if (
      res.type && (res.type === 'application/vnd.openxmlformats-officedocument.wordprocessingml.document' ||
        res.type === 'application/zip')
    ) {
      return res
    }
    // 如果code非20000表示有發生問題
    // code = 1 為運營看板暫時使用
    return res
  },
  error => {
    if (error.response) {
      console.log('err' + error) // for debug
      return error
      // return Promise.reject(error)
    } else {
      console.log('err' + error) // for debug
      Message({
        message: error.message,
        type: 'error',
        duration: 5 * 1000
      })
      return Promise.reject(error)
    }
  }
)

export default service
