const express = require('express')
const app = express()
const port = 3000


// parse requests of content-type - application/json
app.use(express.json());  /* bodyParser.json() is deprecated */

// parse requests of content-type - application/x-www-form-urlencoded
app.use(express.urlencoded({ extended: true }));   /* bodyParser.urlencoded() is deprecated */

app.get('/', (req, res) => {
  res.send('Hello World! (get')
})

app.post('/', (req, res) => {
    res.send('Hello World! (post')
})

app.put('/', (req, res) => {
    res.send('Hello World! (put')
})

app.delete('/', (req, res) => {
    res.send('Hello World! (delete')
})

app.listen(port, () => {
  console.log(`Example app listening on port ${port}`)
})