package datasync.service;

import datasync.common.ResultJavaEntity;
import datasync.common.SyncDataJavaUtil;
import datasync.model.GradeJavaModel;
import datasync.model.PositionJavaModel;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.io.IOException;
import java.util.List;

public class SyncPositionJavaService {

    /**
     * 同步岗位
     *
     * @param positions
     * @param apikey
     * @param secretkey
     * @param baseUrl
     * @return
     * @throws IOException
     */
    public ResultJavaEntity position(List<PositionJavaModel> positions, String apikey, String secretkey, String baseUrl) throws IOException {
        JSONArray array = JSONArray.fromObject(positions);
        JSONObject params = SyncDataJavaUtil.getPublicParam(apikey, secretkey);
        params.put("datas", array);
        String url = baseUrl + "udp/sy/position";
        return SyncDataJavaUtil.getResult(url, params.toString());
    }

    /**
     * 同步职级
     *
     * @param grades
     * @param apikey
     * @param secretkey
     * @param baseUrl
     * @return
     * @throws IOException
     */
    public ResultJavaEntity updategrade(List<GradeJavaModel> grades, String apikey, String secretkey, String baseUrl) throws IOException {
        JSONArray array = JSONArray.fromObject(grades);
        JSONObject params = SyncDataJavaUtil.getPublicParam(apikey, secretkey);
        params.put("datas", array);
        String url = baseUrl + "udp/sy/updgrade";
        return SyncDataJavaUtil.getResult(url, params.toString());
    }

    /**
     * 同步更改岗位名称
     *
     * @param positionNo   岗位编号
     * @param positionName 岗位名称(修改后)
     * @param apikey
     * @param secretkey
     * @param baseUrl
     * @return
     * @throws IOException
     */
    public ResultJavaEntity updatePositionInfo(String positionNo, String positionName, String apikey, String secretkey, String baseUrl) throws IOException {
        JSONObject params = SyncDataJavaUtil.getPublicParam(apikey, secretkey);
        params.put("positionNo", positionNo);
        params.put("positionName", positionName);
        String url = baseUrl + "udp/sy/updatepositioninfo";
        return SyncDataJavaUtil.getResult(url, params.toString());
    }

    /**
     * 查询岗位编号
     *
     * @param positionName 2级岗位类别;岗位名称1
     * @param apikey
     * @param secretkey
     * @param baseUrl
     * @return
     * @throws IOException
     */
    public ResultJavaEntity getPnoByPname(String positionName, String apikey, String secretkey, String baseUrl) throws IOException {
        JSONObject params = SyncDataJavaUtil.getPublicParam(apikey, secretkey);
        params.put("extendKey", positionName);
        String url = baseUrl + "udp/sy/getpnobypname";
        return SyncDataJavaUtil.getResult(url, params.toString());
    }

}
